#include <main.h>

extern struct info sys_info;
extern struct work context;

void LCDinit()
{
	// Config setup pins
	GPIODirModeSet(CS_BASE,CS,GPIO_DIR_MODE_OUT);	// Set all pins as outputs
	GPIODirModeSet(RST_BASE,RST,GPIO_DIR_MODE_OUT);
	GPIODirModeSet(WR_BASE,WR,GPIO_DIR_MODE_OUT);
	GPIODirModeSet(DC_BASE,DC,GPIO_DIR_MODE_OUT);
	GPIODirModeSet(RD_BASE,RD,GPIO_DIR_MODE_OUT);
	GPIOPinWrite(CS_BASE,CS,CS);					// Set init state
	GPIOPinWrite(RST_BASE,RST,RST);
	GPIOPinWrite(WR_BASE,WR,0);
	GPIOPinWrite(DC_BASE,DC,0);
	GPIOPinWrite(RD_BASE,RD,0);
	GPIOPadConfigSet(CS_BASE,CS,GPIO_STRENGTH_6MA,GPIO_PIN_TYPE_STD);	// Set all outputs als 6mA push pull
	GPIOPadConfigSet(RST_BASE,RST,GPIO_STRENGTH_6MA,GPIO_PIN_TYPE_STD);
	GPIOPadConfigSet(WR_BASE,WR,GPIO_STRENGTH_6MA,GPIO_PIN_TYPE_STD);
	GPIOPadConfigSet(DC_BASE,DC,GPIO_STRENGTH_6MA,GPIO_PIN_TYPE_STD);
	GPIOPadConfigSet(RD_BASE,RD,GPIO_STRENGTH_6MA,GPIO_PIN_TYPE_STD);

	// Config data pins
	GPIODirModeSet(LOWER_BASE,0xFF,GPIO_DIR_MODE_OUT);  // Set all pins as outputs
	GPIODirModeSet(HIGHER_BASE,0xFF,GPIO_DIR_MODE_OUT);
	GPIOPinWrite(LOWER_BASE,0xFF,0);					// Set all pins low
	GPIOPinWrite(HIGHER_BASE,0xFF,0);

    delay(500000);		// Wait for display to initializes
    GPIOPinWrite(RST_BASE,RST,0);
    delay(10000); 		// one cycle 62,5ns
    GPIOPinWrite(RST_BASE,RST,RST);
    delay(500000);		// Wait for display to initializes

    writeTo(0x0000,0);			// OSC start
    writeTo(0x0001,1);
    writeTo(0x0003,0);			// Power Control 1
    writeTo(0x0A24,1);
    writeTo(0x000C,0);			// Power Control 2
    writeTo(0x0000,1);
    writeTo(0x000D,0);			// Power Control 3
    writeTo(0x080C,1);
    writeTo(0x000E,0);			// Power Control 4
    writeTo(0x2B00,1);
    writeTo(0x001E,0);			// Power Control 5
    writeTo(0x00B7,1);
    writeTo(0x0001,0);			// Driver Output Control
    writeTo(0x6B3F,1);
    writeTo(0x0002,0);			// LCD Driver AC Control
    writeTo(0X0600,1);
    writeTo(0x0010,0);			// Sleep Mode
    writeTo(0x0000,1);
    delay(600000);
    writeTo(0x0011,0);			// Entry Mode
    writeTo(0x6070,1);
    writeTo(0x0005,0);			// Compare register 1
    writeTo(0x0000,1);
    writeTo(0x0006,0);			// Compare register 2
    writeTo(0x0000,1);
    writeTo(0x0016,0);			// Horizontal Porch
    writeTo(0xEF1C,1);
    writeTo(0x0017,0);			// Vertical Porch
    writeTo(0x0003,1);
    writeTo(0x0007,0);			// Display Control
    writeTo(0x0233,1);
    writeTo(0x000B,0);			// Frame cycle control
    writeTo(0x0000,1);
    writeTo(0x000F,0);			// Gate scan start position
    writeTo(0x0000,1);
    writeTo(0x0041,0);			// Vertical scroll control 1
    writeTo(0x0000,1);
    writeTo(0x0042,0);			// Vertical scroll control 1
    writeTo(0x0000,1);
    writeTo(0x0048,0);			// First Window Start
    writeTo(0x0000,1);
    writeTo(0x0049,0);			// First Window End
    writeTo(0x013F,1);
    writeTo(0x004A,0);			// Second Window Start
    writeTo(0x0000,1);
    writeTo(0x004B,0);			// Second Window Start
    writeTo(0x0000,1);
    writeTo(0x0044,0);			// Horizontal RAM Address Position
    writeTo(0xEF00,1);
    writeTo(0x0045,0);  		// Vertical RAM Address Start Position
    writeTo(0x0000,1);
    writeTo(0x0046,0);			// Vertical RAM Address End Position
    writeTo(0x013F,1);
    writeTo(0x0030,0);			// gamma control 1
    writeTo(0x0707,1);
    writeTo(0x0031,0);			// gamma control 2
    writeTo(0x0204,1);
    writeTo(0x0032,0);			// gamma control 3
    writeTo(0x0204,1);
    writeTo(0x0033,0);			// gamma control 4
    writeTo(0x0502,1);
    writeTo(0x0034,0);			// gamma control 5
    writeTo(0x0507,1);
    writeTo(0x0035,0);			// gamma control 6
    writeTo(0x0204,1);
    writeTo(0x0036,0);			// gamma control 7
    writeTo(0x0204,1);
    writeTo(0x0037,0);			// gamma control 8
    writeTo(0x0502,1);
    writeTo(0x003A,0);			// gamma control 9
    writeTo(0x0302,1);
    writeTo(0x003B,0);			// gamma control 10
    writeTo(0x0302,1);
    writeTo(0x0023,0);			// RAM Write Data Mask 1
    writeTo(0x0000,1);
    writeTo(0x0024,0);			// RAM Write Data Mask 2
    writeTo(0x0000,1);
    writeTo(0x0025,0);			// Frame Frequency
    writeTo(0x8000,1);
    writeTo(0x004F,0);			// Set GDDRAM X Address Counter
    writeTo(0x0000,1);
    writeTo(0x004E,0);			// Set GDDRAM Y Address Counter
    writeTo(0x0000,1);
    clearLCD();
/*
    // Configure the PWM settings for the backlight
	SysCtlPWMClockSet(SYSCTL_PWMDIV_1);           		// Configure PWM Clock to match system
	Period = SysCtlClockGet() / 200;					// Set the PWM period length
	GPIOPinConfigure(GPIO_PA6_M1PWM2);					// Confige the output pin for PWM1 modul
	GPIOPinTypePWM(GPIO_PORTA_BASE, GPIO_PIN_6);		// Set PA6 as PWM pin
	// Configure PWM1 module as up-down counter with no sync
	PWMGenConfigure(PWM1_BASE, PWM_GEN_1, PWM_GEN_MODE_UP_DOWN | PWM_GEN_MODE_NO_SYNC);
	PWMGenPeriodSet(PWM1_BASE, PWM_GEN_1, Period);		// Set the periode of the PWM pulse
	// Set pulse width, at init 50%
	PWMPulseWidthSet(PWM1_BASE, PWM_OUT_6,Period/100*sys_info.brightness);
	PWMGenEnable(PWM1_BASE, PWM_GEN_1);					// Enable PWM1 generator
	PWMOutputInvert(PWM1_BASE, PWM_OUT_6_BIT, true);	// Invert the PWM signal
	PWMOutputState(PWM1_BASE, PWM_OUT_6_BIT, true);		// Activate the PWM output
	*/
}

void writeTo(long data, int select)
{
	if(0==select) GPIOPinWrite(DC_BASE,DC,0);			// Command or data to send
	GPIOPinWrite(WR_BASE,WR,0);							// Write to display
	HWREG(LOWER_BASE +  (GPIO_O_DATA + (0xFF << 2))) =  data & 0x00FF;
	HWREG(HIGHER_BASE + (GPIO_O_DATA + (0xFF << 2))) = (data & 0xFF00)<<8 ;
	GPIOPinWrite(CS_BASE,CS,0);						// Display get the data
	delay(1);
	GPIOPinWrite(CS_BASE,CS,CS);
	delay(1);
	GPIOPinWrite(CS_BASE,CS,CS);					// Set init state
	GPIOPinWrite(RST_BASE,RST,RST);
	GPIOPinWrite(WR_BASE,WR,0);
	GPIOPinWrite(DC_BASE,DC,0);
	GPIOPinWrite(RD_BASE,RD,0);

	/*
	if(0==select) GPIOPinWrite(GPIO_PORTD_BASE,DC,0);			// Command or data to send
	GPIOPinWrite(GPIO_PORTD_BASE,WR,0);							// Write to display
	if(data & 0x0001) //GPIOPinWrite(GPIO_PORTB_BASE,DB0,DB0);	// LSB of data
	HWREG(GPIO_PORTB_BASE + (GPIO_O_DATA + (DB0 << 2))) = DB0;
	if(data & 0x0002)// GPIOPinWrite(GPIO_PORTB_BASE,DB1,DB1);
	HWREG(GPIO_PORTB_BASE + (GPIO_O_DATA + (DB1 << 2))) = DB1;
	if(data & 0x0004)// GPIOPinWrite(GPIO_PORTE_BASE,DB2,DB2);
	HWREG(GPIO_PORTE_BASE + (GPIO_O_DATA + (DB2 << 2))) = DB2;
	if(data & 0x0008)// GPIOPinWrite(GPIO_PORTE_BASE,DB3,DB3);
	HWREG(GPIO_PORTE_BASE + (GPIO_O_DATA + (DB3 << 2))) = DB3;
	if(data & 0x0010) //GPIOPinWrite(GPIO_PORTD_BASE,DB4,DB4);
	HWREG(GPIO_PORTD_BASE + (GPIO_O_DATA + (DB4 << 2))) = DB4;
	if(data & 0x0020) //GPIOPinWrite(GPIO_PORTD_BASE,DB5,DB5);
	HWREG(GPIO_PORTD_BASE + (GPIO_O_DATA + (DB5 << 2))) = DB5;
	if(data & 0x0040) //GPIOPinWrite(GPIO_PORTJ_BASE,DB6,DB6);
	HWREG(GPIO_PORTJ_BASE + (GPIO_O_DATA + (DB6 << 2))) = DB6;
	if(data & 0x0080) //GPIOPinWrite(GPIO_PORTE_BASE,DB7,DB7);
	HWREG(GPIO_PORTE_BASE + (GPIO_O_DATA + (DB7 << 2))) = DB7;
	if(data & 0x0100) //GPIOPinWrite(GPIO_PORTD_BASE,DB8,DB8);
	HWREG(GPIO_PORTD_BASE + (GPIO_O_DATA + (DB8 << 2))) = DB8;
	if(data & 0x0200) //GPIOPinWrite(GPIO_PORTE_BASE,DB9,DB9);
	HWREG(GPIO_PORTE_BASE + (GPIO_O_DATA + (DB9 << 2))) = DB9;
	if(data & 0x0400) //GPIOPinWrite(GPIO_PORTE_BASE,DB10,DB10);
	HWREG(GPIO_PORTE_BASE + (GPIO_O_DATA + (DB10 << 2))) = DB10;
	if(data & 0x0800) //GPIOPinWrite(GPIO_PORTE_BASE,DB11,DB11);
	HWREG(GPIO_PORTE_BASE + (GPIO_O_DATA + (DB11 << 2))) = DB11;
	if(data & 0x1000) //GPIOPinWrite(GPIO_PORTH_BASE,DB12,DB12);
	HWREG(GPIO_PORTH_BASE + (GPIO_O_DATA + (DB12 << 2))) = DB12;
	if(data & 0x2000) //GPIOPinWrite(GPIO_PORTH_BASE,DB13,DB13);
	HWREG(GPIO_PORTH_BASE + (GPIO_O_DATA + (DB13 << 2))) = DB13;
	if(data & 0x4000) //GPIOPinWrite(GPIO_PORTH_BASE,DB14,DB14);
	HWREG(GPIO_PORTH_BASE + (GPIO_O_DATA + (DB14 << 2))) = DB14;
	if(data & 0x8000) //GPIOPinWrite(GPIO_PORTC_BASE,DB15,DB15);	// MSB of data
	HWREG(GPIO_PORTC_BASE + (GPIO_O_DATA + (DB15 << 2))) = DB15;

	GPIOPinWrite(GPIO_PORTA_BASE,CS,0);						// Display get the data
	delay(1);
	GPIOPinWrite(GPIO_PORTA_BASE,CS,CS);
	delay(1);
	// Set all data pins low and all set pins high
	GPIOPinWrite(GPIO_PORTB_BASE,DB0+DB1,0);
	GPIOPinWrite(GPIO_PORTC_BASE,DB15,0);
	GPIOPinWrite(GPIO_PORTD_BASE,WR+RD+DC,WR+RD+DC);
	GPIOPinWrite(GPIO_PORTD_BASE,DB4+DB5+DB8,0);
	GPIOPinWrite(GPIO_PORTE_BASE,DB2+DB3+DB7+DB9+DB10+DB11,0);
	GPIOPinWrite(GPIO_PORTH_BASE,DB12+DB13+DB14,0);
	GPIOPinWrite(GPIO_PORTJ_BASE,DB6,0);
	*/
}

void picInPic(int x, int y, int high, int width)
{

}

void clearLCD()
{
	setArea(0,240,0,320);
	writeTo(0x0022,0);
	for (i=0;i<76800;i++)
	{
		writeTo(black,1);
	}
}
void clearArea(int x_start, int y_start, int hight, int width)
{
	setArea(y_start, y_start+hight, x_start, x_start+width);
	writeTo(0x0022,0);
	volatile unsigned int locY;
	while(width>0)
	{
		locY=0;
		while(locY<hight)
		{
			writeTo(black,1);
			locY++;
		}
		width--;
	}
}
void delay (long time)  //100ns delay
{
	volatile int x=0;
	for(; x < time; x++) ;
}
void setArea(int y_start, int y_end, int x_start, int x_end)
{
	writeTo(0x004E,0);
	writeTo(y_start,1);
	writeTo(0x004F,0);
	writeTo(x_start,1);
	writeTo(0x0044,0);  										// Command set_column_adress
	writeTo((y_start)+((y_end-1)<<8),1);					// Set LSB of column start
	writeTo(0x0045,0);  										// Command set_page_adress
	writeTo(x_start,1);										// Set MSB of page start
	writeTo(0x0046,0);
	writeTo((x_end),1);									// Set MSB of page end
}

void writeString(char *string, int x, int y, int color, int font, int background_color)
{
	unsigned int char_width=0;							// Counter for the overall length of the currently written string
	unsigned int char_scall=font*5+1;						// Scalling factor for one character
	while(*string != '\0')								// Go throgh string till the end
	{
		writeChar(*string,x+char_width,y,color,font,background_color);	// Write char
		*string++;										// Go to next char in the string
		char_width += char_scall;						// Increase the length of the current string
	}
}

char *IntToString(int data)
{
	static char buffer[5];
	ltoa(data,buffer);
	return buffer;
}

char *FloatToString(float data)
{
	static char buf[5];
	int pos=0,ix,dp,num;

	if (data<0)
	{
		buf[pos++]='-';
	    data = -data;
	}
	dp=0;
	while (data>=10.0)
	{
		data=data/10.0;
	    dp++;
	}
	for (ix=1;ix<5;ix++)
	{
		num = (int)data;
	    data = data - num;
	    if (num>9) buf[pos++]='#';
	    else  buf[pos++]='0'+num;
	    if (dp==0) buf[pos++]='.';
	    data = data*10.0;
	    dp--;
	}
	return buf;
}

void setButton(int x_start, int y_start, int hight, int width,int color,int text_col,char *text,int fond)
{
	unsigned int loc_width=width;		// Local integer for the width
	unsigned int backGroundPixel;		// Counter for black pixels in a row
	unsigned int edge_length=5;					// Length of black edge
	unsigned int loc_hight = hight;			// Counter for black pixels in a colomn
	unsigned int text_x = x_start + ((width-strlen(text)*(1+5*fond))>>1);
	unsigned int text_y = y_start + ((hight-(7*fond))>>1);
	setArea(y_start,y_start+hight,x_start,x_start+width);
	writeTo(0x0022,0);
	for(;loc_width>0;loc_width--)
	{
		backGroundPixel=edge_length;
		for(;backGroundPixel>0;backGroundPixel--)
		{
			writeTo(black,1);
		}
		backGroundPixel=edge_length;
		for(;loc_hight>0+(backGroundPixel+backGroundPixel);loc_hight--)
		{
			if(loc_width== width || loc_width == 1 || loc_hight==hight || loc_hight==(backGroundPixel+backGroundPixel+1)) writeTo(black,1);
			else writeTo(color,1);
		}
		loc_hight=hight;
		for(;backGroundPixel>0;backGroundPixel--)
		{
			writeTo(black,1);
		}
		if(loc_width>5 & edge_length>0) edge_length--;
		if(loc_width<=6) edge_length++;
	}
	writeString(text,text_x,text_y,text_col,fond,color);
}

void writeChar(char data, int x, int y, int color, int scall, int background_color)
{
	volatile unsigned int c;							// Column counter
	volatile unsigned int hight=7;						// Define high of one standard character
	volatile unsigned int width=5;						// Define width of one standard character
	setArea(y,y+hight*scall,x,x+width*scall);			// Set Area for one character
	writeTo(0x0022,0);								    // Set Display to write mode
	for(i=0;i<width;i++)								// Go through all 5 columns
	{
		j=0x0001;										// Last column
		for(c=0;c<hight;c++)							// Go through all 7 rows
		{
			if(fontSmall[data-0x20] [i] & j)		// data-A for standard ascii code, start with last line
			{
				writeBlock(scall,scall,x+i*scall,y+c*scall,color);					// Write pixel
			}
			else writeBlock(scall,scall,x+i*scall,y+c*scall,background_color);					// Write pixel
			j = j<<1;									// Shift to next column
		}
	}
}
void writeBlock(int high, int width, int x, int y, int color)
{
	setArea(y,y+high,x,x+width);
	writeTo(0x0022,0);
	volatile unsigned int o=high;
	volatile unsigned int p;
	for(;o>0;o--)
	{
		for(p=width;p>0;p--)
		{
			writeTo(color,1);
		}
	}
}

void printScreen()
{
	unsigned int lines = 0;
	switch(context.cur_menu)
	{
	 case start:
	 {
	    clearLCD();
		setButton(0,0,80,320,yellow,blue,"Sound Mashine 3.0!!",3);
		setButton(0,180,60,80,white,green,"OFF",2);
		setButton(80,180,60,80,white,green,"Setup",2);
		setButton(160,180,60,80,white,green,"Info",2);
		setButton(240,180,60,80,white,green,"Player",2);
		writeString(context.error.VS_error,50,100,white,1,black);
		writeString(context.error.SD_error,50,110,white,1,black);
		writeString(context.error.err_error,50,120,white,1,black);
	 }
	  break;
	 case select:
	 {
		if(context.last_menu == start)
		{
			setButton(0,0,21,320,grey,yellow,"",1);					// Set window header, is the start menu is diffrent
			writeString("Sound Mashine 3.0",10,7,yellow,1,grey);
			writeBlock(9,320,0,21,black);							// Clear upper edge of window
			writeBlock(10,320,0,190,black);							// Clear lower edge of window
			writeBlock(192,320,0,21,black);		// Clear middle window
		}
		if(context.last_menu == eq)
		{
			writeBlock(192,320,0,21,black);		// Clear middle window
		}
		setButton(0,200,40,80,white,green,"Back",2);
		setButton(80,200,40,80,white,green,"Setup",2);
		setButton(160,200,40,80,white,green,"Info",2);
		setButton(240,200,40,80,white,green,"EQ",2);
		setSelectBar();
		// If there are more than 20 names in the lists, sel_pointer is a multiple from 20 and added to print blocks per 20 names
		if(context.isDir) for(;lines<context.dir_count;lines++) writeString(dir_list[lines+context.sel_pointer],40,30+lines*8,white,1,black); // Print 20 names of dir/file list
		else 			  for(;lines<context.file_count;lines++) writeString(file_list[lines+context.sel_pointer],40,30+lines*8,white,1,black);	// Write first 20 files in folder
	 }
	  break;

	 case info:
	 {
		if(context.last_menu == start)
		{
		 	writeBlock(9,320,0,22,black);
		 	writeBlock(10,320,0,190,black);
		 	setButton(0,0,21,320,grey,yellow,"",1);					// Set window header, is the start menu is diffrent
		 	writeString("Sound Mashine 3.0",10,7,yellow,1,grey);
		}
		if(context.last_menu == eq)
		{
			writeBlock(192,320,0,21,black);		// Clear middle window
		}
		writeString("Helligkeit :",50,50,white,1,black);
		writeString(IntToString(sys_info.brightness),246,50,white,1,black);
		writeString("%",264,50,white,1,black);
		writeString("Batteriespannung :",50,60,white,1,black);
		writeString(FloatToString(sys_info.bat_voltage),234,60,white,1,black);
		writeString("V",264,60,white,1,black);
		writeString("Batterielevel :",50,70,white,1,black);
		writeString(IntToString(sys_info.bat_level),246,70,white,1,black);
		writeString("%",264,70,white,1,black);
		writeString("Freier Speicher :",50,80,white,1,black);
		writeString(FloatToString(sys_info.free_space),234,80,white,1,black);
		writeString("GB",258,80,white,1,black);
		writeString("Version :",50,90,white,1,black);
		writeString(sys_info.version,252,90,white,1,black);
		setButton(0,200,40,80,white,green,"Back",2);
		setButton(80,200,40,80,white,green,"",2);
		setButton(160,200,40,80,white,green,"",2);
		setButton(240,200,40,80,white,green,"Enter",2);
	 }
	  break;

	 case eq:
	 {
		 if(context.last_menu == player)
		 {
			 writeBlock(192,320,0,21,black);		// Clear middle window
			 setButton(0,200,40,80,white,green,"Back",2);
			 setButton(80,200,40,80,white,green,"",2);
			 setButton(160,200,40,80,white,green,"",2);
			 setButton(240,200,40,80,white,green,"Enter",2);
		 }
		 // Set the names for the EQ band bargraphs
		 writeString("35Hz",50,180,white,1,black);
		 writeString("185Hz",95,180,white,1,black);
		 writeString("1,65kHz",138,180,white,1,black);
		 writeString("5,5kHz",190,180,white,1,black);
		 writeString("11,5kHz",238,180,white,1,black);
		 // Set the value for the bargraphs
		 writeString(FloatToString(sys_info.EQ1_lvl),50,40,white,1,black);
		 writeString(FloatToString(sys_info.EQ2_lvl),95,40,white,1,black);
		 writeString(FloatToString(sys_info.EQ3_lvl),140,40,white,1,black);
		 writeString(FloatToString(sys_info.EQ4_lvl),190,40,white,1,black);
		 writeString(FloatToString(sys_info.EQ5_lvl),240,40,white,1,black);
		 // Set the bargraphs, display is written from the top so some calculating is neccessary
		 setButton(50,50+128-sys_info.EQ1_lvl*2,sys_info.EQ1_lvl*2,20,white,0,"",1);
		 setButton(100,50+128-sys_info.EQ2_lvl*2,sys_info.EQ2_lvl*2,20,white,0,"",1);
		 setButton(150,50+128-sys_info.EQ3_lvl*2,sys_info.EQ3_lvl*2,20,white,0,"",1);
		 setButton(200,50+128-sys_info.EQ4_lvl*2,sys_info.EQ4_lvl*2,20,white,0,"",1);
		 setButton(250,50+128-sys_info.EQ5_lvl*2,sys_info.EQ5_lvl*2,20,white,0,"",1);
		 // Set the red 0dB line
		 writeString("0dB",20,112,red,1,black);
		 writeBlock(1,238,41,115,red);
	 }
	  break;

	 case setup:
	 {
		 if(context.last_menu == player)
		 {
			 writeBlock(192,320,0,21,black);		// Clear middle window
		 	 setButton(0,200,40,80,white,green,"Back",2);
		 	 setButton(80,200,40,80,white,green,"",2);
		 	 setButton(160,200,40,80,white,green,"",2);
		 	 setButton(240,200,40,80,white,green,"Enter",2);
		 }
		 if(context.last_menu == start)
		 {
		     writeBlock(192,320,0,21,black);		// Clear middle window
		 	 setButton(0,0,21,320,grey,yellow,"",1);					// Set window header, is the start menu is diffrent
		 	 writeString("Sound Mashine 3.0",10,7,yellow,1,grey);
		 	 setButton(0,200,40,80,white,green,"Back",2);
		 	 setButton(80,200,40,80,white,green,"",2);
		 	 setButton(160,200,40,80,white,green,"",2);
		 	 setButton(240,200,40,80,white,green,"Enter",2);
		 }
		 if(context.last_menu == eq)
		 {
		 	 writeBlock(192,320,0,21,black);		// Clear middle window
		 }
	 }
	 	 break;
	 case player:
	 {
		 setSymbol(0,160,3);							// reverse sign
		 setSymbol(80,160,6);							// play sign
		 setSymbol(160,160,5);							// stop sign
		 setSymbol(240,160,2);							// forward sign
		 setSymbol(0,200,8);							// FR
		 setButton(80,200,40,80,white,green,"",2);
		 setButton(160,200,40,80,white,green,"EQ",2);
		 setSymbol(240,200,7);							// FF
	 }
	 	 break;
	 default:
		 break;
	}
}

void setBrightness()
{
	PWMOutputState(PWM1_BASE, PWM_OUT_6_BIT, false);
	PWMPulseWidthSet(PWM1_BASE, PWM_OUT_6,ulPeriod/100*sys_info.brightness);
	PWMOutputState(PWM1_BASE, PWM_OUT_6_BIT, true);
}

void setSelectBar()
{
	switch(context.cur_menu)
	{
		case select:
		{
			int local_yPointer;				// Counts through the 20 names of the screen and stores the Y-Position to write

			// (20 - sel_pointer % 20) is the number of the string on the screen, 8 pixel is on string high, 30 is the offset position from which the string-list starts
			if(context.sel_pointer > 20) local_yPointer = (20-context.sel_pointer % 20) * 8 + 30;	// If sel_pointer<20 it must be used as it is
			else local_yPointer = context.sel_pointer * 8 + 30;

			writeBlock(8,290,40,local_yPointer,grey);			    // Print select bar

			// Pointer is not an the beginning of the screen, so clear the previews selected field and reprint the string
			if(local_yPointer>30)
			{
				if(context.enc_event == up0)
				{
					writeBlock(8,290,40,local_yPointer-8,black);		// Clear previevs selectet field
					if(context.isDir)
					{
						writeString(dir_list[context.sel_pointer-1],40,local_yPointer-8,white,1,black);		// Clear previevs selectet field-8,white,1,black); // Reprint the previeves name
						writeString(dir_list[context.sel_pointer],50,local_yPointer,white,1,grey);	  // Print selectet name
					}
					else
					{
						writeString(file_list[context.sel_pointer-1],40,local_yPointer-8,white,1,black);
						writeString(file_list[context.sel_pointer],50,local_yPointer,white,1,grey);
					}
				}
				else
				{
					writeBlock(8,290,40,local_yPointer+8,black);		// Clear previevs selectet field
					if(context.isDir)
					{
						writeString(dir_list[context.sel_pointer+1],40,local_yPointer+8,white,1,black);		// Clear previevs selectet field-8,white,1,black); // Reprint the previeves name
						writeString(dir_list[context.sel_pointer],50,local_yPointer,white,1,grey);	  // Print selectet name
					}
					else
					{
						writeString(file_list[context.sel_pointer+1],40,local_yPointer+8,white,1,black);
						writeString(file_list[context.sel_pointer],50,local_yPointer,white,1,grey);
					}
				}
			}
			// IF the pointer is at the beginning the clear and reprint is done bei reprinting the whole screen
			else
			{
				if(context.isDir) writeString(dir_list[context.sel_pointer],50,local_yPointer,white,1,grey);	  // Print selectet name
				else writeString(file_list[context.sel_pointer],50,local_yPointer,white,1,grey);
			}
		}
			break;
		case setup:
		{
			setButton(50,context.sel_pointer,10,270,grey,0,"",1);
		}
			break;
		case eq:
		{

		}
			break;
	}
}

void setSymbol(int x_start, int y_start, int symbole)
{
	unsigned int loc_width=80;		// Local integer for the width
	unsigned int backGroundPixel;		// Counter for black pixels in a row
	unsigned int edge_length=5;					// Length of black edge
	unsigned int loc_hight = 40;			// Counter for black pixels in a colomn
	unsigned int text_x = x_start + 35;
	unsigned int text_y = y_start + 13;
	setArea(y_start,y_start+40,x_start,x_start+80);
	writeTo(0x0022,0);
	for(;loc_width>0;loc_width--)
	{
		backGroundPixel=edge_length;
		for(;backGroundPixel>0;backGroundPixel--)
		{
			writeTo(black,1);
		}
		backGroundPixel=edge_length;
		for(;loc_hight>0+(backGroundPixel+backGroundPixel);loc_hight--)
		{
			if(loc_width== 80 || loc_width == 1 || loc_hight==40 || loc_hight==(backGroundPixel+backGroundPixel+1)) writeTo(black,1);
			else writeTo(white,1);
		}
		loc_hight=40;
		for(;backGroundPixel>0;backGroundPixel--)
		{
			writeTo(black,1);
		}
		if(loc_width>5 & edge_length>0) edge_length--;
		if(loc_width<=6) edge_length++;
	}

	volatile unsigned int c;							// Column counter
	for(i=0;i<5;i++)								// Go through all 5 columns
	{
		j=0x0001;										// Last column
		for(c=0;c<7;c++)							// Go through all 7 rows
		{
			if(symbol[symbole] [i] & j)		// data-A for standard ascii code, start with last line
			{
				writeBlock(2,2,text_x+i*2,text_y+c*2,green);					// Write pixel
			}
			else writeBlock(2,2,text_x+i*2,text_y+c*2,white);					// Write pixel
			j = j<<1;									// Shift to next column
		}
	}
}

