#ifndef LCD_H_
#define LCD_H_

volatile unsigned long i;
volatile unsigned long j;
volatile unsigned long Period;

// Define pins
#define CS 		 	GPIO_PIN_0
#define CS_BASE	 	GPIO_PORTA_BASE
#define RST 	 	GPIO_PIN_1
#define RST_BASE 	GPIO_PORTA_BASE
#define WR  	 	GPIO_PIN_4
#define WR_BASE  	GPIO_PORTB_BASE
#define RD 		 	GPIO_PIN_0
#define RD_BASE  	GPIO_PORTH_BASE
#define DC  	 	GPIO_PIN_5
#define DC_BASE  	GPIO_PORTB_BASE
#define LOWER_BASE  GPIO_PORTD_BASE
#define HIGHER_BASE GPIO_PORTE_BASE


// Define methods
void LCDinit();
void delay(long time);

void writePixel(long color, int x, int y, int first);
void writeString(char *string, int x, int y, int color, int font, int background_color);
void writeTo(long data, int select);
void writeBlock(int high, int width, int x, int y, int color);
void writeChar(char data, int x, int y, int color, int scall,int background_color);

void setArea(int col_start, int col_end, int page_start, int page_end);
void setSelectBar();
//void setGraphic(graphic g);
void setButton(int x_start, int y_start, int hight, int width,int color,int text_col, char *text,int font);
void setSymbol(int x_start, int y_start, int symbole);

void clearLCD(void);
void clearArea(int x_start, int y_start, int hight, int width);

char *IntToString(int data);
char *FloatToString(float data);
void printScreen();
void setBrightness();
//void horizontalScroll(char *string, int x_start, int x_end, int y, long color, int font);
void printBier(int x, int y);

void picInPic(int x, int y, int high, int width);

// Define color shortcuts
#define blue 0x001F
#define red 0xF800
#define green 0x07E0
#define yellow 0xFFE0
#define magenta 0xF81F
#define cyan 0x07FF
#define white 0xFFFF
#define black 0x0000
#define orange 0xFC80
#define grey 0x8410
#define purple 0xC01F
#define greywhite 0xE79C
#define DGwhite 0xC718
#define bier 0xDDE8
#define biergrey 0xDF70


static const int fontSmall[104][5] =
{
	0x00, 0x00, 0x00, 0x00, 0x00, // SPACE
    0x00, 0x00, 0x5F, 0x00, 0x00, // !
    0x00, 0x03, 0x00, 0x03, 0x00, // "
    0x14, 0x3E, 0x14, 0x3E, 0x14, // #
    0x24, 0x2A, 0x7F, 0x2A, 0x12, // $
    0x43, 0x33, 0x08, 0x66, 0x61, // %
    0x36, 0x49, 0x55, 0x22, 0x50, // &
    0x00, 0x05, 0x03, 0x00, 0x00, // '
    0x00, 0x1C, 0x22, 0x41, 0x00, // (
    0x00, 0x41, 0x22, 0x1C, 0x00, // )
    0x14, 0x08, 0x3E, 0x08, 0x14, // *
    0x08, 0x08, 0x3E, 0x08, 0x08, // +
    0x00, 0x50, 0x30, 0x00, 0x00, // ,
    0x08, 0x08, 0x08, 0x08, 0x08, // -
    0x00, 0x60, 0x60, 0x00, 0x00, // .
    0x20, 0x10, 0x08, 0x04, 0x02, // /
    0x3E, 0x51, 0x49, 0x45, 0x3E, // 0
    0x00, 0x04, 0x02, 0x7F, 0x00, // 1
    0x42, 0x61, 0x51, 0x49, 0x46, // 2
    0x22, 0x41, 0x49, 0x49, 0x36, // 3
    0x18, 0x14, 0x12, 0x7F, 0x10, // 4
    0x27, 0x45, 0x45, 0x45, 0x39, // 5
    0x3E, 0x49, 0x49, 0x49, 0x32, // 6
    0x01, 0x01, 0x71, 0x09, 0x07, // 7
    0x36, 0x49, 0x49, 0x49, 0x36, // 8
    0x26, 0x49, 0x49, 0x49, 0x3E, // 9
    0x00, 0x36, 0x36, 0x00, 0x00, // :
    0x00, 0x56, 0x36, 0x00, 0x00, // ;
    0x08, 0x14, 0x22, 0x41, 0x00, // <
    0x14, 0x14, 0x14, 0x14, 0x14, // =
    0x00, 0x41, 0x22, 0x14, 0x08, // >
    0x02, 0x01, 0x51, 0x09, 0x06, // ?
    0x3E, 0x41, 0x59, 0x55, 0x5E, // @
    0x7E, 0x09, 0x09, 0x09, 0x7E, // A
    0x7F, 0x49, 0x49, 0x49, 0x36, // B
    0x3E, 0x41, 0x41, 0x41, 0x22, // C
    0x7F, 0x41, 0x41, 0x41, 0x3E, // D
    0x7F, 0x49, 0x49, 0x49, 0x41, // E
    0x7F, 0x09, 0x09, 0x09, 0x01, // F
    0x3E, 0x41, 0x41, 0x49, 0x3A, // G
    0x7F, 0x08, 0x08, 0x08, 0x7F, // H
    0x00, 0x41, 0x7F, 0x41, 0x00, // I
    0x30, 0x40, 0x40, 0x40, 0x3F, // J
    0x7F, 0x08, 0x14, 0x22, 0x41, // K
    0x7F, 0x40, 0x40, 0x40, 0x40, // L
    0x7F, 0x02, 0x0C, 0x02, 0x7F, // M
    0x7F, 0x02, 0x04, 0x08, 0x7F, // N
    0x3E, 0x41, 0x41, 0x41, 0x3E, // O
    0x7F, 0x09, 0x09, 0x09, 0x06, // P
    0x1E, 0x21, 0x21, 0x21, 0x5E, // Q
    0x7F, 0x09, 0x09, 0x09, 0x76, // R
    0x26, 0x49, 0x49, 0x49, 0x32, // S
    0x01, 0x01, 0x7F, 0x01, 0x01, // T
    0x3F, 0x40, 0x40, 0x40, 0x3F, // U
    0x1F, 0x20, 0x40, 0x20, 0x1F, // V
    0x7F, 0x20, 0x10, 0x20, 0x7F, // W
    0x41, 0x22, 0x1C, 0x22, 0x41, // X
    0x07, 0x08, 0x70, 0x08, 0x07, // Y
    0x61, 0x51, 0x49, 0x45, 0x43, // Z
    0x00, 0x7F, 0x41, 0x00, 0x00, // [
    0x02, 0x04, 0x08, 0x10, 0x20, //
    0x00, 0x00, 0x41, 0x7F, 0x00, // ]
    0x04, 0x02, 0x01, 0x02, 0x04, // ^
    0x40, 0x40, 0x40, 0x40, 0x40, // _
    0x00, 0x01, 0x02, 0x04, 0x00, // `
    0x20, 0x54, 0x54, 0x54, 0x78, // a
    0x7F, 0x44, 0x44, 0x44, 0x38, // b
    0x38, 0x44, 0x44, 0x44, 0x44, // c
    0x38, 0x44, 0x44, 0x44, 0x7F, // d
    0x38, 0x54, 0x54, 0x54, 0x18, // e
    0x04, 0x04, 0x7E, 0x05, 0x05, // f
    0x08, 0x54, 0x54, 0x54, 0x3C, // g
    0x7F, 0x08, 0x04, 0x04, 0x78, // h
    0x00, 0x44, 0x7D, 0x40, 0x00, // i
    0x20, 0x40, 0x44, 0x3D, 0x00, // j
    0x7F, 0x10, 0x28, 0x44, 0x00, // k
    0x00, 0x41, 0x7F, 0x40, 0x00, // l
    0x7C, 0x04, 0x78, 0x04, 0x78, // m
    0x7C, 0x08, 0x04, 0x04, 0x78, // n
    0x38, 0x44, 0x44, 0x44, 0x38, // o
    0x7C, 0x14, 0x14, 0x14, 0x08, // p
    0x08, 0x14, 0x14, 0x14, 0x7C, // q
    0x00, 0x7C, 0x08, 0x04, 0x04, // r
    0x48, 0x54, 0x54, 0x54, 0x20, // s
    0x04, 0x04, 0x3F, 0x44, 0x44, // t
    0x3C, 0x40, 0x40, 0x20, 0x7C, // u
    0x1C, 0x20, 0x40, 0x20, 0x1C, // v
    0x3C, 0x40, 0x30, 0x40, 0x3C, // w
    0x44, 0x28, 0x10, 0x28, 0x44, // x
    0x0C, 0x50, 0x50, 0x50, 0x3C, // y
    0x44, 0x64, 0x54, 0x4C, 0x44, // z
    0x00, 0x08, 0x36, 0x41, 0x41, // {
    0x00, 0x00, 0x7F, 0x00, 0x00, // |
    0x41, 0x41, 0x36, 0x08, 0x00, // }
    0x02, 0x01, 0x02, 0x04, 0x02, // ~

};

static const int symbol[8][5] =
{
	0x08, 0x08, 0x2A, 0x1C, 0x08,  // 1: ->
	0x7F, 0x7F, 0x3E, 0x1C, 0x08,  // 2: forward sign
	0x08, 0x1C, 0x3E, 0x7F, 0x7F,  // 3: reverse sign
	0x7F, 0x7F, 0x00, 0x7F, 0x7F,  // 4: pause sign
	0x3E, 0x3E, 0x3E, 0x3E, 0x3E,  // 5: stop sign
	0x7F, 0x3E, 0x1C, 0x08, 0x7F,  // 6: play sign
	0x7F, 0x1C, 0x3E, 0x1C, 0x08,  // 7: FF sign
	0x08, 0x1C, 0x3E, 0x1C, 0x7F,  // 8: FR sign
};


#endif /* LCD_H_ */
