#ifndef SD_CRAD_H_
#define SD_CRAD_H_


// Defines the size of the buffers that hold the path, or temporary data from
// the SD card.  There are two buffers allocated of this size.  The buffer size
// must be large enough to hold the longest expected full path name, including
// the file name, and a trailing null character.
#define PATH_BUF_SIZE           80

// Defines the size of the buffer that holds the command line.
#define CMD_BUF_SIZE            64

// This buffer holds the full path to the current working directory.  Initially it is root ("/").
static char g_pcCwdBuf[PATH_BUF_SIZE] = "/";

// A temporary data buffer used when manipulating file paths, or reading data from the SD card.
static char g_pcTmpBuf[PATH_BUF_SIZE];

// A macro that holds the number of result codes.
#define NUM_FRESULT_CODES (sizeof(g_psFResultStrings) /                 \
                           sizeof(tFResultString))

// A macro to make it easy to add result codes to the table.
#define FRESULT_ENTRY(f)        { (f), (#f) }

void SDinit();
void getDirContent();
void enterDir(char* dirName);
void readFile(char* fileName);
void openFile(char* fileName);	// Used for VS1063 play mode, like readFile, but main loop is done in VS1063play
void closeFile(char* fileName);


#endif
