#include "main.h"

// Forward declaration of the default fault handlers.
void ResetISR(void);
static void NmiSR(void);
static void FaultISR(void);
static void IntDefaultHandler(void);
static void SysTickHandler(void);

extern void _c_int00(void);   // External declaration for the reset handler that is to be called when the processor is started
extern uint32_t __STACK_TOP;  // Linker variable that marks the top of the stack.
extern struct qei ENC;		  // Struct to hold all encoder events
extern struct work context;	  // Struct to hold working context

// The vector table.  Note that the proper constructs must be placed on this to
// ensure that it ends up at physical address 0x0000.0000 or at the start of
// the program if located at a start address other than 0.
#pragma DATA_SECTION(g_pfnVectors, ".intvecs")
void (* const g_pfnVectors[])(void) =
{
    (void (*)(void))((uint32_t)&__STACK_TOP),
                                            // The initial stack pointer
    ResetISR,                               // The reset handler
    NmiSR,                                  // The NMI handler
    FaultISR,                               // The hard fault handler
    IntDefaultHandler,                      // The MPU fault handler
    IntDefaultHandler,                      // The bus fault handler
    IntDefaultHandler,                      // The usage fault handler
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    IntDefaultHandler,                      // SVCall handler
    IntDefaultHandler,                      // Debug monitor handler
    0,                                      // Reserved
    IntDefaultHandler,                      // The PendSV handler
    SysTickHandler,       	                // The SysTick handler
    IntDefaultHandler,                      // GPIO Port A
    IntDefaultHandler,                      // GPIO Port B
    GPIO_C_Handler,                  	    // GPIO Port C
    IntDefaultHandler,                      // GPIO Port D
    IntDefaultHandler,      	            // GPIO Port E
    IntDefaultHandler,                      // UART0 Rx and Tx
    IntDefaultHandler,                      // UART1 Rx and Tx
    IntDefaultHandler,                      // SSI0 Rx and Tx
    IntDefaultHandler,                      // I2C0 Master and Slave
    IntDefaultHandler,                      // PWM Fault
    IntDefaultHandler,                      // PWM Generator 0
    IntDefaultHandler,                      // PWM Generator 1
    IntDefaultHandler,                      // PWM Generator 2
    QEI0Handler,                   		    // Quadrature Encoder 0
    IntDefaultHandler,                      // ADC Sequence 0
    IntDefaultHandler,                      // ADC Sequence 1
    IntDefaultHandler,                      // ADC Sequence 2
    IntDefaultHandler,                      // ADC Sequence 3
    IntDefaultHandler,                      // Watchdog timer
    Timer0A_Handler,          	            // Timer 0 subtimer A
    IntDefaultHandler,                      // Timer 0 subtimer B
    Timer1A_Handler,         	            // Timer 1 subtimer A
    IntDefaultHandler,                      // Timer 1 subtimer B
    IntDefaultHandler,                      // Timer 2 subtimer A
    IntDefaultHandler,                      // Timer 2 subtimer B
    IntDefaultHandler,                      // Analog Comparator 0
    IntDefaultHandler,                      // Analog Comparator 1
    IntDefaultHandler,                      // Analog Comparator 2
    IntDefaultHandler,                      // System Control (PLL, OSC, BO)
    IntDefaultHandler,                      // FLASH Control
    IntDefaultHandler,                      // GPIO Port F
    GPIO_G_Handler,                   	    // GPIO Port G
    GPIO_H_Handler,           	            // GPIO Port H
    IntDefaultHandler,                      // UART2 Rx and Tx
    IntDefaultHandler,                      // SSI1 Rx and Tx
    IntDefaultHandler,                      // Timer 3 subtimer A
    IntDefaultHandler,                      // Timer 3 subtimer B
    IntDefaultHandler,                      // I2C1 Master and Slave
    QEI1Handler,     	                    // Quadrature Encoder 1
    IntDefaultHandler,                      // CAN0
    IntDefaultHandler,                      // CAN1
    0,                                      // Reserved
    0,                                      // Reserved
    IntDefaultHandler,                      // Hibernate
    IntDefaultHandler,                      // USB0
    IntDefaultHandler,                      // PWM Generator 3
    IntDefaultHandler,                      // uDMA Software Transfer
    IntDefaultHandler,                      // uDMA Error
    IntDefaultHandler,                      // ADC1 Sequence 0
    IntDefaultHandler,                      // ADC1 Sequence 1
    IntDefaultHandler,                      // ADC1 Sequence 2
    IntDefaultHandler,                      // ADC1 Sequence 3
    0,                                      // Reserved
    0,                                      // Reserved
    IntDefaultHandler,                      // GPIO Port J
    IntDefaultHandler,                      // GPIO Port K
    IntDefaultHandler,                      // GPIO Port L
    IntDefaultHandler,                      // SSI2 Rx and Tx
    IntDefaultHandler,                      // SSI3 Rx and Tx
    IntDefaultHandler,                      // UART3 Rx and Tx
    IntDefaultHandler,                      // UART4 Rx and Tx
    IntDefaultHandler,                      // UART5 Rx and Tx
    IntDefaultHandler,                      // UART6 Rx and Tx
    IntDefaultHandler,                      // UART7 Rx and Tx
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    IntDefaultHandler,                      // I2C2 Master and Slave
    IntDefaultHandler,                      // I2C3 Master and Slave
    IntDefaultHandler,                      // Timer 4 subtimer A
    IntDefaultHandler,                      // Timer 4 subtimer B
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    0,                                      // Reserved
    IntDefaultHandler,                      // Timer 5 subtimer A
    IntDefaultHandler,                      // Timer 5 subtimer B
    IntDefaultHandler,                      // Wide Timer 0 subtimer A
    IntDefaultHandler,                      // Wide Timer 0 subtimer B
    IntDefaultHandler,                      // Wide Timer 1 subtimer A
    IntDefaultHandler,                      // Wide Timer 1 subtimer B
    IntDefaultHandler,                      // Wide Timer 2 subtimer A
    IntDefaultHandler,                      // Wide Timer 2 subtimer B
    IntDefaultHandler,                      // Wide Timer 3 subtimer A
    IntDefaultHandler,                      // Wide Timer 3 subtimer B
    IntDefaultHandler,                      // Wide Timer 4 subtimer A
    IntDefaultHandler,                      // Wide Timer 4 subtimer B
    IntDefaultHandler,                      // Wide Timer 5 subtimer A
    IntDefaultHandler,                      // Wide Timer 5 subtimer B
    IntDefaultHandler,                      // FPU
    0,                                      // Reserved
    0,                                      // Reserved
    IntDefaultHandler,                      // I2C4 Master and Slave
    IntDefaultHandler,                      // I2C5 Master and Slave
    IntDefaultHandler,                      // GPIO Port M
    IntDefaultHandler,                      // GPIO Port N
    IntDefaultHandler,                      // Quadrature Encoder 2
    0,                                      // Reserved
    0,                                      // Reserved
    IntDefaultHandler,                      // GPIO Port P (Summary or P0)
    IntDefaultHandler,                      // GPIO Port P1
    IntDefaultHandler,                      // GPIO Port P2
    IntDefaultHandler,                      // GPIO Port P3
    IntDefaultHandler,                      // GPIO Port P4
    IntDefaultHandler,                      // GPIO Port P5
    IntDefaultHandler,                      // GPIO Port P6
    IntDefaultHandler,                      // GPIO Port P7
    IntDefaultHandler,                      // GPIO Port Q (Summary or Q0)
    IntDefaultHandler,                      // GPIO Port Q1
    IntDefaultHandler,                      // GPIO Port Q2
    IntDefaultHandler,                      // GPIO Port Q3
    IntDefaultHandler,                      // GPIO Port Q4
    IntDefaultHandler,                      // GPIO Port Q5
    IntDefaultHandler,                      // GPIO Port Q6
    IntDefaultHandler,                      // GPIO Port Q7
    IntDefaultHandler,                      // GPIO Port R
    IntDefaultHandler,                      // GPIO Port S
    IntDefaultHandler,                      // PWM 1 Generator 0
    IntDefaultHandler,                      // PWM 1 Generator 1
    IntDefaultHandler,                      // PWM 1 Generator 2
    IntDefaultHandler,                      // PWM 1 Generator 3
    IntDefaultHandler                       // PWM 1 Fault
};

// This is the code that gets called when the processor first starts execution
// following a reset event.  Only the absolutely necessary set is performed,
// after which the application supplied entry() routine is called.  Any fancy
// actions (such as making decisions based on the reset cause register, and
// resetting the bits in that register) are left solely in the hands of the
// application.
void ResetISR(void)
{
    // Jump to the CCS C initialization routine.  This will enable the
    // floating-point unit as well, so that does not need to be done here.
    //
    __asm("    .global _c_int00\n"
          "    b.w     _c_int00");
}

// This is the code that gets called when the processor receives a NMI.
static void NmiSR(void)
{
    while(1){} // Enter an infinite loop.
}


// This is the code that gets called when the processor receives a fault interrupt.
static void FaultISR(void)
{
	SysCtlReset();	// Reset the processor
    while(1) {}  // Enter an infinite loop.
}

// This is the code that gets called when the processor receives an unexpected interrupt.
static void IntDefaultHandler(void)
{
    while(1) {}  // Go into an infinite loop.
}

static void SysTickHandler(void)
{
    disk_timerproc(); // Call the FatFs tick timer.
}

void QEI0Handler()
{
	QEIIntClear(QEI0_BASE,QEI_INTDIR);									// Clear interrupt flag
	signed int loc = (ENC.ENC0_Value - QEIPositionGet(QEI0_BASE));		// Get diffrence between stored value and current value
	if(loc>0)															// Current Value lower than stored ?
	{
		ENC.ENC0_DOWN = ENC.ENC0_Value - QEIPositionGet(QEI0_BASE);		// Save diffrence
		context.event_flag = encoder_flag;								// Set eventflag
		context.enc_event = down0;
	}
	else if (loc<0)														// Current Value higher than stored ?
	{
		ENC.ENC0_UP = QEIPositionGet(QEI0_BASE) - ENC.ENC0_Value;
		context.event_flag = encoder_flag;
		context.enc_event = up0;
	}
	else
	{
		context.event_flag = no_event_flag;									// If the value is the same than there should be no event
		context.enc_event = no_event;
	}
	ENC.ENC0_Value=QEIPositionGet(QEI0_BASE);							// Store current value
	interruptCtrl();
}

void QEI1Handler()
{
	QEIIntClear(QEI1_BASE,QEI_INTDIR);									// Clear interrupt flag
	signed int loc = (ENC.ENC1_Value - QEIPositionGet(QEI1_BASE));		// Get diffrence between stored value and current value
	if(loc>0)															// Current Value lower than stored ?
	{
		ENC.ENC1_DOWN = ENC.ENC1_Value - QEIPositionGet(QEI1_BASE);		// Save diffrence
		context.event_flag = encoder_flag;									// Set eventflag
		context.enc_event = down1;
	}
	else if (loc<0)														// Current Value higher than stored ?
	{
		ENC.ENC1_UP = QEIPositionGet(QEI1_BASE) - ENC.ENC1_Value;
		context.event_flag = encoder_flag;
		context.enc_event = up1;
	}
	else
	{
		context.event_flag = no_event_flag;										// If the value is the same than there should be no event
		context.enc_event = no_event;
	}
	ENC.ENC1_Value=QEIPositionGet(QEI1_BASE);							// Store current value
	interruptCtrl();
}


void GPIO_C_Handler()
{
	//IntDisable(INT_GPIOC | INT_GPIOE);				// Disabel encoder and touch interrupt
	GPIOIntClear(TOUCH_IRQ_PORT,TOUCH_IRQ_PIN);			// Clear interrupt
	context.event_flag = touch_flag;
	interruptCtrl();
}

void GPIO_H_Handler()
{
	//IntDisable(INT_GPIOC | INT_GPIOE);				// Disabel encoder and touch interrupt
	GPIOIntClear(QEI0_BUT_PORT,QEI0_BUT_PIN|QEI1_BUT_PIN);// Clear interrupt
	context.event_flag = encoder_flag;
	if(GPIOPinRead(QEI0_BUT_PORT,QEI0_BUT_PIN))			// ENCS0 ?
	{
		context.enc_event=push0;
	}
	else if(GPIOPinRead(QEI0_BUT_PORT,QEI1_BUT_PIN))	// ENCS1 ?
	{
		context.enc_event=push1;
	}
	else												// Some error or noise might be occured so it will be ignored
	{
		context.enc_event=no_event;
		context.event_flag = no_event_flag;
	}
	interruptCtrl();
}

void GPIO_G_Handler()
{
	GPIOIntClear(VS_DRQ_BASE,VS_DRQ);			// Clear interrupt
	context.event_flag = data_req_flag;
	interruptCtrl();
}

void Timer0A_Handler()
{
	//Clear timer interrupt flag
	TimerIntClear(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
	TimerDisable(TIMER0_BASE,TIMER_A);

}
void Timer1A_Handler()
{
	//Clear timer interrupt flag
	TimerIntClear(TIMER1_BASE, TIMER_TIMA_TIMEOUT);
	TimerDisable(TIMER1_BASE,TIMER_A);

}
