#include <main.h>

extern struct work context;

uint16_t X_Pos, Y_Pos ;					// Integer for the position
uint32_t Y_Data, X_Data;					// Define databuffers for positions
uint8_t LY_Data, LX_Data;					// Define databuffers for positions
uint8_t X_Buf, Y_Buf;					// Define databuffers for positions

void Touchinit()
{
	SysCtlPeripheralEnable(TOUCH_SSI_PER); 										// Enable clock for SSI modul
	//GPIOPinConfigure(GPIO_PA5_SSI0TX);										// Set AF function
	//GPIOPinConfigure(GPIO_PA4_SSI0RX);
	//GPIOPinConfigure(GPIO_PA2_SSI0CLK);
	GPIOPinTypeSSI(TOUCH_SSI_PORT,TOUCH_SSI_CLK|TOUCH_SSI_MISO|TOUCH_SSI_MOSI);				 // Select SSI pins for AF
	GPIOPadConfigSet(TOUCH_SSI_PORT,TOUCH_SSI_MISO,GPIO_STRENGTH_4MA,GPIO_PIN_TYPE_STD_WPU); // Enable weak pull up for RX pin

	GPIOPinTypeGPIOOutput(TOUCH_CS_PORT, TOUCH_CS_PIN);										// Config CS pin as an output
	GPIOPinTypeGPIOInput(TOUCH_IRQ_PORT, TOUCH_IRQ_PIN);									// Config IRG pin as an input
	GPIOPinWrite(TOUCH_CS_PORT, TOUCH_CS_PIN, TOUCH_CS_PIN);								// Set CS high
	GPIOPadConfigSet(TOUCH_CS_PORT,TOUCH_CS_PIN,GPIO_STRENGTH_8MA,GPIO_PIN_TYPE_STD);		// Set CS as push pull with 8mA
	GPIOPadConfigSet(TOUCH_IRQ_PORT,TOUCH_IRQ_PIN,GPIO_STRENGTH_6MA,GPIO_PIN_TYPE_STD_WPU); // Enable weak pull up for IRG pin

	// Clock from CPU, mastermode, 400kHz,8bit, capture on falling edge
	SSIConfigSetExpClk(TOUCH_SSI_BASE,80000000,SSI_FRF_MOTO_MODE_0,SSI_MODE_MASTER,1000000,8);
	SSIEnable(TOUCH_SSI_BASE);												// Enable SSI0 modul
	X_Pos = Y_Pos = 0;
}

// Write/Red from the touchscreen IC, convert data and switch through all menu layer
void getTouchData()
{
	X_Pos = Y_Pos = 0;
	GPIOPinWrite(TOUCH_CS_PORT, TOUCH_CS_PIN,0);				// CS low
	ROM_SysCtlDelay(100);											// Wait some time
	for(count=0;count<5;count++)
	{
		X_Data = Y_Data = 0;
		if(count==0)	  SSIDataPut(TOUCH_SSI_BASE,0x0098);			// Get X position, DFR, 8bit, low power mode
		else if(count==2) SSIDataPut(TOUCH_SSI_BASE,0x00D8);			// Get Y position, DFR, 8bit, low power mode
		else 			  SSIDataPut(TOUCH_SSI_BASE,0x0000);			// Send dummybyt to read the next data
		while(SSIBusy(TOUCH_SSI_BASE)) ;								// Wait untill SSI is ready again
		ROM_SysCtlDelay(10000);										// Wait some time
		if(count<3)
		{
			SSIDataGetNonBlocking(TOUCH_SSI_BASE,&X_Data);	// Get X_Data
			data[count] = X_Data;						// Save received data
		}
		else
		{
			SSIDataGetNonBlocking(TOUCH_SSI_BASE,&Y_Data);	// Get Y_Data
			data[count] = Y_Data;
		}
		LX_Data = (0xFF & X_Data);
		LY_Data = (0xFF & Y_Data);
		X_Buf = (LX_Data<<1);							// First MSB is allways zero, with the shift the LSB is cut off
		Y_Buf = (LY_Data<<1);
		X_Pos += X_Buf;									// Add byte to the whole data
		Y_Pos += Y_Buf;
	}
	GPIOPinWrite(TOUCH_CS_PORT,TOUCH_CS_PIN,TOUCH_CS_PIN);		// Deselect CS

	X_Pos = 300 - X_Pos * 300 / 255;							// Scale the raw data
	Y_Pos = 220 - Y_Pos * 200 / 255;

	writeString(IntToString(X_Pos),50,150,green,1,black);
	writeString(IntToString(Y_Pos),50,160,red,1,black);

	// Each menu has it's own button content and must be analysed seperatly
	switch (context.cur_menu)
	{
	 case start:
	 {
		if(Y_Pos>180) 			// The buttons are in button of the display with a high of 60 pixel
		{
			if(X_Pos<80)						// Button on the right is pressed
			{
				context.touch_event = BUT_OFF;
			}
			else if(X_Pos>80 && X_Pos<160)		// Button on the middel right is pressed
			{
				context.touch_event = BUT_SETUP;
			}
			else if(X_Pos>160 && X_Pos<240)		// Button on the middel left is pressed
			{
				context.touch_event = BUT_INFO;
			}
			else								// Button on the left is pressed
			{
				context.touch_event = BUT_PLAYER;
			}
		}
	 }
     break;

	 case player:
	 {
	  if(Y_Pos<200 && Y_Pos>160) 					// Button in the upper button row is pressed
	  {
		  if(X_Pos<80)							// Right button
		  {
			  context.touch_event = BUT_REVERS;
			  break;
		  }
		  else if(X_Pos>80 && X_Pos<160)		// Middle right button
		  {
			  context.touch_event = BUT_PP;
			  break;
		  }
		  else if(X_Pos>160 && X_Pos<240)		// Middle left button
		  {
			  context.touch_event = BUT_STOP;
		  }
		  else context.touch_event = BUT_FORWARD;	// Left button
	  }
	  else if(Y_Pos>200)							// Button in the lower button row is pressed
	  	   {
		  	  if(X_Pos<80)							// Right button
		  	  {
		  		  context.touch_event = BUT_FR;
		  		  break;
		  	  }
		  	  else if(X_Pos>80 && X_Pos<160)		// Middle right button
		  	  {
		  		  context.touch_event = NO_EVENT;
		  		  break;
		  	  }
		  	  else if(X_Pos>160 && X_Pos<240)		// Middle left button
		  	  {
		  		  context.touch_event = BUT_EQ;
		  	  }
		  	  else context.touch_event = BUT_FF;	// Left button
	  	   }
	 }
	 break;

	 case eq:
	 {
		  if(Y_Pos>180) 			// Event in lower Display row ?
		  {
			  if(X_Pos<80)		// Select on of the four buttons
			  {
				  context.touch_event = BUT_BACK;
				  break;
			  }
			  else if(X_Pos>80 && X_Pos<160)
			  {
				  context.touch_event = NO_EVENT;
				  break;
			  }
			  else if(X_Pos>160 && X_Pos<240)
			  {
				  context.touch_event = NO_EVENT;
			  }
			  else context.touch_event = BUT_ENTER;
		  }
	 }
	 break;

	 case select:
	 {
		 if(Y_Pos>180) 			// Event in lower Display row ?
		 {
			 if(X_Pos<80)		// Select on of the four buttons
			 {
				 context.touch_event = BUT_BACK;
				 break;
			 }
			 else if(X_Pos>80 && X_Pos<160)
			 {
				 context.touch_event = NO_EVENT;
				 break;
			 }
			 else if(X_Pos>160 && X_Pos<240)
			 {
				 context.touch_event = NO_EVENT;
			 }
			 else context.touch_event = BUT_ENTER;
		 }
	 }
	 	 break;


	 case setup:
	 {
		 if(Y_Pos>180) 			// Event in lower Display row ?
	 	 {
			 if(X_Pos<80)		// Select on of the four buttons
			 {
				 context.touch_event = BUT_BACK;
				 break;
			 }
			 else if(X_Pos>80 && X_Pos<160)
			 {
	 			 context.touch_event = NO_EVENT;
			 }
			 else if(X_Pos>160 && X_Pos<240)
			 {
				 context.touch_event = NO_EVENT;
			 }
			 else context.touch_event = BUT_ENTER;
	 	 }
	 }
	 break;

	 case info:
		 break;

	 default:
		 break;
	}
}

