/** @file HL_sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com  
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "HL_sys_common.h"

/* USER CODE BEGIN (1) */
#include "HL_sci.h"
#include "HL_eqep.h"
#include "HL_sys_core.h"
#include "HL_gio.h"
#include "HL_rti.h"
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
void sciDisplayText(sciBASE_t *sci, uint8 *text, uint32 length);

#define UNIT_POSITION_X 60U
#define VCLK3_MHZ 75U
#define RESOLUTION 4U   /*We will get 4 times resolution if we use quadrature input*/
#define ENCODER_LINES 1U
#define CIRCUMFERENCE 3.1

uint8 Vclk3_divider[8] = {1, 2, 4, 8, 16, 32, 64, 128};
uint32 deltaT = 0U;
uint16 Speed_In_RPM = 0U;
uint8 Array_Speed_In_KMPH[5];
uint16 Register_Value;
uint8_t direction;
uint16 Speed_In_KMPH = 0U;
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    /* EQEP initialization based on GUI Configuration. */
    QEPInit();
    gioInit();
    rtiInit();
    sciInit();

    _enable_IRQ_interrupt_();

    rtiEnableNotification(rtiREG1,rtiNOTIFICATION_COMPARE0);

    rtiStartCounter(rtiREG1,rtiCOUNTER_BLOCK0);

    /* Enable Position Counter */
    eqepEnableCounter(eqepREG2);

    /* Enable Unit Timer. */
    eqepEnableUnitTimer(eqepREG2);

    /* Enable capture timer and capture period latch. */
    eqepEnableCapture(eqepREG2);



    while(1)
    {
        /* Status flag is set to indicate that a new value is latched in the QCPRD register. */
        if((eqepREG2->QEPSTS & 0x80U) !=0U)
        {
            /* Elapsed time between unit position events */
            deltaT = eqepREG2->QCPRD;

            Register_Value = eqepREG2->QCAPCTL;
            Register_Value &= eQEP_QCAPCTL_CCPS;
            Register_Value = (Register_Value >>4);

            /*Converting delta T into uSec*/
            deltaT = ((Vclk3_divider[(((uint16)eqepREG2->QCAPCTL & eQEP_QCAPCTL_CCPS) >> 4)] * deltaT) / VCLK3_MHZ);

            /* Calculate Speed from deltaT and the value of the unit position. */
            /* The value of Unit Position is a sample value and should be changed by the User as per the actual value in the UNIT_POSITION_X macro above. */
            Speed_In_RPM = ((UNIT_POSITION_X*1000000/deltaT)/(RESOLUTION * ENCODER_LINES));
            Speed_In_KMPH = ((Speed_In_RPM * CIRCUMFERENCE * 60)/1000);

            sciDisplayText(sciREG1, "Speed = ", 8);

            uint8_t count = 0;
            while(Speed_In_KMPH)
            {
                uint8_t temp;
                temp = (Speed_In_KMPH % 10);
                Array_Speed_In_KMPH[count] = temp + 48;  /*Converting decimal to ASCII*/
                Speed_In_KMPH /= 10;
                count++;
            }

            while(count)
            {
                sciDisplayText(sciREG1, &Array_Speed_In_KMPH[count - 1], 1);
                count--;
            }

            sciDisplayText(sciREG1, " KMPH \n", 7);

            if(eqepREG2->QEPSTS & (1 << 5))
            {
                direction = 1; /* forward direction */
            }
            else
            {
                direction = 2; /* Reverse direction */
            }

            /* Clear the Status flag. */
            eqepREG2->QEPSTS |= 0x80U;
        }
    }

/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */

void sciDisplayText(sciBASE_t *sci, uint8 *text,uint32 length)
{
    while(length--)
    {
        while ((sciREG1->FLR & 0x4) == 4); /* wait until busy */
        sciSendByte(sciREG1,*text++);      /* send out text   */
    };
}

void rtiNotification(rtiBASE_t *rtiREG, uint32 notification)
{
    static uint8_t count=0;
    count++;
    if(count == 1)
    {
        gioToggleBit(gioPORTA, 0);
    }
    else if(count == 2)
    {
        gioToggleBit(gioPORTA, 1);
        count = 0;
    }
    else
    {
        ;
    }
}
/* USER CODE END */
