/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "mibspi.h"
#include "sys_dma.h"
#include "stdio.h"
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
void mibspiDmaConfig(mibspiBASE_t *mibspi,uint32 channel, uint32 txchannel, uint32 rxchannel);
void dmaConfigCtrlRxPacket(uint32 sadd,uint32 dadd,uint32 dsize);
void dmaConfigCtrlTxPacket(uint32 sadd,uint32 dadd,uint32 dsize);
void loadDataPattern1(uint32 psize, uint8* pptr);
void loadDataPattern3(uint32 psize, uint8* pptr);
#define D_SIZE      610
#define DMA_CH_TX  DMA_CH0
#define DMA_CH_RX  DMA_CH1

/* SPI1 transmit buffer in sys ram */
uint8 mibSPI1_TX_Data[D_SIZE]= "$GPZDA,hhmmss.ss,dd,mm,yyyy,aa,bb*CS<CR><LF>$GPGLL,llll.lllll,a,yyyyy.yyyyy,b,hhmmss.ss,c,a*CS<CR><LF>$GPGSV,t,n,xx,aa,ee,zzz,cc,aa,ee,zzz,cc,aa,ee,zzz,cc,aa,ee,zzz,cc*CS<CR><LF>$GPRMC,hhmmss.ss,A,llll.lllll,A,yyyyy.yyyyy,B,ssss.ss,hhh.hh,ddmmyy,mm.m,D,B*CS<CR><LF>$GPGGA,hhmmss.ss,llll.lllll,A,yyyyy.yyyyy,B,q,nn,hh.h,aaaaa.a,M,sss.s,M,a.a,aaaa*CS<CR><LF>$GPGSA,a,m,s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,s11,s12,pp.p,hh.h,vv.v*CS<CR><LF>$GPVTG,ddd.dd,T,ddd.dd,M,ssss.ss,N,ssss.ss,K,a*CS<CR><LF>";
/* SPI2 transmit  buffer in sys ram */
uint8 mibSPI3_TX_Data[D_SIZE];
/* SPI1 receive buffer in sys ram */
uint8 mibSPI1_RX_Data[D_SIZE]= {0};
/* SPI2 receive  buffer in sys ram */
uint8 mibSPI3_RX_Data[D_SIZE]= {0};

g_dmaCTRL g_dmaCTRLPKT_RX;  /* dma control packet configuration stack for receive */
g_dmaCTRL g_dmaCTRLPKT_TX;  /* dma control packet configuration stack for transmit */
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    uint32 i;
    /* - initializing mibspi - enabling Transfer Group 0 , length 128 (halcogen file)*/
    mibspiInit();
    //loadDataPattern1(D_SIZE,&mibSPI1_TX_Data[0]);

    loadDataPattern3(D_SIZE,&mibSPI3_TX_Data[0]);
/****************************************/

    /* DMA Request Sources: MIBSPI3[0] -> request line 15 */
    dmaReqAssign(DMA_CH_TX,15 );    /* Transmit data DMA channel enable. */
    /* DMA Request Sources: MIBSPI3[1] -> request line 14 */
    dmaReqAssign(DMA_CH_RX,14 );    /* Receive data DMA channel enable. */
    /* - configuring dma control packet for sending data to mibSPI3 tx buffer*/
    dmaConfigCtrlRxPacket((uint32)&(mibspiRAM3->rx[0].data),(uint32)&(mibSPI3_RX_Data),D_SIZE);
    /* - configuring dma control packet for receiving data from mibSPI3 rx buffer*/
    dmaConfigCtrlTxPacket((uint32)&(mibSPI3_TX_Data),(uint32)&(mibspiRAM3->tx[0].data),D_SIZE);

    /* - setting dma control packets for transmit */
    dmaSetCtrlPacket(DMA_CH_TX,g_dmaCTRLPKT_TX);
    /* - setting dma control packets for Receive */
    dmaSetCtrlPacket(DMA_CH_RX,g_dmaCTRLPKT_RX);

    /* - configuring the mibspi dma , channel 0 , txline -15 , rxline -14 */
    mibspiDmaConfig(mibspiREG3,DMA_CH_TX,14,15);
/****************************************/

    /* DMA Request Sources: MIBSPI1[0] -> request line 1 */
    dmaReqAssign(DMA_CH_TX,1 );
    /* - assigning dma request: channel-1 */
    /* DMA Request Sources: MIBSPI1[1] -> request line 0 */
    dmaReqAssign(DMA_CH_RX,0 );

    /* - configuring dma control packet for sending data to mibSPI1 tx buffer*/
    dmaConfigCtrlTxPacket((uint32)&(mibSPI1_TX_Data),(uint32)&(mibspiRAM1->tx[0].data),D_SIZE);
    /* - configuring dma control packet for receiving data from mibSPI1 rx buffer*/
    dmaConfigCtrlRxPacket((uint32)&(mibspiRAM1->rx[0].data),(uint32)&(mibSPI1_RX_Data),D_SIZE);

    /* - setting dma control packets for transmit */
    dmaSetCtrlPacket(DMA_CH_TX,g_dmaCTRLPKT_TX);        // RAM to MIBSPIRAM
    /* - setting dma control packets for Receive */
    dmaSetCtrlPacket(DMA_CH_RX,g_dmaCTRLPKT_RX);        // MIBSPIRAM to RAM

    /* - configuring the mibspi dma , channel 0 , txline -1 , rxline -0 */
    mibspiDmaConfig(mibspiREG1,DMA_CH_TX,0,1);
/****************************************/
    /* - setting the dma channel to trigger on h/w request */
    dmaSetChEnable(DMA_CH_TX,DMA_HW);
    dmaSetChEnable(DMA_CH_RX, DMA_HW);

    /* Enable Interrupt after reception of data */
    dmaEnableInterrupt(DMA_CH_TX,FTC); /* FTC: Frame Transfer Complete Interrupt */
    dmaEnableInterrupt(DMA_CH_RX,FTC); /* FTC: Frame Transfer Complete Interrupt */

    _enable_IRQ();
    /* enable DMA now to make sure it's ready to take requests   */
    dmaEnable();

    /**** Set up slave *****/

    /* Initiate the receive buffer */
    mibspiSetData(mibspiREG3,1,mibSPI3_TX_Data);
    /* - start the mibspi transfer tg 1 */
    mibspiTransfer(mibspiREG3,1);

    /**** Set up master ****/

    /* Initiate the transmit buffer */
    mibspiSetData(mibspiREG1,0,mibSPI1_TX_Data);
    /* - start the mibspi transfer tg 0 */
    mibspiTransfer(mibspiREG1,0);

    /* ... wait until transfer complete  */
    while(!(mibspiIsTransferComplete(mibspiREG1,0)));
    while(!(mibspiIsTransferComplete(mibspiREG3,1)));

    /* copy from mibspi ram to sys ram */
    mibspiGetData(mibspiREG3, 1, mibSPI3_RX_Data);

    for(i=0;i<=D_SIZE;i++)
    {
        printf("\r\n%d mibSPI1_TX_Data: 0x%04x mibSPI3_RX_Data: 0x%04x  ",i, mibSPI1_TX_Data[i], mibSPI3_RX_Data[i]);
    }
    while(1);
/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
void dmaConfigCtrlTxPacket(uint32 sadd,uint32 dadd,uint32 dsize)
{
    g_dmaCTRLPKT_TX.SADD      = sadd;              /* source address             */
    g_dmaCTRLPKT_TX.DADD      = dadd;              /* destination  address       */
    g_dmaCTRLPKT_TX.CHCTRL    = 0;                 /* channel control            */
    g_dmaCTRLPKT_TX.FRCNT     = 1;                 /* frame count                */
    g_dmaCTRLPKT_TX.ELCNT     = dsize;             /* element count              */
    g_dmaCTRLPKT_TX.ELDOFFSET = 4;                 /* element destination offset */
    g_dmaCTRLPKT_TX.ELSOFFSET = 0;                 /* element source offset */
    g_dmaCTRLPKT_TX.FRDOFFSET = 0;                 /* frame destination offset   */
    g_dmaCTRLPKT_TX.FRSOFFSET = 0;                 /* frame destination offset   */
    g_dmaCTRLPKT_TX.PORTASGN  = 4;                 /* port b                     */
    g_dmaCTRLPKT_TX.RDSIZE    = ACCESS_16_BIT;     /* read size                  */
    g_dmaCTRLPKT_TX.WRSIZE    = ACCESS_16_BIT;     /* write size                 */
    g_dmaCTRLPKT_TX.TTYPE     = FRAME_TRANSFER ;   /* transfer type              */
    g_dmaCTRLPKT_TX.ADDMODERD = ADDR_INC1;         /* address mode read          */
    g_dmaCTRLPKT_TX.ADDMODEWR = ADDR_OFFSET;       /* address mode write         */
    g_dmaCTRLPKT_TX.AUTOINIT  = AUTOINIT_ON;       /* autoinit                   */
}

void dmaConfigCtrlRxPacket(uint32 sadd,uint32 dadd,uint32 dsize)
{
    g_dmaCTRLPKT_RX.SADD      = sadd;              /* source address             */
    g_dmaCTRLPKT_RX.DADD      = dadd;              /* destination  address       */
    g_dmaCTRLPKT_RX.CHCTRL    = 0;                 /* channel control            */
    g_dmaCTRLPKT_RX.FRCNT     = 1;                 /* frame count                */
    g_dmaCTRLPKT_RX.ELCNT     = dsize;             /* element count              */
    g_dmaCTRLPKT_RX.ELDOFFSET = 0;                 /* element destination offset */
    g_dmaCTRLPKT_RX.ELSOFFSET = 4;                 /* element source offset */
    g_dmaCTRLPKT_RX.FRDOFFSET = 0;                 /* frame destination offset   */
    g_dmaCTRLPKT_RX.FRSOFFSET = 0;                 /* frame destination offset   */
    g_dmaCTRLPKT_RX.PORTASGN  = 4;                 /* port b                     */
    g_dmaCTRLPKT_RX.RDSIZE    = ACCESS_16_BIT;     /* read size                  */
    g_dmaCTRLPKT_RX.WRSIZE    = ACCESS_16_BIT;     /* write size                 */
    g_dmaCTRLPKT_RX.TTYPE     = FRAME_TRANSFER ;   /* transfer type              */
    g_dmaCTRLPKT_RX.ADDMODERD = ADDR_OFFSET;       /* address mode read          */
    g_dmaCTRLPKT_RX.ADDMODEWR = ADDR_INC1;         /* address mode write         */
    g_dmaCTRLPKT_RX.AUTOINIT  = AUTOINIT_ON;       /* autoinit                   */
}

void mibspiDmaConfig(mibspiBASE_t *mibspi,uint32 channel, uint32 txchannel, uint32 rxchannel)
{
    uint32 bufid  = D_SIZE - 1;
    uint32 icount = 0;

    /* setting transmit and receive channels */
    mibspi->DMACTRL[channel] |= (((rxchannel<<4)|txchannel) << 16);

    /* enabling transmit dma */
    mibspi->DMACTRL[channel] |=  0x00008000;                            // RX DMA Enable
    mibspi->DMACTRL[channel] |=  0x00004000;                            // TX DMA Enable

    mibspi->DMACNTLEN = 0x1;
    /* setting Initial Count of DMA transfers and the buffer utilized for DMA transfer */
    mibspi->DMACTRL[channel] |=  (icount << 8) |(bufid<<24) | (0 << 13);

    mibspi->DMACOUNT[channel] |= (0x0262<<16) | (0x0000<<0);

}

void loadDataPattern1(uint32 psize, uint8* pptr)
{
    int i;
    for(i=0;i<psize;i++)
    {
        pptr[i] = i;
    }
 }

 void loadDataPattern3(uint32 psize, uint8* pptr)
{
    int i;
    for(i=0;i<psize;i++)
    {
        pptr[i] = i+128;
    }
 }
/* USER CODE END */
