#include <stdint.h>
#include <stdbool.h>
#include "inc/hw_ints.h"
#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/uart.h"
#include "driverlib/interrupt.h"
#include "inc/tm4c123gh6pm.h"
#include "inc/hw_i2c.h"
#include "driverlib/i2c.h"
#include "inc/hw_gpio.h"
#include "driverlib/eeprom.h"

 uint8_t point_L;
 uint8_t point_H;
// Generic definition
#define	one_second	13333333
#define	_50ms	1333333
int	y=0, Sim900DataIndx = 0;
	extern uint8_t uart_temp = 0x0, operator = 0;
	uint8_t	array_1[24];
	int32_t SIM900BUFF[100];
	int i = 0;
	bool RFID_intrpt= false;
	int	z=0;
	int	k=0;
	int	J=0;
	int G=0;
	int H=0;
	int	j=0;
	int c=0;
	int V=0;
	int W=0;
	int	d=0;
	int F=0;
	bool M=false;
	bool Roll_over=false;
	int CARD_NUM=0;
	int CARD_INDEX=0;
	uint8_t t=0x0;
	uint8_t Pointer_H;
	uint8_t Pointer_L;
	uint8_t Pointer_HR;
	uint8_t Pointer_LR;
	uint8_t RECV_ARRAY[100];
	unsigned long data;
	uint8_t	Chip_addre;
	///////////////////Generic Defination///////////////////////////////////////////////////
//	#define	Chip_addre  0x50
//	#define	Pointer_H	0x0				//bits 13,14,15 is DONT CARE for 32K & bits 14,15,16 Is DONT CARE for 64K
//	#define	Pointer_L	0x1
	uint16_t CARD_RECV_LOC[32]={0x0001,0x0020,0x0040,0x0060,0x0080,0x00A0,0x00C0,0x00E0,0x0100,0x0120,0x0140,0x0160,0x0180,0x01A0,0x01C0,0x01E0,0x0200,0x0220,0x0240,0x0260,0x0280,0x02A0,0x02C0,0x02E0,0x0300,0x0320,0x0340,0x0360,0x0380,0x03A0,0x03C0,0x03E0};
	uint16_t	Temp2;
	uint16_t	Temp1;
//Generic definitions

// The Display data are defined below for the LCD:
	uint8_t	temp_addr,temp_data;
	uint8_t customchar[8]={0x1f,0x0e,0x0e,0x04,0x04,0x04,0x04,0x04};
	uint8_t NET_LO[8]={0x0,0x0,0x0,0x0,0x0,0x8,0x18,0x18};
	uint8_t NET_MED[8]={0x0,0x0,0x0,0x0,0x4,0xc,0x1c,0x1c};
	uint8_t NET_HI[8]={0x1,0x1,0x1,0x3,0x7,0xf,0x1f,0x1f};//{0x1,0x1,0x1,0x3,0x7,0xf,0x1f,0x1f};
	uint8_t	NoEcho[] = "ATE0\r";
	uint8_t	Echo[] = "ATE1\r";
	uint8_t	ShrtResp[] = "ATV0\r";
	uint8_t	SimReg[] = "AT+CREG?\r";
	uint8_t	ChkGPRS[] = "AT+CGATT=1\r";
	uint8_t	ChkRSSI[] = "AT+CSQ\r";
	uint8_t	ChkOper[] = "AT+COPS?\r";
	uint8_t	IPSHUT[] = "AT+CIPSHUT\r";

	uint8_t	NoEchoRply[] = "\r\nOK\r\n";
	uint8_t	NoEchoRply2[] = "0\r";
	uint8_t	ShrtRespRply[] = "0\r";
	uint8_t	SimRegRplyHome[] = "\r\n+CREG: 0,1\r\n0\r";
	uint8_t	SimRegRplyRoam[] = "\r\n+CREG: 0,5\r\n0\r";
	uint8_t	SimRegRplyNRS[] = "\r\n+CREG: 0,2\r\n0\r"; // Not registered - searching
	uint8_t	SimRegRplyNRF[] = "\r\n+CREG: 0,0\r\n0\r";// Not registered at all
	uint8_t	ChkGPRSRply[] = "0\r";					//"\r\n+CGATT: 1\r\n";
////////////////////////////////GPRS DIALING COMMANDS//////////////////////
	uint8_t	SimAPN[]			=	"AT+CSTT=\"airtelgprs\"\r";			//"live.vodafone.com\"
	uint8_t	WirelessConn[]		=	"AT+CIICR\r";
	uint8_t	SimIP[]				=	"AT+CIFSR\r";
	uint8_t	DomainPort[]		=	"AT+CIPSTART=\"udp\",\"ifabex.dyndns.org\",\"11000\"\r";
	uint8_t	SendData[]			=	"AT+CIPSEND\r";

	uint8_t	SimAPNRply[]		=	"0\r";
	uint8_t	WirelessConnRply[]	=	"\r\nOK\r\n";
	uint8_t	SimIPRply[]			=	"4\r";
	uint8_t	DomainPortRply[]	=	"0\r\r\nCONNECT OK\r\n";
	uint8_t	DomainPortRply1[]	=	"\r\nERROR\r\n\r\nALREADY CONNECT\r\n";
	uint8_t	SendDataRply[]		=	"\r\n>";
/////////////////////////////////////////////////////////////////////////
	uint8_t	GSMErr[] = "Sim Unregistered";
	uint8_t	GSMROAM[] = "  Sim  Roaming  ";
	uint8_t	GSMHOME[] = " Sim Registered ";
	uint8_t	SHOWCARD[] = " Show The Card ";
	uint8_t	ServConn[] = "Server Connected";
	uint8_t	ServDisCon[] = "Connecting Servr";
	uint8_t	GSMFail1[] = "GSM TEST REPORT ";
	uint8_t	GSMFail2[] = "GSM SIM FAILURE ";
	uint8_t	EM18Fail1[] = "EM18 TEST REPORT";
	uint8_t	EM18Fail2[] = "EM18 SENS. FAIL ";
	uint8_t	GSMOk1[] = "GSM TEST OK     ";
	uint8_t	EM18Ok1[] = "EM18 TEST OK    ";
	uint8_t Pulse17[]= "PULSE17 RFID SYS Based Attendance System";
	uint8_t Pulse17Short[]= "PULSE17";
	uint8_t CCare[]= "For any problems, please call Customer Care at +919007145415 / Email: ifabex@outlook.com";
	uint8_t	ChkGSM[] = "                ";
	uint8_t	ChkGPRSConn[] = " Checking  GPRS ";
	uint8_t	ChkGSM2[] = "  Please  wait  ";
	uint8_t	GPRSOK[] = " GPRS Connected ";
	uint8_t	GPRSFail[] = "  GPRS Failure  ";
	uint8_t	ChkOperName[] = " Searching Oper.";
	uint8_t	ChkRSSILcd[] = "Checking Signal ";
	uint8_t Oper1[] = "Airtl   ";
	uint8_t Oper2[] = "Vodfn";
	uint8_t Oper3[] = "Relnc           ";
	uint8_t Oper4[] = "Reliance GSM    ";
	uint8_t Oper5[] = "Relnc";
	uint8_t a[]= ":";
	uint8_t ATN[]="ATTENDANCE SYSTM";
	uint8_t IFT[]="DEVELOPED BY IFABEX TECHNOLOGIES";
// Please enter the RTC details below
	uint8_t RTCSetup[7] = {0x00,0x10,0x03,0x06,0x23,0x01,0x15}; // format: SS,MM,HH,WW,dd,mm,yy
	uint8_t RTCData[7]= {'s','m','h','w','D','M','Y'}; //this is the read data from the RTC
	uint8_t RTCRegister=0x00;		// contains the register being set, starts with 00 for CH SSS SSSS
	uint32_t pui32Read[40];
	uint8_t temp0 = 0x00;
	bool	run_once = true,ServerConnected = true;		// set this true iff you need to set the clock
	uint8_t ui8InitLCD = 0x30;
	uint8_t ui8InitLCD_Func = 0x28;
	uint8_t ui8InitLCD_dispClr = 0x01;
	uint8_t ui8InitLCD_Home = 0x02;
	uint8_t ui8InitLCD_EMS = 0x06;
	uint8_t ui8InitLCD_Cursor = 0x10;
	uint8_t ui8InitLCD_DispOnOff = 0x0c;
	uint32_t data_read = 0x34;
	uint8_t Hour_T = 0x0;
	uint8_t Hour_U = 0x0;
	uint8_t Min_T = 0x0;
	uint8_t Min_U = 0x0;
	uint8_t Sec_T = 0x0;
	uint8_t Sec_U = 0x0;
	//int Sec_U=0;
	uint8_t DOW_U = 0x0;
	uint8_t DOW_T = 0x0;
	uint8_t Day_T = 0x0;
	uint8_t Day_U = 0x0;
	uint8_t Month_T = 0x0;
	uint8_t Month_U = 0x0;
	uint8_t Year_T = 0x0;
	uint8_t Year_U = 0x0;
	//int32_t ConcatData1[40];	// concatenated data of card + rtc + fixed char for every school = 30 chars.
	uint8_t ConcatData[40];
	//uint8_t b[]= Sec_U;

////////////////////////////////udf//////////////////////////////////////////




	void	LCDEnable()
			{
				GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2, 0x04);
				SysCtlDelay(11000);
				GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2, 0x00);
				SysCtlDelay(11000);
			}
	void LCDCLR(void)
	{
		temp_addr = 0x01;
		GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_3, 0x00);
		SysCtlDelay(11000);
		GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		LCDEnable();
		SysCtlDelay(200000);
		temp_addr<<=4;
		GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		LCDEnable();
		SysCtlDelay(200000);
	}
	void	RTC_LCD_Disp(uint8_t startAddr,uint8_t LCDData)
			{
				uint8_t RTCLCDTemp = 0;
				GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x00); // this makes the RS = 0, sending the address
				SysCtlDelay(8000);

				RTCLCDTemp = startAddr;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,RTCLCDTemp); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(8000);
				RTCLCDTemp<<=4;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,RTCLCDTemp); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(8000);

				GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x08); // this makes the RS = 1, sending the data
				SysCtlDelay(8000);

				RTCLCDTemp = LCDData;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,RTCLCDTemp); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(8000);
				RTCLCDTemp<<=4;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,RTCLCDTemp); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(8000);


			}

	void	LCDConfig()
		{
			GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x00); // this makes the RS = 0
		    SysCtlDelay(2000000);

		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, 0x30);
		    LCDEnable();
		    SysCtlDelay(11000);

		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, 0x30);
		    LCDEnable();
		    SysCtlDelay(11000);

		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, 0x30);
		    LCDEnable();
		    SysCtlDelay(11000);

		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, 0x20);
		    LCDEnable();
		    SysCtlDelay(11000);

		    temp_addr = 0x28;
		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		    LCDEnable();
		    SysCtlDelay(200000);
		    temp_addr<<=4;
		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		    LCDEnable();
		    SysCtlDelay(200000);

		    temp_addr = 0x0c;
		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		    LCDEnable();
		    SysCtlDelay(200000);
		    temp_addr<<=4;
		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		    LCDEnable();
		    SysCtlDelay(200000);

		    temp_addr = 0x06;
		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		    LCDEnable();
		    SysCtlDelay(200000);
		    temp_addr<<=4;
		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		    LCDEnable();
		    SysCtlDelay(200000);

		    temp_addr = 0x01;
		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		    LCDEnable();
		    SysCtlDelay(200000);
		    temp_addr<<=4;
		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		    LCDEnable();
		    SysCtlDelay(200000);

		    temp_addr = 0x02;
		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		    LCDEnable();
		    SysCtlDelay(200000);
		    temp_addr<<=4;
		    GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
		    LCDEnable();
		    SysCtlDelay(200000);
		}

	void	LCDDispData(uint8_t	*ptr,int DisplayType,uint8_t Addr,int length,bool ClrScr)	// See IFT standard guideline for this fn. 1=normal,2=scroll, length = how many char to scroll,ClrScr = true will clear the screen
			{
				uint8_t *tmp;
				tmp = ptr;
				//uint8_t	temp_addr,temp_data;;

				if(DisplayType==1)
					{

						GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x00); // this makes the RS = 0
						SysCtlDelay(200000);
					if(ClrScr==true)
						{
						temp_addr = 0x01;
						GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
						LCDEnable();
						SysCtlDelay(200000);
						temp_addr<<=4;
						GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
						LCDEnable();
						SysCtlDelay(200000);
						}

						temp_addr = Addr;
						GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
						LCDEnable();
						SysCtlDelay(200000);
						temp_addr<<=4;
						GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
						LCDEnable();
						SysCtlDelay(200000);
					while(length>0)
						{

								// 1011 0101
							GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x08); // this makes the RS = 0
							SysCtlDelay(200000);
							temp_data = *ptr;
							GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp_data);
							LCDEnable();
							SysCtlDelay(11000);
							temp_data<<=4;
							GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp_data);
							LCDEnable();
							SysCtlDelay(11000);
							length--;
							ptr++;
						}

					}
				else if(DisplayType==2)
						{

							GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x00); // this makes the RS = 0
							SysCtlDelay(200000);

							temp_addr = Addr;
							GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp_addr); // this makes the RS = 0
							LCDEnable();
							SysCtlDelay(200000);
							temp_addr<<=4;
							GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp_addr); // this makes the RS = 0
							LCDEnable();
							SysCtlDelay(200000);
							while((length-15)>0)
							{
								int x;
								for(x=0;x<16;x++)
								{
										GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x08); // this makes the RS = 1
										SysCtlDelay(8000);
										temp_data = *ptr;	// 1011 0101
										GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp_data);
										LCDEnable();
										SysCtlDelay(8000);
										temp_data<<=4;
										GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp_data);
										LCDEnable();
										SysCtlDelay(8000);
										ptr++;
								}
								tmp++;
								ptr=tmp;
								GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x00); // this makes the RS = 0
								SysCtlDelay(8000);
								temp_addr = Addr;
								GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp_addr); // this makes the RS = 0
								LCDEnable();
								SysCtlDelay(8000);
								temp_addr<<=4;
								GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp_addr); // this makes the RS = 0
								LCDEnable();
								SysCtlDelay(8000);
								length--;

							}
						}

			}
/////////////////////// GSM Data, Sends the Data to the Modem. Read is to be done thru NVIC //////////////////////
	void	GSMData(uint8_t	*MdmData)
	{
		while(*MdmData)
		{
			UARTCharPut(UART4_BASE,*MdmData);
			UARTCharPut(UART0_BASE,*MdmData);		//CHANGE
			SysCtlDelay(_50ms);
			MdmData++;
		}
	}
/////////////////////////////Data Comparison routine for SIM900 replies//////////////////////////////////////////
	bool	Sim900DataCompare(uint8_t *CmpRply,int BuffIndex)
	{
		bool	MatchSts = false ;
		int		flag0 = 0;
		while(*CmpRply && (flag0 == 0))
		{
			if(*CmpRply== SIM900BUFF[BuffIndex])
			{
				CmpRply++;
				BuffIndex++;
				MatchSts = true;
			}
			else
			{
				flag0 = 1;
				MatchSts = false;
			}

		}
		return MatchSts;
	}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

uint8_t		GSMInitChk(int MdmCommand) // Checks: sim presence,Operator,Network,Roaming,and GPRS connectivity, command type must be given in integer
						 // 1 = no echo, 2 = Short response, 3 = CREG check, 4 = GPRS check
		{
		uint32_t InitData = 0x00, TempData = 0x0;
		uint8_t  ReturnData = 0x0;

		bool	StatusResult = false;
		Sim900DataIndx = 0;
		if(MdmCommand == 1)
		{
		SysCtlDelay(one_second);
		SysCtlDelay(one_second);
		GSMData(NoEcho);
		SysCtlDelay(one_second);
		ReturnData &= ~0xfe ;
		ReturnData |= Sim900DataCompare(NoEchoRply,0)|Sim900DataCompare(NoEchoRply2,0);

		}

		if(MdmCommand == 2)
		{
		SysCtlDelay(one_second);
		SysCtlDelay(one_second);
		Sim900DataIndx = 0;
		GSMData(ShrtResp);
		SysCtlDelay(one_second);
		ReturnData |= Sim900DataCompare(ShrtRespRply,0);
		}

		if(MdmCommand == 3)
		{
		SysCtlDelay(one_second);
		SysCtlDelay(one_second);
		Sim900DataIndx = 0;
		GSMData(SimReg);
		SysCtlDelay(one_second);
		TempData = SIM900BUFF[11];
		switch (TempData)
		{
		case '0':
			ReturnData &= ~ 0xf9;

		  break;
		case '1':
			ReturnData &= ~ 0xf9;// clears any stored previous value
			ReturnData |= 0x2;

		  break;
		case '3':
			ReturnData &= ~ 0xf9;// clears any stored previous value
		  break;
		case '5':
			ReturnData &= ~ 0xf9;// clears any stored previous value
			ReturnData |= 0x4;

			break;
		case '4':
			ReturnData &= ~ 0xf9;// clears any stored previous value
			ReturnData |= 0x6;
			break;
		}
		}

		if(MdmCommand == 4)
		{
			SysCtlDelay(one_second);
			SysCtlDelay(one_second);
			Sim900DataIndx = 0;


			GSMData(ChkGPRS);
			SysCtlDelay(one_second);
			SysCtlDelay(one_second);

		}

		if(MdmCommand == 5)
		{
			SysCtlDelay(one_second);
			SysCtlDelay(one_second);
			Sim900DataIndx = 0;
			GSMData(ChkOper); // Checks operator name
			while(Sim900DataIndx == 0) // waits in 1 sec delay loop untill some char is received from modem
			{
			SysCtlDelay(one_second);
			}
			if(SIM900BUFF[14]==0x30 & SIM900BUFF[15]==0x35 ) // Reliance
			{
				ReturnData = '5';
			}
			else if(SIM900BUFF[14]=='A' & SIM900BUFF[15]=='i' & SIM900BUFF[16]=='r' & SIM900BUFF[17]=='T' ) // Airtel
					{
						ReturnData = '1';
					}
					else if(SIM900BUFF[14]=='H' & SIM900BUFF[15]=='U' & SIM900BUFF[16]=='T' & SIM900BUFF[17]=='C' & SIM900BUFF[18]=='H' )
						{
						ReturnData = '2';
						}
		}

		if(MdmCommand == 6)
		{
			SysCtlDelay(one_second);
			SysCtlDelay(one_second);
			Sim900DataIndx = 0;
			GSMData(ChkRSSI); // Checks operator name
			while(Sim900DataIndx == 0) // waits in 1 sec delay loop untill some char is received from modem
			{
				SysCtlDelay(one_second);
			}
			TempData = SIM900BUFF[8];
			TempData &= 0x0f ;
			TempData <<= 4;
			SIM900BUFF[9] &= 0x0f;
			TempData |= SIM900BUFF[9];
			TempData /= 2;
			ReturnData = TempData;

		}

		return ReturnData;
		}

	bool	EM18InitChk()
		{
		bool	StatusResult = false;
		StatusResult = false;
		return StatusResult;
		}

	void	LCD_Cmd(uint8_t	Addr,uint8_t *Array)
	{
		uint8_t temp1;
		int i=0;

		GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x00); // this makes the RS = 0
		SysCtlDelay(2000000);
		temp1 = Addr;
		GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp1);
		LCDEnable();
		SysCtlDelay(11000);
		temp1<<=4;
		GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp1);
		LCDEnable();
		SysCtlDelay(11000);

		GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x08); // this makes the RS = 1
		SysCtlDelay(2000000);
			while(i<8)
			{
				temp1 = Array[i];
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp1);
				LCDEnable();
				SysCtlDelay(11000);
				temp1<<=4;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7, temp1);
				LCDEnable();
				SysCtlDelay(11000);
				i++;
			}
	}

	void RESET_MDM()
		{

			while( !GSMInitChk(1))
			{
				SysCtlDelay(one_second);
			}
			while( !GSMInitChk(2))
			{
				SysCtlDelay(one_second);
			}
			GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_2, 0x00);
			GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_2, 0x04);			//TO POWER ON GSM MODEM
			SysCtlDelay(one_second);
			GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_2, 0x00);
			SysCtlDelay(one_second);
			GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_2, 0x00);
			GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_2, 0x04);			//TO POWER ON GSM MODEM
			SysCtlDelay(one_second);
			GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_2, 0x00);
		}


	void	LCDInitDisp()
		{
				bool GSMStat,EM18Stat = false;
				uint32_t	GSMResult = 0;
//				GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x08); // this makes the RS = 0
//				SysCtlDelay(2000000);
				LCDDispData(Pulse17,2,0x80,40,true);
				SysCtlDelay(one_second);
				GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x00); // this makes the RS = 0
				SysCtlDelay(200000);
				temp_addr = 0xc0;				//DISPLAY OF CUSTOM CHARACTER IN THIS LOC
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(200000);
				temp_addr<<=4;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(200000);

				GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x08); // this makes the RS = 0
				SysCtlDelay(200000);

				temp_addr = 0x0;				//DISPLAY OF CUSTOM CHARACTER
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(200000);
				temp_addr<<=4;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(200000);

				temp_addr = 0x1;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(200000);
				temp_addr<<=4;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(200000);

				temp_addr = 0x2;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(200000);
				temp_addr<<=4;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(200000);

				temp_addr = 0x3;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(200000);
				temp_addr<<=4;
				GPIOPinWrite(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7,temp_addr); // this makes the RS = 0
				LCDEnable();
				SysCtlDelay(20000000);			//END OF CUSTOM CHARACTER

			/*	LCDDispData(Pulse17,1,0x80,16,true);
				SysCtlDelay(one_second);
				LCDDispData(ATN,1,0xC0,16,true);
				SysCtlDelay(one_second);
				LCDDispData(IFT,2,0x80,32,true);
				SysCtlDelay(one_second);
				LCDDispData(CCare,2,0xc0,88,false);
				SysCtlDelay(one_second);
				LCDDispData(ChkGSM,1,0x80,16,true);
				LCDDispData(ChkGSM2,1,0xc0,16,false);*/
//////////////////Checks the GSM Connection for SIM Registration and GPRS activation///////////////////
				while( !GSMInitChk(1))
				{
					GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_3,8);
					SysCtlDelay(one_second);
					GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_3,0);
				}
				while( !GSMInitChk(2))
				{
					GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_0,1);
					SysCtlDelay(one_second);
					GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_0,0);
				}
				GSMResult = GSMInitChk(3);
///////////// LcD Display management //////////////////////////////
				if(GSMResult == 0x4)
				{
					LCDCLR();
					RTC_LCD_Disp(0x8E, 'R');//LCDDispData(GSMROAM,1,0x8d,16,false);
					SysCtlDelay(one_second);
					SysCtlDelay(one_second);

				}
				else if(GSMResult == 0x0)
						{
					LCDCLR();
					RTC_LCD_Disp(0x8E, 'E');//LCDDispData(GSMErr,1,0xc0,16,false);
					SysCtlDelay(one_second);
					SysCtlDelay(one_second);
						}
					 else if(GSMResult == 0x2)
					 	 	 {
						 	 	 LCDCLR();
						 	 	RTC_LCD_Disp(0x8E, 'H');//LCDDispData(GSMHOME,1,0xc0,16,false);
						 	 	SysCtlDelay(one_second);
						 	 	SysCtlDelay(one_second);
					 	 	 }

				SysCtlDelay(one_second);
/////////////////////Check GPRS Connectivity /////////////////////
				LCDDispData(ChkGPRSConn,1,0xc0,16,false);
				SysCtlDelay(one_second);
				SysCtlDelay(one_second);
				while(Sim900DataCompare(ChkGPRSRply,0)==false)
				{
				GSMResult = GSMInitChk(4);
				SysCtlDelay(one_second);
				}
			/*	if(GSMResult && 0x1 ==0x01 )
				{
					RTC_LCD_Disp(0x8c, 'G');//LCDDispData(GPRSOK,1,0xc0,00,false);
					SysCtlDelay(one_second);
					SysCtlDelay(one_second);
				}
				else
				{
					RTC_LCD_Disp(0x8c, '-');//LCDDispData(GPRSFail,1,0xc0,00,false);
					SysCtlDelay(one_second);
					SysCtlDelay(one_second);
				}*/

/////////////////////Check Operator name /////////////////////
				LCDDispData(ChkOperName,1,0xc0,16,false);
				SysCtlDelay(one_second);
				SysCtlDelay(one_second);
				GSMResult = GSMInitChk(5);
				switch (GSMResult)
						{
							case '1':
							LCDDispData(Oper1,1,0x80,5,false);
							operator = '1';
							break;
							case '5':
							LCDDispData(Oper5,1,0x80,5,false);
							operator = '5';
							break;
							case '2':
							LCDDispData(Oper2,1,0x80,5,false);
							operator = '2';
							break;
						}
				SysCtlDelay(one_second);
				SysCtlDelay(one_second);

///////////////////////// Checks Signal quality ////////////////////////////////////
				LCDDispData(ChkRSSILcd,1,0xc0,16,false);
				SysCtlDelay(one_second);
				SysCtlDelay(one_second);
				GSMResult = GSMInitChk(6);
				if(GSMResult < 0x10) // show low network bar
				{
					//RTC_LCD_Disp(0x8F, 0x0);
					RTC_LCD_Disp(0x8E, 0x3);
				}
				else if(0x10 <= GSMResult < 0x25)// show medium network bar
				{
					//RTC_LCD_Disp(0x8e, 0x0);
					RTC_LCD_Disp(0x8F, 0x2);
				}
				else // show high network bar
				{
					//RTC_LCD_Disp(0x8e, 0x0);
					RTC_LCD_Disp(0x8F, 0x1);
				}


			//	while(1);
//////////////////////////////////Checks the EM18 Connector module ////////////////////////////////////
			/*	EM18Stat = EM18InitChk();
				if(EM18Stat == true)
				{
					LCDDispData(EM18Ok1,1,0xc0,16,true);
				}
				else
				{
					LCDDispData(EM18Fail1,1,0x80,16,true);
					LCDDispData(EM18Fail2,1,0xc0,16,false);
				}*/
		}



/////////////////////////// Setting the RTC //////////////////////////////////////////////////////////
	void	StartRTC()
	{
	    		I2CMasterSlaveAddrSet(I2C1_BASE, 0x68, false); // The address of the Slave is 0x68

	    		I2CMasterDataPut(I2C1_BASE, 0x00); // Addr 0x00

	    		I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_SEND_START);

	    		while(I2CMasterBusy(I2C1_BASE));

	    			for (i=0;i<7;i++)
	    				{
	    					I2CMasterDataPut(I2C1_BASE, RTCSetup[i]); // data to be saved from Addr 0x0 under autoincrement mode
	    					I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_SEND_CONT);
	    					while(I2CMasterBusy(I2C1_BASE));

	    				}

	    		//I2CMasterDataPut(I2C1_BASE, 0xee); // data to be saved at Addr 0x12 under autoincrement mode

	    		I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_SEND_FINISH);

	    		while(I2CMasterBusy(I2C1_BASE));

	    		while(1);
	}
////////////////////Reading the RTC //////////////////////////////////////////
	void	ReadRTC(uint8_t	RTCRegister)
	{
			IntDisable (INT_UART3);
			IntDisable (INT_UART4);
			uint8_t RTCTemp = RTCRegister,temp0=0x00 ;

		    I2CMasterSlaveAddrSet(I2C1_BASE, 0x68, false);

		    I2CMasterDataPut(I2C1_BASE, RTCTemp); // Addr 0x11

		    I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_SINGLE_SEND);
		    while(I2CMasterBusy(I2C1_BASE));

		    I2CMasterSlaveAddrSet(I2C1_BASE, 0x68, true);

		    I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_RECEIVE_START);
		    while(I2CMasterBusy(I2C1_BASE));

		    SysCtlDelay(11000);

		    temp0 = I2CMasterDataGet(I2C1_BASE); //this is the first register = Ch SSS SSSS

		    RTCData[0] = temp0 ;
		    RTCData[0]>>=4; // Ch SSS SSSS = SSSS ChSSS
		    RTCData[0] &= 0x07 ; // = 0000 0SSS
		    RTCData[0] |= 0x30 ; // = 0011 0SSS to display in ascii
		    Sec_T=RTCData[0];

		    RTCData[0] = temp0 ;
		    RTCData[0] &= 0x0f ; // = 0000 SSSS
		    RTCData[0] |= 0x30 ; // = 0011 SSSS to display in ascii
		    Sec_U=RTCData[0];

		    SysCtlDelay(11000);

		    for (i=1;i<=6;i++)
		    {
		    	I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_RECEIVE_CONT);
		    	while(I2CMasterBusy(I2C1_BASE));
		    	RTCData[i] = I2CMasterDataGet(I2C1_BASE); //Receive
		    	SysCtlDelay(11000);
		    }

		    I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_RECEIVE_FINISH);
		    while(I2CMasterBusy(I2C1_BASE));


		    temp0 = RTCData[2] ;
		    temp0>>=4; // 0 12/24 hh hhhh = SSSS ChSSS
		    temp0 &= 0x03 ; // = 0000 00hh
		    temp0 |= 0x30 ; // = 0011 00hh to display in ascii
		    Hour_T=temp0;
		    temp0 = RTCData[2] ;
		    temp0 &= 0x0f ; // = 0000 hhhh
		    temp0 |= 0x30 ; // = 0011 hhhh to display in ascii
		    Hour_U=temp0;

		    temp0 = RTCData[1] ;
		    temp0>>=4; // 0 mmm mmmm = mmmm 0mmm
		    temp0 &= 0x07 ; // = 0000 0mmm
		    temp0 |= 0x30 ; // = 0011 0mmm to display in ascii
		    Min_T=temp0;

		    temp0 = RTCData[1] ;
		    temp0 &= 0x0f ; // = 0000 mmmm
		    temp0 |= 0x30 ; // = 0011 mmmm to display in ascii
		    Min_U=temp0;

		    temp0 = RTCData[3] ; // day of week DOW_U
		    temp0 |= 0x30;
		    DOW_U = temp0;

		    temp0 = RTCData[4] ;
		    temp0>>=4; // 00DD DDDD = DDDD 00DD
		    temp0 &= 0x03 ; // = 0000 00DD
		    temp0 |= 0x30 ; // = 0011 0mmm to display in ascii
		    Day_T=temp0;

		    temp0 = RTCData[4] ;
		    temp0 &= 0x0f ; // = 0000 DDDD
		    temp0 |= 0x30 ; // = 0011 mmmm to display in ascii
		    Day_U=temp0;

		    temp0 = RTCData[5] ;
		    temp0>>=4; // 000M MMMM = MMMM 000M
		    temp0 &= 0x01 ; // = 0000 000M
		    temp0 |= 0x30 ; // = 0011 000M to display in ascii
		    Month_T=temp0;

		    temp0 = RTCData[5] ;
		    temp0 &= 0x0f ; // = 0000 MMMM
		    temp0 |= 0x30 ; // = 0011 MMMM to display in ascii
		    Month_U=temp0;

		    temp0 = RTCData[6] ;
		    temp0>>=4; // YYYY YYYY = YYYY YYYY SWAPPED UNITS AND TENS
		    temp0 &= 0x0F ; // = 0000 YYYY
		    temp0 |= 0x30 ; // = 0011 YYYY to display in ascii
		    Year_T=temp0;


		    temp0 = RTCData[6] ;
		    temp0 &= 0x0F ; // = 0000 YYYY THIS IS THE ACTUAL UNITS VALUES
		    temp0 |= 0x30 ; // = 0011 YYYY to display in ascii
		    Year_U=temp0;
//////////////////Data concatenation for sending format ////////////
		    ConcatData[13]=Sec_U;
		    ConcatData[12]=Sec_T;
		    ConcatData[15]=Min_U;
		    ConcatData[14]=Min_T;
		    ConcatData[17]=Hour_U;
		    ConcatData[16]=Hour_T;
		    ConcatData[19]=DOW_U;
		    ConcatData[18]='0';//DOW_T;
		    ConcatData[21]=Day_U;
		    ConcatData[20]=Day_T;
		    ConcatData[23]=Month_U;
		    ConcatData[22]=Month_T;
		    ConcatData[25]=Year_U;
		    ConcatData[24]=Year_T;
		//    ConcatData1[4]=Year_T;
		    IntEnable(INT_UART3);
		    IntEnable(INT_UART4);
		    z=0;
	}
///////////////////////////LCD Display Routine of RTC/////////////////////////
	void	LCDRTCDisp()
		{
			RTC_LCD_Disp(0x88, ConcatData[16]);
			RTC_LCD_Disp(0x89, ConcatData[17]);

			RTC_LCD_Disp(0x8a, ':');

			RTC_LCD_Disp(0x8B, ConcatData[14]);
			RTC_LCD_Disp(0x8C, ConcatData[15]);

			RTC_LCD_Disp(0x8D, ' ');

			//RTC_LCD_Disp(0x8E, ConcatData[12]);
			//RTC_LCD_Disp(0x8F, ConcatData[13]);

		}

///////////////////// Custom LCD Character setting ///////////////////////////
	void	LCDCustomCharSet()
		{
		LCD_Cmd(0x40,customchar);
		LCD_Cmd(0x48,NET_HI);
		LCD_Cmd(0x50,NET_MED);
		LCD_Cmd(0x58,NET_LO);
		}

////////////////////////////////////////save card number in CONCATDATA ARRAY///////////////////
    void save(void)
    {
    	for(y=0;y<=11;y++)
    	{
    		ConcatData[y]=array_1[y];
    		SysCtlDelay(1333);
    		//	ConcatData1[y+17]=ConcatData[y+17];		//ConcateData1 is used for 32-bit
    		RFID_intrpt=false;
    		if(z==12)
    		{
    			z=0;

    		}
    	}

    }
///////////////////////////////////////////I2C EEPROM//////////////////////////////////////////////////////////////

  void pointer_H()			//points the HIGHER order address location to save the data.

    {
  	if (CARD_NUM<30)					//1st eeprom(CARD_NUM<251)
  	{
  	Chip_addre=0x50;
	Temp2=CARD_RECV_LOC[CARD_NUM];
  	Temp2>>=8;
  	point_H=Temp2;
  	Temp2=CARD_RECV_LOC[CARD_NUM];
  	point_L=Temp2;
  	}

  	else if (CARD_NUM>=30)				//(CARD_NUM==251)
      	{
  		Chip_addre=0x57;
  		Temp2=CARD_RECV_LOC[d];
  		Temp2>>=8;
  		point_H=Temp2;
  		Temp2=CARD_RECV_LOC[d];
  		point_L=Temp2;
  		d++;
      	}
    }


  void I2C_EEPROM_WRITE(void)
    {
	  IntDisable (INT_UART3);
	  IntDisable (INT_UART4);
	  pointer_H();
	  I2CMasterSlaveAddrSet(I2C1_BASE, Chip_addre, false); // The address of the Slave is 0x69
	  I2CMasterDataPut(I2C1_BASE, point_H); // Addr 0x10
    I2CMasterControl(I2C1_BASE,I2C_MASTER_CMD_BURST_SEND_START);
    while(I2CMasterBusy(I2C1_BASE));
    I2CMasterDataPut(I2C1_BASE,point_L); // Addr 0x11 (Pointer_L)
    I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_SEND_CONT);
    while(I2CMasterBusy(I2C1_BASE));
    for(J=0;J<30;J++)
    {
    I2CMasterDataPut(I2C1_BASE, ConcatData[J]); // data to be saved at Addr 0x11 under autoincrement mode
    I2CMasterControl(I2C1_BASE,I2C_MASTER_CMD_BURST_SEND_CONT); //I2C_MASTER_CMD_BURST_SEND_CONT);
    while(I2CMasterBusy(I2C1_BASE));
 //   I2CMasterDataPut(I2C0_BASE, ConcatData[J]);
    }
    I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_SEND_FINISH);
    while(I2CMasterBusy(I2C1_BASE));
    //////// write complete////////////////////////////////////////////////////////////////////////////
    SysCtlDelay(13333333); // writing time

    CARD_NUM++;
    M=true;

	IntEnable(INT_UART3);
	IntEnable(INT_UART4);
    }

    void I2C_EEPROM_READ(void)
    {
    	IntDisable (INT_UART3);
    	IntDisable (INT_UART4);

    	while(CARD_NUM!=0)				//(t!=500)
    	{
    		CARD_NUM--;
    	if (CARD_NUM<30)			//(t<250)
    	{
    		Chip_addre=0x50;
        	Temp1=	CARD_RECV_LOC[CARD_NUM];				//CARD_RECV_LOC[f];
        	Pointer_L=Temp1;
        	Temp1>>=8;
        	Pointer_H=Temp1;
    	}
    	else if (CARD_NUM>=30)		//(t==251)
    	{	d--;
    		Chip_addre=0x57;
    		Temp1=	CARD_RECV_LOC[d];
    		Pointer_L=Temp1;
    		Temp1>>=8;
    		Pointer_H=Temp1;

    	}


    I2CMasterSlaveAddrSet(I2C1_BASE, Chip_addre, false);
    I2CMasterDataPut(I2C1_BASE, Pointer_H); // Addr 0x0
    I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_SEND_START);
    while(I2CMasterBusy(I2C1_BASE));
    I2CMasterDataPut(I2C1_BASE,Pointer_L); // Addr 0x11
    I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_SEND_CONT);
    while(I2CMasterBusy(I2C1_BASE));
    I2CMasterSlaveAddrSet(I2C1_BASE, Chip_addre, true);
    I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_RECEIVE_START);
    while(I2CMasterBusy(I2C1_BASE));
    for(k=0;k<30;k++)
    {
    data = I2CMasterDataGet(I2C1_BASE); //test
    UARTCharPut(UART0_BASE, data);
    UARTCharPut(UART4_BASE, data);
    RECV_ARRAY[k]=data;
    I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_RECEIVE_CONT);
    while(I2CMasterBusy(I2C1_BASE));
    }
    I2CMasterControl(I2C1_BASE, I2C_MASTER_CMD_BURST_RECEIVE_FINISH);
    while(I2CMasterBusy(I2C1_BASE));
M=false;
    	}

    	IntEnable(INT_UART3);
    	IntEnable(INT_UART4);
    }

 ////////////////////////INTERRUPT HANDLERS////////////////////////////////////////
        void UartIntHandler(void)							//Rfid interrupt
        {
        	GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3, 0x02);
        	GPIOPinWrite(GPIO_PORTD_BASE, GPIO_PIN_2, 0x04);
        	{
        		UARTIntClear(UART3_BASE,UART_INT_RX);
        //    	static uint32_t z = 0x00000000 ;
            	array_1[z] =UARTCharGet(UART3_BASE);
            	UARTCharPut(UART0_BASE,array_1[z]);
            	ConcatData[z]=array_1[z];					//test1
            	z++;
            	if(z==12)
            	{
            		z=0;
            		ReadRTC(0x00);
            		SysCtlDelay(1333);
            		I2C_EEPROM_WRITE();
            	}
            	GPIOPinWrite(GPIO_PORTD_BASE, GPIO_PIN_2, 0x00);
        	GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3, 0x00);

        	}
        }

        void Uart4IntHandler(void)							//sim 900 interrupt
            {
        	UARTIntClear(UART4_BASE,UART_INT_RX);
        	UARTIntClear(UART4_BASE,UART_INT_TX);

            SIM900BUFF[Sim900DataIndx] =UARTCharGet(UART4_BASE);
         //   UARTCharPut(UART0_BASE,UARTCharGet(UART4_BASE));
            SysCtlDelay(1333);
            UARTCharPut(UART0_BASE,SIM900BUFF[Sim900DataIndx]);
            Sim900DataIndx++;
            }
//////////////////////////////////GPRS DIALING///////////////////////
    void GprsDialing(void)
    {		//G++;
    		bool mdm_rply = false;
    		GSMData(IPSHUT);
    		while(Sim900DataIndx<2);
    		SysCtlDelay(one_second);
    		SysCtlDelay(one_second);
    		SysCtlDelay(one_second);
    		GSMData(ChkGPRS);
    		while(Sim900DataIndx<2);
    		SysCtlDelay(one_second);
    		SysCtlDelay(one_second);
    		SysCtlDelay(one_second);

    	while(!mdm_rply)//cstt
    	{	G++;
    		Sim900DataIndx=0;
    		GSMData(SimAPN);
    //		while(Sim900DataIndx==0);
    		SysCtlDelay(one_second);
    		SysCtlDelay(one_second);
    		mdm_rply = Sim900DataCompare(SimAPNRply,0);
    		if(G==5)
    		{
    			//RESET_MDM();
    			mdm_rply =true;
    			G=0;
    		}
    	}
    	mdm_rply =false;
    	//uint8_t  ReturnData = 0x0;
    	while(!mdm_rply)
    	{G++;
    		Sim900DataIndx=0;
    		GSMData(WirelessConn);
    	//	while(Sim900DataIndx<2);
    		SysCtlDelay(one_second);
    		mdm_rply = Sim900DataCompare(WirelessConnRply,0);
    		if(G==5)
    		    		{
    		    			mdm_rply =true;
    		    			G=0;
    		    		}
    	}
    	mdm_rply =false;
    	while(!mdm_rply)
    	{G++;
    		Sim900DataIndx=0;
    		GSMData(SimIP);
    	//	while(Sim900DataIndx<2);
    		SysCtlDelay(one_second);
    		mdm_rply = !Sim900DataCompare(SimIPRply,0);
    		if(G==5)
    		    		{
    		    			mdm_rply =true;
    		    			G=0;
    		    		}
    	}
    	mdm_rply =false;

     	while(!mdm_rply)
    	{G++;
    	Sim900DataIndx=0;
       	GSMData(DomainPort);
    //	while(Sim900DataIndx<2);
    	SysCtlDelay(one_second);
    	mdm_rply = Sim900DataCompare(DomainPortRply,0)|Sim900DataCompare(DomainPortRply1,0);
    	if(G==5)
    	    		{	RESET_MDM();
    	    			mdm_rply =true;
    	    			G=0;
    	    		}
    	}
     	mdm_rply =false;
    }

    void GprsSend(void)
    {
    	Sim900DataIndx=0;
    	GSMData(SendData);
    	SysCtlDelay(13333333);
    	while(Sim900DataIndx==0);
    	if(Sim900DataCompare(SendDataRply,0))
		{I2C_EEPROM_READ();//data from eeprom is to be sent
/*		for(y=0;y<=29;y++)
		{
		UARTCharPut(UART4_BASE,ConcatData[y]);
		//SysCtlDelay(133);
		}*/
		UARTCharPut(UART4_BASE,0x1a);}

    }
///////////////////////////////////BULK SEND///////////////////////////////////////////////////////////////////////
    void BULK_SEND()
    {
    	GprsDialing();
    	GprsSend();				//data from eeprom is to be sent
    //	I2C_EEPROM_READ();			//TESTING
    }
////////////////////////////////////////////////////////////////////////////////////////
    void HOME_SCREEN()
      {
      	RTC_LCD_Disp(0x80, 'P');
      	RTC_LCD_Disp(0x81, 'U');
      	RTC_LCD_Disp(0x82, 'L');
      	RTC_LCD_Disp(0x83, 'S');
      	RTC_LCD_Disp(0x84, 'E');
      	RTC_LCD_Disp(0x85, '1');
      	RTC_LCD_Disp(0x86, '7');
      	RTC_LCD_Disp(0x87, ' ');
        LCDDispData(SHOWCARD,1,0xc0,15,false);
         // RTC_LCD_Disp(0xcd, ' ');
          RTC_LCD_Disp(0xce, ' ');
          RTC_LCD_Disp(0xcf, ' ');
      }

//////////////////////////////////main rtn /////////////////////////////////////////////////
int main(void)

{	//unsigned long data;
	z=0;
	c=0;
	SysCtlClockSet(SYSCTL_SYSDIV_4 | SYSCTL_USE_PLL | SYSCTL_OSC_MAIN | SYSCTL_XTAL_16MHZ);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
	 HWREG(GPIO_PORTD_BASE + GPIO_O_LOCK) = GPIO_LOCK_KEY;
	 HWREG(GPIO_PORTD_BASE + GPIO_O_CR) |= 0x80;
	 HWREG(GPIO_PORTD_BASE + GPIO_O_AFSEL) |= 0x80;
	 HWREG(GPIO_PORTD_BASE + GPIO_O_PCTL) |= 0x10000000;
	 HWREG(GPIO_PORTD_BASE + GPIO_O_LOCK) = 0;
	SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART3);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART4);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOC);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_I2C1);
    GPIOPinTypeI2CSCL(GPIO_PORTA_BASE, GPIO_PIN_6); // I2CSCL
    GPIOPinTypeI2C(GPIO_PORTA_BASE, GPIO_PIN_7);
    GPIOPinConfigure(GPIO_PA6_I2C1SCL);
    GPIOPinConfigure(GPIO_PA7_I2C1SDA);
    GPIOPadConfigSet(GPIO_PORTB_BASE,GPIO_PIN_2,GPIO_STRENGTH_4MA,GPIO_PIN_TYPE_STD_WPU);
    GPIOPinTypeGPIOOutput(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7);
    GPIOPinTypeGPIOOutput(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3);
    GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3);
    GPIOPinTypeGPIOOutput(GPIO_PORTE_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3);
    I2CMasterInitExpClk(I2C1_BASE, SysCtlClockGet(), false);
 //   GPIOPadConfigSet(GPIO_PORTD_BASE,GPIO_PIN_2,GPIO_STRENGTH_4MA,GPIO_PIN_TYPE_STD_WPU);
    GPIOPinTypeGPIOOutput(GPIO_PORTD_BASE, GPIO_PIN_2);
    GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3, 0x00);
    GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_2, 0x04);//blu led lights here
    GPIOPinConfigure(GPIO_PC6_U3RX);
    GPIOPinConfigure(GPIO_PC4_U4RX);
    GPIOPinConfigure(GPIO_PC5_U4TX);
    GPIOPinTypeUART(GPIO_PORTC_BASE, GPIO_PIN_6);						//rfid
    GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0|GPIO_PIN_1);
    GPIOPinTypeUART(GPIO_PORTC_BASE, GPIO_PIN_4|GPIO_PIN_5);			//sim900
    UARTConfigSetExpClk(UART3_BASE, SysCtlClockGet(), 9600,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
    UARTConfigSetExpClk(UART0_BASE, SysCtlClockGet(), 9600,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
    UARTConfigSetExpClk(UART4_BASE, SysCtlClockGet(), 9600,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
    IntEnable(INT_UART3);
    IntEnable(INT_UART4);
    UARTIntEnable(UART3_BASE,UART_INT_RX);
    UARTIntEnable(UART4_BASE,UART_INT_RX);
    IntPrioritySet(INT_UART3,1);		//INTERUPT PRIORITY(RFID)
    IntPrioritySet(INT_UART4,2);		//INTERUPT PRIORITY(SIM900)
    IntMasterEnable();

    UARTEnable(UART3_BASE);
    UARTEnable(UART0_BASE);
    UARTEnable(UART4_BASE);
    UART3_LCRH_R &= ~UART_LCRH_FEN ;  //FIFO DISABLE
    UART4_LCRH_R &= ~UART_LCRH_FEN ;  //FIFO DISABLE

    /*GPIOPinTypeGPIOOutput(GPIO_PORTB_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3|GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7);
    GPIOPinTypeGPIOOutput(GPIO_PORTA_BASE, GPIO_PIN_2|GPIO_PIN_3);*/
    SysCtlDelay(one_second);
   // GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3, 0x02);
  //  RESET_MDM();
// StartRTC();	// this routine will be called if we need to set the Time, else keep disabled. CPU halts inside this rtn.
    LCDConfig();
    LCDCustomCharSet();
    LCDInitDisp();
  //  GprsDialing();

    ConcatData[26]='A';
    ConcatData[27]='B';
    ConcatData[28]='C';
    ConcatData[29]='D';


  //  Pointer_H=0x0,Pointer_L=0x01;
    //////////////////////////////////CALLS THE HOME SCREEN////////////////////////////////////////////////
    while(1)
    {
    	GPIOPinWrite(GPIO_PORTF_BASE,GPIO_PIN_1| GPIO_PIN_2|GPIO_PIN_3, 0x08);
    	GPIOPinWrite(GPIO_PORTE_BASE,GPIO_PIN_1, 0x02);
    	c++;
		if(c==300)				//150 for 1 min
	    	{
	    		c=0;
	    		if(M==true)
	    		{
	    			GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_0, 0x01);
	    			BULK_SEND();
	    			GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_0, 0x00);
	    		}

	    	}
		HOME_SCREEN();
 /*   	if(ServerConnected == true)
    	{
    		LCDDispData(ServConn,1,0xc0,0,false);
    	}
    	else
    	{
    		LCDDispData(ServDisCon,1,0xc0,0,false);
    	}*/
    	SysCtlDelay(11000);
    	ReadRTC(0x00);	// Reads the RTC and sends the date and time values to display on LCD from the given address.
    	SysCtlDelay(11000);
    	LCDRTCDisp();
   // 	G=CARD_NUM;

   /* 	if(RFID_intrpt==true)
    	{
    	//	H=CARD_NUM;
    	//	save();
    		GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3, 0x08);
    		LCDDispData(ConcatData,2,0xc0,30,true);
    		SysCtlDelay(11000);
    	//	I2C_EEPROM_WRITE();
    	//	CARD_NUM++;
    	}*/
    //	H=CARD_NUM-G;

    	GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_2, 0x00);
    	GPIOPinWrite(GPIO_PORTE_BASE,GPIO_PIN_1, 0x00);
    	SysCtlDelay(11000);
}
}


