/*
 * main.h
 *
 *  Author:
 */

#ifndef MAIN_H_
#define MAIN_H_

// System clock rate, 120 MHz
#define SYSTEM_CLOCK            120000000U

//Constants
#define ADC_QUERY_FREQ          20000 //20kHz
#define UART0_BAUD_RATE         57600



//Definitions for SPI0 connected to FPGA Controller
#define GPIO_PA5_SSI0TX         GPIO_PA4_SSI0XDAT0
#define GPIO_PA4_SSI0RX         GPIO_PA5_SSI0XDAT1

#define SPI0_DATA_WIDTH         8
#define SPI0_CLK_SPEED          10000000

#define SPI0_PORT               SYSCTL_PERIPH_GPIOA
#define SPI0_CS
#define SPI0_MISO


//Definitions for ADC Pins connected to AD7609 chip in parallel fashion
#define ADC_OS0                 GPIO_PIN_0 //PM0
#define ADC_OS1                 GPIO_PIN_1 //PM1
#define ADC_OS2                 GPIO_PIN_2 //PM2
#define ADC_BUSY                GPIO_PIN_3 //PM3
#define ADC_CNVSTARTA           GPIO_PIN_4 //PM4
#define ADC_CNVSTARTB           GPIO_PIN_5 //PM5
#define ADC_RANGE               GPIO_PIN_6 //PM6
#define ADC_RESET               GPIO_PIN_7 //PM7

#define ADC_CS                  GPIO_PIN_2 //PN2
#define ADC_READ                GPIO_PIN_3 //PN3

#define ADC_CTRL1_PORT          GPIO_PORTM_BASE
#define ADC_CTRL2_PORT          GPIO_PORTN_BASE
#define ADC_LSB_PORT            GPIO_PORTD_BASE
#define ADC_MSB_PORT            GPIO_PORTK_BASE


//Definitions for I2C0
#define I2C0_CLK                GPIO_PIN_2 //PB2
#define I2C0_SDA                GPIO_PIN_3 //PB3

//LEDs
#define LED0    GPIO_PIN_1 //D1
#define LED1    GPIO_PIN_0 //D2
#define LED2    GPIO_PIN_4 //D3
#define LED3    GPIO_PIN_0 //D4

#define LED0_PORT   GPIO_PORTN_BASE
#define LED1_PORT   GPIO_PORTN_BASE
#define LED2_PORT   GPIO_PORTF_BASE
#define LED3_PORT   GPIO_PORTF_BASE

#define LED0_HIGH   GPIOPinWrite(LED0_PORT,LED0,LED0)
#define LED1_HIGH   GPIOPinWrite(LED1_PORT,LED1,LED1)
#define LED2_HIGH   GPIOPinWrite(LED2_PORT,LED2,LED2)
#define LED3_HIGH   GPIOPinWrite(LED3_PORT,LED3,LED3)

#define LED0_LOW   GPIOPinWrite(LED0_PORT,LED0,0)
#define LED1_LOW   GPIOPinWrite(LED1_PORT,LED1,0)
#define LED2_LOW   GPIOPinWrite(LED2_PORT,LED2,0)
#define LED3_LOW   GPIOPinWrite(LED3_PORT,LED3,0)
//UART Ports
#define UART0   0



#endif /* MAIN_H_ */
