/** @file notification.c 
*   @brief User Notification Definition File
*   @date 16.Feb.2015
*   @version 04.03.00
*
*   This file  defines  empty  notification  routines to avoid
*   linker errors, Driver expects user to define the notification. 
*   The user needs to either remove this file and use their custom 
*   notification function or place their code sequence in this file 
*   between the provided USER CODE BEGIN and USER CODE END.
*
*/

/* 
* Copyright (C) 2009-2015 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* Include Files */

#include "esm.h"
#include "sys_selftest.h"
#include "adc.h"
#include "can.h"
#include "gio.h"
#include "mibspi.h"
#include "sci.h"
#include "spi.h"
#include "het.h"
#include "rti.h"
#include "dcc.h"
#include "i2c.h"
#include "crc.h"
#include "sys_dma.h"

/* USER CODE BEGIN (0) */
#include <string.h>
#include  <esm_bsp_rm48.h>
#include "messageQueue.h"
#include "hwControl.h"
#include "gpio_bsp_rm48.h"
#include "nhet_gpio_bsp_rm48.h"

char adcNotificationUsed = 0;
char crcNotificationUsed = 0;
char dccNotificationUsed = 0;
char dmaGroupANotificationUsed = 0;
char edgeNotificationUsed = 0;
char esmGroup1NotificationUsed = 1;
char esmGroup2NotificationUsed = 1;
char gioNotificationUsed = 0;
char hetNotificationUsed = 0;
char i2cNotificationUsed = 0;
char memoryPort0TestFailNotificationUsed = 0;
char memoryPort1TestFailNotificationUsed = 0;
char mibspiGroupNotificationUsed = 0;
char mibspiNotificationUsed = 0;
char pwmNotificationUsed = 0;
char rtiNotificationUsed = 0;
char sciNotificationUsed = 0;

char g_NOT_buffer[318] = "";
extern char g_printFunction;
extern void BSP_RM48_ERRORS_AddErrors (unsigned error);
extern CPU_INT08U g_inputPinPolarity [INPUT_PIN_LAST];

extern void portExpanderTask(void);


/* USER CODE END */
#pragma WEAK(esmGroup1Notification)
void esmGroup1Notification(uint32 channel)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (1) */

	if(g_printFunction && !esmGroup1NotificationUsed)
	{
		esmGroup1NotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}

	esmTriggerErrorPinReset();
	BSP_RM48_ERRORS_AddErrors (channel);

	switch (channel)
	{
	  case DMA_PARITY_ESM_CHANNEL:
		sciSend	(scilinREG, 24, (unsigned char *) "DMA_PARITY_ESM_CHANNEL\r\n");
		break;

	  case AHB_IMPERCISE_READ_ESM_CHANNEL:
		sciSend	(scilinREG, 24, (unsigned char *) "AHB_PARITY_ESM_CHANNEL\r\n");
		break;

	  case HTU_PARITY_ESM_CHANNEL:
        #if(BIOLASE_SCI0 == DEF_ENABLED)
           sciSend	(sciREG, 24, (unsigned char *) "HTU_PARITY_ESM_CHANNEL\r\n");
        #endif

        #if(BIOLASE_SCI1 == DEF_ENABLED)
		  sciSend	(scilinREG, 24, (unsigned char *) "HTU_PARITY_ESM_CHANNEL\r\n");
        #endif
		break;

	  case PLL_SLIP_ESM_CHANNEL:
		sciSend		(scilinREG, 22, (unsigned char *) "PLL_SLIP_ESM_CHANNEL\r\n");
		break;

	  case CLK_MONITOR_INT_ESM_CHANNEL:
		sciSend		(scilinREG, 29, (unsigned char *) "CLK_MONITOR_INT_ESM_CHANNEL\r\n");
		break;

	  case AHB_IMPERCISE_ESM_CHANNEL:
		sciSend		(scilinREG, 24, (unsigned char *) ".AHB_IMPERCISE_CHANNEL\r\n");
		break;

	  case MIBSPI3_PARITY_ESM_CHANNEL:
		sciSend		(scilinREG, 28, (unsigned char *) "MIBSPI3_PARITY_ESM_CHANNEL\r\n");
		break;

	  case MIBADC1_PARITY_ESM_CHANNEL:
		sciSend		(scilinREG, 28, (unsigned char *) "MIBADC1_PARITY_ESM_CHANNEL\r\n");
		break;

	  case MIBADC2_PARITY_ESM_CHANNEL:
		sciSend		(scilinREG, 28, (unsigned char *) "MIBADC2_PARITY_ESM_CHANNEL\r\n");
		break;

	  case NHET_PARITY_ESM_CHANNEL:
		sciSend		(scilinREG, 25, (unsigned char *) "NHET_PARITY_ESM_CHANNEL\r\n");
		break;

	  case VIM_RAM_PARITY_ESM_CHANNEL:
		sciSend		(scilinREG, 28, (unsigned char *) "VIM_RAM_PARITY_ESM_CHANNEL\r\n");
		break;

	  case FTU_MPU_ESM_CHANNEL:
		sciSend		(scilinREG, 21, (unsigned char *) "FTU_MPU_ESM_CHANNEL\r\n");
		break;

	  case FTU_PARITY_ESM_CHANNEL:
		sciSend		(scilinREG, 24, (unsigned char *) "FTU_PARITY_ESM_CHANNEL\r\n");
		break;

	  case DMA_MPU_ESM_CHANNEL:
		sciSend		(scilinREG, 21, (unsigned char *) "DMA_MPU_ESM_CHANNEL\r\n");
		break;

	  case FLASH_ECC_SINGLE_ESM_CHANNEL:
		sciSend		(scilinREG, 30, (unsigned char *) "FLASH_ECC_SINGLE_ESM_CHANNEL\r\n");
		break;

	  case RAM_ECC_EVEN_ESM_CHANNEL:
		sciSend		(scilinREG, 26, (unsigned char *) "RAM_ECC_EVEN_ESM_CHANNEL\r\n");
		break;

	  case RAM_ECC_ODD_ESM_CHANNEL:
		sciSend		(scilinREG, 25, (unsigned char *) "RAM_ECC_ODD_ESM_CHANNEL\r\n");
		break;

	  case IOMM_MUX_ESM_CHANNEL:
		sciSend		(scilinREG, 22, (unsigned char *) "IOMM_MUX_ESM_CHANNEL\r\n");
		break;

	  case PDC_COMPARE_ESM_CHANNEL:
		sciSend		(scilinREG, 25, (unsigned char *) "PDC_COMPARE_ESM_CHANNEL\r\n");
		break;

	  case PDC_SELFTEST_ESM_CHANNEL:
		sciSend		(scilinREG, 26, (unsigned char *) "PDC_SELFTEST_ESM_CHANNEL\r\n");
		break;

	  case EFUSE_STATUS_ESM_CHANNEL:
		sciSend		(scilinREG, 26, (unsigned char *) "EFUSE_STATUS_ESM_CHANNEL\r\n");
		break;

	  case EFUSE_SELFTEST_ESM_CHANNEL:
		sciSend		(scilinREG, 28, (unsigned char *) "EFUSE_SELFTEST_ESM_CHANNEL\r\n");
		break;

	  case PLL2_SLIP_ESM_CHANNEL:
		sciSend		(scilinREG, 23, (unsigned char *) "PLL2_SLIP_ESM_CHANNEL\r\n");
		break;

	  default:
		sciSend		(scilinREG, 23, (unsigned char *) "UNDEFINED ESM CHANNEL\r\n");
	    break;
	  }
/* USER CODE END */
}

/* USER CODE BEGIN (2) */
/* USER CODE END */
#pragma WEAK(esmGroup2Notification)
void esmGroup2Notification(uint32 channel)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (3) */
	if(g_printFunction && !esmGroup2NotificationUsed)
	{
		esmGroup2NotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}

	esmTriggerErrorPinReset();
	switch (channel)
	{

	  case CCM_SELFTEST_ESM_CHANNEL:
		sciSend		(scilinREG, 26, (unsigned char *) "CCM_SELFTEST_ESM_CHANNEL\r\n");
		break;

	  default:
		sciSend		(scilinREG, 23, (unsigned char *) "UNDEFINED ESM CHANNEL\r\n");
	    break;
	  }


/* USER CODE END */
}

/* USER CODE BEGIN (4) */
/* USER CODE END */
#pragma WEAK(memoryPort0TestFailNotification)
void memoryPort0TestFailNotification(uint32 groupSelect, uint32 dataSelect, uint32 address, uint32 data)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (5) */
	if(g_printFunction && !memoryPort0TestFailNotificationUsed)
	{
		memoryPort0TestFailNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}

/* USER CODE BEGIN (6) */
/* USER CODE END */
#pragma WEAK(memoryPort1TestFailNotification)
void memoryPort1TestFailNotification(uint32 groupSelect, uint32 dataSelect, uint32 address, uint32 data)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (7) */
	if(g_printFunction && !memoryPort1TestFailNotificationUsed)
	{
		memoryPort1TestFailNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}

/* USER CODE BEGIN (8) */
/* USER CODE END */
#pragma WEAK(rtiNotification)
void rtiNotification(uint32 notification)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (9) */
	if(g_printFunction && !rtiNotificationUsed)
	{
		rtiNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}

/* USER CODE BEGIN (10) */
/* USER CODE END */
#pragma WEAK(adcNotification)
void adcNotification(adcBASE_t *adc, uint32 group)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (11) */
	if(g_printFunction && !adcNotificationUsed)
	{
		adcNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}

/* USER CODE BEGIN (12) */
/* USER CODE END */
#pragma WEAK(canErrorNotification)
void canErrorNotification(canBASE_t *node, uint32 notification)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (13) */
/* USER CODE END */
}

#pragma WEAK(canStatusChangeNotification)
void canStatusChangeNotification(canBASE_t *node, uint32 notification)  
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (14) */
/* USER CODE END */
}

#pragma WEAK(canMessageNotification)
void canMessageNotification(canBASE_t *node, uint32 messageBox)  
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (15) */
/* USER CODE END */
}

/* USER CODE BEGIN (16) */
/* USER CODE END */
#pragma WEAK(dccNotification)
void dccNotification(dccBASE_t  *dcc,uint32 flags)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (17) */
	if(g_printFunction && !dccNotificationUsed)
	{
		dccNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}

/* USER CODE BEGIN (18) */
/* USER CODE END */
#pragma WEAK(gioNotification)
void gioNotification(gioPORT_t *port, uint32 bit)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (19) */
	uint8 portValue = 0;
	uint8 polarity = 0;
	INPUT_PIN_TYPE inputPin = INPUT_PIN_LAST;

	if(g_printFunction && !gioNotificationUsed)
	{
		gioNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}

	 portValue = gioGetBit(port,bit);

	if(port == gioPORTA)
	{
	  switch(bit)
	  {
		case TERMINAL_M1_GIOA:	/**< FOOTSWITCH 1 */
			//TODO send to footswitch comm task
			inputPin = INPUT_PIN_FOOTSWITCH_1;
			break;

		case TERMINAL_E1_GIOA:	/**< FOOTSWITCH 2 */
			//TODO send to footswitch comm task
			inputPin = INPUT_PIN_FOOTSWITCH_2;
			break;

		case TERMINAL_A6_GIOA:	/**< RESERVED_BLAST_SHIELD_DETECTION */
			break;

		case TERMINAL_B5_GIOA: /**< HV_TEMP */
			inputPin = INPUT_PIN_HV_TEMP;
			break;

		case TERMINAL_H3_GIOA:/**< HP_DETECT 2 */
			inputPin = INPUT_PIN_HP_DETECT2;
			break;

		default:
			break;
	  }
	}
	else if( port == gioPORTB)
	{
		switch(bit)
		{
		case TERMINAL_F2_GIOB:	/**< WATER_LEVEL */
			inputPin = INPUT_PIN_WATER_LEVEL;
			break;

		case TERMINAL_G1_GIOB:	/**< SIMMER_MONITOR */
			inputPin = INPUT_PIN_SIMMER_MONITOR;
			break;

		case TERMINAL_J2_GIOB:	/**< RF_INTX */
			//TODO send to wireless task
			inputPin = INPUT_PIN_RF_INTX;
			break;

		case TERMINAL_F1_GIOB:	/**< HP_DETECT 1 */
			inputPin = INPUT_PIN_HP_DETECT1;
			break;

  	  case TERMINAL_G2_GIOB: /**< IO Expander I2C Interruption **/
  		  	if(portValue == 0)
  		  	{
  		  		inputPin = INPUT_PIN_IO_EXPANDER_INTERRUPT;
  		  	}
		  break;

		default:
			break;
		}
	}

	if(inputPin != INPUT_PIN_LAST)
	{
		polarity = g_inputPinPolarity[inputPin];
		msgQ_sendInputChangeMessage(inputPin, !(portValue ^ polarity));
	}

/* USER CODE END */
}

/* USER CODE BEGIN (20) */
/* USER CODE END */
#pragma WEAK(i2cNotification)
void i2cNotification(i2cBASE_t *i2c, uint32 flags)      
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (21) */
	if(g_printFunction && !i2cNotificationUsed)
	{
		i2cNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}

/* USER CODE BEGIN (22) */
/* USER CODE END */
#pragma WEAK(mibspiNotification)
void mibspiNotification(mibspiBASE_t *mibspi, uint32 flags)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (25) */
	if(g_printFunction && !mibspiNotificationUsed)
	{
		mibspiNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}

/* USER CODE BEGIN (26) */
/* USER CODE END */
#pragma WEAK(mibspiGroupNotification)
void mibspiGroupNotification(mibspiBASE_t *mibspi, uint32 group)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (27) */
	if(g_printFunction && !mibspiGroupNotificationUsed)
	{
		mibspiGroupNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}
/* USER CODE BEGIN (28) */
/* USER CODE END */

#pragma WEAK(sciNotification)
void sciNotification(sciBASE_t *sci, uint32 flags)     
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (29) */
	if(g_printFunction && !sciNotificationUsed)
	{
		sciNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}

/* USER CODE BEGIN (30) */
/* USER CODE END */
#pragma WEAK(spiNotification)
void spiNotification(spiBASE_t *spi, uint32 flags)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (31) */
/* USER CODE END */
}

/* USER CODE BEGIN (32) */
/* USER CODE END */
#pragma WEAK(spiEndNotification)
void spiEndNotification(spiBASE_t *spi)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (33) */
/* USER CODE END */
}

/* USER CODE BEGIN (34) */
/* USER CODE END */

#pragma WEAK(pwmNotification)
void pwmNotification(hetBASE_t * hetREG,uint32 pwm, uint32 notification)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (35) */
	if(g_printFunction && !pwmNotificationUsed)
	{
		pwmNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}

/* USER CODE BEGIN (36) */
/* USER CODE END */
#pragma WEAK(edgeNotification)
void edgeNotification(hetBASE_t * hetREG,uint32 edge)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (37) */
	uint8 polarity = 0;

	uint32 edgeCounterValue = 0;
	uint8 portValue = 0;
	uint32 edgeBit = 0;

	if(g_printFunction && !edgeNotificationUsed)
	{
		edgeNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}

	switch (edge)
	{
	  case 0:
		edgeBit = TERMINAL_A3_NHET1_GIO;
		break;

	  case 1:
		edgeBit = TERMINAL_A13_NHET1_GIO;
		break;

	  case 2:
		edgeBit = TERMINAL_H4_NHET1_GIO;
		break;

	  case 3:
		edgeBit = TERMINAL_J4_NHET1_GIO;
		break;

	  case 4:
		edgeBit = TERMINAL_J17_NHET1_GIO;
		break;

	  case 5:
		edgeBit = TERMINAL_K19_NHET1_GIO;	/**<Water Flow*/
		break;

	  default:
		break;
	}
	if (hetREG == hetREG1)
	{
	  edgeCounterValue = edgeGetCounter(hetRAM1, edge);
	  portValue = bsp_NHET1_GET(edgeBit);
	}
	else
	{
	  edgeCounterValue = edgeGetCounter(hetRAM2, edge);
	  portValue = bsp_NHET2_GET(edgeBit);
	}

	if(edgeBit == TERMINAL_K19_NHET1_GIO )
	{
		polarity = g_inputPinPolarity[INPUT_PIN_WATER_FLOW];
		msgQ_sendInputChangeMessage(INPUT_PIN_WATER_FLOW, !(portValue ^ polarity));
	}
/* USER CODE END */
}

/* USER CODE BEGIN (38) */
/* USER CODE END */
#pragma WEAK(hetNotification)
void hetNotification(hetBASE_t *het, uint32 offset)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (39) */


	if(g_printFunction && !hetNotificationUsed)
	{
		hetNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}


/* USER CODE END */
}

/* USER CODE BEGIN (40) */
/* USER CODE END */

#pragma WEAK(crcNotification)
void crcNotification(crcBASE_t *crc, uint32 flags)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (41) */
	if(g_printFunction && !crcNotificationUsed)
	{
		crcNotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}
/* USER CODE BEGIN (42) */
/* USER CODE END */

/* USER CODE BEGIN (43) */
/* USER CODE END */


/* USER CODE BEGIN (47) */
/* USER CODE END */


/* USER CODE BEGIN (50) */
/* USER CODE END */


/* USER CODE BEGIN (53) */
/* USER CODE END */

#pragma WEAK(dmaGroupANotification)
void dmaGroupANotification(dmaInterrupt_t inttype, uint32 channel)
{
/*  enter user code between the USER CODE BEGIN and USER CODE END. */
/* USER CODE BEGIN (54) */
	if(g_printFunction && !dmaGroupANotificationUsed)
	{
		dmaGroupANotificationUsed = 1;
		strcat(g_NOT_buffer, __FUNCTION__);
		strcat(g_NOT_buffer, ",\r\n");
	}
/* USER CODE END */
}
/* USER CODE BEGIN (55) */
/* USER CODE END */

/* USER CODE BEGIN (56) */
/* USER CODE END */

/* USER CODE BEGIN (58) */
/* USER CODE END */

/* USER CODE BEGIN (60) */
/* USER CODE END */
