/*
 * ra_dbg_level.h
 *
 *  Created on: Oct 26, 2022
 *      Author: jogappanaik
 */

#ifndef INCLUDE_RA_DBG_LEVEL_H_
#define INCLUDE_RA_DBG_LEVEL_H_

#include <ra_stdio.h>
#include <stdio.h>

#define RA_DEBUG_LEVEL_DEBUG      5
#define RA_DEBUG_LEVEL_INFO       4
#define RA_DEBUG_LEVEL_WARNING    3
#define RA_DEBUG_LEVEL_ERROR      2
#define RA_DEBUG_LEVEL_FATAL      1
#define RA_DEBUG_LEVEL_NO_DEBUG   0

#ifdef  RA_DEBUG_WITH_BASH_COLOR
#define RA_DEBUG_COLOR_RED     "\x1b[31m"
#define RA_DEBUG_COLOR_GREEN   "\x1b[32m"
#define RA_DEBUG_COLOR_YELLOW  "\x1b[33m"
#define RA_DEBUG_COLOR_RESET   "\x1b[0m"
#define RA_DEBUG_PRNT_COLOR_RESET(FD) RA_DEBUG_PRINTF(FD, RA_DEBUG_COLOR_RESET)
#else
#define RA_DEBUG_COLOR_RED     ""
#define RA_DEBUG_COLOR_GREEN   ""
#define RA_DEBUG_COLOR_YELLOW  ""
#define RA_DEBUG_COLOR_RESET   ""
#define RA_DEBUG_PRNT_COLOR_RESET(FD) {}
#endif

#define RA_DEBUG_WITH_FILE_NAME_FMT        " : %s"
#define RA_DEBUG_WITH_FILE_NAME_VALUE      ,__FILE__

#define RA_DEBUG_WITH_LINE_NAME_FMT        " : L:%4u"
#define RA_DEBUG_WITH_LINE_NAME_VALUE      ,__LINE__

#define RA_DEBUG_WITH_FUNC_NAME_FMT        " %s"
#define RA_DEBUG_WITH_FUNC_NAME_VALUE      ,__FUNCTION__

#if !defined(RA_DEBUG_LEVEL)
#define RA_DEBUG_LEVEL RA_DEBUG_LEVEL_NO_DEBUG
#endif

#define RA_DEBUG_FFLUSH(fd)   {fflush(fd);}

#define RA_DEBUG_PRINTF(FD, ...) \
{                                \
    ra_stdio_print(__VA_ARGS__); \
}                                \

#define RA_DEBUG_GEN_WP(FD, ...)      \
{                                     \
    RA_DEBUG_PRINTF(FD, __VA_ARGS__); \
    RA_DEBUG_PRNT_COLOR_RESET(FD);    \
    RA_DEBUG_FFLUSH(FD);              \
}                                     \

#define RA_DEBUG_GEN(FD, PREFIX, ...) \
{                                     \
    RA_DEBUG_PRINTF(FD,"%s ["                      \
            RA_DEBUG_WITH_FUNC_NAME_FMT            \
            RA_DEBUG_WITH_FILE_NAME_FMT            \
            RA_DEBUG_WITH_LINE_NAME_FMT            \
            " ] "                                   \
            ,PREFIX                                 \
            RA_DEBUG_WITH_FUNC_NAME_VALUE          \
            RA_DEBUG_WITH_FILE_NAME_VALUE          \
            RA_DEBUG_WITH_LINE_NAME_VALUE          \
            );                                      \
    RA_DEBUG_GEN_WP(FD, __VA_ARGS__)  \
}                                     \


#if RA_DEBUG_LEVEL >= RA_DEBUG_LEVEL_DEBUG
#define RA_DEBUG(...)            RA_DEBUG_GEN   (stdout, "-D-", __VA_ARGS__)
#define RA_DEBUG_WP(...)         RA_DEBUG_GEN_WP(stdout,        __VA_ARGS__)
#else
#define RA_DEBUG(...)                                                      {}
#define RA_DEBUG_WP(...)                                                   {}
#endif

#if RA_DEBUG_LEVEL >= RA_DEBUG_LEVEL_INFO
#define RA_DEBUG_INFO(...)       RA_DEBUG_GEN   (stdout, "-I-", __VA_ARGS__)
#define RA_DEBUG_INFO_WP(...)    RA_DEBUG_GEN_WP(stdout,        __VA_ARGS__)
#else
#define RA_DEBUG_INFO(...)                                                 {}
#define RA_DEBUG_INFO_WP(...)                                              {}
#endif

#if RA_DEBUG_LEVEL >= RA_DEBUG_LEVEL_WARNING
#define RA_DEBUG_WARNING(...)    RA_DEBUG_GEN   (stderr, RA_DEBUG_COLOR_YELLOW "-W-" , __VA_ARGS__)
#define RA_DEBUG_WARNING_WP(...) RA_DEBUG_GEN_WP(stderr, RA_DEBUG_COLOR_YELLOW         __VA_ARGS__)
#else
#define RA_DEBUG_WARNING(...)                                              {}
#define RA_DEBUG_WARNING_WP(...)                                           {}
#endif

#if RA_DEBUG_LEVEL >= RA_DEBUG_LEVEL_ERROR
#define RA_DEBUG_ERROR(...)      RA_DEBUG_GEN   (stderr, RA_DEBUG_COLOR_RED "-E-" , __VA_ARGS__)
#define RA_DEBUG_ERROR_WP(...)   RA_DEBUG_GEN_WP(stderr, RA_DEBUG_COLOR_RED         __VA_ARGS__)
#else
#define RA_DEBUG_ERROR(...)                                                {}
#define RA_DEBUG_ERROR_WP(...)                                             {}
#endif

#if RA_DEBUG_LEVEL >= RA_DEBUG_LEVEL_FATAL
#define RA_DEBUG_FATAL(...)                      \
{                                                \
    RA_DEBUG_GEN   (stderr,RA_DEBUG_COLOR_RED "-F-" , __VA_ARGS__)  \
    while(1);                                    \
}
#define RA_DEBUG_FATAL_WP(...)                   \
{                                                \
    RA_DEBUG_GEN_WP   (stderr, RA_DEBUG_COLOR_RED      __VA_ARGS__)  \
    while(1);                                    \
}
#else
#define RA_DEBUG_FATAL(...)            {}
#define RA_DEBUG_FATAL_WP(...)         {}
#endif

#endif /* INCLUDE_RA_DBG_LEVEL_H_ */
