/*
 *  COPYRIGHT (c) 2023.
 *  Reflex Aerospace GmbH.
 *
 *  Unauthorized copying of this file, via any medium is strictly prohibited.
 */

#pragma once

#include <stddef.h>
#include <stdint.h>

/**
 * @brief      Function to calculate a CRC32 checksum.
 *
 * @param[in]  buf   The buffer
 * @param[in]  size  The size
 *
 * @return     CRC value
 */
uint32_t rfx_crc32_calculate(const void *buf, size_t size);
