/*
 *  COPYRIGHT (c) 2023.
 *  Reflex Aerospace GmbH.
 *
 *  Unauthorized copying of this file, via any medium is strictly prohibited.
 */

#pragma once

#include <stdint.h>

#define EEPROM_INDEX          0          /**< EEPROM Index, only one EEPROM available on TMS570LC so 0*/
#define EEPROM_FORMAT_KEY_1   0xA5A5A5A5 /**< Format key, API will format only configured sectors. However, TI_Fee_Init has to be called before */
#define EEPROM_FORMAT_KEY_2   0x5A5A5A5A /**< Format key, TI_Fee_Init API call is not required. However, in this case complete EEPROM bank will be formatted. */

#define EEPROM_BLOCK_MIN            1     /**< Minimum number of blocks required by FEE driver */
#define EEPROM_BLOCK_TOTAL_COUNT    16    /**< Total number of blocks configured in ti_fee_cfg.h */
#define EEPROM_BLOCK_SIZE           2048  /**< Block size configured in ti_fee_cfg.c */

#define EEPROM_MAX_INIT_TIME_MS               200  /*<< Maximum EEPROM init time in ms, experimental /tested value */
#define EEPROM_MAX_BANK_FORMAT_TIME_MS        500  /*<< Maximum EEPROM format time in ms, experimental /tested value*/
#define EEPROM_MAX_ASYNC_BLOCK_READ_TIME_MS   1000 /*<< Maximum EEPROM Asynchronous block read time in ms, experimental/tested value for read of 4095 bytes */
#define EEPROM_MAX_ASYNC_BLOCK_WRITE_TIME_MS  500  /*<< Maximum EEPROM Asynchronous block write time in ms,experimental/tested value for read of 4095 bytes */
