/** @file HL_sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com  
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "HL_sys_common.h"

/* USER CODE BEGIN (1) */
#include "HL_sys_core.h"

#include <HL_sci.h>
#include <rfx_eeprom_def.h>
#include <rfx_eeprom.h>
#include <rfx_crc.h>

#include <ra_dbg_level.h>
#include <ra_stdio.h>

#include <stdio.h>
#include <string.h>
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
#define RA_DEBUG_PORT      sciREG3
#define RA_RW_DATA_LEN     32

#define TEST_OFFSET      0          /*<< Test offset value */

uint8_t buf_w[EEPROM_BLOCK_SIZE];   /*<< Buffer to write blocks*/
uint8_t buf_r[EEPROM_BLOCK_SIZE];   /*<< Buffer to read blocks */

/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */

    _enable_IRQ_interrupt_();
    sciInit();
    sciSetBaudrate(sciREG3,460800);
    ra_stdio_init(RA_DEBUG_PORT);

    uint8_t  test_error_status = 0;
    uint32_t crc_value_const   = 0;
    uint32_t i, j, k;

    // EEPROM init
    if (rfx_eeprom_init() != RFX_STATUS_SUCCESS)
    {
            RA_DEBUG_ERROR_WP("rfx_eeprom_init() failed \r\n");
            test_error_status = 1;
    }
    RA_DEBUG_INFO_WP("EEPROM Init done\r\n");

#if 1
    // EEPROM Format
    if(test_error_status == 0)
    {
        if (rfx_eeprom_format(EEPROM_FORMAT_KEY_1) != RFX_STATUS_SUCCESS)
        {
            RA_DEBUG_ERROR_WP("rfx_eeprom_format(EEPROM_FORMAT_KEY_1) failed \r\n");
            test_error_status = 1;
        }
        RA_DEBUG_INFO_WP("EEPROM Format done\r\n");

        // Always call rfx_eeprom_init() after rfx_eeprom_format()
        if (rfx_eeprom_init() != RFX_STATUS_SUCCESS)
        {
            RA_DEBUG_ERROR_WP("rfx_eeprom_init() failed \r\n");
            test_error_status = 1;
        }
        RA_DEBUG_INFO_WP("EEPROM Init done after format\r\n");
    }
#endif

    // Create a sample arrays set with an known pattern
    // write 16 blocks
    if(test_error_status == 0)
    {
        for(i = 0; i < EEPROM_BLOCK_SIZE; i++)
        {
            buf_w[i] = i;
        }

        crc_value_const = rfx_crc32_calculate(&buf_w[0], EEPROM_BLOCK_SIZE);
        RA_DEBUG_INFO_WP("block_crc_const = %u\r\n", crc_value_const);

#if 1
        // write all the blocks
        for (j = EEPROM_BLOCK_MIN; j <= 9; j++)
        {
            if(rfx_eeprom_write_async(j, &buf_w[0], EEPROM_MAX_ASYNC_BLOCK_WRITE_TIME_MS) != RFX_STATUS_SUCCESS)
            {
                RA_DEBUG_ERROR_WP("rfx_eeprom_write_async(block: %u) failed \r\n", j);
                test_error_status = 1;
            }
            //usleep(100000);
        }
        if(test_error_status == 0)
        {
            RA_DEBUG_INFO_WP("EEPROM Block write done !!!\r\n");
        }
        else
        {
            RA_DEBUG_INFO_WP("EEPROM Block write failed!!!\r\n");
        }
#endif
    }

    // read block
    if(test_error_status == 0)
    {
        for(j= EEPROM_BLOCK_MIN; j <= 9; j++)
        {
            if(rfx_eeprom_read_async(j, TEST_OFFSET, EEPROM_BLOCK_SIZE, &buf_r[0], EEPROM_MAX_ASYNC_BLOCK_READ_TIME_MS) != RFX_STATUS_SUCCESS)
            {
                RA_DEBUG_ERROR_WP("rfx_eeprom_read_async() failed \r\n");
                test_error_status = 1;
            }

            uint32_t crc_check_read = rfx_crc32_calculate(&buf_r[0], EEPROM_BLOCK_SIZE);
            if (crc_check_read != crc_value_const)
            {
                RA_DEBUG_ERROR_WP("crc_check() failed at block=%u (%u != %u)\r\n", j, crc_check_read, crc_value_const);
                test_error_status = 1;
            }
            //usleep(100000);

//            for(k=0; k<EEPROM_BLOCK_SIZE; k++)
//            {
//                RA_DEBUG_INFO_WP("%u ", buf_r[k]);
//            }
//            RA_DEBUG_INFO_WP("\r\n");
        }

        if(test_error_status == 0)
        {
            RA_DEBUG_INFO_WP("EEPROM Block read done !!!\r\n");
        }
        else
        {
            RA_DEBUG_INFO_WP("EEPROM Block read failed!!!\r\n");
        }
    }

    if (test_error_status == 0)
    {
        RA_DEBUG_INFO_WP("EEPROM Test done \r\n");
    }
    else
    {
        RA_DEBUG_INFO_WP("EEPROM Test failed\r\n");
    }

    while (1)
    {
        ;
    }


/* USER CODE END */
}


/* USER CODE BEGIN (4) */
/* USER CODE END */
