/*
 * ra_stdio.c
 *
 *  Created on: Oct 28, 2022
 *      Author: jogappanaik
 */
#include <ra_stdio.h>

static volatile short _send_buf[RA_SCI_BUF_MAX_SIZE];
static sciBASE_t       *_std_print_sci = NULL;

void ra_stdio_init(sciBASE_t *sci)
{
    _std_print_sci = sci;
}

int ra_stdio_print(const char *_format, ...)
{
   int length = -1;

   va_list argList;
   va_start( argList, _format );

   length = vsnprintf((char*)_send_buf, sizeof(_send_buf), _format, argList);

   va_end( argList );

   if(_std_print_sci == NULL)
   {
       return -1;
   }

   if (length > 0)
   {
      sciSend(_std_print_sci, (uint32)length, (uint8 *)_send_buf);
   }

   return length;
}
