/** @file HL_sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com  
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "HL_sys_common.h"

/* USER CODE BEGIN (1) */
#include "HL_emac.h"
#include "FreeRTOS.h"
#include "FreeRTOSConfig.h"
#include "os_task.h"
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
extern uint8    emacAddress[6U];
extern hdkif_t hdkif_data[1];
void prvEmacTask(void* pvParameters);
pbuf_t pack[5];
__attribute__( ( section( ".emacBuffers" ) ) ) uint8 data[5][100];
uint32 size1 = 470,size2=94;

void create_packet()
{
    int i,j;

    for(i=0;i<5;i++)
    {
    pack[i].tot_len = size1;
    pack[i].len = size2;
    for(j=0;j<6;j++)
    {
        data[i][j] = 0xffu;

    }
    for(j=0;j<6;j++)
    {
        data[i][j+6]= emacAddress[j];

    }

    data[i][12] = 0;
    data[i][13] = 80;

    for(j=0;j<80;j++)
    {
        data[i][j+14] = i+5;
    }

    pack[i].payload = &data[i][0];
    if(i!=4)
    pack[i].next = &pack[i+1];
    }
    pack[4].next= NULL;
}

/* USER CODE END */

uint8	emacAddress[6U] = 	{0x00U, 0x08U, 0xEEU, 0x03U, 0xA6U, 0x6CU};
uint32 	emacPhyAddress	=	1U;

int main(void)
{
/* USER CODE BEGIN (3) */
    _enable_IRQ();
    EMACHWInit(emacAddress);
    xTaskCreate(
            prvEmacTask,
            "EmacTask",
            (2*configMINIMAL_STACK_SIZE),
            NULL,
            2,
            NULL
        );
    vTaskStartScheduler();
    while(1);
/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
void prvEmacTask(void* pvParameters)
{
    create_packet();
    EMACTransmit(&hdkif_data[0], &pack[0]);
    size1=600;
    size2=120;
    create_packet();
    EMACTransmit(&hdkif_data[0], &pack[0]);
    while(1);
}
/* USER CODE END */
