/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2014.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Adc_Cfg.h
 *      Project:  Tms570_AutosarAdcDriver
 *       Module:  AdcDriver
 *    Generator:  EB Tresos
 *
 *  Description:  This file is generated by EB Tresos.Do not modify this file, otherwise the software may 
 *                behave in unexpected way.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Vishwanath Reddy
 *---------------------------------------------------------------------------------------------------------------------
 * Templete Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.21.00       30Sep2014    Vishwanath Reddy     SDOCM00113127    Initial Version 
 * 02.21.01       23Aug2016    Vishwanath Reddy     SDOCM00121248    Add macros ADC_HW_UNIT0 and ADC_HW_UNIT1 to be 
 *                                                                   used as values for "AdcHwUnitId" in xdm file.
 * 02.30.00       01Dec2016    Sudhakar Singh           None         Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh       SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 **********************************************************************************************************************/

 /*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/
 
#ifndef ADC_CFG_H
#define ADC_CFG_H

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
#include "Os.h"
#include "SchM_Adc.h"

/**********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 *********************************************************************************************************************/

 /* Version identification */
#define ADC_CFG_MAJOR_VERSION               (5U)
#define ADC_CFG_MINOR_VERSION               (30U)
#define ADC_CFG_PATCH_VERSION               (0U)

/* ADC HW UNIT 0 and 1 */
#define ADC_HW_UNIT0			           (0x0U)
#define ADC_HW_UNIT1			           (0x1U)

/* Base address of the register set of ADC HW UNIT 0 and 1 */
#define ADC_HW_UNIT0_BASE_ADDRESS           (0xFFF7C000U)
#define ADC_HW_UNIT1_BASE_ADDRESS           (0xFFF7C200U)

/* Offset of the fifo buffer register relative to hw unit base address */
#define ADC_EV_FIFO_OFFSET                  (0x90U)
#define ADC_G1_FIFO_OFFSET                  (0xB0U)
#define ADC_G2_FIFO_OFFSET                  (0xD0U)
 
 /* Number of results in buffer, after which a threshold interrupt is generated. */
#define ADC_HW_FIFO_THRESHOLD               (14U)
/* Event fifo end mark. Multiply the value defined below by 2 to get the current size of event group fifo. See hw 
 * manual.
 */
#define ADC_EV_FIFO_END                     (10U)
/* Group 1 fifo end mark. (ADC_G1_FIFO_END - ADC_EV_FIFO_END) * 2 delivers the current size of group 1 fifo. The 
 * remaining amount of memory is used for group 2. See hw manual. 
 */
#define ADC_G1_FIFO_END                     (20U)

/* Configure ISR implementation */
#define ADC_ISR_VOID                        (0U)
#define ADC_ISR_CAT1                        (1U)
#define ADC_ISR_CAT2                        (2U)

#define ADC_CFG_ISR_TYPE   ADC_ISR_VOID  /*<ADC_CFG_NATIVE_ISR/>*/ /*ADC_ISR_CAT2*/ 
#define ADC_SRAM_PARITY_ENABLE  (STD_OFF)

/* compiler switches for API enabling */
/* SourceId : ADC_SourceId_024 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR228*/
#define ADC_ENABLE_START_STOP_GROUP_API    (STD_ON)
/* SourceId : ADC_SourceId_025 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR224*/
#define ADC_DEINIT_API                    (STD_ON)
/* SourceId : ADC_SourceId_026 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR232*/
#define ADC_READ_GROUP_API                 (STD_ON)
/* SourceId : ADC_SourceId_027 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR230*/
#define ADC_HW_TRIGGER_API                (STD_OFF)
/* SourceId : ADC_SourceId_028 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR229*/
#define ADC_GRP_NOTIF_CAPABILITY           (STD_ON)
/* SourceId : ADC_SourceId_029 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR234*/
#define ADC_VERSION_INFO_API               (STD_ON)
/* SourceId : ADC_SourceId_030 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR226*/
#define ADC_ENABLE_LIMIT_CHECK			   (STD_ON)
/* SourceId : ADC_SourceId_031 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR227*/
#define ADC_ENABLE_QUEUING				  (STD_OFF)	
/* SourceId : ADC_SourceId_032 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR231*/
#define ADC_PRIORITY_IMPLEMENTATION       ADC_PRIORITY_NONE	
/* SourceId : ADC_SourceId_033 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR233*/
#define ADC_RESULT_ALIGNMENT              ADC_ALIGN_LEFT

#define ADC_SAFETI_API                    (STD_OFF)	
#define ADC_SELF_TEST_ENABLE              (STD_OFF)	
#define ADC_CALIBRATE_FUNCTION_ENABLE     (STD_OFF)	

#define ADC_CHANNEL_VALUESIGNED           (STD_OFF)	
#define ADC_GROUP_FIRST_CHANNEL_FIXED     (STD_OFF)	
#define ADC_MAX_CHANNEL_RESOLUTION        12U	

/* defines for hardware conversion group Id's */
#define ADC_HW_GROUP_EVT                        (0U)
#define ADC_HW_GROUP_G1                         (1U)
#define ADC_HW_GROUP_G2                         (2U)

/* defines for member Notification of Adc_GroupDataType */
#define ADC_NOTIFICATION_ON                     (1U)
#define ADC_NOTIFICATION_OFF                    (0U)

/* defines for member GroupStopMode of Adc_GroupConfigType */
/* Group stops automatically (implicit), after a fix number of samples */
#define ADC_GROUP_STOP_IMPLICIT                 (0U)
/* Group has to be stopped by user action (API call) */
#define ADC_GROUP_STOP_EXPLICIT                 (1U)

/* define fifo size. */
#define ADC_FIFO_BND_END                        (0x02U) /* 0x02: FIFO capacity is 64 words. */

/* Global switch to enable development error detection */
/* SourceId : ADC_SourceId_035 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR52, AR_ADC_SR225 */
#define ADC_DEV_ERROR_DETECT                          (STD_ON)

/* If this switch is set, then 12 bit conversions are supported */
#define ADC_CFG12_BIT_MODE_SUPPORTED     (STD_ON)
/* Defines for all the available ADC resolutions. This is the value that has to be assigned to the MODECR register at
  * position ADC_DATA_FORMAT_OFFSET to get the respective resolution. */
#if (STD_ON == ADC_CFG12_BIT_MODE_SUPPORTED)
#define ADC_CFG_RES_12BIT               (0x00U)
#define ADC_CFG_RES_10BIT               (0x01U)
#define ADC_CFG_RES_8BIT                (0x02U)
#else
#define ADC_CFG_RES_10BIT               (0x00U)
#define ADC_CFG_RES_8BIT                (0x01U)
#endif 

/* Create symbolic names of AdcGroups for use in API functions */
/*<ADC_CFG_GROUPNAME_LIST>*/
/* SourceId : ADC_SourceId_034 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR250 */
#define   MyTestGroup0 (0)
#define   MyTestGroup3 (1)
#define   MyTestGroup4 (2)
#define   MyTestGroup5 (3)


/**********************************************************************************************************************
 *  GLOBAL FUNCTION PROTOTYPES
 *********************************************************************************************************************/
/* Declarations of non-API functions */
FUNC(void, ADC_CODE) Adc_ProcessBufferSingle  (Adc_GroupConfigRefType GroupConfigPtr);
FUNC(void, ADC_CODE) Adc_ProcessBufferLinear  (Adc_GroupConfigRefType GroupConfigPtr);
FUNC(void, ADC_CODE) Adc_ProcessBufferCircular(Adc_GroupConfigRefType GroupConfigPtr);

FUNC(void, ADC_CODE) Adc_ProcessConversionSingle  (Adc_GroupConfigRefType GroupConfigPtr);
FUNC(void, ADC_CODE) Adc_ProcessConversionLinear  (Adc_GroupConfigRefType GroupConfigPtr);
FUNC(void, ADC_CODE) Adc_ProcessConversionCircular(Adc_GroupConfigRefType GroupConfigPtr);

/* extern declarations of Notification API's */

FUNC(void, ADC_CODE) Adc_AvoidNotification(void);

/**********************************************************************************************************************
 *  Exported Object Declarations
 **********************************************************************************************************************/                  
/* extern declarations of post-build configuration sets */
/*<ADC_CFG_GENERAL_EXTERN>*/
extern  CONST(Adc_ConfigType, ADC_PBCFG) AdcConfigSet_0;
/*</ADC_CFG_GENERAL_EXTERN>*/

#endif /*ADC_CFG_H*/
/**********************************************************************************************************************
 *  END OF FILE: Adc_Cfg.h
 *********************************************************************************************************************/
