/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2014.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Can_Cfg.h
 *      Project:  Tms570_AutosarCanDriver
 *       Module:  CanDriver Configuration Header File Can_Cfg.h
 *    Generator:  EB Tresos
 *
 *  Description:  This file is generated by EB Tresos.Do not modify this file, otherwise the software may 
 *                behave in unexpected way.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Vishwanath Reddy
 *---------------------------------------------------------------------------------------------------------------------
 * Template Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.10.00       10Feb2013    Vishwanath Reddy    0000000000000     Initial Version adapted from TMS570LS31xx v1.10.00
 * 02.20.00       23Aug2013    Vishwanath Reddy    SDOCM00103356     Version Info update.
 *                                                                   Safety requirements implementation. 
 *                                                                   Added requirement tags for traceability. 
 * 02.20.01       10Apr2014    Vishwanath Reddy    SDOCM00107321     Version Info update.
 *                                                                   Add missing configuration items.
 *                                                                   Add design tags.
 * 02.21.00       30Sep2014    Vineeth T Alex      SDOCM00113179     Changes for Production release.
 *                                                                   Device compatibility
 * 02.21.01       03Nov2014    Vineeth T Alex      SDOCM00113685     Version Update.
 * 02.21.02       01Mar2016    Vishwanath Reddy    SDOCM00121479     Version Update.
 * 02.30.00       01Dec2016    Sudhakar Singh          None          Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh       SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/

 /*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/
#ifndef CAN_CFG_H
#define CAN_CFG_H

/*********************************************************************************************************************/
/* VERSION CHECK                                                                                                     */
/*********************************************************************************************************************/

/*
 *  Version identification
 */
#define CAN_CFG_MAJOR_VERSION               (5U)
#define CAN_CFG_MINOR_VERSION               (30U)
#define CAN_CFG_PATCH_VERSION               (0U)


/*********************************************************************************************************************/
/* GLOBAL CONSTANT MACROS                                                                                            */
/*********************************************************************************************************************/

/* pre-compile switches for services */
/* SourceId : CAN_SourceId_032 */
/* DesignId : CAN_DesignId_001 */
/* Requirements : AR_CAN_SR248 */
#define CAN_VERSION_INFO_API   (STD_ON)
/* SourceId : CAN_SourceId_030 */
/* DesignId : CAN_DesignId_001 */
/* Requirements : AR_CAN_SR237 */
#define CAN_CHANGE_BAUDRATE_API (STD_ON)
/* SourceId : CAN_SourceId_018 */
/* DesignId : CAN_DesignId_006 */
/* Requirements : AR_CAN_SR122, AR_CAN_SR238 */
#define CAN_DEV_ERROR_DETECT          (STD_ON)
#define CAN_HW_TRANSMIT_CANCELLATION  (STD_OFF)
#define CAN_IDENTICAL_ID_CANCELLATION (STD_OFF)
#define CAN_MULTIPLEXED_TRANSMISSION  (STD_OFF)
#define CAN_LOOPBACK_ENABLE           (STD_ON)
#define CAN_SAFETI_API                (STD_ON)
#define CAN_SRAM_PARITY_ENABLE        (STD_ON)
/* For all controllers setting needs to be same either polling or interrupt No mixed mode is allowed */


#define CAN_TX_POLLING      (STD_ON)
#define CAN_RX_POLLING      (STD_ON)
#define CAN_BUSOFF_POLLING  (STD_ON)
#define CAN_WAKEUP_POLLING  (STD_ON)

/* Maximum number of Config sets */
 #define KMAX_CONFIG_SET      (1U)    
/* Max Filter Masks*/
 #define KMAX_FILTER_LIST      (1U)    
/* Max Baud rate config structs */
 #define KMAX_BAUD_LIST      (1U)    

/* Max number of controllers defined*/
#define KMAX_CONTROLLER      (3U)
/* Max number of mailboxes defined*/
#define KMAX_MAILBOXES      (2U)

#define KMAX_MB_PER_CONTROLLER (64U) /* There can be max of 64 mailboxes per controller */

/* SourceId : CAN_SourceId_031 */
/* DesignId : CAN_DesignId_001*/
/* Requirements : AR_CAN_SR247 */
#define CAN_TIMEOUT_DURATION (1000U)

/* Wake up sources ref */

/* Interrupt category*/
#define IRQ_CAT1           (STD_ON) 

/*Clk Source */
#define CLK_AV_FREQ   100U

/*Symbolic names for the CanHardwareObjectIds*/

/*Symbolic names for the CanControllerId.  Only 3 controllers are supported*/
#define CONTROLLER_ID_0  0U   
#define CONTROLLER_ID_1  1U
#define CONTROLLER_ID_2  2U
/*********************************************************************************************************************/
/* TYPE DEFINITIONS                                                                                                  */
/*********************************************************************************************************************/

typedef uint8 CanControllerState_Type;
typedef uint32 Can_InterruptMask_Type;
typedef uint16 Can_MbHTRHMapping_Type;

typedef struct Can_MaskStruct
{
  uint32 MaskValue;
}Can_MaskType;
typedef P2VAR(Can_MaskType,TYPEDEF,CAN_PBCFG) Can_MaskPtrType;

/* SourceId : CAN_SourceId_021 */
/* DesignId : CAN_DesignId_003 */
/* Requirements : AR_CAN_SR136 */
typedef struct Can_BaudConfigStruct
{
  uint16                  Baud;               /* In KB */
  uint8                   PropSeg;
  uint8                   Pseg1;              
  uint8                   Pseg2;
  uint8                   Sjw;
  uint8                   TimingValues;       /* Sum of all timing parameters  */
  uint16                  BrpValue;           /* Controller BRP value for Baud */
}Can_BaudConfigType;
typedef P2VAR(Can_BaudConfigType,TYPEDEF, CAN_PBCFG ) Can_BaudConfigPtrType;

typedef struct Can_ControllerStruct
{
   uint8                   ControllerId;              /* Id as provided by GUI */   
   boolean                 CntrActive;                /* Contoller is used=1 or not_used=0*/
   uint32                  CntrAddr;                  /* Pointer to CanReg structure */
   boolean                 CanBusWakeupSupport;       /* Automatic wakeup via bus activity */
   boolean                 RxInterrupt;               /* TRUE = Interrupt FALSE = Polling */
   boolean                 TxInterrupt;               /* TRUE = Interrupt FALSE = Polling */
   boolean                 BusOffProcessingInterrupt; /* TRUE = Interrupt FALSE = Polling */
   boolean                 WakeupProcessingInterrup;  /* TRUE = Interrupt FALSE = Polling */
   Can_BaudConfigPtrType   DefaultBaud;               /* pointer to default Baud structure */ 
   uint8                   InterrupMask;              /* Contoller Interrupt Mask */
   Can_BaudConfigType      **BaudRateConfigList;      /* List of available Baudrate structs */
   Can_MaskType            **FilterMaskList;          /* List of Avialable masks */
}Can_ControllerType;

typedef P2VAR(Can_ControllerType,TYPEDEF,CAN_PBCFG) Can_ControllerPtrType;

typedef struct Can_MailboxStruct
{
  uint8                         CanHandleType;    /* CanHandleType 0=Full, 1=Basic */
  uint8                         MBIdType;         /* CanIdType 0=standard 1=Extended*/
  Can_IdType                    IDValue;          /* ID value extended will have MSB set */
  uint16                        CanObjectId;      /* CanObjectId - Holds handle Id */
  Can_HwHandleType              HwHandle;         /* Mailbox - Hw object in the controller*/
  uint8                         MBDir;            /* CanObjectType - Direction of Mailbox,0= Rx or 1= Tx*/
  Can_ControllerPtrType         Controller;       /* Controller */
  Can_MaskPtrType               Mask;             /* ptr to Mask for the RX filtering */
  uint8                         DLC;              /* Length of the Mailbox */
}Can_MailboxType;

typedef P2VAR(Can_MailboxType,TYPEDEF, CAN_PBCFG ) Can_MailboxPtrType;

/* SourceId : CAN_SourceId_020 */
/* DesignId : CAN_DesignId_004 */
/* Requirements : AR_CAN_SR135 */
typedef struct Can_ConfigSetStruct
{
   Can_ControllerType     **CanControllerList;    /* List of enabled Controllers */
   uint8                  CanMaxControllerCount;  /* MaxCount of Controller in Controller List */
   Can_MailboxType        **MailBoxList;          /* MB array for all controllers */
   uint8                  MaxMbCnt;               /* MaxMbCount in MB list in all controller */
}Can_ConfigType;

typedef P2CONST(Can_ConfigType, TYPEDEF, CAN_PBCFG)   Can_ConfigPtrType;

typedef P2VAR(uint8, TYPEDEF, CAN_APPL_VAR) Can_SduPtrType;

/* Can Driver states  */
typedef enum
{
  CAN_UNINIT = 0U,
  CAN_STARTED,
  CAN_STOPPED,
  CAN_SLEEP
}Can_DriverStateType;


/*********************************************************************************************************************/
/* CONFIGURATION DECLARATION                                                                                         */
/*********************************************************************************************************************/

extern const Can_ConfigType CanConfigSet_0 ;

#endif /*CAN_CFG_H_*/

/**********************************************************************************************************************
 *  END OF FILE: Can_Cfg.h
 *********************************************************************************************************************/
