#ifndef DIO_CFG_H
#define DIO_CFG_H
/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Dio_Cfg.h
 *    Component:  Tms570_AutosarDioDriver
 *       Module:  DioDriver Configuration Header File Dio_Cfg.h
 *    Generator:  EB Tresos
 *
 *  Description:  This file is generated by EB Tresos.Do not modify this file, otherwise the software may
 *                behave in unexpected way.
 *
 *
 * ---------------------------------------------------------------------------------------------------------------------
 * Author:  Sunil Kumar T V
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.10.00       11Feb2013    Sapthagiri G         0000000000000    Initial version(adapted from TMS570LS31xx v01.10.00). 
 * 02.20.00       29Aug2013    Sreyas K             SDOCM00103509    Changes for Production Version Champion
 * 02.21.00       30Sep2014    Vineeth T Alex       SDOCM00113124    Changes for 2.21.00 release; Files restructured
 * 02.21.01       11Mar2016    E Lizarraga          SDOCM00121657    Changes for 2.21.01 version
 * 02.30.00       01Dec2016    Sudhakar Singh       None             Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh       SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/

/**********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/

/**********************************************************************************************************************
 *  PUBLIC PART OF CONFIGURATION
 *********************************************************************************************************************/
 
/**********************************************************************************************************************
 * INCLUDES
 *********************************************************************************************************************/
 
#include "Dem.h"
 
/**********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 *********************************************************************************************************************/
/* SourceId : DIO_SourceId_065 */
/* DesignId : Dio_DesignId_01  */
/* Requirements : AR_DIO_SR107 */
/* Configuration file version information */
#define DIO_CFG_MAJOR_VERSION               (5U)
#define DIO_CFG_MINOR_VERSION               (30U)
#define DIO_CFG_PATCH_VERSION               (0U)

#define DIO_INSTANCE_ID           (0U)
/* SourceId : DIO_SourceId_046 */
/* DesignId : Dio_DesignId_07  */
/* Requirements : AR_DIO_SR44, AR_DIO_SR108, AR_DIO_SR45 */
#define DIO_DEV_ERROR_DETECT      (STD_ON)
#define DIO_DEM_ENABLE		      (STD_ON)
/* SourceId : DIO_SourceId_067 */
/* DesignId : Dio_DesignId_01  */
/* Requirements : AR_DIO_SR110 */
#define DIO_VERSION_INFO_API      (STD_ON)
/* SourceId : DIO_SourceId_066 */
/* DesignId : Dio_DesignId_18  */
/* Requirements : AR_DIO_SR109 */
#define DIO_FLIP_CHANNEL_API      (STD_ON)

/* SourceId : DIO_SourceId_008 */
/* DesignId : Dio_DesignId_09  */
/* Requirements : AR_DIO_SR19, AR_DIO_SR20, AR_DIO_SR56, AR_DIO_SR111, AR_DIO_SR114, AR_DIO_SR113, AR_DIO_SR119 */
/*<DIO_CFG_CHL_LIST>*/

#define ISO_WAKEUP_START_N2HET1_6 ((Dio_ChannelType) 0U)
#define LED1_EN ((Dio_ChannelType) 1U)
#define LED2_EN ((Dio_ChannelType) 2U)
#define ISO_FAULT_IN_GIOA_2 ((Dio_ChannelType) 3U)
#define ISO_WAKEUP_GIOA_3 ((Dio_ChannelType) 4U)
#define CAN_STB ((Dio_ChannelType) 5U)
#define ENDRV ((Dio_ChannelType) 6U)

#define MAX_NO_OF_CHANNELS 7U
/*</DIO_CFG_CHL_LIST>*/

/* SourceId : DIO_SourceId_050 */
/* DesignId : Dio_DesignId_09  */
/* Requirements : AR_DIO_SR58, AR_DIO_SR59, AR_DIO_SR60, AR_DIO_SR111,AR_DIO_SR112 */
/*<DIO_CFG_PORT_LIST>*/

#define N2Het1Port ((Dio_PortType)  0U)
#define GioAPort ((Dio_PortType)  1U)

#define MAX_NO_OF_PORTS 2U
/*</DIO_CFG_PORT_LIST>*/


/* SourceId : DIO_SourceId_070*/
/* DesignId : Dio_DesignId_25 */
/* Requirements : AR_DIO_SR106 */
#define DIO_PBCFG_SOURCE


#define DIO_CFG_SUPPORT_GIO           (STD_ON)
#define DIO_CFG_SUPPORT_CAN           (STD_ON)

/* DEM Error Codes */
#define DIO_DEM_NO_EVENT (0xFFFFFFFFU)

/* DIO IO check Dem IDs */
#ifndef DIO_WRITE_CHANNEL_EVENT_ID
/*SAFETYMCUSW 580 S MR:19.1 <APPROVED> "Reason - Inspected, defined if only not defined" */
	#define DIO_WRITE_CHANNEL_EVENT_ID			DIO_DEM_NO_EVENT
#endif
#ifndef DIO_WRITE_PORT_EVENT_ID
/*SAFETYMCUSW 580 S MR:19.1 <APPROVED> "Reason - Inspected, defined if only not defined" */
	#define DIO_WRITE_PORT_EVENT_ID				DIO_DEM_NO_EVENT
#endif

/**********************************************************************************************************************
 *  STATIC TESTS
 *********************************************************************************************************************/
/* Static tests for configuration integrity can be conducted here */
/* This check throws an error if Dio is configured to support neither Can nor Gio */


#if ((DIO_CFG_SUPPORT_GIO == STD_OFF) && (DIO_CFG_SUPPORT_CAN == STD_OFF))
error("DIO does not support CAN or GIO. This configuration is not valid.");
#endif
  
/********************************************************************************************************************
 *  GLOBAL DATA
 ********************************************************************************************************************/

/* table containing all configured channels for checking */
/*SAFETYMCUSW 127 S MR:8.12 <APPROVED> "Array as extern"*/
extern CONST(Dio_ChannelType, DIO_CONST) Dio_ChannelCheckTable[];


/* table containing all configured ports for checking */
/*SAFETYMCUSW 127 S MR:8.12 <APPROVED> "Array as extern"*/
extern CONST(Dio_PortType, DIO_CONST) Dio_PortCheckTable[];


/* SourceId : DIO_SourceId_052 */
/* DesignId : Dio_DesignId_09  */
/* Requirements : AR_DIO_SR63, AR_DIO_SR111, AR_DIO_SR115 */
/*<DIO_CFG_GROUP_LIST>*/

/*</DIO_CFG_GROUP_LIST>*/


/* Dio_ConfigType for the  Dio_Init()*/
/* SourceId : DIO_SourceId_054 */
/* DesignId : Dio_DesignId_02  */
/* Requirements : AR_DIO_SR68, AR_DIO_SR69 */
typedef struct _Dio_ConfigType
{
   uint8 totalNumPorts;
}Dio_ConfigType;

/* Dummy Configuration variable to be passed to Dio Init API */
extern CONST(Dio_ConfigType, DIO_PBCFG) DioModuleConfiguration_0;

#endif  /* DIO_CFG_H */

/**********************************************************************************************************************
 *  END OF FILE: Dio_Cfg.h
 *********************************************************************************************************************/
