/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2014.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Fee_Cfg.h
 *      Project:  Tms570_TIFEEDriver
 *       Module:  FeeDriver Configuration Header File Fee_Cfg.h
 *    Generator:  EB Tresos
 *
 *  Description:  This file is generated by EB Tresos.Do not modify this file, otherwise the software may 
 *                behave in unexpected way.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Vishwanath Reddy
 *---------------------------------------------------------------------------------------------------------------------
 * Template Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *--------------------------------------------------------------------------------------------------------------------- 
 * 02.21.00       30Sep2014    Vishwanath reddy     SDOCM00113128    Initial Version
 * 02.21.01       30Jun2016    Vishwanath Reddy     SDOCM00122388    Add FEE_TOTAL_BLOCKS_DATASETS.
 *                                                                    Update version history.
 *                                                                    FEE_FLASH_CRC_ENABLE is renamed to 
 *                                                                    FEE_FLASH_CHECKSUM_ENABLE. 
 * 02.21.02       04Aug2016    Vishwanath Reddy     SDOCM00122571    Update patch version FEE_SW_PATCH_VERSION. 
 * 02.21.03       23Aug2016    Vishwanath Reddy     SDOCM00122617    Update patch version FEE_SW_PATCH_VERSION.
 * 02.30.00       01Dec2016    Sudhakar Singh           None         Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh       SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/

 /*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/
 
#ifndef FEE_CFG_H
#define FEE_CFG_H

#include "Device_header.h"
#include "MemIf_Types.h"

/*
 *  Version identification
 */
#define FEE_CFG_MAJOR_VERSION               (5U)
#define FEE_CFG_MINOR_VERSION               (30U)
#define FEE_CFG_PATCH_VERSION               (0U)

#define FEE_AR_RELEASE_MAJOR_VERSION     (4U)
#define FEE_AR_RELEASE_MINOR_VERSION     (0U)
#define FEE_AR_RELEASE_REVISION_VERSION  (3U)


/* Callback functions. Only relevant if Polling mode is OFF */
#define FEE_POLLING_MODE   	   				(STD_ON)
#define FEE_NVM_JOB_END_NOTIFICATION		NvM_JobEndNotification
#define FEE_NVM_JOB_ERROR_NOTIFICATION		NvM_JobErrorNotification

/* Device Operating Frequency */
#define FEE_OPERATING_FREQUENCY				(100)

/* Block Configuration */
#define FEE_NUMBER_OF_BLOCKS      (13U)							 
							 
#define FEE_TOTAL_BLOCKS_DATASETS      (13U)		

#define FEE_NUMBER_OF_UNCONFIGUREDBLOCKSTOCOPY	(0U)
/* SourceId : FEE_SourceId_019 */
/* DesignId : FEE4x_DesignId_005 */
/* Requirements : AR_FEE_SR145 */
#define FEE_BLOCK_OVERHEAD						(24U)

/* Virtual Sector Configuration */
#define FEE_NUMBER_OF_VIRTUAL_SECTORS      (4U)		 
#define FEE_NUMBER_OF_VIRTUAL_SECTORS_EEP1	(0U)
/* SourceId : FEE_SourceId_021 */
/* DesignId : FEE4x_DesignId_007 */
/* Requirements : AR_FEE_SR136 */
#define FEE_VIRTUAL_PAGE_SIZE				(0U)
#define FEE_VIRTUAL_SECTOR_OVERHEAD			(16U)
/* SourceId : FEE_SourceId_020 */
/* DesignId : FEE4x_DesignId_006 */
/* Requirements : AR_FEE_SR147 */
#define FEE_PAGE_OVERHEAD					(0U)

/* Misc Configuration */
#define FEE_MAXIMUM_BLOCKING_TIME			(600.0)
/* SourceId : FEE_SourceId_016 */
/* DesignId : FEE4x_DesignId_001 */
/* Requirements : AR_FEE_SR18 */
#define FEE_DEV_ERROR_DETECT   				(STD_ON)
#define FEE_VERSION_INFO_API   				(STD_ON)
#define FEE_SET_MODE_SUPPORTED 				(STD_ON)
#define FEE_FLASH_ERROR_CORRECTION_ENABLE 	(STD_ON)
#define FEE_FLASH_ERROR_CORRECTION_HANDLING (Fee_None)
#define FEE_FLASH_CHECKSUM_ENABLE 				(STD_OFF)
#define FEE_FLASH_WRITECOUNTER_SAVE 		(STD_ON)
/* SourceId : FEE_SourceId_022 */
/* DesignId : FEE4x_DesignId_008 */
/* Requirements : AR_FEE_SR130 */
#define FEE_INDEX							(0U)
/* SourceId : FEE_SourceId_018 */
/* DesignId : FEE4x_DesignId_002 */
/* Requirements : AR_FEE_SR179 */
#define FEE_NUMBER_OF_EEPS					(1U)
#define FEE_NUMBER_OF_EIGHTBYTEWRITES		(1U)
#define FEE_CHECK_BANK7_ACCESS		        (STD_ON)

#endif /*FEE_CFG_H_*/

/**********************************************************************************************************************
 *  END OF FILE: Fee_Cfg.h
 *********************************************************************************************************************/

