/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Gpt_Cfg.h
 *      Project:  Tms570_AutosarGptDriver
 *       Module:  GptDriver
 *    Generator:  EB Tresos
 *
 *  Description:  This component provides services for initialization and control of the microcontroller internal
 *                GPT unit (General Purpose Timer).
 *  
 ---------------------------------------------------------------------------------------------------------------------
 * Author:  Vishwanath Reddy
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *--------------------------------------------------------------------------------------------------------------------- 
 * 02.21.00       30Sep14      Vishwanath Reddy     SDOCM00113129    Initial Version
 * 02.21.01       11Mar16      Enrique Lizarraga    SDOCM00121245    Update version info
 * 02.30.00       01Dec2016    Sudhakar Singh           None         Update version info 
 * 05.30.00       15Mar2017    Sudhakar Singh       SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/

 /*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/
#ifndef GPT_CFG_H
#define GPT_CFG_H

/**********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 *********************************************************************************************************************/
/*---- Version identification -------------------------------------------------*/
#define GPT_CFG_MAJOR_VERSION               (5U)
#define GPT_CFG_MINOR_VERSION               (30U)
#define GPT_CFG_PATCH_VERSION               (0U)

/* ---- Pre-Compile Switches for API Services ----------------------------------*/
#define GPT_DEINIT_API                 		(STD_ON)
#define GPT_TIME_ELAPSED_API		   		(STD_ON)
#define GPT_TIME_REMAINING_API          	(STD_ON)
#define GPT_ENABLE_DISABLE_NOTIFICATION_API (STD_ON)
#define GPT_WAKEUP_FUNCTIONALITY_API     	(STD_ON)
#define GPT_VERSION_INFO_API            	(STD_ON)
#define GPT_SAFETI_API            			(STD_OFF)

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/


#if (GPT_ENABLE_DISABLE_NOTIFICATION_API == STD_ON)
    /* include user callback definitions for notification  */
#include "gpt_notification.h"
#endif

/*<GPT_CFG_CHANNEL_LIST>*/

#define  GptChannelConfiguration_0       0u 
#define  GptChannelConfiguration_1       1u 
/*<GPT_CFG_CHANNEL_LIST>*/





/*Macros for Interrupt Types*/
#define GPT_ISR_CAT1  0U
#define GPT_ISR_CAT2  1U
#define GPT_ISR_VOID  2U

/*********************************************************************************************************************
 * Exported Type Declarations
 *********************************************************************************************************************/
/* notification callback function pointer */
typedef void (*Gpt_NotifyType)(void);

/*type for specifying source clock selection */
typedef uint32 Gpt_ClockSourceType;

/*type describing the Gpt channel*/
typedef uint32 Gpt_ChannelType;

/* Configuration per channel*/
typedef struct
{
	Gpt_ChannelType   ChannelId;
	uint32            ChannelMode;            /* Channel mode */
	float32           GptChannelTickFrequency;/*Channel Frequency*/
	uint32            GptChannelTickValueMax; /*Channel Tick Max Value*/
	boolean           GptEnableWakeup;
	VAR (Gpt_NotifyType, GPT_APPL_CODE) Notification_pt; /* Pointer to notification function */
	Gpt_ClockSourceType GptChannelClksrcRef;        /* Channel clock source */
	uint8 GptWakeupSourceRef;
}Gpt_ChannelConfigType;

/* global configuration of the driver */
typedef struct
{
    P2CONST(Gpt_ChannelConfigType,
            AUTOMATIC,
            GPT_CONST) ChannelConfig_pt;    /* Pointer to Channel list*/
    uint32             ChannelCount;        /* Number of channels configured */
} Gpt_ConfigType;

/**********************************************************************************************************************
 *  Exported Object Declarations
 **********************************************************************************************************************/
/*Extern declaration of GptChannelConfigSet*/

extern CONST(Gpt_ConfigType, GPT_PBCFG) GptChannelConfigSet_0;

/**********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 *********************************************************************************************************************/
/* ---- Development Error Switch------------ ----------------------------------*/
#define GPT_DEV_ERROR_DETECT              (STD_ON)
#define GPT_REPORT_WAKEUP_SOURCE          (STD_ON)
#define GPT_CFG_ISR_TYPE                  GPT_ISR_CAT1


#if (STD_ON == GPT_DEV_ERROR_DETECT)
    /* Function for errorhook */
    #define Gpt_Errorhook(Gpt_FunctionId, Gpt_ErrorCode) Det_ReportError((GPT_MODULE_ID), (0u), (Gpt_FunctionId), (Gpt_ErrorCode))
#else
    #define Gpt_Errorhook(Gpt_FunctionId, Gpt_ErrorCode)
#endif  /* (STD_ON == GPT_DEV_ERROR_DETECT) */

#if (STD_ON == GPT_DEV_ERROR_DETECT)
    /* Include-File, which contains Errorhook-Function */
    #include "Det.h"
#endif  /* (STD_ON == GPT_DEV_ERROR_DETECT) */

#ifndef GPT_PRIVATE_H
#define GPT_PRIVATE_H

/*<GPT_ISR_INCLUDE_IRQ>*/
#include "SchM_Gpt.h"
#include "Os.h"
/*</GPT_ISR_INCLUDE_IRQ>*/

#endif  /* GPT_PRIVATE_H */

#endif /* #if (!defined GPT_CFG_H) */
/**********************************************************************************************************************
 *  End of File: Gpt_Cfg.h
 *********************************************************************************************************************/
