/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Icu_Cfg.h
 *      Project:  Tms570_AutosarIcuDriver
 *       Module:  ICU
 *    Generator:  EB Tresos
 *
 *  Description:  The ICU driver is a module using the input capture unit (ICU) for demodulation of a PWM signal,
 *                counting pulses, measuring of frequency and duty cycle, generating simple interrupts and wake-up
 *                interrupts.
 *
 *                The ICU driver provides services for
 *                -    Signal edge notification
 *                -    Controlling wake-up interrupts
 *                -    Periodic signal time measurement
 *                -    Edge timestamping, usable for the acquisition of non-periodic signals
 *                -    Edge counting
 *
 *                This module works on pins and ports which are configured by the PORT driver for this purpose. For
 *                this reason there is no configuration and initialization of this port structure in the ICU Driver.
 *********************************************************************************************************************/

/**********************************************************************************************************************
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Vineeth Thomas Alex
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version     Date           Author                   Change ID          Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.21.00    30Sept2014     Vineeth Thomas Alex      SDOCM00113121      Initial version adapted from TMS570LS3137
 * 02.21.01    16Mar2016      Enrique Lizarraga        SDOCM00121723      Update version number
 * 02.30.00    01Dec2016      Sudhakar Singh           None               Update version info
 * 05.30.00    15Mar2017      Sudhakar Singh           SDOCM00122834      Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/
/**********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
	This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.
 *********************************************************************************************************************/
#ifndef ICU_CFG_H
#define ICU_CFG_H

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/

#include "Icu_Het.h"

/**********************************************************************************************************************
 *  PUBLIC PART OF CONFIGURATION
 *********************************************************************************************************************/

/**********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 *********************************************************************************************************************/
/* Configuration file version information */
#define ICU_CFG_MAJOR_VERSION               (5U)
#define ICU_CFG_MINOR_VERSION               (30U)
#define ICU_CFG_PATCH_VERSION               (0U)




/* ---- Pre-Compile Switches for API Services ----------------------------------*/
#define ICU_DE_INIT_API                    (STD_ON)
#define ICU_GET_INPUT_STATE_API            (STD_ON)
#define ICU_TIMESTAMP_API                  (STD_ON)
#define ICU_EDGE_COUNT_API                 (STD_ON)
#define ICU_SIGNAL_MEASUREMENT_API         (STD_ON)
#define ICU_EDGE_DETECTION_API             (STD_ON)
#define ICU_WAKEUP_FUNCTIONALITY_API       (STD_ON)
#define ICU_GET_VERSION_INFO_API           (STD_ON)
#define ICU_SAFETI_API                     (STD_OFF)

#if ( ICU_SIGNAL_MEASUREMENT_API == STD_ON )
#define ICU_GET_TIME_ELAPSED_API        /*<ICU_GET_TIME_ELAPSED_API/>*/ (STD_ON)
#define ICU_GET_DUTY_CYCLE_VALUES_API   /*<ICU_GET_DUTY_CYCLE_VALUES_API/>*/ (STD_ON)
#else
#define ICU_GET_TIME_ELAPSED_API        (STD_OFF)
#define ICU_GET_DUTY_CYCLE_VALUES_API   (STD_OFF)
#endif

#if (ICU_WAKEUP_FUNCTIONALITY_API == STD_ON)
#define ICU_SET_MODE_API                /*<ICU_SET_MODE_API/>*/ (STD_ON)
#define ICU_DISABLE_WAKEUP_API          /*<ICU_DISABLE_WAKEUP_API/>*/ (STD_ON)
#define ICU_ENABLE_WAKEUP_API           /*<ICU_ENABLE_WAKEUP_API/>*/ (STD_ON)
#define ICU_REPORT_WAKEUP_SOURCE   /*<ICU_REPORT_WAKEUP_SOURCE/>*/ (STD_ON)
#define Icu_ReportWakeup(WakeupSource) (/*<ICU_WAKEUP_NOTIFICATION>*/EcuM_SetWakeupEvent(WakeupSource)/*</ICU_WAKEUP_NOTIFICATION>*/)
#else
#define ICU_SET_MODE_API                (STD_OFF)
#define ICU_DISABLE_WAKEUP_API          (STD_OFF)
#define ICU_ENABLE_WAKEUP_API           (STD_OFF)
#define ICU_REPORT_WAKEUP_SOURCE        (STD_OFF)
#define Icu_ReportWakeup(WakeupSource)
#endif

#define Icu_GlobalOvNotification()      (/*<ICU_GLOBAL_OV_NOTIFICATION>*/Icu_DoNothing()/*</ICU_GLOBAL_OV_NOTIFICATION>*/)

/* ====== CONFIGURATION FOR DEVELOPMENT MODE ============================== */

/* Development Mode */
#define ICU_DEV_ERROR_DETECT      (STD_ON)/*<ICU_DEV_ERROR_DETECT/>*/

/* This value is used for undefined values (interrupt sources, wakeup identifiers, empty values) */
#define ICU_UNDEFINED   (255U)

/* ====== CHANNEL NAME DEFINES ============================================ */


/*<ICU_CFG_CHL_LIST>*/

#define I_BMU_ID_PWM_N2HET1_24 ((Icu_ChannelType) 0U)
#define HSD_BMU_ID_PWM_NEXT_N2HET1_22 ((Icu_ChannelType) 1U)
/*</ICU_CFG_CHL_LIST>*/



/**********************************************************************************************************************
 *  STATIC TESTS
 *********************************************************************************************************************/

 /* Static tests for configuration integrity are conducted here */
 
 /*Static configuration checks to see if API for configured channel-type is enabled */
 

/**********************************************************************************************************************
 *  GLOBAL DATA TYPES AND STRUCTURES
 *********************************************************************************************************************/
/* SourceId : ICU_SourceId_006 */
/* DesignId : ICU_DesignId_12  */
/* Requirements : AR_ICU_SR52,AR_ICU_SR53,AR_ICU_SR55,AR_ICU_SR57,AR_ICU_SR58,AR_ICU_SR59 */

/* General type for ICU values */
typedef uint32 Icu_ValueType;
/* Type for the (encoded) Wake-up identifiers */
typedef uint8 Icu_ChlWakeupIDType;



/* ===== NOTIFICATION TYPES =============================================== */
/*SAFETYMCUSW 37 S MR:16.3 <APPROVED> "Notification function pointer" */
typedef P2FUNC(void, ICU_APPL_CODE, Icu_NotifyType) (void);


#if(STD_ON == ICU_TIMESTAMP_API)
    /* Type to abstract the return value of the service Icu_GetTimestampIndex() */
    typedef uint8 Icu_IndexType;

    /* Timestamp measurement property type */
    typedef uint8 Icu_TimestampBufferType;

    #define ICU_LINEAR_BUFFER           (0U)
    #define ICU_CIRCULAR_BUFFER         (1U)

#endif



#if(STD_ON == ICU_SIGNAL_MEASUREMENT_API)
    /* Signal measurement property type */
    typedef uint8 Icu_SignalMeasurementPropertyType;

    #define ICU_LOW_TIME                (0U)
    #define ICU_HIGH_TIME               (1U)
    #define ICU_PERIOD_TIME             (2U)
    #define ICU_DUTY_CYCLE              (3U)

#endif

/* Definition of the measurement mode type */
typedef enum
{
    ICU_MODE_SIGNAL_EDGE_DETECT = 0U,
    ICU_MODE_SIGNAL_MEASUREMENT,
    ICU_MODE_TIMESTAMP,
    ICU_MODE_EDGE_COUNTER
} Icu_MeasurementModeType;

/* Definition of the type of activation of an ICU channel */
typedef enum
{
    ICU_RISING_EDGE = 0U,
    ICU_FALLING_EDGE,
    ICU_BOTH_EDGES
} Icu_ActivationType;

/* ===== CONFIGURATION TYPES ============================================== */
/* SourceId : ICU_SourceId_005 */
/* DesignId : ICU_DesignId_12  */
/* Requirements : AR_ICU_SR42,AR_ICU_SR43,AR_ICU_SR44,AR_ICU_SR45,AR_ICU_SR46,
                  AR_ICU_SR47,AR_ICU_SR48,AR_ICU_SR49 */

/* Channel configuration structure */
typedef struct
{
    /* Pointer to the channels notification function */
    Icu_NotifyType  Icu_Notify_pt;
    /* Channel's measurement mode */
    Icu_MeasurementModeType Icu_ChlMeasMode_t;
    /* Channel's activation edge */
    Icu_ActivationType Icu_DefaultStartEdge_t;
    /* Hardware identifier value to store the hardware identifier */
    uint8 Icu_HwIdentifier_u8;
    /* Common variable to store measurement property information. To improve memory usage, this variable contains
     * different information for each measurment mode:
     *
     *                          - Edge counting: None (set to default 255)
     *                          - Timestamping: Buffer type (circular/linear)
     *                          - Signal edge detection: None (set to default 255)
     *                          - Signal measurement: Measurement property (low time/high time/period/duty cycle) */
    uint8 Icu_CommonPropertyStore_u8;
    /* Variable to store the wakeup identifier of a signal edge detection channel. As wakeup identifiers are a 32 bit
     * value with only one bit set, only the 'shift' value is stored to improve memory usage. */
    uint8 Icu_EcuMWakeupIdent;
}Icu_ChannelConfigType;

/* Main configuration structure */
typedef struct
{
    /* Pointer to the channel configuration array */
    const Icu_ChannelConfigType* Icu_ChannelConfig_at;
    /* Pointer to the interrupt cross-table */
    const Het_Icu_BlockType* Icu_HetRamBlocks_at;
    /* Number of edge counting channels */
    uint8   Icu_EcChannelCount_u8;
    /* Number of timestamping channels */
    uint8   Icu_TsChannelCount_u8;
    /* Number of signal edge detection channels */
    uint8   Icu_EdChannelCount_u8;
    /* Number of signal measurement channels */
    uint8   Icu_SmChannelCount_u8;
    /* NHET Register base address */
    uint32 Icu_NhetRegBaseAddress_u32;
    /* NHET RAM base address */
    uint32 Icu_NhetRamBaseAddress_u32;
}Icu_ConfigType;
/**********************************************************************************************************************
 *  GLOBAL DATA PROTOTYPES
 *********************************************************************************************************************/

/* extern declaration of the runtime configuration structure */
/*<ICU_CFG_EXTERN>*/

extern CONST(Icu_ConfigType, ICU_PBCFG) IcuConfigSet_0;

/*</ICU_CFG_EXTERN>*/

#endif /* ICU_CFG_H, public part of configuration */


#ifndef ICU_PRIVATE_H
#define ICU_PRIVATE_H

	#define ICU_ISR_CAT1 (1U)
	#define ICU_ISR_CAT2 (2U)
	#define ICU_ISR_VOID (3U)

	#define ICU_CFG_ISR_TYPE ICU_ISR_VOID/*<ICU_ISR_TYPE/>*/ 

#endif/*ICU_PRIVATE_H*/
/**********************************************************************************************************************
 *  END OF FILE: ICU_Cfg.h
 *********************************************************************************************************************/

