/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2014.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Lin_Cfg.h
 *      Project:  Tms570_AutosarLinDriver
 *       Module:  LinDriver Configuration Header File Lin_Cfg.h
 *    Generator:  EB Tresos
 *
 *  Description:  This file is generated by EB Tresos.Do not modify this file, otherwise the software may 
 *                behave in unexpected way.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Prathap Srinivasan
 *---------------------------------------------------------------------------------------------------------------------
 * Template Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.10.00       24Jan2013   Prathap Srinivasan  0000000000000   - Initial Version adapted from TMS570LS1227
 * 02.10.01		  14Mar2013   Vishwanath Reddy	  SDOCM00099800   - Moved structure Lin_ChannelData to Lin.c
 * 02.20.00		  23Aug2013   Vishwanath Reddy	  SDOCM00103357   - Version info updated.
 *                                                                  Added requirement tags for traceability.
 *                                                                  Safety requirements implementation. 
 * 02.20.02		  14Jul2014   Vishwanath Reddy	  SDOCM00112032   - Version info updated.
 * 02.20.03		  08Aug2014   Vishwanath Reddy	  SDOCM00112419   - Enum added for LIN Errors.
 *                                                                  LIN_CALL_USERCALLOUT macro added.
 *                                                                  Extern declaration for user callout API added. 
 * 02.21.00		  30Sep2014   Vishwanath Reddy	  SDOCM00113130   - Version info updated. Additional DEM Errors are now
 *                                                                  referenced from Tresos.
 * 02.21.01		  05Nov2014   Vishwanath Reddy	  SDOCM00113739   - Version info updated.
 * 02.21.02		  29Apr2016   Vishwanath Reddy	  SDOCM00122618   - Version info updated.
 * 02.30.00       01Dec2016   Sudhakar Singh         None         - Update version info
 * 05.30.00       15Mar2017   Sudhakar Singh      SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/

 /*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/
  
#ifndef LIN_CFG_H
#define LIN_CFG_H

/**********************************************************************************************************************
 *  INCLUDES 
 *********************************************************************************************************************/

/**********************************************************************************************************************
 *  VERSION DEFINES 
 *********************************************************************************************************************/

#define LIN_CFG_MAJOR_VERSION               (5U)
#define LIN_CFG_MINOR_VERSION               (30U)
#define LIN_CFG_PATCH_VERSION               (0U)

/**********************************************************************************************************************
 *  DEFINES 
 *********************************************************************************************************************/

/* SourceId : LIN_SourceId_018 */
/* DesignId : LIN_DesignId_005 */
/* Requirements : AR_LIN_SR58, AR_LIN_SR151 */
#define LIN_DEV_ERROR_DETECT                 (STD_ON)
/* SourceId : LIN_SourceId_019 */
/* DesignId : LIN_DesignId_001 */
/* Requirements : AR_LIN_SR60 */
#define LIN_PROD_ERROR_DETECT                (STD_ON)
/* SourceId : LIN_SourceId_020 */
/* DesignId : LIN_DesignId_001 */
/* Requirements : AR_LIN_SR152 */
#define LIN_INDEX                            (0U)
/* SourceId : LIN_SourceId_021 */
/* DesignId : LIN_DesignId_001 */
/* Requirements : AR_LIN_SR153 */
#define LIN_TIMEOUT_DURATION                 (65535U)
/* SourceId : LIN_SourceId_022 */
/* DesignId : LIN_DesignId_001 */
/* Requirements : AR_LIN_SR154 */
#define LIN_VERSION_INFO_API                 (STD_ON)
#define LIN_SAFETI_API                 		 (STD_OFF)
#define LIN_LOOPBACKTEST_ENABLE              (STD_OFF)
/*SAFETYMCUSW 79 S MR:19.4 <REVIEWED> "Reason - ISR categories will be defined in other layer and needs to be referred
                                               here."*/
#define LIN_CFG_ISR_TYPE                     LIN_ISR_VOID
/* Macro to select between DEM reporting or user callout API. */
#define LIN_CALL_USERCALLOUT                 (STD_ON)


/* Production error codes from AUTOSAR specification extensions */
#define LIN_DEM_NO_EVENT (0xFFFFFFFFU) 


#ifndef LIN_E_NORESPONSE
#define LIN_E_NORESPONSE     LIN_DEM_NO_EVENT
#endif


#ifndef LIN_E_CHKSUM
#define LIN_E_CHKSUM     LIN_DEM_NO_EVENT
#endif

#ifndef LIN_E_OVRRUN
#define LIN_E_OVRRUN     LIN_DEM_NO_EVENT
#endif

#ifndef LIN_E_PHYBUS
#define LIN_E_PHYBUS     LIN_DEM_NO_EVENT
#endif

#ifndef LIN_E_BIT
#define LIN_E_BIT     LIN_DEM_NO_EVENT
#endif

#ifndef LIN_E_FRM
#define LIN_E_FRM     LIN_DEM_NO_EVENT
#endif

#ifndef LIN_E_SYNCFIELD
#define LIN_E_SYNCFIELD     LIN_DEM_NO_EVENT
#endif

#ifndef LIN_E_PARITY
#define LIN_E_PARITY     LIN_DEM_NO_EVENT
#endif

/* Enum containing LIN error's */
typedef enum
{
  LIN_ERROR_PARITY = 0U,
  LIN_ERROR_SYNCFIELD,
  LIN_ERROR_FRM,
  LIN_ERROR_BIT,
  LIN_ERROR_PHYBUS,
  LIN_ERROR_OVRRUN,
  LIN_ERROR_CHKSUM,
  LIN_ERROR_NORESPONSE
}Lin_ErrorType;

/* Extern declaration for user callout API */
extern FUNC(void, LIN_CODE)Lin_AvoidCallOut(Lin_ErrorType Error);
/* Macro used in Lin_Interrupt */
#define USERCALLOUT Lin_AvoidCallOut

#define LIN_START_SEC_CONST_UNSPECIFIED
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"

#define  LinGlobalConfig_0_LinChannel_0       (0U)

#define Lin_NumberOfModules                  (1U)
#define Lin_NumberOfChannelsPerModule        (1U)
#define Lin_TotalNumberOfChannels            (1U)

#define LIN_STOP_SEC_CONST_UNSPECIFIED
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"

#endif /* LIN_CFG_H */

/**********************************************************************************************************************
 *  END OF FILE : Lin_Cfg.h 
 *********************************************************************************************************************/

