/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2016.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Mcu_Cfg.h
 *      Project:  Tms570_AutosarMcuDriver
 *       Module:  McuDriver Configuration Header File Mcu_Cfg.h
 *    Generator:  Elektrobit Tresos
 *
 *  Description:  This file is generated by EB Tresos.Do not modify this file, otherwise the software may 
 *                behave in unexpected way.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Enrique Lizarraga
 *---------------------------------------------------------------------------------------------------------------------
 * Template Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID          Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.10.00       05Feb2013    Enrique Lizarraga    0000000000000      -Based on TMS570LS3 (01.10.00)
 * 02.20.00       08Aug2013    Enrique Lizarraga    SDOCM00103171      -Updated version info
 *                                                                     -Traceability comments
 *                                                                     -Mcu_RegisterReadback API added
 *                                                                     -Updated Entering Exclusive area macros
 * 02.21.00       30Sep2014    Enrique Lizarraga    SDOCM00112263      -Updated version info
 *                                                                     -Added traceability info
 *                                                                     -Relocated Enter/Exit critical section macros
 *                                                                     -Removed unused code
 * 02.21.01       26Feb2016    Enrique Lizarraga    SDOCM00115297      -Updated version info
 * 02.30.00       01Dec2016    Sudhakar Singh         None             -Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh       SDOCM00122834       Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/

 /*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/
 /* Protection against multiple inclusion */
#ifndef MCU_CFG_H
#define MCU_CFG_H

/*********************************************************************************************************************
 * Standard Header Files
 *********************************************************************************************************************/

/*********************************************************************************************************************
 * Other Header Files
 *********************************************************************************************************************/

/**********************************************************************************************************************
 * Version Check
 *********************************************************************************************************************/
#define MCU_CFG_MAJOR_VERSION               (5U)
#define MCU_CFG_MINOR_VERSION               (30U)
#define MCU_CFG_PATCH_VERSION               (0U)

/*********************************************************************************************************************
 * Exported Preprocessor #define Constants
 *********************************************************************************************************************/
/* SourceId : MCU_SourceId_032 */
/* DesignId : MCU_DesignId_007 */
/* Requirements : AR_MCU_SR20, AR_MCU_SR21, AR_MCU_SR24, AR_MCU_SR113 */
/* Enable/Disable Development Error Detection */
#define MCU_DEV_ERROR_DETECT       (STD_ON)
 
/* Enable/Disable API's */
/* SourceId : MCU_SourceId_033 */
/* DesignId : MCU_DesignId_017 */
/* Requirements : AR_MCU_SR99, AR_MCU_SR114 */
#define MCU_GET_RAM_STATE_API      (STD_OFF)
/* SourceId : MCU_SourceId_034 */
/* DesignId : MCU_DesignId_017 */
/* Requirements : AR_MCU_SR67, AR_MCU_SR115 */
#define MCU_INIT_CLOCK_API         (STD_ON)
/* SourceId : MCU_SourceId_035 */
/* DesignId : MCU_DesignId_017 */
/* Requirements : AR_MCU_SR88, AR_MCU_SR117 */
#define MCU_PERFORM_RESET_API      (STD_ON)
/* SourceId : MCU_SourceId_036 */
/* DesignId : MCU_DesignId_017 */
/* Requirements : AR_MCU_SR94, AR_MCU_SR118 */
#define MCU_GET_VERSION_INFO_API   (STD_ON)
#define MCU_INIT_RAM_API           (STD_ON)
/* SourceId : MCU_SourceId_037 */
/* DesignId : MCU_DesignId_017 */
/* Requirements : AR_MCU_SR116 */
#define MCU_NO_PLL                 (STD_OFF)
#define MCU_CLEAR_RESET_REASON_API (STD_ON)

/* Configuration registers readback */
#define MCU_REGISTER_READBACK_API  (STD_OFF)
/* Lock/ unlock the trim settings */
#define MCU_COPY_TRIM_FROM_OTP     (STD_ON)

/* Enable/Disable Safety Initialization Features*/
#define MCU_CPU_SELFTEST           (STD_OFF)
#define MCU_EFUSE_SELF_TEST        (STD_OFF)
#define MCU_PBIST_SELFTEST         (STD_OFF)
#define MCU_ESM_GROUP3_CHECK       (STD_OFF)

/* PBIST */
#define PBIST_ROM_PBIST            (0x00000001U) /* ROM */
#define STC_ROM_PBIST              (0x00000002U) /* ROM */
#define DCAN1_RAM_PBIST            (0x00000004U) /* Dual Port */
#define DCAN2_RAM_PBIST            (0x00000008U) /* Dual Port */
#define DCAN3_RAM_PBIST            (0x00000010U) /* Dual Port */
#define ESRAM1_RAM_PBIST           (0x00000020U) /* Single Port */
#define MIBSPI1_RAM_PBIST          (0x00000040U) /* Dual Port */
#define MIBSPI3_RAM_PBIST          (0x00000080U) /* Dual Port */
#define MIBSPI5_RAM_PBIST          (0x00000100U) /* Dual Port */
#define VIM_RAM_PBIST              (0x00000200U) /* Dual Port */
#define MIBADC1_RAM_PBIST          (0x00000400U) /* Dual Port */
#define DMA_RAM_PBIST              (0x00000800U) /* Dual Port */
#define N2HET1_RAM_PBIST           (0x00001000U) /* Dual Port */
#define HET_TU1_RAM_PBIST          (0x00002000U) /* Dual Port */
#define RTP_RAM_PBIST              (0x00004000U) /* Dual Port */
#define FLEXRAY1_RAM_PBIST         (0x00008000U) /* Dual Port */
#define FLEXRAY2_RAM_PBIST         (0x00010000U) /* Single Port */
#define MIBADC2_RAM_PBIST          (0x00020000U) /* Dual Port */
#define N2HET2_RAM_PBIST           (0x00040000U) /* Dual Port */
#define HET_TU2_RAM_PBIST          (0x00080000U) /* Dual Port */
#define ESRAM5_RAM_PBIST           (0x00100000U) /* Single Port */
#define ESRAM6_RAM_PBIST           (0x00200000U) /* Single Port */
#define ETHERNET1_RAM_PBIST        (0x00400000U) /* Dual Port */
#define ETHERNET2_RAM_PBIST        (0x00800000U) /* Dual Port */
#define ETHERNET3_RAM_PBIST        (0x01000000U) /* Single Port */
#define ESRAM8_RAM_PBIST           (0x08000000U) /* Single Port */

/* PBIST Groups */
#define CPU_RAM_GROUP_PBIST          (ESRAM1_RAM_PBIST | ESRAM5_RAM_PBIST | ESRAM6_RAM_PBIST | ESRAM8_RAM_PBIST)
#define DUAL_PORT_RAM_GROUP_PBIST    (0x00000000U)
#define SINGLE_PORT_RAM_GROUP_PBIST  (0x00000000U)

/* Memory Init */
#define CPU_RAM_INIT               (0x00000001U)
#define DMA_RAM_INIT               (0x00000002U)
#define VIM_RAM_INIT               (0x00000004U)
#define N2HET1_RAM_INIT            (0x00000008U)
#define HET_TU1_RAM_INIT           (0x00000010U)
#define DCAN1_RAM_INIT             (0x00000020U)
#define DCAN2_RAM_INIT             (0x00000040U)
#define MIBSPI1_RAM_INIT           (0x00000080U)
#define MIBADC1_RAM_INIT           (0x00000100U)
#define DCAN3_RAM_INIT             (0x00000400U)
#define MIBSPI3_RAM_INIT           (0x00000800U)
#define MIBSPI5_RAM_INIT           (0x00001000U)
#define FLEXRAY_TU_INIT            (0x00002000U)
#define MIBADC2_RAM_INIT           (0x00004000U)
#define N2HET2_RAM_INIT            (0x00008000U)
#define HET_TU2_RAM_INIT           (0x00010000U)

#define PERIPHERAL_RAM_INIT        (0x00000000U)

/*
 * The following defines shall be used as input
 * parameter for: Mcu_SetMode(),
 *                Mcu_InitClock()
 *                Mcu_InitRamSection()
 */

/*<MCU_CFG_MODEUSERCONFIG_LIST>*/
#define McuModeSettingConf_0 (0U)
#define McuModeSettingConf_1 (1U)
#define McuModeSettingConf_2 (2U)

/*</MCU_CFG_MODEUSERCONFIG_LIST>*/


/*
* Clock configuration
*/
/* SourceId : MCU_SourceId_040 */
/* Requirements : AR_MCU_SR125, AR_MCU_SR126 */
/*<MCU_CFG_CLOCKUSERCONFIG_LIST>*/
#define McuClockSettingConfig (0U)

/*</MCU_CFG_CLOCKUSERCONFIG_LIST>*/


/*
* RAM Section configuration
*/
/*<MCU_CFG_RAMSECTIONUSERCONFIG_LIST>*/
#define McuRamSectorSettingConf_0 (0U)

/*</MCU_CFG_RAMSECTIONUSERCONFIG_LIST>*/

/*********************************************************************************************************************
 * Exported Preprocessor #define Macros
 *********************************************************************************************************************/

/*********************************************************************************************************************
 * Exported Type Declarations
 *********************************************************************************************************************/
typedef struct
{
   uint32 Mcu_PllCtl1Reg;
   uint32 Mcu_PllCtl2Reg;
   uint32 Mcu_CSDisClrReg;
   uint32 Mcu_LpoMonCtlReg;
   uint32 Mcu_CDDisClrReg;
   uint32 Mcu_GHVSrcReg;
   uint32 Mcu_ClkCntlReg;
   uint32 Mcu_RClkSrcReg;
   uint32 Mcu_VClkASrcReg;
}Mcu_Sys1RegConfigType;

typedef struct
{
   uint32 Mcu_PllCtl3Reg;
   uint32 Mcu_Clk2CntlReg;
   uint32 Mcu_VClkACon1Reg;
}Mcu_Sys2RegConfigType;

typedef struct
{
   uint32 Mcu_PsPwrDwnClr0Reg;
   uint32 Mcu_PsPwrDwnClr1Reg;
   uint32 Mcu_PsPwrDwnClr2Reg;
   uint32 Mcu_PsPwrDwnClr3Reg;
}Mcu_PcrRegConfigType;

typedef struct
{
   uint32 Mcu_FrdCntlReg;
   uint32 Mcu_EepConfig;
   uint32 Mcu_FbFallback;
}Mcu_FlsRegConfigType;

typedef struct
{
   uint8 Mcu_PowerMode_u8;
}Mcu_ModeConfigType;

/* SourceId : MCU_SourceId_038 */
/* DesignId : MCU_DesignId_019 */
/* Requirements : AR_MCU_SR38 */
typedef struct
{
   /* RAM section base address, Destination */
   P2VAR(uint8, AUTOMATIC, MCU_RAM_COPY)   Mcu_RamSectionBaseAddress;
   /* RAM Default Value */
   uint8    Mcu_RamDefaultValue;
   /* Section Size */
   uint32    Mcu_RamSectionBytes;
   /* Data pre-setting to be initialized */
}Mcu_RamSectionConfigType;

typedef P2CONST(Mcu_Sys1RegConfigType, AUTOMATIC, MCU_PBCFG)    Mcu_Sys1RegConfigPtrType;
typedef P2CONST(Mcu_Sys2RegConfigType, AUTOMATIC, MCU_PBCFG)    Mcu_Sys2RegConfigPtrType;
typedef P2CONST(Mcu_PcrRegConfigType, AUTOMATIC, MCU_PBCFG)     Mcu_PcrRegConfigPtrType;
typedef P2CONST(Mcu_FlsRegConfigType, AUTOMATIC, MCU_PBCFG)     Mcu_FlsRegConfigPtrType;
typedef P2CONST(Mcu_ModeConfigType, AUTOMATIC, MCU_PBCFG)       Mcu_ModeConfigPtrType;
typedef P2CONST(Mcu_RamSectionConfigType, AUTOMATIC, MCU_PBCFG) Mcu_RamConfigPtrType;

/* SourceId : MCU_SourceId_039 */
/* DesignId : MCU_DesignId_016 */
/* Requirements : AR_MCU_SR34 */
typedef struct
{
   Mcu_Sys1RegConfigPtrType Mcu_Sys1RegConfig;
   Mcu_Sys2RegConfigPtrType Mcu_Sys2RegConfig;
   Mcu_PcrRegConfigPtrType  Mcu_PcrRegConfig;
   Mcu_FlsRegConfigPtrType  Mcu_FlsRegConfig;
   Mcu_ModeConfigPtrType    Mcu_ModeConfig;
   uint8                    Mcu_ModesNumber;
   uint8                    Mcu_ClockSetting;
   Mcu_RamConfigPtrType     Mcu_ConfigRamSection;
   uint8                    Mcu_NumberOfRamSectors;
}Mcu_ConfigType;

/*********************************************************************************************************************
 *  Exported Object Declarations
 *********************************************************************************************************************/

extern CONST(Mcu_ConfigType, MCU_PBCFG) McuModuleConfiguration_0;


#endif /* #ifndef MCU_CFG_H */
/**********************************************************************************************************************
 *  End of File: Mcu_Cfg.h
 *********************************************************************************************************************/
