
/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Port_Cfg.h
 *      Project:  Tms570_AutosarPortDriver
 *       Module:  PortDriver
 *    Generator:  EB Tresos
 *
 *  Description:  This module implements a driver in ANSI C programming language to centralize the
 *                configuration of ports and pins which are used by more than one driver module.
 *                With this driver you can:
 *                - Configure all port pins
 *                - Initialize the configuration
 *                - Refresh the configuration (EMC purposes)
 *                - Switch the port pin configuration during runtime[Not supported at this time]
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Sunil Kumar T V
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author         Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.10.00       11Feb2013   Sapthagiri G    0000000000000    Initial version(adapted from TMS570LS31xx v01.10.00). 
 * 02.20.00       29Aug2013   Sreyas K        SDOCM00103509    Changes for Production Version Champion
 * 02.21.00       30Sep2014   Vineeth T Alex  SDOCM00113123    Changes for 2.21.00 release; Files restructured
 * 02.21.01       23Aug2016   VishwanathReddy SDOCM00122619    Update version info.
 * 02.30.00       01Dec2016   Sudhakar Singh  None             Update version info
 * 05.30.00       15Mar2017   Sudhakar Singh  SDOCM00122834    Version supports TMS570LSxx Family of Devices.
  *********************************************************************************************************************/

/**********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01

    This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.

 *********************************************************************************************************************/
#ifndef PORT_CFG_H
#define PORT_CFG_H

/**********************************************************************************************************************
 * INCLUDES
 *********************************************************************************************************************/
#include "Std_Types.h"
/**********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 *********************************************************************************************************************/

/*  Cfg Version identification  */
#define PORT_CFG_MAJOR_VERSION               (5U) 
#define PORT_CFG_MINOR_VERSION               (30U)
#define PORT_CFG_PATCH_VERSION               (0U)

/* List of symbolic names for Dio pin channels */
/*<PORT_PIN_CHANNEL_LIST>*/

#define PORT_TEST0 (0U) 
#define PORT_TEST1 (1U) 
#define PORT_TEST2 (2U) 
#define PORT_TEST3 (3U) 
#define PORT_TEST4 (4U) 
#define PORT_TEST5 (5U) 
#define PORT_TEST6 (6U) 
#define PORT_TEST7 (7U) 


/*</PORT_PIN_CHANNEL_LIST>*/

/* Pre-compile switches for services */
#define PORT_SET_PIN_DIRECTION_API       (STD_ON) 
#define PORT_REFRESH_PORT_DIRECTION_API  (STD_ON) 
#define PORT_VERSION_INFO_API            (STD_ON) 
#define PORT_SET_PIN_MODE_API            (STD_OFF) 
#define PORT_SAFETI_API					 (STD_OFF) 

/* Requirement from safety manual */
#if (STD_ON == PORT_SAFETI_API)
#define PORT_CONFIG_REG_SIZE            (256U)
#endif


/* Pre-compile switches for Development Error Detection */
/* SourceId : Port_SourceId_006 */
/* DesignId : Port_DesignId_06  */
/* Requirements : AR_PORT_SR26 */
#define PORT_DEV_ERROR_DETECT		 (STD_ON) 

#if (STD_ON == PORT_DEV_ERROR_DETECT)
	/* SourceId : Port_SourceId_017 */
	/* DesignId : Port_DesignId_01  */
	/* Requirements : AR_PORT_SR75, AR_PORT_SR76 */
    /*SAFETYMCUSW 340 S MR:19.7 <APPROVED> "Reason - To report the development error to Det"*/
    #define Port_Errorhook(Port_FunctionId, Port_ErrorCode) (Det_ReportError\
	                          ((uint16)(PORT_MODULE_ID), (uint8)0U, (uint8)(Port_FunctionId), (uint8)(Port_ErrorCode)))
#else
      #define Port_Errorhook(Port_FunctionId, Port_ErrorCode)

#endif   /*(STD_ON == PORT_DEV_ERROR_DETECT)*/

/**********************************************************************************************************************
 *  STATIC TESTS
 *********************************************************************************************************************/






/**********************************************************************************************************************
 *  GLOBAL DATA TYPES AND STRUCTURES
 *********************************************************************************************************************/

 
/* Requirement from safety manual */
#if (STD_ON == PORT_SAFETI_API)
typedef struct{
	uint32 configRegs[PORT_CONFIG_REG_SIZE];
} _PortConfigRegsType;
#endif
 
/*  Mapping of port registers as data struct  */
/*SAFETYMCUSW 74 S MR:18.4 <APPROVED> "Reason - To access the Port registers and their bit fields "*/
typedef union{
    /* Regular Port register structure */
    struct
    {
        uint32 Function_u32;
        uint32 Direction_u32;
        uint32 DataIn_u32;
        uint32 DataOut_u32;
        uint32 DataSet_u32;
        uint32 DataClr_u32;
        uint32 OpenDrain_u32;
        uint32 PullDisable_u32;
        uint32 PullSelect_u32;
        uint32 Dummy1[15U];	
        uint32 SlewRate1_u32;
        uint32 Dummy2[3U];
        uint32 SlewRate2_u32;
    }Reg;
    /*Alternative Port register structure for ADC*/
    struct
    {
        uint32 Direction_u32;
        uint32 DataOut_u32;
        uint32 DataIn_u32;
        uint32 DataSet_u32;
        uint32 DataClr_u32;
        uint32 OpenDrain_u32;
        uint32 PullDisable_u32;
        uint32 PullSelect_u32;
    }AltReg;

    /* Special structure for Can pheripheral*/
    struct
    {
        uint32 IoCtrl_0_u32;
        uint32 IoCtrl_1_u32;
    }Can;

    /* Struct for Mux register */
    struct
    {
        uint32 GnrlRg_u32;
    }Mux;
} Port_RegisterType;

typedef volatile P2VAR(Port_RegisterType, AUTOMATIC, MSR_REGSPACE) Port_RegisterPtrType;


/* Pointer to a function */
typedef void (* const Port_InternFcnType) (void);

#if (PORT_SET_PIN_MODE_API == STD_ON)
    /*Pseudo struct, necessary for the unsupported API */
    /*function Port_SetPinMode()                       */
    /* SourceId : Port_SourceId_021 */
	/* DesignId : Port_DesignId_09  */
 	/* Requirements : AR_PORT_SR85, AR_PORT_SR86, AR_PORT_SR87 */
    typedef struct
    {
        uint8 PinMode;
    }Port_PinModeType;
#endif /*(PORT_SET_PIN_MODE_API == STD_ON)*/


#if (STD_ON == PORT_REFRESH_PORT_DIRECTION_API)
    /* Type to configure all the direction register with the configured content */
    typedef struct
    {
        /* Address of register (see list of #defines)                           */
        Port_RegisterPtrType RegisterBaseAddr_pt;

        /* Value which shall be written to the register                         */
        uint32 InitialDirection_u32;

        /* Information which pins are refreshable
         * ("1" = refreshable, "0" non refreshable)                            */
        uint32 RefreshMask_u32;
    }Port_RefreshConfigType;
#endif


#if ( STD_ON == PORT_SET_PIN_DIRECTION_API )
    /* Configuration type for pin channels                                      */
    typedef P2CONST(uint32, AUTOMATIC, PORT_PBCFG) Port_PinChlConfigType;
#endif


/* Here is the resulting, whole configuration type. It includes all types
 * of configuration which can be made by the customer.                      */
/* SourceId : Port_SourceId_001 */
/* DesignId : Port_DesignId_09  */
/* Requirements : AR_PORT_SR78, AR_PORT_SR79, AR_PORT_SR80 */
typedef struct
{
   Port_InternFcnType Port_InitPortPins_t;
    #if ( STD_ON == PORT_REFRESH_PORT_DIRECTION_API )
        P2CONST( Port_RefreshConfigType, AUTOMATIC, PORT_PBCFG) RefreshConfig_pt;
    #endif

    #if ( STD_ON == PORT_SET_PIN_DIRECTION_API )
        Port_PinChlConfigType PinChlConfig_pt;
    #endif

    #if ( STD_ON == PORT_REFRESH_PORT_DIRECTION_API )
        uint8 NumberOfRefreshPorts_u8;
    #endif

    #if ( STD_ON == PORT_SET_PIN_DIRECTION_API )
        uint8 NumberOfPinChannels_u8;
    #endif


}Port_ConfigType;

/**********************************************************************************************************************
 *  GLOBAL DATA PROTOTYPES
 *********************************************************************************************************************/

/*<PORT_CFG_EXTERN>*/
/* SourceId : Port_SourceId_022 */
/* DesignId : Port_DesignId_20  */
/* Requirements : AR_PORT_SR88, AR_PORT_SR89, AR_PORT_SR94 */
extern CONST( Port_ConfigType, PORT_PORT_PBCFG) Port_Runtime;
/*</PORT_CFG_EXTERN>*/


/**********************************************************************************************************************
 *  GLOBAL FUNCTION PROTOTYPES
 *********************************************************************************************************************/
/* Requirement from safety manual */
#if (STD_ON == PORT_SAFETI_API)
FUNC(void, PORT_PBCODE) Port_GetConfigRegValues_Config( uint8 initial, P2VAR(_PortConfigRegsType, AUTOMATIC, PORT_PBCFG) ConfigRegPtr );
#endif 
 
#endif  /* PORT_CFG_H */


/**********************************************************************************************************************
 *  END OF FILE: Port_Cfg.h
 *********************************************************************************************************************/
