/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Pwm_Cfg.h
 *      Project:  Tms570_AutosarPwmDriver
 *       Module:  DriverPwm
 *    Generator:  EB Tresos
 *
 *  Description:  This component provides services for initialization and control of the microcontroller internal
 *                PWM unit (pulse width modulation). The PWM module generates pulses with variable pulse width. 
 *                It allows the selection of the duty cycle and the signal period time.
 *  
 ---------------------------------------------------------------------------------------------------------------------
 * Author:  Vineeth Thomas Alex
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version     Date           Author                   Change ID          Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.21.00    30Sep2014     Vineeth Thomas Alex      SDOCM00113122      Initial version adapted from TMS570LS3137
 * 02.21.01    23Aug2016     Vishwanath Reddy         SDOCM00122620      Vresion info updated.
 * 02.30.00    01Dec2016     Sudhakar Singh           None               Update version info
 * 05.30.00    15Mar2017     Sudhakar Singh           SDOCM00122834      Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/

/**********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/
#ifndef PWM_CFG_H
#define PWM_CFG_H


/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/

#include "Pwm_Het.h"


/**********************************************************************************************************************
 *  PUBLIC PART OF CONFIGURATION
 *********************************************************************************************************************/

/**********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 *********************************************************************************************************************/
/* Configuration file version information */
#define PWM_CFG_MAJOR_VERSION               (5U)
#define PWM_CFG_MINOR_VERSION               (30U)
#define PWM_CFG_PATCH_VERSION               (0U)





/* ---- Pre-Compile Switches for API Services ----------------------------------*/
/* SourceId : PWM_SourceId_016 */
/* DesignId : PWM_DesignId_25  */
/* Requirements : AR_PWM_SR48, AR_PWM_SR55, AR_PWM_SR60, AR_PWM_SR64, AR_PWM_SR65, AR_PWM_SR70, AR_PWM_SR73,
 * AR_PWM_SR74, AR_PWM_SR78, AR_PWM_SR79, AR_PWM_SR82, AR_PWM_SR83, AR_PWM_SR116, AR_PWM_SR117, AR_PWM_SR118,
 * AR_PWM_SR119, AR_PWM_SR120, AR_PWM_SR121, AR_PWM_SR122, AR_PWM_SR123 */
#define PWM_DE_INIT_API                 (STD_ON)
#define PWM_GET_OUTPUT_STATE_API		(STD_ON)
#define PWM_SET_DUTY_CYCLE_API          (STD_ON)
#define PWM_SET_OUTPUT_TO_IDLE_API      (STD_ON)
#define PWM_SET_PERIOD_AND_DUTY_API     (STD_ON)
#define PWM_VERSION_INFO_API            (STD_ON)
#define PWM_SAFETI_API            (STD_OFF)
#define PWM_ISR_CAT1          0U
#define PWM_ISR_CAT2          1U
#define PWM_ISR_VOID          2U
/*SAFETYMCUSW 79 S MR:19.4 <APPROVED> "Reason -  Macro is used to select ISR Category" */

#define PWM_CFG_ISR_TYPE                PWM_ISR_VOID


/* SourceId : Pwm_SourceId_049 */
/* DesignId : PWM_DesignId_25  */
/* Requirements : AR_PWM_SR106 */
#define PWM_PERIOD_UPDATED_ENDPERIOD   (STD_ON)


/*<PWM_CFG_CHL_LIST>*/
#define HSD_BMU_ID_PWM_N2HET1_0 ((Pwm_ChannelType) 0U)
/*</PWM_CFG_CHL_LIST>*/


/*----- Pre-Compile Switches for additional functionality ------------------*/
/* SourceId : PWM_SourceId_007 */
/* DesignId : PWM_DesignId_07  */
/* Requirements : AR_PWM_SR14, AR_PWM_SR88, AR_PWM_SR89, AR_PWM_SR90, AR_PWM_SR101, AR_PWM_SR103, AR_PWM_SR105 */
#define PWM_DEV_ERROR_DETECT              (STD_ON)
#define PWM_NOTIFICATION_SUPPORTED        (STD_ON)


/**********************************************************************************************************************
 *  STATIC TESTS
 *********************************************************************************************************************/

 /* Static tests for configuration integrity can be conducted here */
 

/**********************************************************************************************************************
 *  GLOBAL DATA TYPES AND STRUCTURES
 *********************************************************************************************************************/
/* SourceId : PWM_SourceId_013 */
/* DesignId : PWM_DesignId_13  */
/* Requirements : AR_PWM_SR27, AR_PWM_SR28, AR_PWM_SR29, AR_PWM_SR30, AR_PWM_SR31, AR_PWM_SR32, AR_PWM_SR33 */

/* "logical" channel numbers */
typedef uint8 Pwm_ChannelType;

/* possible output states of a pwm channel */
typedef enum
{
    PWM_LOW = 0U,
    PWM_HIGH
} Pwm_OutputStateType;

typedef enum
{
	HETCLR = 0U,
	HET1 = 1U,
    HET2 = 2U
}Pwm_HetType;

typedef enum
{
    PWM_RISING_EDGE  = 1U,   /* rising edges issue notification  */
    PWM_FALLING_EDGE = 2U,   /* falling edges issue notification */
    PWM_BOTH_EDGES   = 3U    /* both edges issue notification    */
} Pwm_EdgeNotificationType;


typedef uint32 Pwm_PeriodType;

/* SourceId : PWM_SourceId_009 */
/* DesignId : PWM_DesignId_13  */
/* Requirements : AR_PWM_SR20 */
typedef uint16 Pwm_DutycycleType;

/* Period type for pwm channels. Fixed periods prohibit changes to the period
 * length with Pwm_SetPeriod(  ). PWM_FIXED_PERIOD_SHIFTED type is not
 * supported due to hardware restrictions of the S12X' PWM unit.
 */
typedef enum
{
    PWM_FIXED_PERIOD = 0U,       /* period is immutable                      */
    PWM_FIXED_PERIOD_SHIFTED,   /* period is immutable with phase shift     */
    PWM_VARIABLE_PERIOD         /* period is variable                       */
} Pwm_ChannelClassType;

/* function pointer for callback, used for emergency shutdown
 * callback and for notification (which is only supported
 * by software emulation)
 */
/*SAFETYMCUSW 298 S <APPROVED> "Function pointer used as constant only." */
typedef P2FUNC(void, PWM_APPL_CODE, Pwm_NotifyFuncType)( void );

/* runtime configuration per channel */
/*<PWM_CHANNEL_CFG_TYPE>*/
typedef struct
{ 
	Pwm_ChannelClassType ChannelClass_t;
	Pwm_PeriodType InitialPeriod_t;
    Pwm_OutputStateType IdleState_t;
	Pwm_OutputStateType Polarity_t;
    Pwm_DutycycleType Dutycycle_t;
    Pwm_NotifyFuncType NotificationFunc_pt;
    Pwm_HetType Het_t;
    uint8 OutputPin_u8;
} Pwm_ChannelConfigType;
/*</PWM_CHANNEL_CFG_TYPE>*/

/* global runtime configuration structure */
typedef struct
{
    P2CONST( Het_Pwm_BlockType, AUTOMATIC, PWM_PBCFG ) Pwm_Het1Program_at;
    P2CONST( Het_Pwm_BlockType, AUTOMATIC, PWM_PBCFG ) Pwm_Het2Program_at;
    P2CONST( Pwm_ChannelConfigType, AUTOMATIC, PWM_PBCFG ) ChannelConfig_at;
    uint8 NumberOfChannels_u8;
} Pwm_ConfigType;

#endif /* PWM_CFG_H, public part of configuration */

#ifndef PWM_PRIVATE_H
#define PWM_PRIVATE_H
/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/

/*---- include of supporting definitions for configuration -----------------*/
/*<PWM_CFG_INCLUDE_IRQ>*/
#include "SchM_Pwm.h"
#include "Os.h"
/*</PWM_CFG_INCLUDE_IRQ>*/

#endif /* PWM_PRIVATE_H */	


/*********************************************************************************************************************/
/* CONFIGURATION DECLARATION                                                                                         */
/*********************************************************************************************************************/
/* extern declaration of the runtime configuration structure */
/*<PWM_CFG_EXTERN>*/

extern CONST(Pwm_ConfigType, PWM_PBCFG) PwmChannelConfigSet_0;

/*</PWM_CFG_EXTERN>*/


/**********************************************************************************************************************
 *  END OF FILE: Pwm_Cfg.h
 *********************************************************************************************************************/
 
