/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2011.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Spi_Cfg.h
 *      Project:  --
 *       Module:  SpiDriver Configuration Header File Spi_Cfg.h
 *    Generator:  Elektrobit Tresos
 *
 *  Description:  This file is generated by EB Tresos.Do not modify this file, otherwise the software may 
 *                behave in unexpected way.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Prathap Srinivasan
 *---------------------------------------------------------------------------------------------------------------------
 * Template Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.10.00       24Jan2013    Prathap Srinivasan  0000000000000    Initial Version adapted for TMS570LS1227
 * 02.20.00       08Aug2013    Enrique Lizarraga   SDOCM00103201    -Removed individual DET macros. Only one macro
 *                                                                   enables/disables all DET errors.
 *                                                                  -Added config parameter to include notification 
 *                                                                   header file
                                                                    -Update version info
 *                                                                  -Added traceability tags
 *                                                                  -Removed DEM function-like macro
 *                                                                  -Added Loopback mode enable/disable API's
 *                                                                  -Added protection to DEM error codes to avoid
 *                                                                   redefinition
 *                                                                  -Removed unused definition Spi_GlobalReEnable()
 * 02.21.00       30Sep2014    Enrique Lizarraga   SDOCM00112317    -Update version info
 *                                                                  -Added traceability tags
 *                                                                  -Removed unnecessary definitions
 * 02.21.01       29Feb2016    Enrique Lizarraga   SDOCM00121246    -Update version info
 *                                                                  -Change SpiLevelDelivered type from enum to int
 * 02.22.00       18Jul2016    Prathap Srinivasan  SDOCM00122408    -Update version info
 * 02.22.01       10Aug2016    Prathap Srinivasan  SDOCM00122593    -Bug Fix: Spi_IrqTxRxERR function checks for
 *                                                                   wrong error status bit
 * 02.22.02       23Aug2016    Vishwanath Reddy    SDOCM00121246    -Update version info
 * 02.22.03       26Sep2016    Prathap Srinivasan  SDOCM00122695    -Update version info
 * 02.30.00       01Dec2016    Sudhakar Singh         None          -Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh      SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 *
 *********************************************************************************************************************/

 /*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/

#ifndef SPI_CFG_H
#define SPI_CFG_H

/**********************************************************************************************************************
 * INCLUDES
 *********************************************************************************************************************/
#include "SchM_Spi.h"
#include "Os.h"
#include "Dem.h"


/**********************************************************************************************************************
 *  GLOBAL CONSTANT MACROS
 *********************************************************************************************************************/

#define SPI_CFG_MAJOR_VERSION               (5U)
#define SPI_CFG_MINOR_VERSION               (30U)
#define SPI_CFG_PATCH_VERSION               (0U)

/* Compile switch to enable /disable the Spi_GetVersionInfo function */
/*<T_SPI_VERSION_INFO_API/>*/ 
#define SPI_VERSION_INFO_API   (STD_ON) 
/* Compile switch to enable /disable the Spi_Cancel function */
/*<T_SPI_CANCEL_API/>*/
#define SPI_CANCEL_API         (STD_ON) 
/* Compile switch to enable /disable the Spi_GetJobResult function */
/*<T_SPI_HW_STATUS_API/>*/ 
#define SPI_HW_STATUS_API      (STD_ON)
/* Compile switch to enable /disable the Loopback Mode functions */
/*<T_SPI_ENABLE_LOOPBACK_MODE_API/>*/ 
#define SPI_LOOPBACK_MODE_API            (STD_OFF)
/* Compile switch to enable /disable the Spi_RegisterReadback function */
/*<SPI_REGISTER_READBACK_API/>*/ 
#define SPI_REGISTER_READBACK_API        (STD_OFF)

/* Pre-processor switch for enabling the development error detection and reporting */
/*<T_SPI_DEV_ERROR_DETECT/>*/ 
/* SourceId : SPI_SourceId_046 */
/* DesignId : SPI_DesignId_016 */
/* Requirements : AR_SPI_SR100, AR_SPI_SR101, AR_SPI_SR102, AR_SPI_SR103, AR_SPI_SR115, AR_SPI_SR285 */
#define SPI_DEV_ERROR_DETECT   (STD_ON) 
#if (SPI_DEV_ERROR_DETECT == STD_ON)
    /* include DET as configured */
    /*<T_SPI_DET_INCLUDE_FILE/>*/ 
    #include "Det.h"
    /*</T_SPI_DET_INCLUDE_FILE>*/
#endif

/* SourceId : SPI_SourceId_047 */
/* DesignId : SPI_DesignId_021 */
/* Requirements : AR_SPI_SR16, AR_SPI_SR124, AR_SPI_SR326, AR_SPI_SR97, AR_SPI_SR98, AR_SPI_SR116, AR_SPI_SR284,
 * AR_SPI_SR104 */
/* DEM Error Codes */
#define SPI_DEM_NO_EVENT (0xFFFFFFFFU)

#ifndef SPI_E_HARDWARE_ERROR
/*SAFETYMCUSW 79 S MR:19.4 <APPROVED> "Following Autosar Standard" */
#define SPI_E_HARDWARE_ERROR SPI_DEM_NO_EVENT
#endif
#ifndef SPI_E_BIT_ERROR
/*SAFETYMCUSW 79 S MR:19.4 <APPROVED> "Following Autosar Standard" */
#define SPI_E_BIT_ERROR      SPI_DEM_NO_EVENT
#endif
#ifndef SPI_E_DESYNC_ERROR
/*SAFETYMCUSW 79 S MR:19.4 <APPROVED> "Following Autosar Standard" */
#define SPI_E_DESYNC_ERROR   SPI_DEM_NO_EVENT
#endif
#ifndef SPI_E_DLEN_ERROR
/*SAFETYMCUSW 79 S MR:19.4 <APPROVED> "Following Autosar Standard" */
#define SPI_E_DLEN_ERROR     SPI_DEM_NO_EVENT
#endif
#ifndef SPI_E_TXSTALL_ERROR
/*SAFETYMCUSW 79 S MR:19.4 <APPROVED> "Following Autosar Standard" */
#define SPI_E_TXSTALL_ERROR  SPI_DEM_NO_EVENT
#endif
#ifndef SPI_E_RXSTALL_ERROR
/*SAFETYMCUSW 79 S MR:19.4 <APPROVED> "Following Autosar Standard" */
#define SPI_E_RXSTALL_ERROR  SPI_DEM_NO_EVENT
#endif
#ifndef SPI_E_DOVR_ERROR
/*SAFETYMCUSW 79 S MR:19.4 <APPROVED> "Following Autosar Standard" */
#define SPI_E_DOVR_ERROR     SPI_DEM_NO_EVENT
#endif
#ifndef SPI_E_TO_ERROR
/*SAFETYMCUSW 79 S MR:19.4 <APPROVED> "Following Autosar Standard" */
#define SPI_E_TO_ERROR       SPI_DEM_NO_EVENT
#endif

/*<T_SPI_IRQ_NOTIFICATION_DECL/>*/ 
#define SPI_CFG_ISR_TYPE    (SPI_ISR_VOID) 

/*---- defines for max allowed channels, jobs, sequences ------------------------------------------------------------*/

/*<T_SPI_MAX_CHANNEL/>*/  
#define SPI_MAX_CHANNEL     (254U)
/*<T_SPI_MAX_JOB/>*/ 
#define SPI_MAX_JOB         (254U)
/*<T_SPI_MAX_SEQUENCE/>*/ 
#define SPI_MAX_SEQUENCE    (254U)
/*<T_SPI_EXTERNALDEVICE_CONTAINER_NR/>*/ 
#define SPI_MAX_EXTDEVICE   (254U)

/*--------- scalability levels --------------------------------------------------------------------------------------*/
/* SourceId : SPI_SourceId_049 */
/* DesignId : SPI_DesignId_016 */
/* Requirements : AR_SPI_SR18, AR_SPI_SR19 */
/*<T_SPI_LEVEL_DELIVERED/>*/ 
/* Basic Synchronous functions */
#define SPI_LEVEL_0         (0U)
/* Basic Asynchronous functions */
#define SPI_LEVEL_1         (1U)
/* Synchronous and Asynchronous functions */
#define SPI_LEVEL_2         (2U)

#define SPI_SCALEABILITY    (1U) 

/* SourceId : SPI_SourceId_050 */
/* DesignId : SPI_DesignId_016 */
/* Requirements : AR_SPI_SR35, AR_SPI_SR36 */
/*<T_SPI_CHANNEL_BUFFERS_ALLOWED/>*/ 
#define SPI_CHANNELBUFFERS  (1U)

/*--------- define for runtime mapping ------------------------------------------------------------------------------*/
/*<T_SPI_MAX_H_W_UNIT/>*/ 
#define SPI_MAX_HWUNIT      (5U) 

/* SourceId : SPI_SourceId_051 */
/* DesignId : SPI_DesignId_016 */
/* Requirements : AR_SPI_SR20, AR_SPI_SR21 */
/* definitions of channel, device and job enums */
/*<T_SPI_NR_OF_CHANNEL_DEF>*/
#define Spi_SpiChannel_0    (0U)
/*</T_SPI_NR_OF_CHANNEL_DEF>*/

    /*<T_SPI_NR_OF_DEVICE_DEF>*/
#define Spi_SpiExternalDevice_0    (0U)
/*</T_SPI_NR_OF_DEVICE_DEF>*/

    /*<T_SPI_NR_OF_JOB_DEF>*/
#define Spi_SpiJob_0    (0U)
/*</T_SPI_NR_OF_JOB_DEF>*/

    /*<T_SPI_NR_OF_SEQ_DEF>*/
#define Spi_SpiSequence_0    (0U)
/*</T_SPI_NR_OF_SEQ_DEF>*/

    /*<T_SPI_NR_OF_HW_UNIT_ACTIVE_DEF>*/
#define SPI_HARDWAREUNIT0_ACTIVE (STD_ON)
#define SPI_HARDWAREUNIT1_ACTIVE (STD_ON)
#define SPI_HARDWAREUNIT2_ACTIVE (STD_ON)
#define SPI_HARDWAREUNIT3_ACTIVE (STD_ON)
#define SPI_HARDWAREUNIT4_ACTIVE (STD_ON)
/*</T_SPI_NR_OF_HW_UNIT_ACTIVE_DEF>*/

/**********************************************************************************************************************
 *  GLOBAL FUNCTION MACROS
 *********************************************************************************************************************/
/*<T_SPI_GLOBAL_SUSPEND/>*/ 
#define Spi_GlobalSuspend()   SchM_Enter_Spi_SPI_EXCLUSIVE_AREA_0()
/*<T_SPI_GLOBAL_RESTORE/>*/ 
#define Spi_GlobalRestore()   SchM_Exit_Spi_SPI_EXCLUSIVE_AREA_0()

/**********************************************************************************************************************
 *  GLOBAL DATA TYPES AND STRUCTURES
 *********************************************************************************************************************/
/**********************************************************************************************************************
 *  GLOBAL DATA PROTOTYPES
 *********************************************************************************************************************/
/**********************************************************************************************************************
 *  GLOBAL FUNCTION PROTOTYPES
 *********************************************************************************************************************/

#endif  /* SPI_CFG_H */
/**********************************************************************************************************************
 *  END OF FILE: Spi_Cfg.h
 *********************************************************************************************************************/

