/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2014.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *  File:       Wdg_Cfg.h
 *  Project:    Tms570_AutosarWdgDriver
 *  Module:     Wdg
 *  Generator:  Elektrobit Tresos
 *
 *  Description:  The Wdg Driver provides services for initialization, changing the operation mode and setting the
 *                trigger condition (timeout).
 *
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Enrique Lizarraga
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author                 Change ID       Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.21.00       30Sep2014    Enrique Lizarraga      SDOCM00112272   -Initial Release
 * 02.21.01       29Feb2016    Enrique Lizarraga      SDOCM00121247   -Corrected WdgInitialTimeout and WdgMaxTimeout
 *                                                                     configuration parameters from INT to FLOAT
 *                                                                    -Updated version info
 * 02.30.00       01Dec2016    Sudhakar Singh         None            -Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh         SDOCM00122834    Version supports TMS570LSxx Family of Devices. 
 *
 *********************************************************************************************************************/

/*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
*********************************************************************************************************************/

/* Protection against multiple inclusion */
#ifndef WDG_CFG_H
#define WDG_CFG_H

/*********************************************************************************************************************
 * Standard Header Files
 *********************************************************************************************************************/

/*********************************************************************************************************************
 * Other Header Files
 *********************************************************************************************************************/

/*********************************************************************************************************************
 * Version Check
 *********************************************************************************************************************/
#define WDG_CFG_MAJOR_VERSION               (5U)
#define WDG_CFG_MINOR_VERSION               (30U)
#define WDG_CFG_PATCH_VERSION               (0U)

/*********************************************************************************************************************
 * Exported Preprocessor #define Constants
 *********************************************************************************************************************/
/* SourceId : WDG_SourceId_012 */
/* DesignId : WDG_DesignId_012 */
/* Requirements : AR_WDG_SR16, AR_WDG_SR17, AR_WDG_SR19 */
/* Enable/Disable Development Error Detection */
#define WDG_DEV_ERROR_DETECT       (STD_ON)

/* SourceId : WDG_SourceId_013 */
/* DesignId : WDG_DesignId_012 */
/* Requirements : AR_WDG_SR73 */
/* Enable/Disable Version Info API */
#define WDG_GET_VERSION_INFO_API   (STD_ON)

/* Enable/Disable Register Readback API */
#define WDG_REGISTER_READBACK_API  (STD_OFF)

/* Watchdog Initial Timeout (milliseconds) */
#define WDG_INITIAL_TIMEOUT        (1000U)

/* Watchdog Maximum Timeout (milliseconds) */
#define WDG_MAX_TIMEOUT            (65535U)

/* RTI Clock Frequency */
#define WDG_RTI_FREQUENCY          ((uint32)90)

/* Watchdog Default Mode */
/*SAFETYMCUSW 79 S MR:19.4 <APPROVED> "Macro defined at Wdg.h. This file is always included through Wdg.h" */
#define WDG_DEF_MODE               (WDGIF_FAST_MODE)

/* Watchdog Window Size */
/*SAFETYMCUSW 79 S MR:19.4 <APPROVED> "Macro defined at Wdg.h. This file is always included through Wdg.h" */
#define WDG_WINDOW_SIZE            (WINDOW_100_PERCENT)

/* Watchdog Reaction */
#define WDG_REACTION               (0x05U)

/* Watchdog Preload Value */
#define WDG_PRELOAD_VALUE          (4095U)

/* Interrupt Type */
#define WDG_CFG_ISR_TYPE           (WDG_ISR_VOID) 

/* Watchdog Disable Allowed*/
#define WDG_DISABLE_ALLOWED        (STD_OFF)

/* SourceId : WDG_SourceId_022 */
/* DesignId : WDG_DesignId_001 */
/* Requirements : AR_WDG_SR15 */
/* DEM Error Definitions */
/* DEM Error Codes */
#define WDG_DEM_NO_EVENT (0xFFFFFFFFU)

#ifndef WDG_E_MODE_FAILED
#define WDG_E_MODE_FAILED          WDG_DEM_NO_EVENT
#endif

#ifndef WDG_E_DISABLE_REJECTED
#define WDG_E_DISABLE_REJECTED     WDG_DEM_NO_EVENT
#endif
/*********************************************************************************************************************
 * Exported Preprocessor #define Macros
 *********************************************************************************************************************/

/*********************************************************************************************************************
 * Exported Type Declarations
 *********************************************************************************************************************/
/* SourceId : WDG_SourceId_014 */
/* DesignId : WDG_DesignId_004 */
/* Requirements : AR_WDG_SR44 */
typedef struct
{
   uint16 Wdg_Default_Mode;
}Wdg_ConfigType;

/*********************************************************************************************************************
 * Exported Object Declarations
 *********************************************************************************************************************/
extern CONST(Wdg_ConfigType, WDG_PBCFG) WdgSettingsConfig_0;


#endif  /* WDG_CFG_H */
/*********************************************************************************************************************
 *  End of File: Wdg_Cfg.h
 *********************************************************************************************************************/
