/***********************************************************************************************************************
 *  COPYRIGHT
 *  --------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2014.  All rights reserved.
 *
 *  \endverbatim
 *  --------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  --------------------------------------------------------------------------------------------------------------------
 *  File:         Adc_PBcfg.c
 *  Project:      Tms570_AutosarAdcDriver
 *  Module:       AdcDriver
 *  Generator:    EB Tresos
 *
 *
 *  Description:  The Adc Driver provides the low level functions for the Adc Module.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Vishwanath Reddy
 *---------------------------------------------------------------------------------------------------------------------
 * Templete Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.21.00       30Sep2014    Vishwanath Reddy     SDOCM00113127    Initial Version 
 * 02.21.01       23Aug2016    Vishwanath Reddy     SDOCM00121248    AdcHwUnitId is now checked against ADC_HW_UNIT0
 *                                                                   instead of zero to make it AS4.0.3 compliant.
 * 02.30.00       01Dec2016    Sudhakar Singh           None         Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh       SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 **********************************************************************************************************************/
 /*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
#include "Std_Types.h"
#include "Adc.h"

/**********************************************************************************************************************
 *  GLOBAL CONFIG DATA
 **********************************************************************************************************************/

#define ADC_START_SEC_VAR_NOINIT_UNSPECIFIED
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"
/* Declare RAM variables. One array for each of the runtimes */
/*<ADC_GROUP_DATA_LIST>*/
static VAR(Adc_GroupDataType, ADC_VAR) Adc_GroupDataListRt0Hw0_at[1];
static VAR(Adc_GroupDataType, ADC_VAR) Adc_GroupDataListRt0Hw1_at[3];

/*</ADC_GROUP_DATA_LIST>*/ 
 
#define ADC_STOP_SEC_VAR_NOINIT_UNSPECIFIED
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"

#define ADC_START_SEC_PBCFG
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"


/* Create group configuration sets. One array for each of the runtimes */
/* SourceId : ADC_SourceId_022 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR9, AR_ADC_SR10, AR_ADC_SR13, AR_ADC_SR247, AR_ADC_SR248, AR_ADC_SR249, AR_ADC_SR253, 
                  AR_ADC_SR254, AR_ADC_SR255, AR_ADC_SR256, AR_ADC_SR257, AR_ADC_SR258, AR_ADC_SR259,*/
static CONST(Adc_GroupConfigType, ADC_PBCFG) Adc_GroupConfigList0_at[] = 
{
   
  {
    ( (1<<0)| (1<<1)),
    &Adc_GroupDataListRt0Hw0_at[0],
    (P2VAR(Adc_RegType, AUTOMATIC, MSR_REGSPACE))(ADC_HW_UNIT0_BASE_ADDRESS+0x08 ),
    (P2VAR(uint32, AUTOMATIC, MSR_REGSPACE))(ADC_HW_UNIT0_BASE_ADDRESS +ADC_G2_FIFO_OFFSET ),
    {&Adc_AvoidNotification,&Adc_AvoidNotification},
      &Adc_ProcessBufferSingle,  
  &Adc_ProcessConversionSingle, 
     4096U,  /*GroupSampTime_t based on the selected channel */
    10U,
    ADC_CONV_MODE_ONESHOT,
    ADC_TRIGG_SRC_SW,
    ADC_ACCESS_MODE_SINGLE,
    ADC_STREAM_BUFFER_LINEAR,
      ADC_HW_TRIG_FALLING_EDGE, /* Use rising or falling edge for event pin trigger */
    (ADC_HW_FIFO_THRESHOLD/2U),/* GroupThreshold_t */ 
     12U,/*Based on the selected channels we should select the groupResolution item */
    ADC_HW_UNIT0, /*GroupHwUnitId_t*/
    0U, /* Hardware trigger event: Zero when group is triggered
                            * by event pin; 1-7 for internal timers 
                            */
      ADC_HW_GROUP_G2, /* GroupHwGroupId_u8 */
    2U,   /* The number of channels of a group */
    ADC_GROUP_STOP_IMPLICIT       
  },
  
   
  {
    ( (1<<1)),
    &Adc_GroupDataListRt0Hw1_at[0],
    (P2VAR(Adc_RegType, AUTOMATIC, MSR_REGSPACE))(ADC_HW_UNIT0_BASE_ADDRESS+0x08 ),
    (P2VAR(uint32, AUTOMATIC, MSR_REGSPACE))(ADC_HW_UNIT0_BASE_ADDRESS +ADC_G2_FIFO_OFFSET ),
    {&Adc_AvoidNotification,&Adc_AvoidNotification},
      &Adc_ProcessBufferSingle,  
  &Adc_ProcessConversionSingle, 
     4096U,  /*GroupSampTime_t based on the selected channel */
    1U,
    ADC_CONV_MODE_ONESHOT,
    ADC_TRIGG_SRC_SW,
    ADC_ACCESS_MODE_SINGLE,
    ADC_STREAM_BUFFER_LINEAR,
      ADC_HW_TRIG_FALLING_EDGE, /* Use rising or falling edge for event pin trigger */
    (ADC_HW_FIFO_THRESHOLD/1U),/* GroupThreshold_t */ 
     12U,/*Based on the selected channels we should select the groupResolution item */
    ADC_HW_UNIT0, /*GroupHwUnitId_t*/
    0U, /* Hardware trigger event: Zero when group is triggered
                            * by event pin; 1-7 for internal timers 
                            */
      ADC_HW_GROUP_G2, /* GroupHwGroupId_u8 */
    1U,   /* The number of channels of a group */
    ADC_GROUP_STOP_IMPLICIT       
  },
   
  {
    ( (1<<1)| (1<<3)| (1<<2)),
    &Adc_GroupDataListRt0Hw1_at[1],
    (P2VAR(Adc_RegType, AUTOMATIC, MSR_REGSPACE))(ADC_HW_UNIT0_BASE_ADDRESS+0x08 ),
    (P2VAR(uint32, AUTOMATIC, MSR_REGSPACE))(ADC_HW_UNIT0_BASE_ADDRESS +ADC_G2_FIFO_OFFSET ),
    {&Adc_AvoidNotification,&Adc_AvoidNotification},
      &Adc_ProcessBufferSingle,  
  &Adc_ProcessConversionSingle, 
     4096U,  /*GroupSampTime_t based on the selected channel */
    1U,
    ADC_CONV_MODE_ONESHOT,
    ADC_TRIGG_SRC_SW,
    ADC_ACCESS_MODE_SINGLE,
    ADC_STREAM_BUFFER_LINEAR,
      ADC_HW_TRIG_FALLING_EDGE, /* Use rising or falling edge for event pin trigger */
    (ADC_HW_FIFO_THRESHOLD/3U),/* GroupThreshold_t */ 
     12U,/*Based on the selected channels we should select the groupResolution item */
    ADC_HW_UNIT0, /*GroupHwUnitId_t*/
    0U, /* Hardware trigger event: Zero when group is triggered
                            * by event pin; 1-7 for internal timers 
                            */
      ADC_HW_GROUP_G2, /* GroupHwGroupId_u8 */
    3U,   /* The number of channels of a group */
    ADC_GROUP_STOP_IMPLICIT       
  },
   
  {
    ( (1<<2)),
    &Adc_GroupDataListRt0Hw1_at[2],
    (P2VAR(Adc_RegType, AUTOMATIC, MSR_REGSPACE))(ADC_HW_UNIT0_BASE_ADDRESS+0x08 ),
    (P2VAR(uint32, AUTOMATIC, MSR_REGSPACE))(ADC_HW_UNIT0_BASE_ADDRESS +ADC_G2_FIFO_OFFSET ),
    {&Adc_AvoidNotification,&Adc_AvoidNotification},
      &Adc_ProcessBufferSingle,  
  &Adc_ProcessConversionSingle, 
     4096U,  /*GroupSampTime_t based on the selected channel */
    1U,
    ADC_CONV_MODE_ONESHOT,
    ADC_TRIGG_SRC_SW,
    ADC_ACCESS_MODE_SINGLE,
    ADC_STREAM_BUFFER_LINEAR,
      ADC_HW_TRIG_FALLING_EDGE, /* Use rising or falling edge for event pin trigger */
    (ADC_HW_FIFO_THRESHOLD/1U),/* GroupThreshold_t */ 
     12U,/*Based on the selected channels we should select the groupResolution item */
    ADC_HW_UNIT0, /*GroupHwUnitId_t*/
    0U, /* Hardware trigger event: Zero when group is triggered
                            * by event pin; 1-7 for internal timers 
                            */
      ADC_HW_GROUP_G2, /* GroupHwGroupId_u8 */
    1U,   /* The number of channels of a group */
    ADC_GROUP_STOP_IMPLICIT       
  },
  
  
};

/*<ADC_GROUP_CONFIG_LIST>*/

/* Create hw unit configuration sets. One array for each of the runtimes */
/*<ADC_HW_UNIT_CONFIG_LIST>*/
/* SourceId : ADC_SourceId_023 */
/* DesignId : ADC_DesignId_001 */
/* Requirements : AR_ADC_SR261, AR_ADC_SR263, AR_ADC_SR264,  */
CONST(Adc_HwUnitConfigType, ADC_PBCFG) Adc_HwUnitConfigList0_at[] = 
{
  
{
  ADC_EV_FIFO_END,
  ADC_G1_FIFO_END,
  (Adc_RegisterRefType)ADC_HW_UNIT0_BASE_ADDRESS,
    32 
},
  
{
  ADC_EV_FIFO_END,
  ADC_G1_FIFO_END,
  (Adc_RegisterRefType)ADC_HW_UNIT0_BASE_ADDRESS,
  0 
},

};


#define ADC_STOP_SEC_PBCFG
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"

#define ADC_START_SEC_PBCFG_ROOT
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"

/* Create runtime configurations. */
/*<ADC_CONFIG>*/
 CONST(Adc_ConfigType, ADC_PBCFG) AdcConfigSet_0 =
{
    Adc_HwUnitConfigList0_at,
    Adc_GroupConfigList0_at,
    2,
    4
};


/*</ADC_CONFIG>*/

#define ADC_STOP_SEC_PBCFG_ROOT
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"

/**********************************************************************************************************************
 *  END OF FILE: Adc_PBcfg.h
 *********************************************************************************************************************/

