/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2014.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *  File:         Can_PBcfg.c
 *  Project:      Tms570_AutosarCanDriver
 *  Module:       Can
 *  Generator:    EB Tresos
 *
 *
 *  Description:  The Can Driver provides the low level functions for the CAN interface layer.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Vishwanath Reddy
 *---------------------------------------------------------------------------------------------------------------------
 * Template Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.10.00       10Feb2013    Vishwanath Reddy    0000000000000    Initial Version adapted from TMS570LS31xx v1.10.00
 * 02.20.00       23Aug2013    Vishwanath Reddy    SDOCM00103356    Version Info update.
 *                                                                  Added requirement tags for traceability. 
 * 02.20.01       10Apr2014    Vishwanath Reddy    SDOCM00107321    Version Info update.
 *                                                                  Add design tags.
 * 02.21.00       30Sep2014    Vineeth T Alex      SDOCM00113179    Changes for Production release.
 *                                                                  Device compatibility
 * 02.21.01       03Nov2014    Vineeth T Alex      SDOCM00113685    Version Update.
 * 02.21.02       01Mar2016    Vishwanath Reddy    SDOCM00121479    Version Update.
 * 02.30.00       01Dec2016    Sudhakar Singh          None         Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh       SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/
/**********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
	This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.
 *********************************************************************************************************************/
/*
 * Module switch
 */
#define CAN_PBCFG_SOURCE
/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
 #include "Can.h"
 #include "Can_Cfg.h"

/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/
#define CAN_CFG_C_MAJOR_VERSION               (5U)
#define CAN_CFG_C_MINOR_VERSION               (30U)
#define CAN_CFG_C_PATCH_VERSION               (0U)

/*  Version checking  */
 #if (   (CAN_SW_MAJOR_VERSION != CAN_CFG_C_MAJOR_VERSION)||\
         (CAN_SW_MINOR_VERSION != CAN_CFG_C_MINOR_VERSION))
  #error "Version numbers of Can_PBcfg.c and Can.h are inconsistent!"
#endif

#if (   (CAN_CFG_MAJOR_VERSION != CAN_CFG_C_MAJOR_VERSION) || \
        (CAN_CFG_MINOR_VERSION != CAN_CFG_C_MINOR_VERSION))
  #error "Version numbers of Can_PBcfg.c and Can_Cfg.h are inconsistent!"
#endif

/**********************************************************************************************************************
 *  GLOBAL DATA
 *********************************************************************************************************************/
#define CAN_START_SEC_PBCFG
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"

/* Filter masks for all the config sets */
Can_MaskType  CanConfigSet_0_CanController_0_CanFilterMask_0 = 
{
  4294967295U  /* Mask Value */
};

Can_MaskType  CanConfigSet_0_CanController_1_CanFilterMask_0 = 
{
  4294967295U  /* Mask Value */
};

Can_MaskType  CanConfigSet_0_CanController_2_CanFilterMask_0 = 
{
  4294967295U  /* Mask Value */
};



/* SourceId : CAN_SourceId_034 */
/* DesignId : CAN_DesignId_001 */
/* Requirements : AR_CAN_SR278, AR_CAN_SR279 */
/*List of the FilterMask structures */
Can_MaskType *CanConfigSet_0_CanController_0_FilterMaskList []=
{ 
    &CanConfigSet_0_CanController_0_CanFilterMask_0,
  
};
Can_MaskType *CanConfigSet_0_CanController_1_FilterMaskList []=
{ 
    &CanConfigSet_0_CanController_1_CanFilterMask_0,
  
};
Can_MaskType *CanConfigSet_0_CanController_2_FilterMaskList []=
{ 
    &CanConfigSet_0_CanController_2_CanFilterMask_0,
  
};
 

/* SourceId : CAN_SourceId_033 */
/* DesignId : CAN_DesignId_001 */
/* Requirements : AR_CAN_SR263, AR_CAN_SR264, AR_CAN_SR265, AR_CAN_SR266, AR_CAN_SR267, AR_CAN_SR268 */
/* Baud Rate Structure for all configsets */
Can_BaudConfigType  CanConfigSet_0_CanController_0_CanControllerBaudrateConfig_0 = 
{
  500U,     /* in KB */
  1U, 
  3U, 
  2U,
  2U,
  6U,  /* Sum of all timing parameters  */
  29U, /* Controller BRP value for Baud */
};

Can_BaudConfigType  CanConfigSet_0_CanController_1_CanControllerBaudrateConfig_0 = 
{
  500U,     /* in KB */
  1U, 
  3U, 
  2U,
  2U,
  6U,  /* Sum of all timing parameters  */
  29U, /* Controller BRP value for Baud */
};

Can_BaudConfigType  CanConfigSet_0_CanController_2_CanControllerBaudrateConfig_0 = 
{
  500U,     /* in KB */
  1U, 
  3U, 
  2U,
  2U,
  6U,  /* Sum of all timing parameters  */
  29U, /* Controller BRP value for Baud */
};



/* SourceId : CAN_SourceId_035 */
/* DesignId : CAN_DesignId_001 */
/* Requirements : AR_CAN_SR280 */
/*List of the Baudrate structures */
Can_BaudConfigType *CanConfigSet_0_CanController_0_BaudRateConfigList[]=
{ 
    &CanConfigSet_0_CanController_0_CanControllerBaudrateConfig_0,
  
};

Can_BaudConfigType *CanConfigSet_0_CanController_1_BaudRateConfigList[]=
{ 
    &CanConfigSet_0_CanController_1_CanControllerBaudrateConfig_0,
  
};

Can_BaudConfigType *CanConfigSet_0_CanController_2_BaudRateConfigList[]=
{ 
    &CanConfigSet_0_CanController_2_CanControllerBaudrateConfig_0,
  
};

  

/* SourceId : CAN_SourceId_016 */
/* DesignId : CAN_DesignId_001 */
/* Requirements : AR_CAN_SR115, AR_CAN_SR252, AR_CAN_SR253, AR_CAN_SR254, AR_CAN_SR255, AR_CAN_SR256, AR_CAN_SR257,AR_CAN_SR258, AR_CAN_SR259, AR_CAN_SR260, AR_CAN_SR251   */
/* Controller structure defined here for all config sets */
Can_ControllerType  CanConfigSet_0_CanController_0 = 
{
  0U,      /* Id as provided by GUI */
    TRUE,   /* Contoller is used=1 or not_used=0*/
  0xfff7dc00U, /* Pointer to CanReg structure */  
  TRUE,   /* Automatic wakeup via bus activity */
  FALSE,  /* TRUE = Interrupt FALSE = Polling */
  FALSE,  /* TRUE = Interrupt FALSE = Polling */
  FALSE,   /* TRUE = Interrupt FALSE = Polling */
  FALSE,   /* TRUE = Interrupt FALSE = Polling */
  &CanConfigSet_0_CanController_0_CanControllerBaudrateConfig_0,  /* pointer to default Baud structure */
  0x00U,  /* Contoller Interrupt Mask */
  CanConfigSet_0_CanController_0_BaudRateConfigList,  /* List of available Baudrate structs */
  CanConfigSet_0_CanController_0_FilterMaskList       /* List of Avialable masks */
};


Can_ControllerType  CanConfigSet_0_CanController_1 = 
{
  1U,      /* Id as provided by GUI */
    FALSE,   /* Contoller is used=1 or not_used=0*/
  0xfff7de00U, /* Pointer to CanReg structure */  
  TRUE,   /* Automatic wakeup via bus activity */
  FALSE,  /* TRUE = Interrupt FALSE = Polling */
  FALSE,  /* TRUE = Interrupt FALSE = Polling */
  FALSE,   /* TRUE = Interrupt FALSE = Polling */
  FALSE,   /* TRUE = Interrupt FALSE = Polling */
  &CanConfigSet_0_CanController_1_CanControllerBaudrateConfig_0,  /* pointer to default Baud structure */
  0x00U,  /* Contoller Interrupt Mask */
  CanConfigSet_0_CanController_1_BaudRateConfigList,  /* List of available Baudrate structs */
  CanConfigSet_0_CanController_1_FilterMaskList       /* List of Avialable masks */
};


Can_ControllerType  CanConfigSet_0_CanController_2 = 
{
  2U,      /* Id as provided by GUI */
    FALSE,   /* Contoller is used=1 or not_used=0*/
  0xfff7e000U, /* Pointer to CanReg structure */  
  TRUE,   /* Automatic wakeup via bus activity */
  FALSE,  /* TRUE = Interrupt FALSE = Polling */
  FALSE,  /* TRUE = Interrupt FALSE = Polling */
  FALSE,   /* TRUE = Interrupt FALSE = Polling */
  FALSE,   /* TRUE = Interrupt FALSE = Polling */
  &CanConfigSet_0_CanController_2_CanControllerBaudrateConfig_0,  /* pointer to default Baud structure */
  0x00U,  /* Contoller Interrupt Mask */
  CanConfigSet_0_CanController_2_BaudRateConfigList,  /* List of available Baudrate structs */
  CanConfigSet_0_CanController_2_FilterMaskList       /* List of Avialable masks */
};


  

/*List of the Controller structures */
Can_ControllerType *CanConfigSet_0_CanController_List[]= 
{ 
    &CanConfigSet_0_CanController_0,
    &CanConfigSet_0_CanController_1,
    &CanConfigSet_0_CanController_2,
  
};



       

/* All the Mailbox objects(MB's) will be defined here for all config sets */
Can_MailboxType  CanConfigSet_0_CanHardwareObject_0 = 
{
  0U,  /*  CanHandleType 0=Full, 1=Basic */ 
  1U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/ 

  200U,  /* ID value extended will have MSB set */
  0U,  /* CanObjectId - Holds handle Id */
  1U,  /* HwHandle */ /* Mailbox - Hw object in the controller*/
  1U,  /* CanObjectType - Direction of Mailbox,0= Rx or 1= Tx*/
  &CanConfigSet_0_CanController_0,  /* Controller */ 
  &CanConfigSet_0_CanController_0_CanFilterMask_0,  /* ptr to Mask for the RX filtering */
  8U   /* Length of the Mailbox */
};

Can_MailboxType  CanConfigSet_0_CanHardwareObject_1 = 
{
  0U,  /*  CanHandleType 0=Full, 1=Basic */ 
  1U,  /* CanIdType 0=standard 1=Extended 2=Mixed*/ 

  200U,  /* ID value extended will have MSB set */
  1U,  /* CanObjectId - Holds handle Id */
  2U,  /* HwHandle */ /* Mailbox - Hw object in the controller*/
  0U,  /* CanObjectType - Direction of Mailbox,0= Rx or 1= Tx*/
  &CanConfigSet_0_CanController_0,  /* Controller */ 
  &CanConfigSet_0_CanController_0_CanFilterMask_0,  /* ptr to Mask for the RX filtering */
  8U   /* Length of the Mailbox */
};



/* List of the Mailboxes */
Can_MailboxType *CanConfigSet_0_CanHardwareObject_List[] = 
{
   &CanConfigSet_0_CanHardwareObject_0,
   &CanConfigSet_0_CanHardwareObject_1,
  
};


/*SAFETYMCUSW 580 S MR:1.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#define CAN_STOP_SEC_PBCFG
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"

/*SAFETYMCUSW 580 S MR:1.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#define CAN_START_SEC_PBCFG_ROOT
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"
/* SourceId : CAN_SourceId_012 */
/* DesignId : CAN_DesignId_001 */
/* Requirements : AR_CAN_SR83, AR_CAN_SR84 */
/*Can Config struct */
const Can_ConfigType  CanConfigSet_0 = 
{
   CanConfigSet_0_CanController_List, /* List of all controllers in this config set */
     (3U),  /* max Controllers */      
   CanConfigSet_0_CanHardwareObject_List,
   (2U)/* total number of mail boxes in this configset */
};


/*SAFETYMCUSW 580 S MR:1.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#define  CAN_STOP_SEC_PBCFG_ROOT
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h" 
/*********************************************************************************************************************
 *  End of File: Can_PBcfg.c
 *********************************************************************************************************************/
