/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Gpt_PBCfg.c
 *      Project:  Tms570_AutosarGptDriver
 *       Module:  GptDriver
 *    Generator:  EB Tresos
 *
 *  Description:  This component provides services for initialization and control of the microcontroller internal
 *                GPT unit (General Purpose Timer).
 *  
 *********************************************************************************************************************/

/*********************************************************************************************************************
/ *---------------------------------------------------------------------------------------------------------------------
 * Author:  Vishwanath Reddy
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.21.00       30Sep14      Vishwanath Reddy     SDOCM00113130    Initial Version
 * 02.21.01       11Mar16      Enrique Lizarraga    SDOCM00121245    Correct GptChannelId type from Enum to Int
 * 02.30.00       01Dec2016    Sudhakar Singh           None         Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh       SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/
/*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
**********************************************************************************************************************/
#include "Std_Types.h"
#include "Gpt.h"
#include "Gpt_Cfg.h"

#define GPT_CFG_C_MAJOR_VERSION               (5U)
#define GPT_CFG_C_MINOR_VERSION               (30U)
#define GPT_CFG_C_PATCH_VERSION               (0U)

/* ---- Perform version checking  ----------------------------------------- */
#if (   (GPT_SW_MAJOR_VERSION != GPT_CFG_C_MAJOR_VERSION) \
     || (GPT_SW_MINOR_VERSION != GPT_CFG_C_MINOR_VERSION))
  #error "Version numbers of Gpt_PBcfg.c and Gpt.h are inconsistent!"
#endif

#if (   (GPT_CFG_MAJOR_VERSION != GPT_CFG_C_MAJOR_VERSION) \
     || (GPT_CFG_MINOR_VERSION != GPT_CFG_C_MINOR_VERSION))
  #error "Version numbers of Gpt_PBcfg.c and Gpt_Cfg.h are inconsistent!"
#endif

#define GPT_START_SEC_CONST_PBCFG_ROOT
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"



/* Gpt Channel Configuration parameters */

static CONST(Gpt_ChannelConfigType, GPT_PBCFG) Gpt_ChannelConfig0[2] = 
{
  
  {
    1,
    GPT_CH_MODE_CONTINUOUS,/* Gpt Channel Mode */
    99U,/* Channel Frequency in MHz*/ 
    0x3e8U,/*Max Channel Tick Value*/
    FALSE,/*Wakeup Enable Flag*/
    gpt_notification_fn,/*Notification Call Back function*/
    80U,    /* Gpt Clock derived from Mcu in MHz*/ 
    0U
  },
  {
    1,
    GPT_CH_MODE_CONTINUOUS,/* Gpt Channel Mode */
    99U,/* Channel Frequency in MHz*/ 
    0x3e8U,/*Max Channel Tick Value*/
    FALSE,/*Wakeup Enable Flag*/
    gpt_notification_fn,/*Notification Call Back function*/
    80U,    /* Gpt Clock derived from Mcu in MHz*/ 
    0U
  }
};


/*<GPT_CONFIGURATION>*/




CONST(Gpt_ConfigType, GPT_PBCFG) GptChannelConfigSet_0 =
{
  Gpt_ChannelConfig0,/*Pointer to Channel Configuration*/
  2/*Number of Channels*/
};

/*</GPT_CONFIGURATION>*/

#define GPT_STOP_SEC_CONST_PBCFG_ROOT
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"

/*----- End of File --------------------------------------------------------*/
