/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Icu_PBcfg.c
 *      Project:  Tms570_AutosarIcuDriver
 *       Module:  ICU
 *    Generator:  EB Tresos
 *
 *  Description:  The ICU driver is a module using the input capture unit (ICU) for demodulation of a PWM signal,
 *                counting pulses, measuring of frequency and duty cycle, generating simple interrupts and wake-up
 *                interrupts.
 *
 *                The ICU driver provides services for
 *                -    Signal edge notification
 *                -    Controlling wake-up interrupts
 *                -    Periodic signal time measurement
 *                -    Edge timestamping, usable for the acquisition of non-periodic signals
 *                -    Edge counting
 *
 *                This module works on pins and ports which are configured by the PORT driver for this purpose. For
 *                this reason there is no configuration and initialization of this port structure in the ICU Driver.
 *********************************************************************************************************************/

/**********************************************************************************************************************
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Vineeth Thomas Alex
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version     Date           Author                   Change ID          Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.21.00    30Sept2014     Vineeth Thomas Alex      SDOCM00113121      Initial version adapted from TMS570LS3137
 * 02.21.01    16Mar2016      Enrique Lizarraga        SDOCM00121723      Update version number
 * 02.30.00    01Dec2016      Sudhakar Singh           None               Update version info
 * 05.30.00    15Mar2017      Sudhakar Singh           SDOCM00122834      Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/
 /**********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
	This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.
***********************************************************************************************************************
**********************************************************************************************************************/
#define ICU_PBCFG_SOURCE
/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/

#include "Std_Types.h"
#include "Icu_Cfg.h"
#include "Icu.h"
#include "Icu_Cbk.h"
/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/

#define ICU_CFG_C_MAJOR_VERSION               (5U)
#define ICU_CFG_C_MINOR_VERSION               (30U)
#define ICU_CFG_C_PATCH_VERSION               (0U)

/* ---- Perform version checking  ----------------------------------------- */
#if (   (ICU_SW_MAJOR_VERSION != ICU_CFG_C_MAJOR_VERSION) \
     || (ICU_SW_MINOR_VERSION != ICU_CFG_C_MINOR_VERSION))
  #error "Version numbers of Icu_PBcfg.c and Icu.h are inconsistent!"
#endif

#if (   (ICU_CFG_MAJOR_VERSION != ICU_CFG_C_MAJOR_VERSION) \
     || (ICU_CFG_MINOR_VERSION != ICU_CFG_C_MINOR_VERSION))
  #error "Version numbers of Icu_PBcfg.c and Icu_Cfg.h are inconsistent!"
#endif

/*SAFETYMCUSW 580 S MR:1.1 <APPROVED> "Reason - Memory mapping requires this syntax" */
#define ICU_START_SEC_CONST_PBCFG
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format for specifying memory sections" */
#include "MemMap.h"

/* Icu Channel Configuration parameters */
static CONST(Icu_ChannelConfigType, ICU_PBCFG) IcuConfigSet0_ChannelConfig_at[] =
{
		{
		NULL_PTR,/*Notification function*/
		ICU_MODE_SIGNAL_MEASUREMENT,/*Measurement mode*/
		ICU_RISING_EDGE,/*Default Start Edge*/
		0U,/*Hardware Identifier*/
		ICU_HIGH_TIME,/*Common Variable for property info*/
		ICU_UNDEFINED/*Wakeup Identifier*/
	},
	{
		NULL_PTR,/*Notification function*/
		ICU_MODE_SIGNAL_MEASUREMENT,/*Measurement mode*/
		ICU_RISING_EDGE,/*Default Start Edge*/
		0U,/*Hardware Identifier*/
		ICU_DUTY_CYCLE,/*Common Variable for property info*/
		ICU_UNDEFINED/*Wakeup Identifier*/
	}
};


/*<Het_Icu_PROGRAM>*/
static CONST(Het_Icu_InstructionType, ICU_PBCFG) IcuConfigSet0_HetBlock1_at[] =
{
				{ 0x00042f58U, 0x00000000U, 0x00000000U, 0x0U},
				{ 0x0009cf56U, 0x00000000U, 0x00000000U, 0x0U}
	
	};
static CONST(Het_Icu_InstructionType, ICU_PBCFG) IcuConfigSet0_HetBlock2_at[] =
{
		{0x00004f98U,0x00000000U,0x00000000U,0x00U},
		{0x00006f96U,0x00000000U,0x00000000U,0x00U}
		
		
};
/*</Het_Icu_PROGRAM>*/


/*<Het_Icu_RAM_BLOCK_ARRAY>*/
/* --- HET block array for IcuConfigSet --- */
static CONST(Het_Icu_BlockType, ICU_PBCFG) IcuConfigSet0_HetRamBlocks_at[] =
{
    {IcuConfigSet0_HetBlock1_at, 2U},
    {IcuConfigSet0_HetBlock2_at, 2U}
};
/*</Het_Icu_RAM_BLOCK_ARRAY>*/


/* global Icu runtime configuration Het1,Het2*/
/*<ICU_CONFIGURATION>*/
CONST(Icu_ConfigType, ICU_PBCFG) IcuConfigSet_0 =
{
	IcuConfigSet0_ChannelConfig_at,/*Channel Config*/
	IcuConfigSet0_HetRamBlocks_at,/*Instruction Set*/
	0U,/* Number of edge counter channels*/
	0U,/* Number of timestamping channels*/
	0U,/* Number of signal edge detection channels*/
	2U,/* Number of signal measurement channels*/
	ICU_HET1_REG_ADDR,/*NHET Register Base Address*/
	ICU_HET1_RAM_ADDR/*NHET RAM Base Address*/
};
/*</ICU_CONFIGURATION>*/
/*SAFETYMCUSW 580 S MR:1.1 <APPROVED> "Reason - Memory mapping requires this syntax" */
#define ICU_STOP_SEC_CONST_PBCFG
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format for specifying memory sections" */
#include "MemMap.h"

/**********************************************************************************************************************
 *  END OF FILE: Icu_PBcfg.c                                                                                          *
 *********************************************************************************************************************/


