/***********************************************************************************************************************
 *  COPYRIGHT
 *  --------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2014.  All rights reserved.
 *
 *  \endverbatim
 *  --------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  --------------------------------------------------------------------------------------------------------------------
 *  File:         Mcu_PBcfg.c
 *  Project:      Tms570_AutosarMcuDriver
 *  Module:       Mcu
 *  Generator:    Elektrobit Tresos
 *
 *
 *  Description:  The Mcu Driver provides services for basic microcontroller initialization,
 *                power down functionality, reset and microcontroller specific functions
 *                required from other MCAL software modules.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Enrique Lizarraga
 *---------------------------------------------------------------------------------------------------------------------
 * Templete Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.10.00       05Feb2013    Enrique Lizarraga    0000000000000    - Based on TMS570LS3 (01.10.00)
 *
 * 02.20.00       08Aug2013    Enrique Lizarraga    SDOCM00103171    -Updated version info
 *                                                                   -Traceability comments
 * 02.21.00       30Sep2014    Enrique Lizarraga    SDOCM00112263    -Updated version info
 *                                                                   -Added traceability info
 * 02.21.01       26Feb2016    Enrique Lizarraga    SDOCM00115297    -Updated version info
 * 02.30.00       01Dec2016    Sudhakar Singh         None           -Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh       SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/
 
 /**********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/

/* Module switch */
#define MCU_PBCFG_SOURCE

/**********************************************************************************************************************
 * Standard Header Files
 **********************************************************************************************************************/

/*********************************************************************************************************************
 * Other Header Files
 *********************************************************************************************************************/
#include "Mcu.h"

/**********************************************************************************************************************
 *  Version Check
 *********************************************************************************************************************/
#define MCU_CFG_C_MAJOR_VERSION               (5U)
#define MCU_CFG_C_MINOR_VERSION               (30U)
#define MCU_CFG_C_PATCH_VERSION               (0U)

/*  Version checking  */
 #if (   (MCU_SW_MAJOR_VERSION != MCU_CFG_C_MAJOR_VERSION)||\
         (MCU_SW_MINOR_VERSION != MCU_CFG_C_MINOR_VERSION))
  #error "Version numbers of Mcu_PBcfg.c and Mcu.h are inconsistent!"
#endif

#if (   (MCU_CFG_MAJOR_VERSION != MCU_CFG_C_MAJOR_VERSION) ||\
        (MCU_CFG_MINOR_VERSION != MCU_CFG_C_MINOR_VERSION))
  #error "Version numbers of Mcu_PBcfg.c and Mcu_Cfg.h are inconsistent!"
#endif

/**********************************************************************************************************************
 * Local Preprocessor #define Constants
 **********************************************************************************************************************/
 
/**********************************************************************************************************************
 * Local Preprocessor #define Macros
 **********************************************************************************************************************/

/**********************************************************************************************************************
 * Local Data Types and Structures
 **********************************************************************************************************************/
typedef enum
{
   OSCIN,
   PLL1,
   SOURCE_NOT_AVAILABLE_2,
   EXTCLKIN1,
   LFLPO,
   HFLPO,
   PLL2,
   EXTCLKIN2,
   VCLK_SRC  /*Peripheral Asynchronous and RTI Clock Source Only*/
}Mcu_ClockSources;

typedef enum
{
   GCLK,
   HCLK,
   VCLK,
   VCLK2,
   VCLKA1,
   VCLKA2,
   RTICLK1,
   DOMAIN_NOT_AVAILABLE_7,
   VCLK3,
   DOMAIN_NOT_AVAILABLE_9,
   DOMAIN_NOT_AVAILABLE_10,
   VCLKA4
}Mcu_ClockDomains;

typedef enum
{
   DivideByOne = 0,
   DivideByTwo,
   DivideByThree,
   DivideByFour,
   DivideByFive,
   DivideBySix,
   DivideBySeven,
   DivideByEight
}Mcu_ClkDividers;

typedef enum
{
   RomClkDivideByOne = 0,
   RomClkDivideByTwo,
   RomClkDivideByFour,
   RomClkDivideByEight
}Mcu_RomClkDividers;

typedef enum
{
   RtiClkDivideByOne = 0,
   RtiClkDivideByTwo,
   RtiClkDivideByFour,
   RtiClkDivideByEight
}Mcu_RtiClkDividers;

typedef enum
{
   HfTrim29Comma52Percent=0,
   HfTrim34Comma24Percent,
   HfTrim38Comma85Percent,
   HfTrim43Comma45Percent,
   HfTrim47Comma99Percent,
   HfTrim52Comma55Percent,
   HfTrim57Comma02Percent,
   HfTrim61Comma46Percent,
   HfTrim65Comma92Percent,
   HfTrim70Comma17Percent,
   HfTrim74Comma55Percent,
   HfTrim78Comma92Percent,
   HfTrim83Comma17Percent,
   HfTrim87Comma43Percent,
   HfTrim91Comma75Percent,
   HfTrim95Comma89Percent,
   HfTrim100Comma00Percent,
   HfTrim104Comma09Percent,
   HfTrim108Comma17Percent,
   HfTrim112Comma32Percent,
   HfTrim116Comma41Percent,
   HfTrim120Comma67Percent,
   HfTrim124Comma42Percent,
   HfTrim128Comma38Percent,
   HfTrim132Comma24Percent,
   HfTrim136Comma15Percent,
   HfTrim140Comma15Percent,
   HfTrim143Comma94Percent,
   HfTrim148Comma02Percent,
   HfTrim151Comma80Percent,
   HfTrim155Comma50Percent,
   HfTrim159Comma35Percent
}Mcu_HfTrim;

typedef enum
{
   LfTrim20Comma67Percent = 0,
   LfTrim25Comma76Percent,
   LfTrim30Comma84Percent,
   LfTrim35Comma90Percent,
   LfTrim40Comma93Percent,
   LfTrim45Comma95Percent,
   LfTrim50Comma97Percent,
   LfTrim55Comma91Percent,
   LfTrim60Comma86Percent,
   LfTrim65Comma78Percent,
   LfTrim70Comma75Percent,
   LfTrim75Comma63Percent,
   LfTrim80Comma61Percent,
   LfTrim85Comma39Percent,
   LfTrim90Comma23Percent,
   LfTrim95Comma11Percent,
   LfTrim100Comma00Percent,
   LfTrim104Comma84Percent,
   LfTrim109Comma51Percent,
   LfTrim114Comma31Percent,
   LfTrim119Comma01Percent,
   LfTrim123Comma75Percent,
   LfTrim128Comma62Percent,
   LfTrim133Comma31Percent,
   LfTrim138Comma03Percent,
   LfTrim142Comma75Percent,
   LfTrim147Comma32Percent,
   LfTrim152Comma02Percent,
   LfTrim156Comma63Percent,
   LfTrim161Comma38Percent,
   LfTrim165Comma90Percent,
   LfTrim170Comma42Percent
}Mcu_LfTrim;

typedef enum
{
   TiedLow_0 = 0,
   HclkSrc,
   ExtClock,
   TiedLow_3
}Mcu_EcpInSel;

typedef enum
{
   SleepMode = 0,
   StandbyMode,
   Reserved_2,
   ActiveMode
}Mcu_FlashPowerMode;



#define MCU_START_SEC_PBCFG
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Based on Autosar Memory Map strategy" */
#include "MemMap.h"

/**********************************************************************************************************************
 * Constants for Post-Build Configuration
 **********************************************************************************************************************/
/* SourceId : MCU_SourceId_029 */
/* DesignId : MCU_DesignId_019 */
/* Requirements : AR_MCU_SR119, AR_MCU_SR143 */
static CONST(Mcu_Sys1RegConfigType, MCU_PBCFG) Mcu_Sys1RegConfiguration =
{
	/*PLL Control Register 1(PLLCTL1)*/
	((0x00000000U)|(0U<<31U)|(2U<<29U)|(1U<<24U)|(0U<<23U)|(4U<<16U)|(0x6300U)),
	/*PLL Control Register 2(PLLCTL2)*/
	((0x00000000U)|(0U<<31U)|(255U<<22U)|(7U<<12U)|(1U<<9U)|(61U)),
	/* Clock Source Disable Clear Register (CSDISCLR) */
	((0x00000000U)|(STD_OFF<<EXTCLKIN2)|(STD_OFF<<PLL2)|(STD_ON<<HFLPO)|(STD_ON<<LFLPO)|(STD_OFF<<EXTCLKIN1)|(STD_ON<<PLL1)|(STD_ON<<OSCIN)),
	/*LPO/Clock Monitor Control Register(LPOMONCTL)*/
	((0x00000000U)|(1U<<24U)|(0U<<16U)|(HfTrim100Comma00Percent<<8U)|(LfTrim100Comma00Percent)),
	/* Clock Domain Disable Clear Register(CDDISCLR) */
	((0x00000000U)|(STD_ON<<GCLK)|(STD_ON<<HCLK)|(STD_ON<<VCLK)|(STD_ON<<VCLK2)|(STD_ON<<VCLKA1)|(STD_ON<<VCLKA2)|(STD_ON<<RTICLK1)|(STD_ON<<VCLK3)|(STD_ON<<VCLKA4)),
	/*GCLK, HCLK, VCLK and VCLK2 Source Register after Wakeup(GHVSRC)*/
	((0x00000000U)|(PLL1<<24U)|(PLL1<<16U)|(PLL1)),
	/*Clock Control Register(CLKCNTL)*/
	((0x00000000U)|(0U<<24U)|(0U<<16U)),
	/*RTI Clock Source Register(RCLKSRC)*/
	((0x00000000U)|(RtiClkDivideByOne<<8U)|(VCLK_SRC)),
	/*Peripheral Asynchronous Clock Source Register(VCLKASRC)*/
	((0x00000000U)|(VCLK_SRC<<8U)|(VCLK_SRC))
};

static CONST(Mcu_Sys2RegConfigType, MCU_PBCFG) Mcu_Sys2RegConfiguration =
{
	/*PLL Control Register 3(PLLCTL3)*/
	((0x00000000U)|(1U<<29U)|(1U<<24U)|(4U<<16U)|(0x6300U)),
	/*Clock 2 Control Register(CLK2CNTRL)*/
	((0x00000000U)|(0U)|(0U << 8U)),
	/*Peripheral Asynchronous Clock Configuration 1 Register (VCLKACON1)*/
	((0x00000000U)|(DivideByOne<<24U)|(STD_OFF<<20U)|(VCLK_SRC<<16U)),
};

static CONST(Mcu_PcrRegConfigType, MCU_PBCFG) Mcu_PcrRegConfiguration =
{
	/* Peripheral select quadrant clock power-down Register0 (PSPWRDWNCLR0)*/
	((0x00000000U)|(0xFU<<0U)|(0xFU<<4U)|(0xFU<<8U)|(0xFU<<24U)|(0xFU<<28U)),
	/* Peripheral select quadrant clock power-down Register1 (PSPWRDWNCLR1)*/
	((0x00000000U)|(0xFU<<0U)|(0xFU<<8U)|(0xFU<<16U)|(0xFU<<20U)|(0xFU<<28U)),
	/* Peripheral select quadrant clock power-down Register2 (PSPWRDWNCLR2)*/
	((0x00000000U)|(0xFU<<0U)|(0xFU<<4U)|(0xFU<<24U)|(0xFU<<28U)),
	/* Peripheral select quadrant clock power-down Register3 (PSPWRDWNCLR3)*/
	0x00000000U
};

static CONST(Mcu_FlsRegConfigType, MCU_PBCFG) Mcu_FlsRegConfiguration =
{
	/* Flash Option Control Register (FRDCNTL) */
	((0x00000000U)|(STD_ON<<0U)|(STD_ON<<4U)|(1U<<8U)),
	/* EEPROM Emulation Configuration Register (EEPROM_CONFIG) */
	((0x00000000U)|(5U<<16U)|(0U<<8U)|(2U)),
	/* Bank Fallback Power Register (FBFALLBACK) */
	((0x00000000U)|(ActiveMode<<0U)|(ActiveMode<<2U)|(ActiveMode<<14U)),
};

/* SourceId : MCU_SourceId_030 */
/* Requirements : AR_MCU_SR14, AR_MCU_SR121, AR_MCU_SR130, AR_MCU_SR131 */
static CONST(Mcu_ModeConfigType, MCU_PBCFG) Mcu_ModeConfig[3] =
{
    {
       MCU_DOZE_MODE
    },
    {
       MCU_SLEEP_MODE
    },
    {
       MCU_SNOOZE_MODE
    }
};


/* SourceId : MCU_SourceId_031 */
/* DesignId : MCU_DesignId_019 */
/* Requirements : AR_MCU_SR122, AR_MCU_SR132, AR_MCU_SR133, AR_MCU_SR134, AR_MCU_SR135 */
static CONST(Mcu_RamSectionConfigType, MCU_PBCFG) Mcu_RamSectionConfig[] =
{
    {
	   ((uint8*)0x08027f00),
	   0x00U,
	   256U
    }
};

#define MCU_STOP_SEC_PBCFG
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Based on Autosar Memory Map strategy" */
#include "MemMap.h"

#define  MCU_START_SEC_PBCFG_ROOT
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Based on Autosar Memory Map strategy" */
#include "MemMap.h"

/*<MCU_CFG_CONFIG>*/

/* SourceId : MCU_SourceId_041 */
/* DesignId : MCU_DesignId_019 */
/* Requirements : AR_MCU_SR124, AR_MCU_SR125, AR_MCU_SR126 */

CONST(Mcu_ConfigType, MCU_PBCFG) McuModuleConfiguration_0 =
{
	&Mcu_Sys1RegConfiguration, /* Mcu_Sys1RegConfig */
	&Mcu_Sys2RegConfiguration, /* Mcu_Sys2RegConfig */
	&Mcu_PcrRegConfiguration,  /* Mcu_PcrRegConfig */
	&Mcu_FlsRegConfiguration,  /* Mcu_FlsRegConfig */
	Mcu_ModeConfig,            /* Mcu_ModeConfig */
	3,                         /* Mcu_ModesNumber */
	1,                         /* Mcu_ClockSetting */
	Mcu_RamSectionConfig,      /* Mcu_ConfigRamSection */
	1                          /* Mcu_NumberOfRamSectors */
};

/*</MCU_CFG_CONFIG>*/
#define  MCU_STOP_SEC_PBCFG_ROOT
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Based on Autosar Memory Map strategy" */
#include "MemMap.h"
/**********************************************************************************************************************
 *  End of File: Mcu_PBcfg.c
 *********************************************************************************************************************/
