/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Port_PBcfg.c
 *      Project:  Tms570_AutosarPortDriver
 *       Module:  PortDriver
 *    Generator:  EB Tresos
 *
 *  Description:  This module implements a driver in ANSI C programming language to centralize the
 *                configuration of ports and pins which are used by more than one driver module.
 *                With this driver you can:
 *                - Configure all port pins
 *                - Initialize the configuration
 *                - Refresh the configuration (EMC purposes)
 *                - Switch the port pin configuration during runtime[not supported at this time]
 *
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Sunil Kumar T V
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author            Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.10.00       11Feb2013    Sapthagiri G     0000000000000   Initial version(adapted from TMS570LS31xx v01.10.00).
 * 02.20.00       29Aug2013    Sreyas K         SDOCM00103509   Changes for Production Version Champion
 * 02.21.00       30Sep2014    Vineeth T Alex   SDOCM00113123   Changes for 2.21.00 release; Files restructured
 * 02.21.01       23Aug2016    VishwanathReddy  SDOCM00122619   Update version info.
 * 02.30.00       01Dec2016    Sudhakar Singh         None      Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh   SDOCM00122834   Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/

/**********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01

	This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.
 *********************************************************************************************************************/

#define PORT_CFG_SOURCE

/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/
#include "Std_Types.h"
#include "Port.h"

/*  Cfg C Version identification  */
#define PORT_CFG_C_MAJOR_VERSION               (5U)
#define PORT_CFG_C_MINOR_VERSION               (30U)
#define PORT_CFG_C_PATCH_VERSION               (0U)


/*  Version checking  */
#if (   (PORT_SW_MAJOR_VERSION != PORT_CFG_C_MAJOR_VERSION) || \
    (PORT_SW_MINOR_VERSION != PORT_CFG_C_MINOR_VERSION))
  #error "Version numbers of Port_PBcfg.c and Port.h are inconsistent!"
#endif

#if (   (PORT_CFG_MAJOR_VERSION != PORT_CFG_C_MAJOR_VERSION) || \
    (PORT_CFG_MINOR_VERSION != PORT_CFG_C_MINOR_VERSION))
  #error "Version numbers of Port_PBcfg.c and Port_Cfg.h are inconsistent!"
#endif

/**********************************************************************************************************************
 *  LOCAL MACROS
 **********************************************************************************************************************/

 /*Function Macros*/
#define PORT_PIN_MODE_ADC       0x01U   
#define PORT_PIN_MODE_CAN       0x01U 
#define PORT_PIN_MODE_DIO       0x0U 
#define PORT_PIN_MODE_DIO_GPT   0x01U 
#define PORT_PIN_MODE_DIO_WDG   0x01U
#define PORT_PIN_MODE_FLEXRAY   0x01U
#define PORT_PIN_MODE_ICU       0x01U
#define PORT_PIN_MODE_LIN       0x01U 
#define PORT_PIN_MODE_MEM       0x01U
#define PORT_PIN_MODE_PWM       0x01U
#define PORT_PIN_MODE_SPI       0x01U
#define PORT_PIN_MODE_ECLK      0x01U
#define PORT_PIN_MODE_SCI       0x01U
#define PORT_PIN_MODE_IIC       0x01U

#define RESET     ((uint32)0x01U)
#define GIO_GCR   (*(volatile uint32 *)0xFFF7BC00U)
#define SCI_GCR   (*(volatile uint32 *)0xFFF7E500U)
#define LIN_GCR   (*(volatile uint32 *)0xFFF7E400U)
#define SPI1_GCR  (*(volatile uint32 *)0xFFF7F400U)
#define SPI2_GCR  (*(volatile uint32 *)0xFFF7F600U)
#define SPI3_GCR  (*(volatile uint32 *)0xFFF7F800U)
#define SPI4_GCR  (*(volatile uint32 *)0xFFF7FA00U)
#define SPI5_GCR  (*(volatile uint32 *)0xFFF7FC00U)
#define CAN1_GCR  (*(volatile uint32 *)0xFFF7DC00U)
#define CAN2_GCR  (*(volatile uint32 *)0xFFF7DE00U)
#define CAN3_GCR  (*(volatile uint32 *)0xFFF7E000U)
 
 
 
#define GIOA_USE    (STD_ON) 
#define GIOB_USE    (STD_ON) 
#define CAN1_USE    (STD_ON) 
#define CAN2_USE    (STD_ON) 
#define CAN3_USE    (STD_ON) 
#define SPI1_USE    (STD_ON) 
#define SPI2_USE    (STD_ON) 
#define SPI3_USE    (STD_ON) 
#define SPI4_USE    (STD_ON) 
#define SPI5_USE    (STD_ON) 
#define LIN_USE     (STD_ON) 
#define I2C_USE     (STD_ON) 
#define N2HET1_USE  (STD_ON) 
#define N2HET2_USE  (STD_ON) 
#define ADC1_USE    (STD_ON) 
#define ADC2_USE    (STD_ON) 
#define SCI_USE     (STD_ON) 
#define SYS_USE     (STD_ON) 

/* definition of the alternative pin mux values */
#define PORT_PIN_MUX_DEFAULT 0x01U
#define PORT_PIN_MUX_ALT_1   0x02U
#define PORT_PIN_MUX_ALT_2   0x04U
#define PORT_PIN_MUX_ALT_3   0x08U
#define PORT_PIN_MUX_ALT_4   0x10U
#define PORT_PIN_MUX_ALT_5   0x20U

/*Push pull level definition */
#define PORT_PUSH_PULL    0x00U
#define PORT_OPEN_DRAIN   0x01U

/* Pin Levels */
#define PORT_PIN_LEVEL_LOW   0x00U
#define PORT_PIN_LEVEL_HIGH  0x01U


/*Pull disable defines */
#define PORT_PULL_DISABLED  0x00U
#define PORT_PULL_UP        0x01U
#define PORT_PULL_DOWN      0x00U

/*Port Direction */
#define PORT_PIN_IN   0x00U
#define PORT_PIN_OUT  0x01U

/*Port Initial Values */
#define GIOA_INITIAL_VALUE  ((uint32)( (PORT_PIN_OUT<<0U)|(PORT_PIN_OUT<<1U)|(PORT_PIN_IN<<2U)|(PORT_PIN_OUT<<3U)|(PORT_PIN_OUT<<4U)|(PORT_PIN_IN<<5U)|(PORT_PIN_IN<<6U)|(PORT_PIN_IN<<7U)))
#define GIOB_INITIAL_VALUE  ((uint32)( (PORT_PIN_OUT<<0U)|(PORT_PIN_OUT<<1U)|(PORT_PIN_OUT<<2U)|(PORT_PIN_OUT<<3U)|(PORT_PIN_OUT<<4U)|(PORT_PIN_OUT<<5U)|(PORT_PIN_OUT<<6U)|(PORT_PIN_OUT<<7U)))
#define LIN_INITIAL_VALUE   ((uint32)( (PORT_PIN_IN<<1U)|(PORT_PIN_IN<<2U)))
#define SCI_INITIAL_VALUE   ((uint32)( (PORT_PIN_IN<<0U)|(PORT_PIN_IN<<1U)))
#define IIC_INITIAL_VALUE   ((uint32)( (PORT_PIN_IN<<0U)|(PORT_PIN_IN<<1U)))
#define SPI1_INITIAL_VALUE  ((uint32)( (PORT_PIN_IN<<9U)|(PORT_PIN_IN<<0U)|(PORT_PIN_IN<<1U)|(PORT_PIN_IN<<2U)|(PORT_PIN_IN<<3U)|(PORT_PIN_IN<<4U)|(PORT_PIN_IN<<5U)|(PORT_PIN_IN<<8U)|(PORT_PIN_IN<<10U)|(PORT_PIN_IN<<17U)|(PORT_PIN_IN<<11U)|(PORT_PIN_IN<<25U)))
#define SPI2_INITIAL_VALUE  ((uint32)( (PORT_PIN_IN<<9U)|(PORT_PIN_IN<<0U)|(PORT_PIN_IN<<1U)|(PORT_PIN_IN<<10U)|(PORT_PIN_IN<<11U)|(PORT_PIN_IN<<8U)))
#define SPI3_INITIAL_VALUE  ((uint32)( (PORT_PIN_IN<<9U)|(PORT_PIN_IN<<0U)|(PORT_PIN_IN<<1U)|(PORT_PIN_IN<<2U)|(PORT_PIN_IN<<3U)|(PORT_PIN_IN<<4U)|(PORT_PIN_IN<<5U)|(PORT_PIN_IN<<8U)|(PORT_PIN_IN<<10U)|(PORT_PIN_IN<<11U)))
#define SPI4_INITIAL_VALUE  ((uint32)( (PORT_PIN_IN<<9U)|(PORT_PIN_IN<<0U)|(PORT_PIN_IN<<8U)|(PORT_PIN_IN<<10U)|(PORT_PIN_IN<<11U)))
#define SPI5_INITIAL_VALUE  ((uint32)( (PORT_PIN_IN<<9U)|(PORT_PIN_IN<<0U)|(PORT_PIN_IN<<1U)|(PORT_PIN_IN<<2U)|(PORT_PIN_IN<<3U)|(PORT_PIN_IN<<8U)|(PORT_PIN_IN<<16U)|(PORT_PIN_IN<<17U)|(PORT_PIN_IN<<18U)|(PORT_PIN_IN<<19U)|(PORT_PIN_IN<<24U)|(PORT_PIN_IN<<25U)|(PORT_PIN_IN<<26U)|(PORT_PIN_IN<<27U)))
#define NHET1_INITIAL_VALUE  ((uint32)( (PORT_PIN_OUT<<0U)|(PORT_PIN_IN<<1U)|(PORT_PIN_IN<<2U)|(PORT_PIN_IN<<3U)|(PORT_PIN_IN<<4U)|(PORT_PIN_IN<<5U)|(PORT_PIN_OUT<<6U)|(PORT_PIN_IN<<7U)|(PORT_PIN_IN<<8U)|(PORT_PIN_IN<<9U)|(PORT_PIN_IN<<10U)|(PORT_PIN_IN<<11U)|(PORT_PIN_IN<<12U)|(PORT_PIN_IN<<13U)|(PORT_PIN_IN<<14U)|(PORT_PIN_IN<<15U)|(PORT_PIN_IN<<16U)|(PORT_PIN_IN<<17U)|(PORT_PIN_IN<<18U)|(PORT_PIN_IN<<19U)|(PORT_PIN_IN<<20U)|(PORT_PIN_IN<<21U)|(PORT_PIN_IN<<22U)|(PORT_PIN_IN<<23U)|(PORT_PIN_IN<<24U)|(PORT_PIN_IN<<25U)|(PORT_PIN_IN<<26U)|(PORT_PIN_IN<<27U)|(PORT_PIN_IN<<28U)|(PORT_PIN_IN<<29U)|(PORT_PIN_IN<<30U)|(PORT_PIN_IN<<31U)))
#define NHET2_INITIAL_VALUE  ((uint32)( (PORT_PIN_IN<<0U)|(PORT_PIN_IN<<1U)|(PORT_PIN_IN<<2U)|(PORT_PIN_IN<<3U)|(PORT_PIN_IN<<4U)|(PORT_PIN_IN<<5U)|(PORT_PIN_IN<<6U)|(PORT_PIN_IN<<7U)|(PORT_PIN_IN<<8U)|(PORT_PIN_IN<<9U)|(PORT_PIN_IN<<10U)|(PORT_PIN_IN<<11U)|(PORT_PIN_IN<<12U)|(PORT_PIN_IN<<13U)|(PORT_PIN_IN<<14U)|(PORT_PIN_IN<<15U)|(PORT_PIN_IN<<16U)|(PORT_PIN_IN<<17U)|(PORT_PIN_IN<<18U)))
#define SYS_INITIAL_VALUE    ((uint32)( (PORT_PIN_IN<<0U)))
#define ADC1_INITIAL_VALUE  ((uint32)( (PORT_PIN_IN<<0U)))
#define ADC2_INITIAL_VALUE  ((uint32)( (PORT_PIN_IN<<0U)))
#define CAN1_INITIAL_VALUE   ((uint32)((PORT_PIN_IN << 2) | (1<<3) | (PORT_PUSH_PULL << 16) | (1<< 18) | (0<< 17) | (PORT_PIN_LEVEL_HIGH<< 1)))
#define CAN1_INITIAL_VALUE_1  ((uint32)((PORT_PIN_IN << 2) | (1<<3) | (PORT_PUSH_PULL << 16) | (1<< 18) | (0<< 17) | (PORT_PIN_LEVEL_HIGH<< 1)))
#define CAN2_INITIAL_VALUE   ((uint32)((PORT_PIN_IN << 2) | (1<<3) | (PORT_PUSH_PULL << 16) | (1<< 18) | (0<< 17) | (PORT_PIN_LEVEL_LOW<< 1)))
#define CAN2_INITIAL_VALUE_1 ((uint32)((PORT_PIN_IN << 2) | (1<<3) | (PORT_PUSH_PULL << 16) | (1<< 18) | (0<< 17) | (PORT_PIN_LEVEL_LOW<< 1)))
#define CAN3_INITIAL_VALUE    ((uint32)((PORT_PIN_IN << 2) | (1<<3) | (PORT_PUSH_PULL << 16) | (1<< 18) | (0<< 17) | (PORT_PIN_LEVEL_LOW<< 1)))
#define CAN3_INITIAL_VALUE_1  ((uint32)((PORT_PIN_IN << 2) | (1<<3) | (PORT_PUSH_PULL << 16) | (1<< 18) | (0<< 17) | (PORT_PIN_LEVEL_LOW<< 1)))


/*Port Refresh Mask*/
#define PORT_GIOA_REFRESH_MASK  ((uint32)( (0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<6)|(0<<7)))
#define PORT_GIOB_REFRESH_MASK  ((uint32)( (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)))
#define PORT_CAN1_REFRESH_MASK  ((uint32)( (1<<0)|(1<<1)))
#define PORT_CAN2_REFRESH_MASK  ((uint32)( (1<<0)|(1<<1)))
#define PORT_CAN3_REFRESH_MASK  ((uint32)( (1<<0)|(1<<1)))
#define PORT_LIN_REFRESH_MASK   ((uint32)( (1<<1)|(1<<2)))
#define PORT_SCI_REFRESH_MASK   ((uint32)( (1<<0)|(1<<1)))
#define PORT_IIC_REFRESH_MASK   ((uint32)( (1<<0)|(1<<1)))
#define PORT_SPI1_REFRESH_MASK   ((uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<8)|(1<<10)|(1<<17)|(1<<11)|(1<<25)))
#define PORT_SPI2_REFRESH_MASK   ((uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<10)|(1<<11)|(1<<8)))
#define PORT_SPI3_REFRESH_MASK   ((uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<8)|(1<<10)|(1<<11)))
#define PORT_SPI4_REFRESH_MASK   ((uint32)( (1<<9)|(1<<0)|(1<<8)|(1<<10)|(1<<11)))
#define PORT_SPI5_REFRESH_MASK   ((uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<8)|(1<<16)|(1<<17)|(1<<18)|(1<<19)|(1<<24)|(1<<25)|(1<<26)|(1<<27)))
#define PORT_NHET1_REFRESH_MASK  ((uint32)( (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9)|(1<<10)|(1<<11)|(1<<12)|(1<<13)|(1<<14)|(1<<15)|(1<<16)|(1<<17)|(1<<18)|(1<<19)|(1<<20)|(1<<21)|(1<<22)|(1<<23)|(1<<24)|(1<<25)|(1<<26)|(1<<27)|(1<<28)|(1<<29)|(1<<30)|(1<<31)))
#define PORT_NHET2_REFRESH_MASK  ((uint32)( (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9)|(1<<10)|(1<<11)|(1<<12)|(1<<13)|(1<<14)|(1<<15)|(1<<16)|(1<<17)|(1<<18)))
#define PORT_SYS_REFRESH_MASK    ((uint32)( (1<<0)))
#define PORT_ADC1_REFRESH_MASK   ((uint32)( (1<<0)))
#define PORT_ADC2_REFRESH_MASK   ((uint32)( (1<<0)))


/**********************************************************************************************************************
 *  LOCAL CONSTANT MACROS
 **********************************************************************************************************************/

/*<PORT_MUX_BASE_ADDR>*/
#define PORT_BASE_ADDR_PINMUX_0  ((Port_RegisterPtrType)(0xFFFFEB10U))
#define PORT_BASE_ADDR_PINMUX_1  ((Port_RegisterPtrType)(0xFFFFEB14U))
#define PORT_BASE_ADDR_PINMUX_2  ((Port_RegisterPtrType)(0xFFFFEB18U))
#define PORT_BASE_ADDR_PINMUX_3  ((Port_RegisterPtrType)(0xFFFFEB1CU))
#define PORT_BASE_ADDR_PINMUX_4  ((Port_RegisterPtrType)(0xFFFFEB20U))
#define PORT_BASE_ADDR_PINMUX_5  ((Port_RegisterPtrType)(0xFFFFEB24U))
#define PORT_BASE_ADDR_PINMUX_6  ((Port_RegisterPtrType)(0xFFFFEB28U))
#define PORT_BASE_ADDR_PINMUX_7  ((Port_RegisterPtrType)(0xFFFFEB2CU))
#define PORT_BASE_ADDR_PINMUX_8  ((Port_RegisterPtrType)(0xFFFFEB30U))
#define PORT_BASE_ADDR_PINMUX_9  ((Port_RegisterPtrType)(0xFFFFEB34U))
#define PORT_BASE_ADDR_PINMUX_10  ((Port_RegisterPtrType)(0xFFFFEB38U))
#define PORT_BASE_ADDR_PINMUX_11  ((Port_RegisterPtrType)(0xFFFFEB3CU))
#define PORT_BASE_ADDR_PINMUX_12  ((Port_RegisterPtrType)(0xFFFFEB40U))
#define PORT_BASE_ADDR_PINMUX_13  ((Port_RegisterPtrType)(0xFFFFEB44U))
#define PORT_BASE_ADDR_PINMUX_14  ((Port_RegisterPtrType)(0xFFFFEB48U))
#define PORT_BASE_ADDR_PINMUX_15  ((Port_RegisterPtrType)(0xFFFFEB4CU))
#define PORT_BASE_ADDR_PINMUX_16  ((Port_RegisterPtrType)(0xFFFFEB50U))
#define PORT_BASE_ADDR_PINMUX_17  ((Port_RegisterPtrType)(0xFFFFEB54U))
#define PORT_BASE_ADDR_PINMUX_18  ((Port_RegisterPtrType)(0xFFFFEB58U))
#define PORT_BASE_ADDR_PINMUX_19  ((Port_RegisterPtrType)(0xFFFFEB5CU))
#define PORT_BASE_ADDR_PINMUX_20  ((Port_RegisterPtrType)(0xFFFFEB60U))
#define PORT_BASE_ADDR_PINMUX_21  ((Port_RegisterPtrType)(0xFFFFEB64U))
#define PORT_BASE_ADDR_PINMUX_22  ((Port_RegisterPtrType)(0xFFFFEB68U))
#define PORT_BASE_ADDR_PINMUX_23  ((Port_RegisterPtrType)(0xFFFFEB6CU))
#define PORT_BASE_ADDR_PINMUX_24  ((Port_RegisterPtrType)(0xFFFFEB70U))
#define PORT_BASE_ADDR_PINMUX_25  ((Port_RegisterPtrType)(0xFFFFEB74U))
#define PORT_BASE_ADDR_PINMUX_26  ((Port_RegisterPtrType)(0xFFFFEB78U))
#define PORT_BASE_ADDR_PINMUX_27  ((Port_RegisterPtrType)(0xFFFFEB7CU))
#define PORT_BASE_ADDR_PINMUX_28  ((Port_RegisterPtrType)(0xFFFFEB80U))
#define PORT_BASE_ADDR_PINMUX_29  ((Port_RegisterPtrType)(0xFFFFEB84U))
#define PORT_BASE_ADDR_PINMUX_30  ((Port_RegisterPtrType)(0xFFFFEB88U))
#define PORT_BASE_ADDR_PINMUX_31  ((Port_RegisterPtrType)(0xFFFFEB8CU))
#define PORT_BASE_ADDR_PINMUX_32  ((Port_RegisterPtrType)(0xFFFFEB90U))
#define PORT_BASE_ADDR_PINMUX_33  ((Port_RegisterPtrType)(0xFFFFEB94U))
#define PORT_BASE_ADDR_PINMUX_34  ((Port_RegisterPtrType)(0xFFFFEB98U))
#define PORT_BASE_ADDR_PINMUX_35  ((Port_RegisterPtrType)(0xFFFFEB9CU))
/*</PORT_MUX_BASE_ADDR>*/

/*<PORT_BCM_BASE_ADDR1>*/
#define PORT_BASE_ADDR_BCM_KICK_REG0       ((Port_RegisterPtrType)(0xFFFFEA38U))
/*</PORT_BCM_BASE_ADDR1>*/

/*<PORT_BCM_BASE_ADDR2>*/
#define PORT_BASE_ADDR_BCM_KICK_REG1       ((Port_RegisterPtrType)(0xFFFFEA3CU))
/*</PORT_BCM_BASE_ADDR2>*/

/*<PORT_BASE_ADDR>*/
#if 0
#define PORT_BASE_ADDR_GIOA      ((Port_RegisterPtrType)(0xFFF7BC30U))
#define PORT_BASE_ADDR_GIOB      ((Port_RegisterPtrType)(0xFFF7BC50U))
#define PORT_BASE_ADDR_CAN1      ((Port_RegisterPtrType)(0xFFF7DDE0U))
#define PORT_BASE_ADDR_CAN2      ((Port_RegisterPtrType)(0xFFF7DFE0U))
#define PORT_BASE_ADDR_CAN3      ((Port_RegisterPtrType)(0xFFF7E1E0U))
#define PORT_BASE_ADDR_LIN      ((Port_RegisterPtrType)(0xFFF7E43CU))
#define PORT_BASE_ADDR_SCI      ((Port_RegisterPtrType)(0xFFF7E53CU))
#define PORT_BASE_ADDR_IIC      ((Port_RegisterPtrType)(0xFFF7D448U))
#define PORT_BASE_ADDR_SPI1      ((Port_RegisterPtrType)(0xFFF7F414U))
#define PORT_BASE_ADDR_SPI2      ((Port_RegisterPtrType)(0xFFF7F614U))
#define PORT_BASE_ADDR_SPI3      ((Port_RegisterPtrType)(0xFFF7F814U))
#define PORT_BASE_ADDR_SPI4      ((Port_RegisterPtrType)(0xFFF7FA14U))
#define PORT_BASE_ADDR_SPI5      ((Port_RegisterPtrType)(0xFFF7FC14U))
#define PORT_BASE_ADDR_NHET1      ((Port_RegisterPtrType)(0xFFF7B848U))
#define PORT_BASE_ADDR_NHET2      ((Port_RegisterPtrType)(0xFFF7B948U))
#define PORT_BASE_ADDR_SYS      ((Port_RegisterPtrType)(0xFFFFFF00U))
#define PORT_BASE_ADDR_ADC1      ((Port_RegisterPtrType)(0xFFF7C0F8U))
#define PORT_BASE_ADDR_ADC2      ((Port_RegisterPtrType)(0xFFF7C2F8U))
#define PORT_BASE_ADDR_RTP      ((Port_RegisterPtrType)(0xFFFFFA34U))
#define PORT_BASE_ADDR_DMM      ((Port_RegisterPtrType)(0xFFFFF76CU))
#endif

/*<PORT_BASE_ADDR>*/
#define PORT_BASE_ADDR_GIOA  ((Port_RegisterPtrType)(4294425648))
#define PORT_BASE_ADDR_GIOB  ((Port_RegisterPtrType)(4294425680))
#define PORT_BASE_ADDR_CAN1   ((Port_RegisterPtrType)(4294434272))
#define PORT_BASE_ADDR_CAN2   ((Port_RegisterPtrType)(4294434784))
#define PORT_BASE_ADDR_CAN3  ((Port_RegisterPtrType)(4294435296))
#define PORT_BASE_ADDR_LIN   ((Port_RegisterPtrType)(4294435900))
#define PORT_BASE_ADDR_SCI   ((Port_RegisterPtrType)(4294440252))
#define PORT_BASE_ADDR_IIC   ((Port_RegisterPtrType)(4294431816))
#define PORT_BASE_ADDR_SPI1  ((Port_RegisterPtrType)(4294439956))
#define PORT_BASE_ADDR_SPI2  ((Port_RegisterPtrType)(4294440468))
#define PORT_BASE_ADDR_SPI3  ((Port_RegisterPtrType)(4294440980))
#define PORT_BASE_ADDR_SPI4  ((Port_RegisterPtrType)(4294441492))
#define PORT_BASE_ADDR_SPI5  ((Port_RegisterPtrType)(4294442004))
#define PORT_BASE_ADDR_NHET1 ((Port_RegisterPtrType)(4294424648))
#define PORT_BASE_ADDR_NHET2 ((Port_RegisterPtrType)(4294424904))
#define PORT_BASE_ADDR_SYS   ((Port_RegisterPtrType)(4294967040))
#define PORT_BASE_ADDR_ADC1  ((Port_RegisterPtrType)(4294426876))
#define PORT_BASE_ADDR_ADC2  ((Port_RegisterPtrType)(4294427388))



/*</PORT_BASE_ADDR>*/
 


/**********************************************************************************************************************
 *  GLOBAL DATA
 **********************************************************************************************************************/

/*<PORT_DEFAULT_SETTINGS>*/ 
#define PORT_OPEN_DRAIN_DEFAULT_0     (0x00000000U)
#define PORT_PULL_SELECT_DEFAULT_0    (0xFFFFFFFFU)
#define PORT_PULL_DISABLE_DEFAULT_0   (0x00000000U)
#define PORT_MODE_DEFAULT_0           (0x00000000U)
#define PORT_DATA_DEFAULT_0           (0x00000000U)
#define PORT_DIRECTION_DEFAULT_0      (0x00000000U)
#define PORT_SLEW_RATE_DEFAULT_0      (0x00000000U)

/*</PORT_DEFAULT_SETTINGS>*/


/**********************************************************************************************************************
 *  LOCAL FUNCTIONS
 **********************************************************************************************************************/

/*SAFETYMCUSW 580 S MR:1.1 <APPROVED> "Reason - This is the format for specifying memory sections" */
#define PORT_START_SEC_PBCODE
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format for specifying memory sections" */
#include "MemMap.h"

/*<PORT_INIT_FUNC>*/
FUNC(void, PORT_PBCODE) Port_InitPortRegs0( void )
{

/*</PORT_PIN_CHANNEL_LIST>*/
/* Requirement from safety manual */
#if  (STD_ON)   
/* ------------- Configuration of multiplexer -----------------------------------------------*/
	volatile uint32 temp;
  volatile uint32 mask;
  volatile uint32 writePattern;

	PORT_BASE_ADDR_BCM_KICK_REG0->Mux.GnrlRg_u32 = (uint32)(0x83e70b13U);    /* Unlock MMR Registers */
  PORT_BASE_ADDR_BCM_KICK_REG1->Mux.GnrlRg_u32 = (uint32)(0x95a4f1e0U);    /* Unlock MMR Registers */
		
  
  temp = PORT_BASE_ADDR_PINMUX_10->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_10->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_22->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_22->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_21->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_21->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_22->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_22->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_22->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 8U;
  mask = (uint32)(0xFFU << 8U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_22->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_23->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_23->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 24U;
  mask = (uint32)(0xFFU << 24U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_10->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_10->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_11->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_11->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_2->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_2->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_2->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_2->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_2->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 24U;
  mask = (uint32)(0xFFU << 24U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_2->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_3->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_3->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_4->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_4->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 24U;
  mask = (uint32)(0xFFU << 24U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_20->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_20->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_8->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 8U;
  mask = (uint32)(0xFFU << 8U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_8->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_9->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 24U;
  mask = (uint32)(0xFFU << 24U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_9->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_12->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_12->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 24U;
  mask = (uint32)(0xFFU << 24U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_9->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_9->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_7->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 8U;
  mask = (uint32)(0xFFU << 8U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_7->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_0->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 24U;
  mask = (uint32)(0xFFU << 24U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_0->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_0->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_0->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_9->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 8U;
  mask = (uint32)(0xFFU << 8U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_9->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 8U;
  mask = (uint32)(0xFFU << 8U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_27->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_27->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_12->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 24U;
  mask = (uint32)(0xFFU << 24U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_12->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 8U;
  mask = (uint32)(0xFFU << 8U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_5->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_5->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_4->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_4->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_5->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 8U;
  mask = (uint32)(0xFFU << 8U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_5->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_4->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 24U;
  mask = (uint32)(0xFFU << 24U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_4->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_5->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_5->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_7->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_7->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_6->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_6->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_6->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_6->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_17->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_17->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_1->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 8U;
  mask = (uint32)(0xFFU << 8U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_1->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_17->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_17->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_8->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_8->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_8->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_8->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_34->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_34->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_34->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 8U;
  mask = (uint32)(0xFFU << 8U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_34->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_34->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 16U;
  mask = (uint32)(0xFFU << 16U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_34->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_11->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 24U;
  mask = (uint32)(0xFFU << 24U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_11->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_12->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_12->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 8U;
  mask = (uint32)(0xFFU << 8U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_19->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 8U;
  mask = (uint32)(0xFFU << 8U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_19->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
  temp = PORT_BASE_ADDR_PINMUX_29->Mux.GnrlRg_u32;
  writePattern = PORT_PIN_MUX_DEFAULT << 0U;
  mask = (uint32)(0xFFU << 0U);
  temp &= ~mask;
  temp |= writePattern;
  PORT_BASE_ADDR_PINMUX_29->Mux.GnrlRg_u32 = (uint32)temp ;
  
  
 
  PORT_BASE_ADDR_BCM_KICK_REG0->Mux.GnrlRg_u32 = (uint32)(0xFFFFFFFFU);    /* Lock MMR Registers */
#endif
 /* SourceId : Port_SourceId_001 */
 /* DesignId : Port_DesignId_01  */
 /* Requirements : AR_PORT_SR9, AR_PORT_SR10, AR_PORT_SR11, AR_PORT_SR12, AR_PORT_SR16 */
    /* ------------- Configuration of ports used for genera IO, SPECIFIC functionality, Default settings--------------*/
 #if (STD_ON == GIOA_USE )     
    		
		/*reg manipulation*/
	GIO_GCR = RESET;
	PORT_BASE_ADDR_GIOA->Reg.PullSelect_u32 = (uint32)( (0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(1<<6)|(1<<7));
	PORT_BASE_ADDR_GIOA->Reg.PullDisable_u32 = (uint32)( (0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<6)|(0<<7));
	PORT_BASE_ADDR_GIOA->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<6)|(PORT_PUSH_PULL<<7));
	PORT_BASE_ADDR_GIOA->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<0)|(PORT_PIN_LEVEL_LOW<<1)|(PORT_PIN_LEVEL_LOW<<2)|(PORT_PIN_LEVEL_LOW<<3)|(PORT_PIN_LEVEL_LOW<<4)|(PORT_PIN_LEVEL_LOW<<5)|(PORT_PIN_LEVEL_LOW<<6)|(PORT_PIN_LEVEL_LOW<<7));
	PORT_BASE_ADDR_GIOA->Reg.Direction_u32 = GIOA_INITIAL_VALUE;


#else
    /* -- GIO A --  */
    PORT_BASE_ADDR_GIOA->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_GIOA->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_GIOA->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_GIOA->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_GIOA->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;

#endif


 #if (STD_ON == GIOB_USE ) 		
    		
/*reg manipulation*/
	PORT_BASE_ADDR_GIOB->Reg.PullSelect_u32 = (uint32)( (0<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7));
	PORT_BASE_ADDR_GIOB->Reg.PullDisable_u32 = (uint32)( (0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<6)|(0<<7));
	PORT_BASE_ADDR_GIOB->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<6)|(PORT_PUSH_PULL<<7));
	PORT_BASE_ADDR_GIOB->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<0)|(PORT_PIN_LEVEL_LOW<<1)|(PORT_PIN_LEVEL_LOW<<2)|(PORT_PIN_LEVEL_LOW<<3)|(PORT_PIN_LEVEL_LOW<<4)|(PORT_PIN_LEVEL_LOW<<5)|(PORT_PIN_LEVEL_LOW<<6)|(PORT_PIN_LEVEL_LOW<<7));
	PORT_BASE_ADDR_GIOB->Reg.Direction_u32 = GIOB_INITIAL_VALUE;
		
#else
 /* -- GIO B --  */
    PORT_BASE_ADDR_GIOB->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_GIOB->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_GIOB->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_GIOB->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_GIOB->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif		


#if (STD_ON == LIN_USE )
		
/*reg manipulation*/
    LIN_GCR = RESET;
	PORT_BASE_ADDR_LIN->Reg.PullSelect_u32 = (uint32)( (1<<1)|(1<<2));
	PORT_BASE_ADDR_LIN->Reg.PullDisable_u32 = (uint32)( (0<<1)|(0<<2));
	PORT_BASE_ADDR_LIN->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2));
	PORT_BASE_ADDR_LIN->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<1)|(PORT_PIN_LEVEL_LOW<<2));
	PORT_BASE_ADDR_LIN->Reg.Direction_u32 = LIN_INITIAL_VALUE;

	PORT_BASE_ADDR_LIN->Reg.Function_u32 = (uint32)((1<<1)|(1<<2));

#else
/* -- LIN --  */
    PORT_BASE_ADDR_LIN->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_LIN->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_LIN->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_LIN->Reg.Function_u32 = (uint32)0x00000000U;    /* Configuration of LIN Function Register */
    PORT_BASE_ADDR_LIN->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_LIN->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif


#if (STD_ON == SCI_USE )

/*reg manipulation*/
    SCI_GCR = RESET;
	PORT_BASE_ADDR_SCI->Reg.PullSelect_u32 = (uint32)( (1<<0)|(1<<1));
	PORT_BASE_ADDR_SCI->Reg.PullDisable_u32 = (uint32)( (0<<0)|(0<<1));
	PORT_BASE_ADDR_SCI->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1));
	PORT_BASE_ADDR_SCI->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<0)|(PORT_PIN_LEVEL_LOW<<1));
	PORT_BASE_ADDR_SCI->Reg.Direction_u32 = SCI_INITIAL_VALUE;
	PORT_BASE_ADDR_SCI->Reg.Function_u32 = (uint32)((0<<0)|(0<<1));
#else
/* -- SCI --  */
    PORT_BASE_ADDR_SCI->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_SCI->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_SCI->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_SCI->Reg.Function_u32 = (uint32)0x00000000U;    /* Configuration of SCI Function Register */
    PORT_BASE_ADDR_SCI->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_SCI->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif


#if (STD_ON == I2C_USE )

/*reg manipulation*/
	PORT_BASE_ADDR_IIC->Reg.PullSelect_u32 = (uint32)( (1<<0)|(1<<1));
	PORT_BASE_ADDR_IIC->Reg.PullDisable_u32 = (uint32)( (0<<0)|(0<<1));
	PORT_BASE_ADDR_IIC->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1));
	PORT_BASE_ADDR_IIC->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<0)|(PORT_PIN_LEVEL_LOW<<1));
	PORT_BASE_ADDR_IIC->Reg.Direction_u32 = IIC_INITIAL_VALUE ;
		PORT_BASE_ADDR_IIC->Reg.Function_u32 = (uint32)((0<<0)|(0<<1));
#else
 /* -- I2C --  */
    PORT_BASE_ADDR_IIC->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_IIC->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_IIC->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_IIC->Reg.Function_u32 = (uint32)0x00000000U;    /* Configuration of I2C Function Register */
    PORT_BASE_ADDR_IIC->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_IIC->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif


#if (STD_ON == SPI1_USE )
   
/*reg manipulation*/
    SPI1_GCR = RESET;
	PORT_BASE_ADDR_SPI1->Reg.PullSelect_u32 = (uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<8)|(1<<10)|(1<<17)|(1<<11)|(1<<25));
	PORT_BASE_ADDR_SPI1->Reg.PullDisable_u32 = (uint32)( (0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<8)|(0<<10)|(0<<17)|(0<<11)|(0<<25));
	PORT_BASE_ADDR_SPI1->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<17)|(PORT_PUSH_PULL<<11)|(PORT_PUSH_PULL<<25));
	PORT_BASE_ADDR_SPI1->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<9)|(PORT_PIN_LEVEL_LOW<<0)|(PORT_PIN_LEVEL_LOW<<1)|(PORT_PIN_LEVEL_LOW<<2)|(PORT_PIN_LEVEL_LOW<<3)|(PORT_PIN_LEVEL_LOW<<4)|(PORT_PIN_LEVEL_LOW<<5)|(PORT_PIN_LEVEL_LOW<<8)|(PORT_PIN_LEVEL_LOW<<10)|(PORT_PIN_LEVEL_LOW<<17)|(PORT_PIN_LEVEL_LOW<<11)|(PORT_PIN_LEVEL_LOW<<25));
	PORT_BASE_ADDR_SPI1->Reg.Direction_u32 =  SPI1_INITIAL_VALUE;
	PORT_BASE_ADDR_SPI1->Reg.Function_u32 = (uint32)((0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<8)|(0<<10)|(0<<17)|(0<<11)|(0<<25));
#else
/* -- MBSPI 1 --  */
    PORT_BASE_ADDR_SPI1->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_SPI1->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_SPI1->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_SPI1->Reg.Function_u32 = (uint32)0x00000000U;    /* Configuration of MBSPI 1 Function Register */
    PORT_BASE_ADDR_SPI1->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_SPI1->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif		


#if (STD_ON == SPI2_USE )
    
/*reg manipulation*/
    SPI2_GCR = RESET;
	PORT_BASE_ADDR_SPI2->Reg.PullSelect_u32 = (uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<10)|(1<<11)|(1<<8));
	PORT_BASE_ADDR_SPI2->Reg.PullDisable_u32 = (uint32)( (0<<9)|(0<<0)|(0<<1)|(0<<10)|(0<<11)|(0<<8));
	PORT_BASE_ADDR_SPI2->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<11)|(PORT_PUSH_PULL<<8));
	PORT_BASE_ADDR_SPI2->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<9)|(PORT_PIN_LEVEL_LOW<<0)|(PORT_PIN_LEVEL_LOW<<1)|(PORT_PIN_LEVEL_LOW<<10)|(PORT_PIN_LEVEL_LOW<<11)|(PORT_PIN_LEVEL_LOW<<8));
	PORT_BASE_ADDR_SPI2->Reg.Direction_u32 = SPI2_INITIAL_VALUE;
	PORT_BASE_ADDR_SPI2->Reg.Function_u32 = (uint32)((0<<9)|(0<<0)|(0<<1)|(0<<10)|(0<<11)|(0<<8));
#else
/* -- SPI 2 --  */
    PORT_BASE_ADDR_SPI2->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_SPI2->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_SPI2->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_SPI2->Reg.Function_u32 = (uint32)0x00000000U;    /* Configuration of SPI 2 Function Register */
    PORT_BASE_ADDR_SPI2->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_SPI2->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif		


#if (STD_ON == SPI3_USE )
    		
		/*reg manipulation*/
	SPI3_GCR = RESET;
	PORT_BASE_ADDR_SPI3->Reg.PullSelect_u32 = (uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<8)|(1<<10)|(1<<11));
	PORT_BASE_ADDR_SPI3->Reg.PullDisable_u32 = (uint32)( (0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<8)|(0<<10)|(0<<11));
	PORT_BASE_ADDR_SPI3->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<11));
	PORT_BASE_ADDR_SPI3->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<9)|(PORT_PIN_LEVEL_LOW<<0)|(PORT_PIN_LEVEL_LOW<<1)|(PORT_PIN_LEVEL_LOW<<2)|(PORT_PIN_LEVEL_LOW<<3)|(PORT_PIN_LEVEL_LOW<<4)|(PORT_PIN_LEVEL_LOW<<5)|(PORT_PIN_LEVEL_LOW<<8)|(PORT_PIN_LEVEL_LOW<<10)|(PORT_PIN_LEVEL_LOW<<11));
	PORT_BASE_ADDR_SPI3->Reg.Direction_u32 = SPI3_INITIAL_VALUE;
	PORT_BASE_ADDR_SPI3->Reg.Function_u32 = (uint32)((0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<8)|(0<<10)|(0<<11));
#else
/* -- MBSPI 3 --  */
    PORT_BASE_ADDR_SPI3->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_SPI3->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_SPI3->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_SPI3->Reg.Function_u32 = (uint32)0x00000000U;    /* Configuration of MBSPI 3 Function Register */
    PORT_BASE_ADDR_SPI3->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_SPI3->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif		


#if (STD_ON == SPI4_USE )
    
/*reg manipulation*/
    SPI4_GCR = RESET;
	PORT_BASE_ADDR_SPI4->Reg.PullSelect_u32 = (uint32)( (1<<9)|(1<<0)|(1<<8)|(1<<10)|(1<<11));
	PORT_BASE_ADDR_SPI4->Reg.PullDisable_u32 = (uint32)( (0<<9)|(0<<0)|(0<<8)|(0<<10)|(0<<11));
	PORT_BASE_ADDR_SPI4->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<11));
	PORT_BASE_ADDR_SPI4->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<9)|(PORT_PIN_LEVEL_LOW<<0)|(PORT_PIN_LEVEL_LOW<<8)|(PORT_PIN_LEVEL_LOW<<10)|(PORT_PIN_LEVEL_LOW<<11));
	PORT_BASE_ADDR_SPI4->Reg.Direction_u32 = SPI4_INITIAL_VALUE;
	PORT_BASE_ADDR_SPI4->Reg.Function_u32 = (uint32)((0<<9)|(0<<0)|(0<<8)|(0<<10)|(0<<11));
#else
/* -- SPI 4 --  */
    PORT_BASE_ADDR_SPI4->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_SPI4->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_SPI4->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_SPI4->Reg.Function_u32 = (uint32)0x00000000U;    /* Configuration of SPI 4 Function Register */
    PORT_BASE_ADDR_SPI4->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_SPI4->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif		



#if (STD_ON == SPI5_USE )

/*reg manipulation*/
    SPI5_GCR = RESET;
	PORT_BASE_ADDR_SPI5->Reg.PullSelect_u32 = (uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<8)|(1<<16)|(1<<17)|(1<<18)|(1<<19)|(1<<24)|(1<<25)|(1<<26)|(1<<27));
	PORT_BASE_ADDR_SPI5->Reg.PullDisable_u32 = (uint32)( (0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<8)|(0<<16)|(0<<17)|(0<<18)|(0<<19)|(0<<24)|(0<<25)|(0<<26)|(0<<27));
	PORT_BASE_ADDR_SPI5->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<16)|(PORT_PUSH_PULL<<17)|(PORT_PUSH_PULL<<18)|(PORT_PUSH_PULL<<19)|(PORT_PUSH_PULL<<24)|(PORT_PUSH_PULL<<25)|(PORT_PUSH_PULL<<26)|(PORT_PUSH_PULL<<27));
	PORT_BASE_ADDR_SPI5->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<9)|(PORT_PIN_LEVEL_LOW<<0)|(PORT_PIN_LEVEL_LOW<<1)|(PORT_PIN_LEVEL_LOW<<2)|(PORT_PIN_LEVEL_LOW<<3)|(PORT_PIN_LEVEL_LOW<<8)|(PORT_PIN_LEVEL_LOW<<16)|(PORT_PIN_LEVEL_LOW<<17)|(PORT_PIN_LEVEL_LOW<<18)|(PORT_PIN_LEVEL_LOW<<19)|(PORT_PIN_LEVEL_LOW<<24)|(PORT_PIN_LEVEL_LOW<<25)|(PORT_PIN_LEVEL_LOW<<26)|(PORT_PIN_LEVEL_LOW<<27));
	PORT_BASE_ADDR_SPI5->Reg.Direction_u32 = SPI5_INITIAL_VALUE;
	PORT_BASE_ADDR_SPI5->Reg.Function_u32 = (uint32)((0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<8)|(0<<16)|(0<<17)|(0<<18)|(0<<19)|(0<<24)|(0<<25)|(0<<26)|(0<<27));
#else
 /* -- MBSPI 5 --  */
    PORT_BASE_ADDR_SPI5->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_SPI5->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_SPI5->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_SPI5->Reg.Function_u32 = (uint32)0x00000000U;    /* Configuration of MBSPI 5 Function Register */
    PORT_BASE_ADDR_SPI5->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_SPI5->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif		


#if (STD_ON == N2HET1_USE )
    
/*reg manipulation*/
	PORT_BASE_ADDR_NHET1->Reg.PullSelect_u32 = (uint32)( (0<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(0<<6)|(1<<7)|(1<<8)|(1<<9)|(1<<10)|(1<<11)|(1<<12)|(1<<13)|(1<<14)|(1<<15)|(1<<16)|(1<<17)|(1<<18)|(1<<19)|(1<<20)|(1<<21)|(0<<22)|(1<<23)|(0<<24)|(1<<25)|(1<<26)|(1<<27)|(1<<28)|(1<<29)|(1<<30)|(1<<31));
	PORT_BASE_ADDR_NHET1->Reg.PullDisable_u32 = (uint32)( (0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<6)|(0<<7)|(0<<8)|(0<<9)|(0<<10)|(0<<11)|(0<<12)|(0<<13)|(0<<14)|(0<<15)|(0<<16)|(0<<17)|(0<<18)|(0<<19)|(0<<20)|(0<<21)|(0<<22)|(0<<23)|(0<<24)|(0<<25)|(0<<26)|(0<<27)|(0<<28)|(0<<29)|(0<<30)|(0<<31));
	PORT_BASE_ADDR_NHET1->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<6)|(PORT_PUSH_PULL<<7)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<11)|(PORT_PUSH_PULL<<12)|(PORT_PUSH_PULL<<13)|(PORT_PUSH_PULL<<14)|(PORT_PUSH_PULL<<15)|(PORT_PUSH_PULL<<16)|(PORT_PUSH_PULL<<17)|(PORT_PUSH_PULL<<18)|(PORT_PUSH_PULL<<19)|(PORT_PUSH_PULL<<20)|(PORT_PUSH_PULL<<21)|(PORT_PUSH_PULL<<22)|(PORT_PUSH_PULL<<23)|(PORT_PUSH_PULL<<24)|(PORT_PUSH_PULL<<25)|(PORT_PUSH_PULL<<26)|(PORT_PUSH_PULL<<27)|(PORT_PUSH_PULL<<28)|(PORT_PUSH_PULL<<29)|(PORT_PUSH_PULL<<30)|(PORT_PUSH_PULL<<31));
	PORT_BASE_ADDR_NHET1->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<0)|(PORT_PIN_LEVEL_LOW<<1)|(PORT_PIN_LEVEL_LOW<<2)|(PORT_PIN_LEVEL_LOW<<3)|(PORT_PIN_LEVEL_LOW<<4)|(PORT_PIN_LEVEL_LOW<<5)|(PORT_PIN_LEVEL_LOW<<6)|(PORT_PIN_LEVEL_LOW<<7)|(PORT_PIN_LEVEL_LOW<<8)|(PORT_PIN_LEVEL_LOW<<9)|(PORT_PIN_LEVEL_LOW<<10)|(PORT_PIN_LEVEL_LOW<<11)|(PORT_PIN_LEVEL_LOW<<12)|(PORT_PIN_LEVEL_LOW<<13)|(PORT_PIN_LEVEL_LOW<<14)|(PORT_PIN_LEVEL_LOW<<15)|(PORT_PIN_LEVEL_LOW<<16)|(PORT_PIN_LEVEL_LOW<<17)|(PORT_PIN_LEVEL_LOW<<18)|(PORT_PIN_LEVEL_LOW<<19)|(PORT_PIN_LEVEL_LOW<<20)|(PORT_PIN_LEVEL_LOW<<21)|(PORT_PIN_LEVEL_LOW<<22)|(PORT_PIN_LEVEL_LOW<<23)|(PORT_PIN_LEVEL_LOW<<24)|(PORT_PIN_LEVEL_LOW<<25)|(PORT_PIN_LEVEL_LOW<<26)|(PORT_PIN_LEVEL_LOW<<27)|(PORT_PIN_LEVEL_LOW<<28)|(PORT_PIN_LEVEL_LOW<<29)|(PORT_PIN_LEVEL_LOW<<30)|(PORT_PIN_LEVEL_LOW<<31));
	PORT_BASE_ADDR_NHET1->Reg.Direction_u32 = NHET1_INITIAL_VALUE;
		
#else
/* -- NHET1 --  */
    PORT_BASE_ADDR_NHET1->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_NHET1->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_NHET1->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_NHET1->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_NHET1->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif		

#if (STD_ON == N2HET2_USE )

/*reg manipulation*/
	PORT_BASE_ADDR_NHET2->Reg.PullSelect_u32 = (uint32)( (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9)|(1<<10)|(1<<11)|(1<<12)|(1<<13)|(1<<14)|(1<<15)|(1<<16)|(1<<17)|(1<<18));
	PORT_BASE_ADDR_NHET2->Reg.PullDisable_u32 = (uint32)( (0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<6)|(0<<7)|(0<<8)|(0<<9)|(0<<10)|(0<<11)|(0<<12)|(0<<13)|(0<<14)|(0<<15)|(0<<16)|(0<<17)|(0<<18));
	PORT_BASE_ADDR_NHET2->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<6)|(PORT_PUSH_PULL<<7)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<11)|(PORT_PUSH_PULL<<12)|(PORT_PUSH_PULL<<13)|(PORT_PUSH_PULL<<14)|(PORT_PUSH_PULL<<15)|(PORT_PUSH_PULL<<16)|(PORT_PUSH_PULL<<17)|(PORT_PUSH_PULL<<18));
	PORT_BASE_ADDR_NHET2->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<0)|(PORT_PIN_LEVEL_LOW<<1)|(PORT_PIN_LEVEL_LOW<<2)|(PORT_PIN_LEVEL_LOW<<3)|(PORT_PIN_LEVEL_LOW<<4)|(PORT_PIN_LEVEL_LOW<<5)|(PORT_PIN_LEVEL_LOW<<6)|(PORT_PIN_LEVEL_LOW<<7)|(PORT_PIN_LEVEL_LOW<<8)|(PORT_PIN_LEVEL_LOW<<9)|(PORT_PIN_LEVEL_LOW<<10)|(PORT_PIN_LEVEL_LOW<<11)|(PORT_PIN_LEVEL_LOW<<12)|(PORT_PIN_LEVEL_LOW<<13)|(PORT_PIN_LEVEL_LOW<<14)|(PORT_PIN_LEVEL_LOW<<15)|(PORT_PIN_LEVEL_LOW<<16)|(PORT_PIN_LEVEL_LOW<<17)|(PORT_PIN_LEVEL_LOW<<18));
	PORT_BASE_ADDR_NHET2->Reg.Direction_u32 = NHET2_INITIAL_VALUE;
		
#else
/* -- NHET2 --  */
    PORT_BASE_ADDR_NHET2->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_NHET2->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_NHET2->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_NHET2->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_NHET2->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif		



#if (STD_ON == SYS_USE )

/*reg manipulation*/
	PORT_BASE_ADDR_SYS->Reg.PullSelect_u32 = (uint32)( (1<<0));
	PORT_BASE_ADDR_SYS->Reg.PullDisable_u32 = (uint32)( (0<<0));
	PORT_BASE_ADDR_SYS->Reg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<0));
	PORT_BASE_ADDR_SYS->Reg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<0));
	PORT_BASE_ADDR_SYS->Reg.Direction_u32 = SYS_INITIAL_VALUE;
	PORT_BASE_ADDR_SYS->Reg.Function_u32 = (uint32)((0<<0));
#else
/* -- ECLK --  */
    PORT_BASE_ADDR_SYS->Reg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_SYS->Reg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_SYS->Reg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_SYS->Reg.SlewRate1_u32  = (uint32)PORT_SLEW_RATE_DEFAULT_0;
    PORT_BASE_ADDR_SYS->Reg.Function_u32 = (uint32)0x00000000U;    /* Configuration of ECLK Function Register */
    PORT_BASE_ADDR_SYS->Reg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_SYS->Reg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif		

#if (STD_ON == ADC1_USE )
   
/*reg manipulation*/
	PORT_BASE_ADDR_ADC1->AltReg.PullSelect_u32 = (uint32)( (1<<0));
	PORT_BASE_ADDR_ADC1->AltReg.PullDisable_u32 = (uint32)( (0<<0));
	PORT_BASE_ADDR_ADC1->AltReg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<0));
	PORT_BASE_ADDR_ADC1->AltReg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<0));
	PORT_BASE_ADDR_ADC1->AltReg.Direction_u32 = ADC1_INITIAL_VALUE;
		
#else
/* -- MibADC 1 --  */
    PORT_BASE_ADDR_ADC1->AltReg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_ADC1->AltReg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_ADC1->AltReg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_ADC1->AltReg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_ADC1->AltReg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif		


#if (STD_ON == ADC2_USE )

/*reg manipulation*/
	PORT_BASE_ADDR_ADC2->AltReg.PullSelect_u32 = (uint32)( (1<<0));
	PORT_BASE_ADDR_ADC2->AltReg.PullDisable_u32 = (uint32)( (0<<0));
	PORT_BASE_ADDR_ADC2->AltReg.OpenDrain_u32 = (uint32)( (PORT_PUSH_PULL<<0));
	PORT_BASE_ADDR_ADC2->AltReg.DataOut_u32 = (uint32)( (PORT_PIN_LEVEL_LOW<<0));
	PORT_BASE_ADDR_ADC2->AltReg.Direction_u32 = ADC2_INITIAL_VALUE;
		
#else
 /* -- MibADC 2 --  */
    PORT_BASE_ADDR_ADC2->AltReg.PullSelect_u32  = (uint32)PORT_PULL_SELECT_DEFAULT_0;
    PORT_BASE_ADDR_ADC2->AltReg.PullDisable_u32  = (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    PORT_BASE_ADDR_ADC2->AltReg.OpenDrain_u32  = (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    PORT_BASE_ADDR_ADC2->AltReg.DataOut_u32 = (uint32)PORT_DATA_DEFAULT_0;
    PORT_BASE_ADDR_ADC2->AltReg.Direction_u32 = (uint32)PORT_DIRECTION_DEFAULT_0;
#endif		

#if (STD_ON == CAN1_USE )
    PORT_BASE_ADDR_CAN1->Can.IoCtrl_0_u32 = CAN1_INITIAL_VALUE; 
	PORT_BASE_ADDR_CAN1->Can.IoCtrl_1_u32 = CAN1_INITIAL_VALUE_1;
#else
    PORT_BASE_ADDR_CAN1->Can.IoCtrl_0_u32 = (uint32)(0x00040000U);    /* Configuration of CAN 1 IO Ctrl 0 */
    PORT_BASE_ADDR_CAN1->Can.IoCtrl_1_u32 = (uint32)(0x00040000U);    /* Configuration of CAN 1 IO Ctrl 1 */
#endif		


#if (STD_ON == CAN2_USE )
    PORT_BASE_ADDR_CAN2->Can.IoCtrl_0_u32 = CAN2_INITIAL_VALUE;
    PORT_BASE_ADDR_CAN2->Can.IoCtrl_1_u32 = CAN2_INITIAL_VALUE_1;

#else
    PORT_BASE_ADDR_CAN2->Can.IoCtrl_0_u32 = (uint32)(0x00040000U);    /* Configuration of CAN 2 IO Ctrl 0 */
    PORT_BASE_ADDR_CAN2->Can.IoCtrl_1_u32 = (uint32)(0x00040000U);    /* Configuration of CAN 2 IO Ctrl 1 */

#endif		


#if (STD_ON == CAN3_USE )
    PORT_BASE_ADDR_CAN3->Can.IoCtrl_0_u32 = CAN3_INITIAL_VALUE;
    PORT_BASE_ADDR_CAN3->Can.IoCtrl_1_u32 = CAN3_INITIAL_VALUE_1;

#else
    PORT_BASE_ADDR_CAN3->Can.IoCtrl_0_u32 = (uint32)(0x00040000U);    /* Configuration of CAN 3 IO Ctrl 0 */
    PORT_BASE_ADDR_CAN3->Can.IoCtrl_1_u32 = (uint32)(0x00040000U);    /* Configuration of CAN 3 IO Ctrl 1 */

#endif	
	

		
    return;
}
/*</PORT_INIT_FUNC>*/
#if (STD_ON == PORT_SAFETI_API)
/* <Port_GetConfigRegValues>*/
/* Safety manual requirement: Read back of configuration registers*/
FUNC(void, PORT_PBCODE) Port_GetConfigRegValues_Config( uint8 initial, P2VAR(_PortConfigRegsType, AUTOMATIC, PORT_PBCFG) ConfigRegPtr )
{
#if  (STD_ON) 
/* ------------- Configuration of multiplexer -----------------------------------------------*/
	volatile uint32 temp;
	volatile uint32 mask;
	volatile uint32 writePattern;
#endif
	uint32 i = 0;
	/* Initialize everything to 0 */
	#if(PORT_CONFIG_REG_SIZE<138U)
		#error "Number of registers in the structure is less than the number of configurations from the GUI, Check Tresos"
	#endif
	for(i=0;i<PORT_CONFIG_REG_SIZE;i++)
	{
		ConfigRegPtr->configRegs[i]=0;
	}
	i=0;
#if  (STD_ON) 
/* ------------- Configuration of multiplexer -----------------------------------------------*/

	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_10->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_22->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_21->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_22->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 8;
	mask = (uint32)(0xFFU << 8);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_22->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_23->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 24;
	mask = (uint32)(0xFFU << 24);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_10->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_11->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_2->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_2->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 24;
	mask = (uint32)(0xFFU << 24);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_2->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_3->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_4->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 24;
	mask = (uint32)(0xFFU << 24);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_20->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 8;
	mask = (uint32)(0xFFU << 8);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_8->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 24;
	mask = (uint32)(0xFFU << 24);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_9->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_12->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 24;
	mask = (uint32)(0xFFU << 24);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_9->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 8;
	mask = (uint32)(0xFFU << 8);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_7->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 24;
	mask = (uint32)(0xFFU << 24);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_0->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_0->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 8;
	mask = (uint32)(0xFFU << 8);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_9->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 8;
	mask = (uint32)(0xFFU << 8);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_27->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 24;
	mask = (uint32)(0xFFU << 24);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_12->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 8;
	mask = (uint32)(0xFFU << 8);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_13->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_5->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_4->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 8;
	mask = (uint32)(0xFFU << 8);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_5->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 24;
	mask = (uint32)(0xFFU << 24);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_4->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_33->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_5->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_7->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_6->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_6->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_17->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 8;
	mask = (uint32)(0xFFU << 8);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_1->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_17->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_8->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_8->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_34->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 8;
	mask = (uint32)(0xFFU << 8);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_34->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 16;
	mask = (uint32)(0xFFU << 16);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_34->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 24;
	mask = (uint32)(0xFFU << 24);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_11->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_12->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 8;
	mask = (uint32)(0xFFU << 8);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_14->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 8;
	mask = (uint32)(0xFFU << 8);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_19->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
	temp = 0U;
	writePattern = PORT_PIN_MUX_DEFAULT << 0;
	mask = (uint32)(0xFFU << 0);
	temp |= writePattern;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_PINMUX_29->Mux.GnrlRg_u32 & mask) : (uint32)temp ;
	
#endif
 /* SourceId : Port_SourceId_001 */
 /* DesignId : Port_DesignId_01 */
 /* Requirements : AR_PORT_SR9, AR_PORT_SR10, AR_PORT_SR11, AR_PORT_SR12, AR_PORT_SR16 */
    /* ------------- Configuration of ports used for genera IO, SPECIFIC functionality, Default settings--------------*/
#if (STD_ON == GIOA_USE )

	/*reg manipulation*/
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? GIO_GCR : RESET;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOA->Reg.PullSelect_u32 : (uint32)( (0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(1<<6)|(1<<7));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOA->Reg.PullDisable_u32 : (uint32)( (0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<6)|(0<<7));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOA->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<6)|(PORT_PUSH_PULL<<7));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOA->Reg.Direction_u32 : (uint32)GIOA_INITIAL_VALUE;


#else
    /* -- GIO A --  */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOA->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOA->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOA->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOA->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0;

#endif

 #if (STD_ON == GIOB_USE )

/*reg manipulation*/
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOB->Reg.PullSelect_u32 : (uint32)( (0<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOB->Reg.PullDisable_u32 : (uint32)( (0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<6)|(0<<7));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOB->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<6)|(PORT_PUSH_PULL<<7));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOB->Reg.Direction_u32 : (uint32)GIOB_INITIAL_VALUE;

#else
 /* -- GIO B --  */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOB->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOB->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOB->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_GIOB->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0;
#endif

#if (STD_ON == LIN_USE )

   /*reg manipulation*/
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? LIN_GCR : RESET;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_LIN->Reg.PullSelect_u32 : (uint32)( (1<<1)|(1<<2));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_LIN->Reg.PullDisable_u32 : (uint32)( (0<<1)|(0<<2));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_LIN->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_LIN->Reg.Direction_u32 : (uint32)LIN_INITIAL_VALUE;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_LIN->Reg.Function_u32 : (uint32)((1<<1)|(1<<2));

#else
/* -- LIN --  */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_LIN->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_LIN->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_LIN->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_LIN->Reg.Function_u32 : (uint32)0x00000000U;    /* Configuration of LIN Function Register */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_LIN->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0;
#endif

#if (STD_ON == SCI_USE )

/*reg manipulation*/
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? SCI_GCR : RESET;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SCI->Reg.PullSelect_u32 : (uint32)( (1<<0)|(1<<1));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SCI->Reg.PullDisable_u32 : (uint32)( (0<<0)|(0<<1));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SCI->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SCI->Reg.Direction_u32 : (uint32)SCI_INITIAL_VALUE;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SCI->Reg.Function_u32 : (uint32)((0<<0)|(0<<1));
#else
/* -- SCI --  */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SCI->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SCI->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SCI->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SCI->Reg.Function_u32 : (uint32)0x00000000U;    /* Configuration of SCI Function Register */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SCI->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0;
#endif

#if (STD_ON == I2C_USE )

/*reg manipulation*/
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_IIC->Reg.PullSelect_u32 : (uint32)( (1<<0)|(1<<1));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_IIC->Reg.PullDisable_u32 : (uint32)( (0<<0)|(0<<1));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_IIC->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_IIC->Reg.Direction_u32 : (uint32)IIC_INITIAL_VALUE ;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_IIC->Reg.Function_u32 : (uint32)(((0<<0)|(0<<1)) & 0x1U);
#else
 /* -- I2C --  */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_IIC->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_IIC->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_IIC->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_IIC->Reg.Function_u32 : (uint32)0x00000000U;    /* Configuration of I2C Function Register */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_IIC->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0;
#endif

#if (STD_ON == SPI1_USE )

 /*reg manipulation*/
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? SPI1_GCR : RESET;
	ConfigRegPtr->configRegs[i++] = (uint32) ((0x2020F3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI1->Reg.PullSelect_u32 : (uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<8)|(1<<10)|(1<<17)|(1<<11)|(1<<25))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0x2020F3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI1->Reg.PullDisable_u32 : (uint32)( (0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<8)|(0<<10)|(0<<17)|(0<<11)|(0<<25))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0x2020F3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI1->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<17)|(PORT_PUSH_PULL<<11)|(PORT_PUSH_PULL<<25))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0x2020F3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI1->Reg.Direction_u32 :  (uint32)SPI1_INITIAL_VALUE));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0x2020F3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI1->Reg.Function_u32 : (uint32)((0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<8)|(0<<10)|(0<<17)|(0<<11)|(0<<25))));
#else
/* -- MBSPI 1 --  */
    ConfigRegPtr->configRegs[i++] = (uint32) ((0x2020F3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI1->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0x2020F3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI1->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0x2020F3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI1->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0x2020F3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI1->Reg.Function_u32 : (uint32)0x00000000U));    /* Configuration of MBSPI 1 Function Register */
    ConfigRegPtr->configRegs[i++] = (uint32) ((0x2020F3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI1->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0));
#endif

#if (STD_ON == SPI2_USE )

/*reg manipulation*/
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? SPI2_GCR : RESET;
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF03) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI2->Reg.PullSelect_u32 : (uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<10)|(1<<11)|(1<<8))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF03) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI2->Reg.PullDisable_u32 : (uint32)( (0<<9)|(0<<0)|(0<<1)|(0<<10)|(0<<11)|(0<<8))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF03) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI2->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<11)|(PORT_PUSH_PULL<<8))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF03) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI2->Reg.Direction_u32 : (uint32)SPI2_INITIAL_VALUE));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF03) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI2->Reg.Function_u32 : (uint32)((0<<9)|(0<<0)|(0<<1)|(0<<10)|(0<<11)|(0<<8))));
#else
/* -- SPI 2 --  */
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF03) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI2->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF03) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI2->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF03) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI2->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF03) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI2->Reg.Function_u32 : (uint32)0x00000000U));    /* Configuration of SPI 2 Function Register */
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF03) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI2->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0));
#endif

#if (STD_ON == SPI3_USE )

		/*reg manipulation*/
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? SPI3_GCR : RESET;
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI3->Reg.PullSelect_u32 : (uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<8)|(1<<10)|(1<<11))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI3->Reg.PullDisable_u32 : (uint32)( (0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<8)|(0<<10)|(0<<11))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI3->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<11))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI3->Reg.Direction_u32 : (uint32)SPI3_INITIAL_VALUE));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI3->Reg.Function_u32 : (uint32)((0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<8)|(0<<10)|(0<<11))));
#else
/* -- MBSPI 3 --  */
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI3->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI3->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI3->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI3->Reg.Function_u32 : (uint32)0x00000000U));    /* Configuration of MBSPI 3 Function Register */
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF3F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI3->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0));
#endif

#if (STD_ON == SPI4_USE )

/*reg manipulation*/
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? SPI4_GCR : RESET;
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF01) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI4->Reg.PullSelect_u32 : (uint32)( (1<<9)|(1<<0)|(1<<8)|(1<<10)|(1<<11))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF01) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI4->Reg.PullDisable_u32 : (uint32)( (0<<9)|(0<<0)|(0<<8)|(0<<10)|(0<<11))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF01) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI4->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<11))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF01) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI4->Reg.Direction_u32 : SPI4_INITIAL_VALUE));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xF01) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI4->Reg.Function_u32 : (uint32)((0<<9)|(0<<0)|(0<<8)|(0<<10)|(0<<11))));
#else
/* -- SPI 4 --  */
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF01) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI4->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF01) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI4->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF01) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI4->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF01) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI4->Reg.Function_u32 : (uint32)0x00000000U));    /* Configuration of SPI 4 Function Register */
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xF01) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI4->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0));
#endif

#if (STD_ON == SPI5_USE )

/*reg manipulation*/
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? SPI5_GCR : RESET;
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xE0E0F0F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI5->Reg.PullSelect_u32 : (uint32)( (1<<9)|(1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<8)|(1<<16)|(1<<17)|(1<<18)|(1<<19)|(1<<24)|(1<<25)|(1<<26)|(1<<27))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xE0E0F0F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI5->Reg.PullDisable_u32 : (uint32)( (0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<8)|(0<<16)|(0<<17)|(0<<18)|(0<<19)|(0<<24)|(0<<25)|(0<<26)|(0<<27))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xE0E0F0F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI5->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<16)|(PORT_PUSH_PULL<<17)|(PORT_PUSH_PULL<<18)|(PORT_PUSH_PULL<<19)|(PORT_PUSH_PULL<<24)|(PORT_PUSH_PULL<<25)|(PORT_PUSH_PULL<<26)|(PORT_PUSH_PULL<<27))));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xE0E0F0F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI5->Reg.Direction_u32 : (uint32)SPI5_INITIAL_VALUE));
	ConfigRegPtr->configRegs[i++] = (uint32) ((0xE0E0F0F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI5->Reg.Function_u32 : (uint32)((0<<9)|(0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<8)|(0<<16)|(0<<17)|(0<<18)|(0<<19)|(0<<24)|(0<<25)|(0<<26)|(0<<27))));
#else
 /* -- MBSPI 5 --  */
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xE0E0F0F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI5->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xE0E0F0F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI5->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xE0E0F0F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI5->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0));
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xE0E0F0F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI5->Reg.Function_u32 : (uint32)0x00000000U));    /* Configuration of MBSPI 5 Function Register */
    ConfigRegPtr->configRegs[i++] = (uint32) ((0xE0E0F0F) & ((initial == FALSE) ? PORT_BASE_ADDR_SPI5->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0));
#endif

#if (STD_ON == N2HET1_USE )

/*reg manipulation*/
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET1->Reg.PullSelect_u32 : (uint32)( (0<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(0<<6)|(1<<7)|(1<<8)|(1<<9)|(1<<10)|(1<<11)|(1<<12)|(1<<13)|(1<<14)|(1<<15)|(1<<16)|(1<<17)|(1<<18)|(1<<19)|(1<<20)|(1<<21)|(0<<22)|(1<<23)|(0<<24)|(1<<25)|(1<<26)|(1<<27)|(1<<28)|(1<<29)|(1<<30)|(1<<31));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET1->Reg.PullDisable_u32 : (uint32)( (0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<6)|(0<<7)|(0<<8)|(0<<9)|(0<<10)|(0<<11)|(0<<12)|(0<<13)|(0<<14)|(0<<15)|(0<<16)|(0<<17)|(0<<18)|(0<<19)|(0<<20)|(0<<21)|(0<<22)|(0<<23)|(0<<24)|(0<<25)|(0<<26)|(0<<27)|(0<<28)|(0<<29)|(0<<30)|(0<<31));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET1->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<6)|(PORT_PUSH_PULL<<7)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<11)|(PORT_PUSH_PULL<<12)|(PORT_PUSH_PULL<<13)|(PORT_PUSH_PULL<<14)|(PORT_PUSH_PULL<<15)|(PORT_PUSH_PULL<<16)|(PORT_PUSH_PULL<<17)|(PORT_PUSH_PULL<<18)|(PORT_PUSH_PULL<<19)|(PORT_PUSH_PULL<<20)|(PORT_PUSH_PULL<<21)|(PORT_PUSH_PULL<<22)|(PORT_PUSH_PULL<<23)|(PORT_PUSH_PULL<<24)|(PORT_PUSH_PULL<<25)|(PORT_PUSH_PULL<<26)|(PORT_PUSH_PULL<<27)|(PORT_PUSH_PULL<<28)|(PORT_PUSH_PULL<<29)|(PORT_PUSH_PULL<<30)|(PORT_PUSH_PULL<<31));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET1->Reg.Direction_u32 : (uint32)NHET1_INITIAL_VALUE;

#else
/* -- NHET1 --  */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET1->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET1->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET1->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET1->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0;
#endif

#if (STD_ON == N2HET2_USE )

/*reg manipulation*/
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET2->Reg.PullSelect_u32 : (uint32)( (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9)|(1<<10)|(1<<11)|(1<<12)|(1<<13)|(1<<14)|(1<<15)|(1<<16)|(1<<17)|(1<<18));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET2->Reg.PullDisable_u32 : (uint32)( (0<<0)|(0<<1)|(0<<2)|(0<<3)|(0<<4)|(0<<5)|(0<<6)|(0<<7)|(0<<8)|(0<<9)|(0<<10)|(0<<11)|(0<<12)|(0<<13)|(0<<14)|(0<<15)|(0<<16)|(0<<17)|(0<<18));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET2->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<0)|(PORT_PUSH_PULL<<1)|(PORT_PUSH_PULL<<2)|(PORT_PUSH_PULL<<3)|(PORT_PUSH_PULL<<4)|(PORT_PUSH_PULL<<5)|(PORT_PUSH_PULL<<6)|(PORT_PUSH_PULL<<7)|(PORT_PUSH_PULL<<8)|(PORT_PUSH_PULL<<9)|(PORT_PUSH_PULL<<10)|(PORT_PUSH_PULL<<11)|(PORT_PUSH_PULL<<12)|(PORT_PUSH_PULL<<13)|(PORT_PUSH_PULL<<14)|(PORT_PUSH_PULL<<15)|(PORT_PUSH_PULL<<16)|(PORT_PUSH_PULL<<17)|(PORT_PUSH_PULL<<18));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET2->Reg.Direction_u32 : (uint32)NHET2_INITIAL_VALUE;

#else
/* -- NHET2 --  */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET2->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET2->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET2->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_NHET2->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0;
#endif

#if (STD_ON == SYS_USE )

/*reg manipulation*/
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SYS->Reg.PullSelect_u32 : (uint32)( (1<<0));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SYS->Reg.PullDisable_u32 : (uint32)( (0<<0));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SYS->Reg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<0));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SYS->Reg.Direction_u32 : (uint32)SYS_INITIAL_VALUE;
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SYS->Reg.Function_u32 : (uint32)((0<<0));
#else
/* -- ECLK --  */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SYS->Reg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SYS->Reg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SYS->Reg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SYS->Reg.SlewRate1_u32  : (uint32)PORT_SLEW_RATE_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SYS->Reg.Function_u32 : (uint32)0x00000000U;    /* Configuration of ECLK Function Register */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_SYS->Reg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0;
#endif

#if (STD_ON == ADC1_USE )

/*reg manipulation*/
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC1->AltReg.PullSelect_u32 : (uint32)( (1<<0));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC1->AltReg.PullDisable_u32 : (uint32)( (0<<0));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC1->AltReg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<0));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC1->AltReg.Direction_u32 : (uint32)ADC1_INITIAL_VALUE;

#else
/* -- MibADC 1 --  */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC1->AltReg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC1->AltReg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC1->AltReg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC1->AltReg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0;
#endif

#if (STD_ON == ADC2_USE )

/*reg manipulation*/
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC2->AltReg.PullSelect_u32 : (uint32)( (1<<0));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC2->AltReg.PullDisable_u32 : (uint32)( (0<<0));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC2->AltReg.OpenDrain_u32 : (uint32)( (PORT_PUSH_PULL<<0));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC2->AltReg.Direction_u32 : (uint32)ADC2_INITIAL_VALUE;

#else
 /* -- MibADC 2 --  */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC2->AltReg.PullSelect_u32  : (uint32)PORT_PULL_SELECT_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC2->AltReg.PullDisable_u32  : (uint32)PORT_PULL_DISABLE_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC2->AltReg.OpenDrain_u32  : (uint32)PORT_OPEN_DRAIN_DEFAULT_0;
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? PORT_BASE_ADDR_ADC2->AltReg.Direction_u32 : (uint32)PORT_DIRECTION_DEFAULT_0;
#endif


#if (STD_ON == CAN1_USE )
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN1->Can.IoCtrl_0_u32 & (~0x3U)) : ((uint32)CAN1_INITIAL_VALUE & (~0x3U));
	ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN1->Can.IoCtrl_1_u32 & (~0x3U)) : ((uint32)CAN1_INITIAL_VALUE_1 & (~0x3U));
#else
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN1->Can.IoCtrl_0_u32 & (~0x3U)) : (uint32)(0x00040000U);    /* Configuration of CAN 1 IO Ctrl 0 */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN1->Can.IoCtrl_1_u32 & (~0x3U)) : (uint32)(0x00040000U);    /* Configuration of CAN 1 IO Ctrl 1 */
#endif

#if (STD_ON == CAN2_USE )
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN2->Can.IoCtrl_0_u32 & (~0x3U)) : ((uint32)CAN2_INITIAL_VALUE & (~0x3U));
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN2->Can.IoCtrl_1_u32 & (~0x3U)) : ((uint32)CAN2_INITIAL_VALUE_1 & (~0x3U));

#else
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN2->Can.IoCtrl_0_u32 & (~0x3U)) : (uint32)(0x00040000U);    /* Configuration of CAN 2 IO Ctrl 0 */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN2->Can.IoCtrl_1_u32 & (~0x3U)) : (uint32)(0x00040000U);    /* Configuration of CAN 2 IO Ctrl 1 */

#endif

#if (STD_ON == CAN3_USE )
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN3->Can.IoCtrl_0_u32 & (~0x3U)) : ((uint32)CAN3_INITIAL_VALUE & (~0x3U));
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN3->Can.IoCtrl_1_u32 & (~0x3U)) : ((uint32)CAN3_INITIAL_VALUE_1 & (~0x3U));

#else
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN3->Can.IoCtrl_0_u32 & (~0x3U)) : (uint32)(0x00040000U);    /* Configuration of CAN 3 IO Ctrl 0 */
    ConfigRegPtr->configRegs[i++] = (initial == FALSE) ? (PORT_BASE_ADDR_CAN3->Can.IoCtrl_1_u32 & (~0x3U)) : (uint32)(0x00040000U);    /* Configuration of CAN 3 IO Ctrl 1 */
#endif

    return;
}
#endif
/* </Port_GetConfigRegValues>*/
#define PORT_STOP_SEC_PBCODE
#include "MemMap.h"


#define PORT_START_SEC_PBCFG
#include "MemMap.h"
#if ( STD_ON == PORT_REFRESH_PORT_DIRECTION_API )
/*<PORT_REFRESHFUNC>*/
static CONST( Port_RefreshConfigType, PORT_PBCFG) Port_RefreshConfig0_at[] =
{ 
    /* ------- Configuration of refreshable direction registers -------
     *  1. Register address
     *  2. Value which has to be written to this register
     *  3. Information which bits can be refreshed (refresh-mask):
     *     ( 1 = refreshable,  0  not refreshable)
     *    Note: All pins which are set as pin-channels have to be set
     *          in the appropriate pin mask to 0
     * ----------------------------------------------------------------  */
     { (Port_RegisterPtrType)(PORT_BASE_ADDR_GIOA  ), (uint32)(GIOA_INITIAL_VALUE ), (uint32)(PORT_GIOA_REFRESH_MASK) }
    ,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_GIOB  ), (uint32)(GIOB_INITIAL_VALUE ), (uint32)(PORT_GIOB_REFRESH_MASK ) }
	,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_LIN   ), (uint32)(LIN_INITIAL_VALUE ), (uint32)(PORT_LIN_REFRESH_MASK  ) }
	,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_SCI   ), (uint32)(SCI_INITIAL_VALUE ), (uint32)(PORT_SCI_REFRESH_MASK  ) }
	,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_IIC   ), (uint32)(IIC_INITIAL_VALUE ), (uint32)(PORT_IIC_REFRESH_MASK  ) }
    ,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_SPI1  ), (uint32)(SPI1_INITIAL_VALUE ), (uint32)(PORT_SPI1_REFRESH_MASK ) }
	,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_SPI2  ), (uint32)(SPI2_INITIAL_VALUE ), (uint32)(PORT_SPI2_REFRESH_MASK ) }
    ,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_SPI3  ), (uint32)(SPI3_INITIAL_VALUE), (uint32)(PORT_SPI3_REFRESH_MASK ) }
    ,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_SPI4  ), (uint32)(SPI4_INITIAL_VALUE), (uint32)(PORT_SPI4_REFRESH_MASK ) }
	,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_SPI5  ), (uint32)(SPI5_INITIAL_VALUE  ), (uint32)(PORT_SPI5_REFRESH_MASK ) }
	,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_NHET1 ), (uint32)(NHET1_INITIAL_VALUE ), (uint32)(PORT_NHET1_REFRESH_MASK) }
	,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_NHET2 ), (uint32)(NHET2_INITIAL_VALUE ), (uint32)(PORT_NHET2_REFRESH_MASK) }
    ,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_SYS   ), (uint32)(SYS_INITIAL_VALUE  ), (uint32)(PORT_SYS_REFRESH_MASK  ) }
	,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_ADC1  ), (uint32)(ADC1_INITIAL_VALUE ), (uint32)(PORT_ADC1_REFRESH_MASK ) }
	,{ (Port_RegisterPtrType)(PORT_BASE_ADDR_ADC2  ), (uint32)(ADC2_INITIAL_VALUE), (uint32)(PORT_ADC2_REFRESH_MASK ) }
	};
/*</PORT_REFRESHFUNC>*/
#endif

/**********************************************************************************************************************
 *  GLOBAL DATA
 **********************************************************************************************************************/
#if ( STD_ON == PORT_SET_PIN_DIRECTION_API )
/*<PORT_PINCHANNELCONFIG>*/
static CONST( uint32, PORT_PBCFG ) Port_PinChannelConfig0_at[] =
{

    /* ----------------- Configuration of pin channels ----------------
    *
    *          | Lower 24-Bits of Base Addr | Pin Number |
    *          31                           8            0 
    *
    *  Note: The following channels can be accessed by a symbolic name.
    *        This channel-names have to be created and its values
    *        represent the index of the following table.
    * ----------------------------------------------------------------  */
    
    (0xf7bc3000),
    (0xf7bc3001),
    (0xf7bc3002),
    (0xf7bc3003),
    (0xf7bc3004),
    (0xf7bc3005),
    (0xf7bc3006),
    (0xf7bc3007),
};
/*</PORT_PINCHANNELCONFIG>*/
#endif

#define PORT_STOP_SEC_PBCFG
#include "MemMap.h"

#define PORT_START_SEC_PBCFG_ROOT
#include "MemMap.h"

/*<PORT_CONFIGURATION>*/
CONST( Port_ConfigType, PORT_PBCFG) Port_Runtime =
{
     Port_InitPortRegs0
	 #if ( STD_ON == PORT_REFRESH_PORT_DIRECTION_API )
    ,Port_RefreshConfig0_at
	#endif
	#if ( STD_ON == PORT_SET_PIN_DIRECTION_API )
    ,Port_PinChannelConfig0_at
	#endif
    #if ( STD_ON == PORT_REFRESH_PORT_DIRECTION_API )
    ,(uint8)15U
    #endif
	#if ( STD_ON == PORT_SET_PIN_DIRECTION_API )
    ,(uint8)8U
	#endif
};
/*</PORT_CONFIGURATION>*/

/*SAFETYMCUSW 580 S MR:1.1 <APPROVED> "Reason - Start Section Code is also defined Port.h" */
#define PORT_STOP_SEC_PBCFG_ROOT
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format for specifying memory sections" */
#include "MemMap.h"

/**********************************************************************************************************************
 *  END OF FILE: Port_PBcfg.c                                                                                         *
 **********************************************************************************************************************/


