/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Pwm_PBCfg.c
 *      Project:  Tms570_AutosarPwmDriver
 *       Module:  DriverPwm
 *    Generator:  EB Tresos
 *
 *  Description:  This component provides services for initialization and control of the microcontroller internal
 *                PWM unit (pulse width modulation). The PWM module generates pulses with variable pulse width. 
 *                It allows the selection of the duty cycle and the signal period time.
 *  
 *********************************************************************************************************************/

/**********************************************************************************************************************
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Vineeth Thomas Alex
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version     Date           Author                   Change ID          Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.21.00    30Sep2014     Vineeth Thomas Alex      SDOCM00113122      Initial version adapted from TMS570LS3137
 * 02.21.01    23Aug2016     Vishwanath Reddy         SDOCM00122620      Vresion info updated.
 * 02.30.00    01Dec2016     Sudhakar Singh           None               Update version info
 * 05.30.00    15Mar2017     Sudhakar Singh           SDOCM00122834      Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/

/**********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
	This file is generated by EB Tresos
    Do not modify this file, otherwise the software may behave in unexpected way.
 *********************************************************************************************************************/
#define PWM_CFG_SOURCE
/**********************************************************************************************************************
 *  INCLUDES
 *********************************************************************************************************************/

#include "Std_Types.h"
#include "Pwm_Het.h"
#include "Pwm.h"
#include "Pwm_Cfg.h"
/**********************************************************************************************************************
 *  VERSION CHECK
 *********************************************************************************************************************/
#define PWM_CFG_C_MAJOR_VERSION               (5U)
#define PWM_CFG_C_MINOR_VERSION               (30U)
#define PWM_CFG_C_PATCH_VERSION               (0U)

/* ---- Perform version checking  ----------------------------------------- */
#if (   (PWM_SW_MAJOR_VERSION != PWM_CFG_C_MAJOR_VERSION) \
     || (PWM_SW_MINOR_VERSION != PWM_CFG_C_MINOR_VERSION))
  #error "Version numbers of Pwm_PBcfg.c and Pwm.h are inconsistent!"
#endif

#if (   (PWM_CFG_MAJOR_VERSION != PWM_CFG_C_MAJOR_VERSION) \
     || (PWM_CFG_MINOR_VERSION != PWM_CFG_C_MINOR_VERSION))
  #error "Version numbers of Pwm_PBcfg.c and Pwm_Cfg.h are inconsistent!"
#endif

#define PWM_START_SEC_CONST_PBCFG
#include "MemMap.h"

/* SourceId : PWM_SourceId_047 */
/* DesignId : PWM_DesignId_25  */
/* Requirements : AR_PWM_SR107, AR_PWM_SR108, AR_PWM_SR109, AR_PWM_SR110, AR_PWM_SR111, AR_PWM_SR99, AR_PWM_SR112,
 * AR_PWM_SR113, AR_PWM_SR114, AR_PWM_SR115 */
/* Pwm Channel Configuration parameters */
static CONST(Pwm_ChannelConfigType, PWM_PBCFG) Pwm_ChannelCfg0 [] =
{
  {
    PWM_VARIABLE_PERIOD,
    781U,/* Default Period Length */
    PWM_HIGH,/* Idle State */
    PWM_HIGH,/* Polarity */
    16384U,/* Default Dutycycle out of 0x8000 */
    NULL_PTR,/*Notification Function*/
    HET1,/*HET used*/
    0U/* Output Pin */
  }
};
/*</PWM_HET1_PROGRAM>*/


static CONST(Het_Pwm_InstructionType, PWM_PBCFG) Pwm_Het1ProgramBlock1_Cfg0 [] =
{
   {0x00060C80U,0x01FFFFFFU,0xFFFFFF80U,0x0U}   /* Pwm HET1 Global CNT */
};

static CONST(Het_Pwm_InstructionType, PWM_PBCFG) Pwm_Het1ProgramBlock0_Cfg0 [] = 
{
  {0x000a15c0U,0x4a001eU,0x00000000U,0x0U}  /* Pwm Chl0 PWCNT */
};

static CONST(Het_Pwm_InstructionType, PWM_PBCFG) Pwm_Het1ProgramBlock2_Cfg0 [] = 
{
  {0x00063480U,0x000c0006U,0x00000000U,0x0U}  /* Pwm Chl0 DJZ */
};

static CONST(Het_Pwm_InstructionType, PWM_PBCFG) Pwm_Het1ProgramBlock3_Cfg0 [] =
{
  {0x000e0230U,0x4a001eU,0x0000c380U,0x0U}  /* Pwm Chl0 MOV64 DutyCycle */
};

static CONST(Het_Pwm_InstructionType, PWM_PBCFG) Pwm_Het1ProgramBlock4_Cfg0 [] =
{
  {0x00062250U,0x000c0006U,0x00018600U,0x0U}  /* Pwm Chl0 MOV64 Period */
};

static CONST(Het_Pwm_BlockType, PWM_PBCFG) Pwm_Het1Program_Cfg0[] =
{
    { Pwm_Het1ProgramBlock0_Cfg0, 1U },
    { Pwm_Het1ProgramBlock1_Cfg0, 1U},
    { Pwm_Het1ProgramBlock2_Cfg0, 1U },
    { Pwm_Het1ProgramBlock3_Cfg0, 1U },
    { Pwm_Het1ProgramBlock4_Cfg0, 1U }
};
/*</PWM_HET1_PROGRAM>*/


/*</PWM_HET2_PROGRAM>*/


static CONST(Het_Pwm_InstructionType, PWM_PBCFG) Pwm_Het2ProgramBlock1_Cfg0 [] =
{
   {0x00000000U,0x00000000U,0x00000000U,0x0U} /*void*/
};

static CONST(Het_Pwm_InstructionType, PWM_PBCFG) Pwm_Het2ProgramBlock0_Cfg0 [] = 
{
  {0x00000000U,0x00000000U,0x00000000U,0x00U}
};

static CONST(Het_Pwm_InstructionType, PWM_PBCFG) Pwm_Het2ProgramBlock2_Cfg0 [] = 
{
  {0x00000000U,0x00000000U,0x00000000U,0x00U}
};

static CONST(Het_Pwm_InstructionType, PWM_PBCFG) Pwm_Het2ProgramBlock3_Cfg0 [] =
{
  {0x00000000U,0x00000000U,0x00000000U,0x00U}
};

static CONST(Het_Pwm_InstructionType, PWM_PBCFG) Pwm_Het2ProgramBlock4_Cfg0 [] =
{
  {0x00000000U,0x00000000U,0x00000000U,0x00U}
};

static CONST(Het_Pwm_BlockType, PWM_PBCFG) Pwm_Het2Program_Cfg0[] =
{
    { Pwm_Het2ProgramBlock0_Cfg0, 0U },
    { Pwm_Het2ProgramBlock1_Cfg0, 0U},
    { Pwm_Het2ProgramBlock2_Cfg0, 0U },
    { Pwm_Het2ProgramBlock3_Cfg0, 0U },
    { Pwm_Het2ProgramBlock4_Cfg0, 0U }
};
/*</PWM_HET2_PROGRAM>*/

/* global pwm runtime configuration Het1,Het2*/
/*<PWM_CONFIGURATION>*/
CONST(Pwm_ConfigType, PWM_PBCFG) PwmChannelConfigSet_0 =
{
    Pwm_Het1Program_Cfg0,
    Pwm_Het2Program_Cfg0,
    Pwm_ChannelCfg0,
    1U
};

/*</PWM_CONFIGURATION>*/
/*SAFETYMCUSW 580 S MR:1.1 <APPROVED> "Reason - This is the format for specifying memory sections" */
#define PWM_STOP_SEC_CONST_PBCFG
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format for specifying memory sections" */
#include "MemMap.h"

/**********************************************************************************************************************
 *  END OF FILE: Pwm_PBcfg.c                                                                                          *
 *********************************************************************************************************************/
