/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2014.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *  File:       Wdg_PBCfg.c
 *  Project:    Tms570_AutosarWdgDriver
 *  Module:     Wdg
 *  Generator:  Elektrobit Tresos
 *
 *  Description:  The Wdg Driver provides services for initialization, changing the operation mode and setting the
 *                trigger condition (timeout).
 *
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Enrique Lizarraga
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author                 Change ID       Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.21.00       30Sep2014    Enrique Lizarraga      SDOCM00112272   -Initial Release
 * 02.21.01       29Feb2016    Enrique Lizarraga      SDOCM00121247   -Update version info
 * 02.30.00       01Dec2016    Sudhakar Singh         None            -Update version info
 * 05.30.00       15Mar2017    Sudhakar Singh         SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 *
 *********************************************************************************************************************/

/*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
*********************************************************************************************************************/

/* Module switch */
#define WDG_PBCFG_SOURCE

/**********************************************************************************************************************
 * Standard Header Files
 **********************************************************************************************************************/

/*********************************************************************************************************************
 * Other Header Files
 *********************************************************************************************************************/
#include "Wdg.h"

/**********************************************************************************************************************
 *  Version Check
 *********************************************************************************************************************/
#define WDG_CFG_C_MAJOR_VERSION               (5U)
#define WDG_CFG_C_MINOR_VERSION               (30U)
#define WDG_CFG_C_PATCH_VERSION               (0U)

/*  Version checking  */
 #if (   (WDG_SW_MAJOR_VERSION != WDG_CFG_C_MAJOR_VERSION)||\
         (WDG_SW_MINOR_VERSION != WDG_CFG_C_MINOR_VERSION))
  #error "Version numbers of Wdg_PBcfg.c and Wdg.h are inconsistent!"
#endif

#if (   (WDG_CFG_MAJOR_VERSION != WDG_CFG_C_MAJOR_VERSION) || \
        (WDG_CFG_MINOR_VERSION != WDG_CFG_C_MINOR_VERSION))
  #error "Version numbers of Wdg_PBcfg.c and Wdg_Cfg.h are inconsistent!"
#endif

/**********************************************************************************************************************
 * Local Preprocessor #define Constants
 **********************************************************************************************************************/

/**********************************************************************************************************************
 * Local Preprocessor #define Macros
 **********************************************************************************************************************/

/**********************************************************************************************************************
 * Local Data Types and Structures
 **********************************************************************************************************************/

/**********************************************************************************************************************
 * Constants for Post-Build Configuration
 **********************************************************************************************************************/
#define  WDG_START_SEC_CONST_16
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Based on Autosar Memory Map strategy" */
#include "MemMap.h"

/*<WDG_CFG_CONFIG>*/
/* SourceId : WDG_SourceId_016 */
/* DesignId : WDG_DesignId_007 */
/* Requirements : AR_WDG_SR56 */
CONST(Wdg_ConfigType, WDG_PBCFG) WdgSettingsConfig_0 =
{
   WDGIF_FAST_MODE
};

/*</WDG_CFG_CONFIG>*/
#define  WDG_STOP_SEC_CONST_16
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Based on Autosar Memory Map strategy" */
#include "MemMap.h"
/**********************************************************************************************************************
 *  End of File: Wdg_PBcfg.c
 *********************************************************************************************************************/
