/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments - 2014.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Fee_Cfg.c
 *      Project:  Tms570_TIFEEDriver
 *       Module:  FeeDriver Configuration Header File Fee_Cfg.c
 *    Generator:  EB Tresos
 *
 *  Description:  This file is generated by EB Tresos.Do not modify this file, otherwise the software may 
 *                behave in unexpected way.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  Vishwanath Reddy
 *---------------------------------------------------------------------------------------------------------------------
 * Template Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 02.21.00       30Sept2014   Vishwanath reddy     SDOCM00113128    Initial Version
 * 02.21.01       30June2016   Vishwanath Reddy     SDOCM00122388    Update patch version FEE_SW_PATCH_VERSION.
 * 02.21.02       04Augu2016   Vishwanath Reddy     SDOCM00122571    Update patch version FEE_SW_PATCH_VERSION.
 * 02.21.03       23Augu2016   Vishwanath Reddy     SDOCM00122617    Update patch version FEE_SW_PATCH_VERSION.
 * 02.30.00       01Dec2016    Sudhakar Singh           None         Update version info 
 * 05.30.00       15Mar2017    Sudhakar Singh       SDOCM00122834    Version supports TMS570LSxx Family of Devices.
 *********************************************************************************************************************/

 /*********************************************************************************************************************
    Project: TMS570LS07_Sample_Config
	Date   : 2018-03-14 10:10:01 
	
    This file is generated by EB Tresos 
    Do not modify this file, otherwise the software may behave in unexpected way.
    
 *********************************************************************************************************************/

/* Include Files                                                              */

#include "Fee.h"
#include "Fee_Cbk.h"
#include "SchM_Fee.h"

/*----------------------------------------------------------------------------*/
/* Fee Version Check                                                          */
#define FEE_CFG_C_MAJOR_VERSION               (5U)
#define FEE_CFG_C_MINOR_VERSION               (30U)
#define FEE_CFG_C_PATCH_VERSION               (0U)

#if (FEE_AR_MAJOR_VERSION != 0x04U)
    #error Fee_Cfg.c: FEE_AR_MAJOR_VERSION of Fee.h is incompatible.
#endif /* FEE_AR_MAJOR_VERSION */
#if (FEE_AR_MINOR_VERSION != 0x00U)
    #error Fee_Cfg.c: FEE_AR_MINOR_VERSION of Fee.h is incompatible.
#endif /* FEE_AR_MINOR_VERSION */
#if (FEE_AR_PATCH_VERSION != 0x03U)
    #error Fee_Cfg.c: FEE_AR_PATCH_VERSION of Fee.h is incompatible.
#endif /* FEE_AR_PATCH_VERSION */
#if (FEE_SW_MAJOR_VERSION != FEE_CFG_C_MAJOR_VERSION)
    #error Fee_Cfg.c: FEE_SW_MAJOR_VERSION of Fee.h is incompatible.
#endif /* FEE_SW_MAJOR_VERSION */
#if (FEE_SW_MINOR_VERSION != FEE_CFG_C_MINOR_VERSION)
    #error Fee_Cfg.c: FEE_SW_MINOR_VERSION of Fee.h is incompatible.
#endif /* FEE_SW_MINOR_VERSION */
#if (FEE_SW_PATCH_VERSION != FEE_CFG_C_PATCH_VERSION)
    #error Fee_Cfg.c: FEE_SW_PATCH_VERSION of Fee.h is incompatible.
#endif /* FEE_SW_PATCH_VERSION */

/*----------------------------------------------------------------------------*/
/* Fee_Cfg Configuration         											  */

/*SAFETYMCUSW 580 S MR:1.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#define FEE_START_SEC_CONST_UNSPECIFIED
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h" 

/* Virtual Sector Configuration */
const Fee_VirtualSectorConfigType Fee_VirtualSectorConfiguration[] = 
{    

    {
        1U,		/* Virtual sector number */
		7U,		/* Bank */
		(Fapi_FlashSectorType)0U,	/* Start Sector */	
		(Fapi_FlashSectorType)0U		/* End Sector */ 	
	},

    {
        2U,		/* Virtual sector number */
		7U,		/* Bank */
		(Fapi_FlashSectorType)1U,	/* Start Sector */	
		(Fapi_FlashSectorType)1U		/* End Sector */ 	
	},

    {
        3U,		/* Virtual sector number */
		7U,		/* Bank */
		(Fapi_FlashSectorType)2U,	/* Start Sector */	
		(Fapi_FlashSectorType)2U		/* End Sector */ 	
	},

    {
        4U,		/* Virtual sector number */
		7U,		/* Bank */
		(Fapi_FlashSectorType)3U,	/* Start Sector */	
		(Fapi_FlashSectorType)3U		/* End Sector */ 	
	}	
};
 

/* SourceId : FEE_SourceId_015 */
/* DesignId : FEE4x_DesignId_003, FEE4x_DesignId_004  */
/* Requirements : AR_FEE_SR9, AR_FEE_SR137, AR_FEE_SR138, AR_FEE_SR139, AR_FEE_SR140, AR_FEE_SR141, AR_FEE_SR142 */
/* Block Configuration */
const Fee_BlockConfigType Fee_BlockConfiguration[] =
{    

    {
        16U,		/* Block number */
		12U,		/* Block size */
		TRUE,		/* Block immediate data used */		
		5U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        176U,		/* Block number */
		10U,		/* Block size */
		TRUE,		/* Block immediate data used */		
		2U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        160U,		/* Block number */
		26U,		/* Block size */
		FALSE,		/* Block immediate data used */		
		0U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        144U,		/* Block number */
		18U,		/* Block size */
		FALSE,		/* Block immediate data used */		
		0U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        128U,		/* Block number */
		18U,		/* Block size */
		FALSE,		/* Block immediate data used */		
		0U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        112U,		/* Block number */
		18U,		/* Block size */
		FALSE,		/* Block immediate data used */		
		0U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        96U,		/* Block number */
		18U,		/* Block size */
		FALSE,		/* Block immediate data used */		
		0U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        80U,		/* Block number */
		18U,		/* Block size */
		FALSE,		/* Block immediate data used */		
		0U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        64U,		/* Block number */
		18U,		/* Block size */
		FALSE,		/* Block immediate data used */		
		0U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        48U,		/* Block number */
		18U,		/* Block size */
		FALSE,		/* Block immediate data used */		
		0U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        32U,		/* Block number */
		18U,		/* Block size */
		FALSE,		/* Block immediate data used */		
		0U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        192U,		/* Block number */
		4U,		/* Block size */
		FALSE,		/* Block immediate data used */		
		0U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	},

    {
        193U,		/* Block number */
		4U,		/* Block size */
		FALSE,		/* Block immediate data used */		
		0U,		/* Block number of write cycles */
		0U,		/* Device Index */					
		1U,		/* Number of DataSets */
		0U		/* EEP Number */	
	}	
};

/*SAFETYMCUSW 580 S MR:1.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#define FEE_STOP_SEC_CONST_UNSPECIFIED
/*SAFETYMCUSW 338 S MR:19.1 <APPROVED> "Reason - This is the format to use for specifying memorysections."*/
#include "MemMap.h"

/**********************************************************************************************************************
 *  END OF FILE: Fee_Cfg.c
 *********************************************************************************************************************/


