/** @file main.c 
*   @brief Application main file
*   @date 05-Oct-2016
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2016 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* Include Files */

#include "sys_common.h"
#include "sys_core.h"
#include "system.h"
#include "dio.h"
#include "port.h"
#include "mcu.h"
#include "can.h"
#include "adc.h"
#include "sci.h"
#include "fee.h"
#include "gpt.h"
#include "pwm.h"
#include "icu.h"
#include "gpt_notification.h"
#define SIMPLE_DELAY  200000

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

#define UART_SCI sciREG    // Pin 38 and 39
#define UART_LIN scilinREG // Pin 131 & 132

#define UARTPORT UART_SCI

/*--------------------*/
/* CAN Globals */
/*--------------------*/
Can_PduType Pdu, Pdu1;
Std_VersionInfoType VersionInfo;
uint8 CanRxData[8];
uint32 CAN_RX_Int_Flag;
uint32 CAN_RX_Done_Flag, CAN_TX_Done_Flag;
boolean TestState;
/*--------------------*/
/* ADC Globals */
/*--------------------*/
Adc_ValueGroupRefType Adc_Test;
Adc_ValueGroupRefRefType Adc_Test2;
Adc_ValueGroupRefType AdcDataBuffer;
Adc_ValueGroupType  Adc_result_buffer[20];

uint8 *Result_Ptr;
/*--------------------*/
/* ICU Globals */
/*--------------------*/
Icu_DutyCycleType I_BMU_ID_PWM_dutyCycle;
Icu_DutyCycleType HSD_BMU_ID_PWM_NEXT_dutycycle;

/*--------------------*/
/* FEE Globals */
/*--------------------*/
uint8 SpecialRamBlock[100];
unsigned char read_data[100]={0};

/*--------------------*/

void delay(void)
{
	unsigned int dummycnt=0x0000FFU;
	do
	{
		dummycnt--;
	}
	while(dummycnt>0);
}

int main(void)
{

	uint32 i;

/**********************************************/
/* General Device Initializations */
/**********************************************/

    /* enable irq interrupt in Cortex R4 */
    _enable_interrupt_();

    setupFlash();

/**********************************************/

/**********************************************/
/* Testing PORT MCAL */
/**********************************************/

	/* Initialize Port module for all Pin Mux related setting */
	Port_Init(&Port_Runtime);

/**********************************************/
/* UART Initilization
     * Note : Select UART using MACRO UART in
     * top of this file
     * UART Baud Rate : ( HALCoGen Configured )
     * Baudrate : 9600
     * Stop Bit : 2
     * Length   : 8
     * Parity   : None */

   sciInit();
   //sciSendByte(UARTPORT, 'A');
   sciSend(UARTPORT, 17,(uint8 *) "The test Begins");

/**********************************************/
/* Testing ADC MCAL */
/**********************************************/

	Adc_Init(&AdcConfigSet_0);
    Adc_SetupResultBuffer(MyTestGroup0,&Adc_result_buffer[0]);
    Adc_StartGroupConversion(MyTestGroup0);

    //    Adc_EnableGroupNotification(0); // This is when Interrupt is used.
    while (!(Adc_GetGroupStatus(MyTestGroup0) == ADC_STREAM_COMPLETED));

    Adc_StopGroupConversion(MyTestGroup0);
    Adc_ReadGroup(MyTestGroup0, &Adc_result_buffer[0]);
    Adc_DeInit();

    //    Adc_DisableGroupNotification(0);

/**********************************************/
/* Testing PWM MCAL */
/**********************************************/

    Pwm_Init(&PwmChannelConfigSet_0);


/**********************************************/
/* Testing DCAN MCAL */
/**********************************************/
	{
	const Can_ConfigPtrType  Can_ConfigPtr = &CanConfigSet_0 ;
	Can_PduInfoPtrType PduInfo;
	uint8 data[8]={0x11, 0x22,0x33,0x44, 0x55,0x66,0x77,0x88 };
	Can_ReturnType status;
	volatile uint32 i3=0;

	PduInfo = &Pdu;
	TestState = TRUE;

	Pdu.id = 200;
	Pdu.length = 8;
	Pdu.swPduHandle = 0;
    Pdu.sdu = &data[0];

    /* Set the Flag to know value
     * this gets updated in RX interrupt service routine
     */
    CAN_RX_Int_Flag = 0x12345678;
    CAN_RX_Done_Flag  = 0x12345678;
	CAN_TX_Done_Flag  = 0x12345678;

#if 0/*Reg Read Back testing */
	Can_Init( Can_ConfigPtr );
	Can_ConfigRegReadBack(0);
	Can_CanConfigTest = Can_CanConfig;
#endif

/* Loopback testing  */
	/* Configuration is done for message object 0 as TX and 1 as X
	 * Check the CAN configuration CanHardwareObject_0 and CanHardwareObject_1
	 */

	Can_Init( Can_ConfigPtr );

	/* 0 is CanController_0(DCAN1 of 3 DCAN's ( DCAN1, DCAN2, DCAN3)) */
	status = Can_SetControllerMode( 0, CAN_T_START );

	/* Enable Loop Back ( Non AUTOSAR Functions) */
	/* 0 is CanController_0 (DCAN1 of 3 DCAN's ( DCAN1, DCAN2, DCAN3)) */
	Can_TestLoopBackModeEnable(0, 1);

	/* Write data to CAN CanHardwareObject_0 */
	/* Note : 0 is CanHardwareObject_0, not CanController_0 */
	Can_Write(0, PduInfo);

	/* Wait until TX is complete flag is cleared in call back of canIF(Can_misc.c file)*/
	while(CAN_TX_Done_Flag == 0x12345678)
	{
		Can_MainFunction_Write();
	}
	CAN_TX_Done_Flag = 0x12345678;

	/* Wait until RX is complete and indicated via call back of canIF(Can_misc.c file)*/
	while(CAN_RX_Done_Flag == 0x12345678)
	{
		Can_MainFunction_Read();
	}
	CAN_RX_Done_Flag = 0x12345678;


	/* Check the received data is same */
	for(i=0; i<Pdu.length; i++)
	{
		if(CanRxData[i] != data[i])
		TestState = FALSE;
	}

	/* Disable Loop Back ( Non AUTOSAR Functions) */
	/* 0 is CanController_0 (DCAN1 of 3 DCAN's ( DCAN1, DCAN2, DCAN3)) */
	Can_TestLoopBackModeDisable(0, 1);
	}

/**********************************************/
/* Testing FEE MCAL */
/**********************************************/

	{
		unsigned int BlockNumber;
		unsigned char *Read_Ptr=read_data;

		volatile uint32 flashread = 0u;

		volatile unsigned int loop, loop1;

		for(loop=0;loop<100;loop++)SpecialRamBlock[loop] = loop;

		Fee_Init();
		do
		{
			Fee_MainFunction();
		}
		while(Fee_GetStatus() != IDLE);

		//Making sure all sectors are erased and marked as Empty.
		// Loop of 6 is just a number....
		// At least loop should be equal to nuber of sectors more is ok..
		for(loop=0;loop<6;loop++)
		{
			do
			{
				Fee_MainFunction();
			}
			while(Fee_GetStatus() != IDLE);
		}

		/* Check Async write */
		BlockNumber=16;
		Fee_Write(BlockNumber, &SpecialRamBlock[0]);
		do
		{
			Fee_MainFunction();
		}
		while(Fee_GetStatus() != IDLE);

		Fee_Read(BlockNumber,0,Read_Ptr, 0xFFFF);
		do
		{
			Fee_MainFunction();
		}
		while(Fee_GetStatus() != IDLE);

		/* Check the received data is same */
		for(i=0; i<12; i++)
		{
			if(SpecialRamBlock[i] != read_data[i])
			TestState = FALSE;
		}

	}

/**********************************************/
/* Testing GPT MCAL */
/**********************************************/

	Gpt_Init(&GptChannelConfigSet_0);
	Gpt_EnableNotification(1); // Channel 1
	Gpt_StartTimer(1,1000); // Channel 1 and 1 tick = 1MHZ = 1micro sec, so to get 1msec pass value 1000


/**********************************************/
/* Testing DIO MCAL */
/**********************************************/
	/* Initialize DIO module */
	Dio_Init(&DioModuleConfiguration_0);

	/* Perform a simple Blinky */
	while(1)
	{
		/* Toggling Pin16 that is GIOA[6] */
	//	Dio_FlipChannel(PIN_16);
		for(i=0;i<SIMPLE_DELAY;i++);
	}

}


void gpt_notification_fn()
{

    Dio_FlipChannel(LED1_EN);
    asm(" nop");
    asm(" nop");
    asm(" nop");
    asm(" nop");
    asm(" nop");
    asm(" nop");
    asm(" nop");


}
