/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 * 
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  CanIf_Cbk.h
 *    Component:  Tms570_AutoSarCanDriver
 *       Module:  CanDriver
 *    Generator:  -
 *
 *  Description:  API to hardware abstraction of the CAN-driver             
 * ---------------------------------------------------------------------------------------------------------------------
 * Author:  Sudhakar Singh
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
* 04.10.00       25May2016    Sudhakar Singh       0000000000000    Initial Version adapted from TMS570LS12xx v2.21.00
 *********************************************************************************************************************/
#ifndef CANIF_CBK_H
#define CANIF_CBK_H

typedef enum
{
  CANIF_CS_UNINIT = 0U,  /**<Controller is not initialized */
  CANIF_CS_STOPPED,     /**<Controller is stopped */
  CANIF_CS_STARTED,     /**<Controller is active/running */
  CANIF_CS_SLEEP        /**<Controller is in sleep mode */
} CanIf_ControllerModeType;

void CanIf_ControllerBusOff(uint8 Controller);
void CanIf_RxIndication(uint8 Hrh, Can_IdType RxCanId,uint8 RxCanDlc, const uint8 *RxCanSduPtr);
void CanIf_TxConfirmation(PduIdType CanTxPduId);
void CanIf_ControllerModeIndication( uint8 ControllerId, CanIf_ControllerModeType ControllerMode );


#endif /* CANIF_CBK_H end file*/

