/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                 TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *                 Property of Texas Instruments, Unauthorized reproduction and/or distribution
 *                 is strictly prohibited.  This product  is  protected  under  copyright  law
 *                 and  trade  secret law as an  unpublished work.
 *                 (C) Copyright Texas Instruments.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 * 
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *         File:  Can_if.h
 *    Component:  Tms570_AutoSarCanDriver
 *       Module:  CanDriver
 *    Generator:  -
 *
 *  Description:  API to hardware abstraction of the CAN-driver             
 * ---------------------------------------------------------------------------------------------------------------------
 * Author:  Sudhakar Singh
 *---------------------------------------------------------------------------------------------------------------------
 * Revision History
 *---------------------------------------------------------------------------------------------------------------------
 * Version        Date         Author               Change ID        Description
 *---------------------------------------------------------------------------------------------------------------------
 * 04.10.00       25May2016    Sudhakar Singh       0000000000000    Initial Version adapted from TMS570LS12xx v2.21.00
 *********************************************************************************************************************/
#if !defined(CAN__IF_H)
#define CAN__IF_H


typedef uint8 CanIf_ControllerModeType;

void CanIf_ControllerBusOff(uint8 Controller);
void CanIf_RxIndication(uint8 Hrh, Can_IdType CanId,uint8 CanDlc, const uint8 *CanSduPtr);
void CanIf_TxConfirmation(PduIdType CanTxPduId);
void CanIf_ControllerModeIndication( uint8 ControllerId, CanIf_ControllerModeType ControllerMode );


#endif /* AN__IF_H end file*/

