#ifndef _DEM_H__
#define _DEM_H__
#include <std_types.h>

#include "Platform_Types.h"
#include "Compiler.h"

#define LIN_E_TIMEOUT                    (uint8)0x07u
#define DEM_EVENT_STATUS_PREPASSED       (uint8)3u
#define DEM_EVENT_STATUS_PREFAILED       (uint8)4u

typedef VAR(uint16, TYPEDEF) Dem_EventIdType;
typedef VAR(uint8, TYPEDEF) Dem_EventStatusType;

#define DEM_EVENT_STATUS_PASSED       (Dem_EventStatusType) 0x00U
#define DEM_EVENT_STATUS_FAILED       (Dem_EventStatusType) 0x01U

#define DIO_WRITE_CHANNEL_EVENT_ID       0U
#define DIO_WRITE_PORT_EVENT_ID          1U
#define DIO_WRITE_CHL_GROUP_EVENT_ID     2U
#define DIO_FLIP_CHANNEL_EVENT_ID        3U 

#define DemConf_DemEventParameter_SPI_E_BIT_ERROR               ((Dem_EventIdType)0x12U)
#define DemConf_DemEventParameter_SPI_E_DESYNC_ERROR            ((Dem_EventIdType)0x13U)
#define DemConf_DemEventParameter_SPI_E_DLEN_ERROR              ((Dem_EventIdType)0x14U)
#define DemConf_DemEventParameter_SPI_E_TXSTALL_ERROR           ((Dem_EventIdType)0x15U)
#define DemConf_DemEventParameter_SPI_E_RXSTALL_ERROR           ((Dem_EventIdType)0x16U)
#define DemConf_DemEventParameter_SPI_E_DOVR_ERROR              ((Dem_EventIdType)0x17U)
#define DemConf_DemEventParameter_SPI_E_TO_ERROR                ((Dem_EventIdType)0x18U)

#define DemConf_DemEventParameter_WDG_E_MODE_FAILED             ((Dem_EventIdType)0x21U)
#define DemConf_DemEventParameter_WDG_E_DISABLE_REJECTED        ((Dem_EventIdType)0x22U)

#define DemConf_DemEventParameter_MCU_E_CLOCK_FAILURE           ((Dem_EventIdType)0x00U)

extern Dem_EventIdType Reported_Dem_Error;

void Dem_ReportErrorStatus( Dem_EventIdType EventId, Dem_EventStatusType EventStatus );

#endif /* _DEM_H__ */
