/*
 * Can_dummy.c
 *
 *  Created on: Nov 6, 2012
 *      Author: a0132081
 */
#include "std_types.h"
#include "det.h"
#if TMS570LCx_TEST
#include "HL_sys_common.h"
#include "HL_system.h"
#else
#include "sys_common.h"
#include "system.h"
#endif
#include "can.h"
#include "CanIf_Cbk.h"
#include "Can_misc.h"

#include "EcuM_Cbk.h"

boolean bCanBusOff;
extern uint8 CanRxData_temp[8];
extern uint32 CAN_RX_Int_Flag;
extern uint32 CAN_RX_Done_Flag, CAN_TX_Done_Flag;

void CanIf_ControllerBusOff(uint8 Controller)
{
	bCanBusOff = FALSE;
}

void CanIf_RxIndication(uint8 Hrh, Can_IdType CanId,uint8 CanDlc, const uint8 *CanSduPtr)
{
	uint8 i;
	CAN_RX_Int_Flag = 0xABCDEF;
	CAN_RX_Done_Flag = 0xABCDEF;
	/* Copy data */
	for(i=0;i<CanDlc; i++)
	CanRxData[i] = CanSduPtr[i];
}

static int i2 =0;
void CanIf_TxConfirmation(PduIdType CanTxPduId)
{
	i2++;
	// The test is with Pdu.swPduHandle = 0;
	// So the check is also for it.
	if(CanTxPduId < 4)
	{
		CAN_TX_Done_Flag = 0xABCDEF;
	}

}

/*void EcuM_CheckWakeup(EcuM_WakeupSourceType wakeupSource)
{
	bCanBusOff = TRUE;
}*/

void CanIf_ControllerModeIndication( uint8 ControllerId, CanIf_ControllerModeType ControllerMode )
{
	static volatile uint8 controller;
	volatile CanIf_ControllerModeType ControllerMode1;
	controller = ControllerId;
	ControllerMode1 = ControllerMode;
}


