/*----------------------------------------------------------------------------*/
/* sys_link.ld                                                              */
/*                                                                            */
/* (c) Texas Instruments 2009-2014, All rights reserved.                      */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/* Entry Point */
ENTRY(_c_int00)

/* Highest address of the stack */
_estack = 0x8040000;    /* end of 256K RAM */

/* Generate a link error if heap and stack don't fit into RAM */
_Min_Heap_Size = 0x400;      /* required amount of heap  */

/* Specify the memory areas */
MEMORY
{
  VECTORS(rx)     : ORIGIN = 0x00000000, LENGTH = 0x00000020
  KERNEL (rx)     : ORIGIN = 0x00000020, LENGTH = 0x00008000
  FLASH  (rx)     : ORIGIN = 0x00008020, LENGTH = (0x001F7FE0 + 0x00200000)
  CPU_STACK (rw)  : ORIGIN = 0x08000000, LENGTH = 0x00000800 /* Stack is configured in sys_core.asm */
  KRAM (xrw)      : ORIGIN = 0x08000800, LENGTH = 0x00000800
  RAM (xrw)       : ORIGIN = (0x08000800 + 0x00000800), LENGTH = (0x0007F800 - 0x00000800)
  MEMORY_B1 (rx)  : ORIGIN = 0x60000000, LENGTH = 0K
}

/* Define output sections */
SECTIONS
{
  /* The ISR vector goes first into RAM */
  .intvecs :
  {
    . = ALIGN(4);
    KEEP(*(.intvecs)) /* ISR vector */
    . = ALIGN(4);
  } >VECTORS

 /* FreeRTOS Kernel in protected region of Flash */
  .kernelTEXT :
  {
    . = ALIGN(4);
    KEEP(*(.kernelTEXT))
    . = ALIGN(4);
  } >KERNEL
  
  /* The program code and other data goes into RAM */
  .text :
  {
    . = ALIGN(4);
    *(.text)           /* .text sections (code) */
    *(.text*)          /* .text* sections (code) */
    *(.glue_7)         /* glue arm to thumb code */
    *(.glue_7t)        /* glue thumb to arm code */
    *(.eh_frame)

    KEEP (*(.init))
    KEEP (*(.fini))

    . = ALIGN(4);
    _etext = .;        /* define a global symbols at end of code */
  } >FLASH

  /* Constant data goes into RAM */
  .rodata :
  {
    . = ALIGN(4);
    *(.rodata)         /* .rodata sections (constants, strings, etc.) */
    *(.rodata*)        /* .rodata* sections (constants, strings, etc.) */
    . = ALIGN(4);
  } >FLASH

   .ARM.extab   : { *(.ARM.extab* .gnu.linkonce.armextab.*) } >RAM
    .ARM : {
    __exidx_start = .;
      *(.ARM.exidx*)
      __exidx_end = .;
    } >FLASH

  .preinit_array     :
  {
    PROVIDE_HIDDEN (__preinit_array_start = .);
    KEEP (*(.preinit_array*))
    PROVIDE_HIDDEN (__preinit_array_end = .);
  } >FLASH
  .init_array :
  {
    PROVIDE_HIDDEN (__init_array_start = .);
    KEEP (*(SORT(.init_array.*)))
    KEEP (*(.init_array*))
    PROVIDE_HIDDEN (__init_array_end = .);
  } >FLASH
  .fini_array :
  {
    PROVIDE_HIDDEN (__fini_array_start = .);
    KEEP (*(SORT(.fini_array.*)))
    KEEP (*(.fini_array*))
    PROVIDE_HIDDEN (__fini_array_end = .);
  } >FLASH

  /* used by the startup to initialize data */
  _sidata = LOADADDR(.data);
  
  /* Initialized data sections goes into RAM, load LMA copy after code */
  .data :
  {
    . = ALIGN(4);
    _sdata = .;        /* create a global symbol at data start */
    *(.data)           /* .data sections */
    *(.data*)          /* .data* sections */

    . = ALIGN(4);
    _edata = .;        /* define a global symbol at data end */
  } >RAM AT> FLASH

  .kernelBSS :
  {
    . = ALIGN(4);
    _kernel_bss = .;
    *(.kernelBSS)
    *(.kernelBSS*)

    _ekernel_bss = .;         /* define a global symbol at bss end */
    __kernel_bss_end__ = _ekernel_bss;
  } >KRAM

  /* FreeRTOS Kernel data in protected region of RAM */
  /* used by the startup to initialize data */
  _ksidata = LOADADDR(.kernelBSS);
 
  /* Initialized data sections goes into RAM, load LMA copy after code */
  .data :
  {
    . = ALIGN(4);
    _ksdata = .;        /* create a global symbol at data start */
    *(.data)           /* .data sections */
    *(.data*)          /* .data* sections */

    . = ALIGN(4);
    _kedata = .;        /* define a global symbol at data end */
  } >RAM AT> FLASH
  
  .kernelHEAP : {} >RAM
  
  /* Uninitialized data section */
  . = ALIGN(4);
  .bss :
  {
    /* This is used by the startup in order to initialize the .bss secion */
    _sbss = .;         /* define a global symbol at bss start */
    __bss_start__ = _sbss;
    *(.bss)
    *(.bss*)
    *(COMMON)

    . = ALIGN(4);
    _ebss = .;         /* define a global symbol at bss end */
    __bss_end__ = _ebss;
  } >RAM

  PROVIDE ( end = _ebss );
  PROVIDE ( _end = _ebss );

  /* MEMORY_bank1 section, code must be located here explicitly            */
  /* Example: extern int foo(void) __attribute__ ((section (".mb1text"))); */
  .memory_b1_text :
  {
    *(.mb1text)        /* .mb1text sections (code) */
    *(.mb1text*)       /* .mb1text* sections (code)  */
    *(.mb1rodata)      /* read-only data (constants) */
    *(.mb1rodata*)
  } >MEMORY_B1

  /* Remove information from the standard libraries */
  /DISCARD/ :
  {
    libc.a ( * )
    libm.a ( * )
    libgcc.a ( * )
  }
  
  .ARM.attributes 0 : { *(.ARM.attributes) }
}
