/** @file sys_common.h
*   @brief Common Header File
*   @date 04.October.2011
*   @version 1.02.000
*   
*   This file contains:
*   - General Definitions
*   .
*   which are relevant for all drivers.
*/

/* (c) Texas Instruments 2009-2010, All rights reserved. */


#ifndef __SYS_COMMON_H__
#define __SYS_COMMON_H__

/* USER CODE BEGIN (0) */
/* USER CODE END */


/* General Definitios */

/** @def NULL
*   @brief NULL definition
*/
#ifndef NULL
    #define NULL ((void *) 0U)
#endif

/** @def TRUE
*   @brief definition for TRUE
*/
#ifndef true
    #define true 1U
#endif
#ifndef TRUE
    #define TRUE 1U
#endif

/** @def FALSE
*   @brief BOOLEAN definition for FALSE
*/
#ifndef false
    #define false 0U
#endif

#ifndef FALSE
    #define FALSE 0U
#endif

#ifndef bool
typedef unsigned char bool;
#endif

#ifndef _BOOLEAN_DECLARED
typedef bool boolean;
#define	_BOOLEAN_DECLARED
#endif


#ifndef _INT32_DECLARED
//typedef  int    int32_t;
#define	_INT32_DECLARED
#endif


#ifndef _TBOOLEAN_DECLARED
typedef boolean tBoolean;
#define _TBOOLEAN_DECLARED
#endif

#ifndef _UINT64_DECLARED
typedef unsigned long long uint64;
#define	_UINT64_DECLARED
#endif

//#ifndef _uint32_t_DECLARED
////typedef unsigned int uint32_t;
//#define	_uint32_t_DECLARED
//#endif

//#ifndef _uint16_t_DECLARED
//typedef unsigned short uint16_t;
//#define	_uint16_t_DECLARED
//#endif

//#ifndef _uint8_t_DECLARED
//typedef unsigned char uint8_t;
//#define	_uint8_t_DECLARED
//#endif

#ifndef _SINT64_DECLARED
typedef signed long long sint64;
#define	_SINT64_DECLARED
#endif

#ifndef _SINT32_DECLARED
typedef signed int sint32;
#define	_SINT32_DECLARED
#endif

#ifndef _SINT16_DECLARED
typedef signed short sint16;
#define	_SINT16_DECLARED
#endif

#ifndef _SINT8_DECLARED
typedef signed char sint8;
#define	_SINT8_DECLARED
#endif

#ifndef _FLOAT32_DECLARED
typedef float float32;
#define	_FLOAT32_DECLARED
#endif

#ifndef _FLOAT64_DECLARED
typedef double float64;
#define	_FLOAT64_DECLARED
#endif

/** @enum loopBackType
*   @brief Loopback type definition
*/
/** @typedef loopBackType_t
*   @brief Loopback type Type Definition
*
*   This type is used to select the module Loopback type Digital or Analog loopback.
*/
typedef enum loopBackType
{
    Digital_Lbk = 0U,
    Analog_Lbk = 1U
}loopBackType_t;

/** @typedef config_value_type_t
*   @brief config type Type Definition
*
*   This type is used to specify the Initial and Current value.
*/
typedef enum config_value_type
{
	InitialValue,
	CurrentValue
}config_value_type_t;


/* USER CODE BEGIN (1) */
/* USER CODE END */

#endif
