/** @file HL_sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com  
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
#include "Types.h"
#include "F021.h"
#include "HL_reg_flash.h"
/* USER CODE END */

/* Include Files */

#include "HL_sys_common.h"

/* USER CODE BEGIN (1) */
#define SYS_CLK_FREQ            150
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
uint8_t DataBuffer[8] = {0xAA,0xBB,0xCC,0xDD,0xEE,0xFF,0x00,0x55};
uint8_t DataBuffer2[16] = {0xAA,0xBB,0xCC,0xDD,0xEE,0xFF,0x00,0x55,0xAA,0xBB,0xCC,0xDD,0xEE,0xFF,0x00,0x55};

Fapi_StatusType Return_Status;
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    if ((Fapi_initializeFlashBanks((uint32_t)SYS_CLK_FREQ)) == Fapi_Status_Success){
        Fapi_setActiveFlashBank(Fapi_FlashBank7);                       /*Activate the Bank-7 for write*/
        Fapi_enableEepromBankSectors(0xFFFFFFFF,0);                             /*Enabling All 32 sectors in Bank-7 for programming*/

        while( FAPI_CHECK_FSM_READY_BUSY != Fapi_Status_FsmReady );
        while( FAPI_GET_FSM_STATUS != Fapi_Status_Success ); /* don't have to include this one*/
    }

    Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector,(uint32_t*)0xF0207000);  /*Sending sector erase command for 8th sector in Bank-1*/
    while( FAPI_CHECK_FSM_READY_BUSY == Fapi_Status_FsmBusy );
    while(FAPI_GET_FSM_STATUS != Fapi_Status_Success);

    Return_Status = Fapi_issueProgrammingCommand((uint32_t*)0xF0207350,DataBuffer,8,0,0,Fapi_AutoEccGeneration);    /*Programming data to 8th sector*/
    while( FAPI_CHECK_FSM_READY_BUSY == Fapi_Status_FsmBusy );
    while(FAPI_GET_FSM_STATUS != Fapi_Status_Success);

    while(1)
    {
        ;
    }
/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
/* USER CODE END */
