/*
 * ahrs.h
 *
 *  Created on: 2016 febr. 7
 *      Author: Sandor
 */

#ifndef AHRS_H_
#define AHRS_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include "mpu.h"

typedef enum eAHRSInstState {
	AHRS_STATE_IDLE = 0,
	AHRS_STATE_DISABLED,
	AHRS_STATE_RUN
} tAHRSInstState;

typedef struct sAHRSInst {
    tAHRSInstState ui8State;
    bool bDataReady;
    float q0, q1, q2, q3;
    float yaw, pitch, roll;
    float axe, aye, aze, vxe, vye, vze, pxe, pye, pze;
    float sampleFreq;
    float twoKp, twoKi;
    float integralFBx,  integralFBy, integralFBz;
    uint32_t ui32SysTick;
    tMPUInst *psMPUInst;
    void *pfnCallback;
    void *pvCallbackData;
} tAHRSInst;

void AHRS_init(tAHRSInst *psInst, tMPUInst *psMPUInst);
void AHRS_poll(tAHRSInst *psInst);
void AHRS_update(tAHRSInst *psInst);

#ifdef __cplusplus
}
#endif

#endif /* AHRS_H_ */
