/*
 * common.h
 *
 *  Created on: 2016 febr. 8
 *      Author: Sandor
 */

#ifndef COMMON_H_
#define COMMON_H_

typedef struct sErrorCounters {
	uint16_t ui16I2CMErrorCount;
	uint16_t ui16uDMAErrorCount;
	uint16_t ui16MPUErrorCount;
} tErrorCounters;

typedef union{
	uint32_t u32;
	uint16_t u16[2];
	uint8_t  u8[4];
}tu32union;

#define NO_CALLBACK		0

#define EEPROM_BASE_ADDRESS_CAL	0x400

#define EEPROM_ADRESS_SET(address)	(EEPROM_BASE_ADDRESS_CAL + address)

#define EEPROM_ADC_OFFSET			2
#define EEPROM_MOTOR_1				3
#define EEPROM_MOTOR_2				4
#define EEPROM_MOTOR_3				5
#define EEPROM_MOTOR_4				6
#define EEPROM_MOTOR_OFFSET			7
#define EEPROM_PID1_P				8
#define EEPROM_PID1_I				9
#define EEPROM_PID1_D				10
#define EEPROM_PID2_P				11
#define EEPROM_PID2_I				12
#define EEPROM_PID2_D				13

#endif /* COMMON_H_ */
