/*
 * fifo.c
 *
 *  Created on: 2016 mrc. 3
 *      Author: Sandor
 */

#include "fifo.h"


void FIFO_Init(_FIFOu8* fifo, uint8_t* data){
	fifo->FiFo = data;
	fifo->Head = 0;
	fifo->Tail = 0;
	fifo->Number = 0;
	fifo->package_counter = 0;
	fifo->Maxnumber = BUFFER_SIZE;
}


//************************************************************
//! Write to FIFO
//************************************************************
uint8_t FIFO_Push(_FIFOu8 *fifo, uint8_t data)
{
  if(fifo->Maxnumber >= fifo->Number)   //ha tele a FIFO
  {
    return 0;
  }
  fifo->FiFo[fifo->Head++] = data;

  if(fifo->Head == fifo->Maxnumber)
  {
    fifo->Head = 0;     //ezrt gyrs FIFO
  }
  fifo->Number++;

  return 1;
}

//************************************************************
//! Read from FIFO
//************************************************************
uint8_t FIFO_Pop(_FIFOu8 *fifo, uint8_t *data)
{
  if(fifo->Number == 0)         // ha res a FIFO
  {
   return 0;
  }
  *data = fifo->FiFo[fifo->Tail];
  if(++fifo->Tail == fifo->Maxnumber)
  {
    fifo->Tail = 0;
  }
  fifo->Number --;

  return 1;
}

//************************************************************
//!  Clear the FIFO's counters
//************************************************************
uint8_t FIFO_Clear(_FIFOu8 *fifo)
{
  if(fifo != 0)
  {
    fifo->Head = 0;
    fifo->Number = 0;
    fifo->Tail = 0;
    return 1;
  }
  else return 0;
}
