/*
 * halExtInt.c
 *
 *  Created on: 2015 okt. 20
 *      Author: Sandor
 */


#include <inttypes.h>
#include <math.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>

#include "driverlib/cpu.h"
#include "driverlib/fpu.h"
#include "driverlib/pin_map.h"
#include "driverlib/gpio.h"
#include "driverlib/interrupt.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/udma.h"
#include "driverlib/eeprom.h"

#include "inc/hw_gpio.h"
#include "inc/hw_memmap.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "inc/hw_eeprom.h"
#include "inc/hw_ints.h"

#include "utils/ustdlib.h"

#include "halExtInt.h"

uint32_t measuredValues[MAX_CHANNEL];
uint32_t savedValues[MAX_CHANNEL];
uint32_t runValues[MAX_CHANNEL];
uint8_t extIntState = 0;


/*
 * External Interrupt Init with FALLING_EDGE
*/
void halExtInttInit(){
	uint8_t i=0;

	/*
	 * 1 - PD3
	 * 2 - PD4
	 * 3 - PD5
	 * 4 - PD6
	 * 5 - PD7
	 * 6 - PF2
	 * 7 - PF3
	 * 8 - PF4
	 */

	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
	GPIOIntDisable(GPIO_PORTD_BASE,   CHANNEL_0
									| CHANNEL_1
									| CHANNEL_2
									| CHANNEL_3
									| CHANNEL_4);

	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);
	GPIOIntDisable(GPIO_PORTF_BASE,   CHANNEL_5
									| CHANNEL_6
									| CHANNEL_7);

	ROM_GPIOIntTypeSet(GPIO_PORTD_BASE,   	  CHANNEL_0
											| CHANNEL_1
											| CHANNEL_2
											| CHANNEL_3
											| CHANNEL_4, GPIO_RISING_EDGE);


	ROM_GPIOIntTypeSet(GPIO_PORTF_BASE,   CHANNEL_5
										| CHANNEL_6
										| CHANNEL_7, GPIO_RISING_EDGE);

	GPIOIntClear(GPIO_PORTD_BASE, CHANNEL_0
								| CHANNEL_1
								| CHANNEL_2
								| CHANNEL_3
								| CHANNEL_4);

	GPIOIntClear(GPIO_PORTF_BASE, CHANNEL_5
								| CHANNEL_6
								| CHANNEL_7);


	ROM_GPIOPinTypeGPIOInput(GPIO_PORTD_BASE, CHANNEL_0
											| CHANNEL_1
											| CHANNEL_2
											| CHANNEL_3
											| CHANNEL_4);

	ROM_GPIOPinTypeGPIOInput(GPIO_PORTF_BASE, CHANNEL_5
											| CHANNEL_6
											| CHANNEL_7);


//	GPIOIntRegister(GPIO_PORTD_BASE,IntGPIODHandler);
//	GPIOIntRegister(GPIO_PORTF_BASE,IntGPIOFHandler);

	GPIOIntEnable(GPIO_PORTD_BASE,	  CHANNEL_0
									| CHANNEL_1
									| CHANNEL_2
									| CHANNEL_3
									| CHANNEL_4);

	GPIOIntEnable(GPIO_PORTF_BASE,	  CHANNEL_5
									| CHANNEL_6
									| CHANNEL_7);

	IntMasterEnable();            //Interrupt Engedlyezse
	IntEnable(INT_GPIOE);
	IntEnable(INT_GPIOD);

	for(i = 0; i < MAX_CHANNEL; i++){
		measuredValues[i] = 0;
		runValues[i] = 0;
	}
}

/*
 * GPIOF External Interrupt
 */
void IntGPIODHandler(){
	GPIOPinWrite(GPIO_PORTF_BASE,GPIO_PIN_1, GPIO_PIN_1);
	switch(extIntState){
			case 0:
				if(GPIOPinRead(GPIO_PORTD_BASE,GPIO_PIN_3)){
					measuredValues[0] = 0;
					runValues[0] = 1;
					GPIOIntTypeSet(GPIO_PORTD_BASE,GPIO_PIN_3, GPIO_FALLING_EDGE);
				} else {
					runValues[0] = 0;
					GPIOIntTypeSet(GPIO_PORTD_BASE,GPIO_PIN_3, GPIO_RISING_EDGE);
					extIntState++;
					savedValues[0] = measuredValues[0];
				}
				GPIOIntClear(GPIO_PORTD_BASE, CHANNEL_0);
				break;
			case 1:
				if(GPIOPinRead(GPIO_PORTD_BASE,GPIO_PIN_4)){
					measuredValues[1] = 0;
					runValues[1] = 1;
					GPIOIntTypeSet(GPIO_PORTD_BASE,GPIO_PIN_4, GPIO_FALLING_EDGE);
				} else {
					runValues[1] = 0;
					GPIOIntTypeSet(GPIO_PORTD_BASE,GPIO_PIN_4, GPIO_RISING_EDGE);
					extIntState++;
					savedValues[1] = measuredValues[1];
				}
				GPIOIntClear(GPIO_PORTD_BASE, CHANNEL_1);
				break;
			case 2:
				if(GPIOPinRead(GPIO_PORTD_BASE,GPIO_PIN_5)){
					measuredValues[2] = 0;
					runValues[2] = 1;
					GPIOIntTypeSet(GPIO_PORTD_BASE,GPIO_PIN_5, GPIO_FALLING_EDGE);
				} else {
					runValues[2] = 0;
					GPIOIntTypeSet(GPIO_PORTD_BASE,GPIO_PIN_5, GPIO_RISING_EDGE);
					extIntState++;
					savedValues[2] = measuredValues[2];
				}
				GPIOIntClear(GPIO_PORTD_BASE, CHANNEL_2);
				break;
			case 3:
				if(GPIOPinRead(GPIO_PORTD_BASE,GPIO_PIN_6)){
					measuredValues[3] = 0;
					runValues[3] = 1;
					GPIOIntTypeSet(GPIO_PORTD_BASE,GPIO_PIN_6, GPIO_FALLING_EDGE);
				} else {
					runValues[3] = 0;
					GPIOIntTypeSet(GPIO_PORTD_BASE,GPIO_PIN_6, GPIO_RISING_EDGE);
					extIntState++;
					savedValues[3] = measuredValues[3];
				}
				GPIOIntClear(GPIO_PORTD_BASE, CHANNEL_3);
				break;
			case 4:
				if(GPIOPinRead(GPIO_PORTD_BASE,GPIO_PIN_7)){
					measuredValues[4] = 0;
					runValues[4] = 1;
					GPIOIntTypeSet(GPIO_PORTD_BASE,GPIO_PIN_7, GPIO_FALLING_EDGE);
				} else {
					runValues[4] = 0;
					GPIOIntTypeSet(GPIO_PORTD_BASE,GPIO_PIN_7, GPIO_RISING_EDGE);
					extIntState++;
					savedValues[4] = measuredValues[4];
				}
				GPIOIntClear(GPIO_PORTD_BASE, CHANNEL_4);
				break;
		}
}

/*
 * GPIOF External Interrupt
 */
void IntGPIOFHandler(){
	GPIOPinWrite(GPIO_PORTF_BASE,GPIO_PIN_1, GPIO_PIN_1);
	switch(extIntState){
		case 5:
			if(GPIOPinRead(GPIO_PORTF_BASE,GPIO_PIN_2)){
				measuredValues[5] = 0;
				runValues[5] = 1;
				GPIOIntTypeSet(GPIO_PORTF_BASE,GPIO_PIN_2, GPIO_FALLING_EDGE);
			} else {
				runValues[5] = 0;
				GPIOIntTypeSet(GPIO_PORTF_BASE,GPIO_PIN_2, GPIO_RISING_EDGE);
				extIntState++;
				savedValues[5] = measuredValues[5];
			}
			GPIOIntClear(GPIO_PORTF_BASE, CHANNEL_5);
			break;
		case 6:
			if(GPIOPinRead(GPIO_PORTF_BASE,GPIO_PIN_3)){
				measuredValues[6] = 0;
				runValues[6] = 1;
				GPIOIntTypeSet(GPIO_PORTF_BASE,GPIO_PIN_3, GPIO_FALLING_EDGE);
			} else {
				runValues[6] = 0;
				GPIOIntTypeSet(GPIO_PORTF_BASE,GPIO_PIN_3, GPIO_RISING_EDGE);
				extIntState++;
				savedValues[6] = measuredValues[6];
			}
			GPIOIntClear(GPIO_PORTF_BASE, CHANNEL_6);
			break;
		case 7:
			if(GPIOPinRead(GPIO_PORTF_BASE,GPIO_PIN_4)){
				measuredValues[7] = 0;
				runValues[7] = 1;
				GPIOIntTypeSet(GPIO_PORTF_BASE,GPIO_PIN_4, GPIO_FALLING_EDGE);
			} else {
				runValues[7] = 0;
				GPIOIntTypeSet(GPIO_PORTF_BASE,GPIO_PIN_4, GPIO_RISING_EDGE);
				extIntState = 0;
				savedValues[7] = measuredValues[7];
			}
			GPIOIntClear(GPIO_PORTF_BASE, CHANNEL_7);
			break;
	}
}



