/*
 * hal_pwm.c
 *
 *  Created on: 2015 nov. 21
 *      Author: Sandor
 */

#include <inttypes.h>
#include <math.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>

#include <stdint.h>
#include <stdbool.h>
#include <inttypes.h>

#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/pin_map.h"
#include "driverlib/gpio.h"
#include "driverlib/pwm.h"

#include "inc/hw_gpio.h"
#include "inc/hw_types.h"
#include "inc/hw_memmap.h"

#include "halPWM.h"

/* halPWMMotorsInit
 \param
 \param
 */
void halPWMMotorsInit(){
    uint16_t frequency = 50;                                                    // 50Hz
    uint32_t period = SysCtlClockGet() / 64 / (frequency);                      // 50MHz / 64 / 50
    uint32_t duty = (unsigned int)(2000*(0.000001f/(1/((double)SysCtlClockGet()/64.0f))));
    // 1481;                                                       // in "ns"

    SysCtlPWMClockSet(SYSCTL_PWMDIV_64);                                        // PreDiv by 64

    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOB);                                // Enable the peripheral
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);

    SysCtlPeripheralEnable(SYSCTL_PERIPH_PWM0);                                 // The Tiva Launchpad has two modules
    //SysCtlPeripheralEnable(SYSCTL_PERIPH_PWM1);                                 // (0 and 1). Module 1 covers the LED pins


    GPIOPinConfigure(GPIO_PB6_M0PWM0);                                          //Configure Pins as PWM
    GPIOPinConfigure(GPIO_PB7_M0PWM1);
    GPIOPinConfigure(GPIO_PB4_M0PWM2);
    GPIOPinConfigure(GPIO_PB5_M0PWM3);
    GPIOPinConfigure(GPIO_PE4_M0PWM4);
    GPIOPinConfigure(GPIO_PE5_M0PWM5);
    GPIOPinConfigure(GPIO_PD0_M0PWM6);
    GPIOPinConfigure(GPIO_PD1_M0PWM7);

    GPIOPinTypePWM(GPIO_PORTB_BASE, GPIO_PIN_4
                                  | GPIO_PIN_5
                                  | GPIO_PIN_6
                                  | GPIO_PIN_7);

    GPIOPinTypePWM(GPIO_PORTD_BASE, GPIO_PIN_0
                                  | GPIO_PIN_1);

    GPIOPinTypePWM(GPIO_PORTE_BASE, GPIO_PIN_4
                                  | GPIO_PIN_5);

                                                                                /* Configure PWM Options               */
                                                                                /* PWM_GEN_0 Covers M0PWM0 and M0PWM1  */
                                                                                /* PWM_GEN_1 Covers M0PWM2 and M0PWM3  */
                                                                                /* PWM_GEN_2 Covers M0PWM4 and M0PWM5  */
                                                                                /* PWM_GEN_3 Covers M0PWM6 and M0PWM7  */
    PWMGenConfigure(PWM0_BASE, PWM_GEN_0, PWM_GEN_MODE_DOWN | PWM_GEN_MODE_NO_SYNC);
    PWMGenConfigure(PWM0_BASE, PWM_GEN_1, PWM_GEN_MODE_DOWN | PWM_GEN_MODE_NO_SYNC);
    PWMGenConfigure(PWM0_BASE, PWM_GEN_2, PWM_GEN_MODE_DOWN | PWM_GEN_MODE_NO_SYNC);
    PWMGenConfigure(PWM0_BASE, PWM_GEN_3, PWM_GEN_MODE_DOWN | PWM_GEN_MODE_NO_SYNC);
                                                                                /* Set the period of the PWM signals   */
    PWMGenPeriodSet(PWM0_BASE, PWM_GEN_0, period);
    PWMGenPeriodSet(PWM0_BASE, PWM_GEN_1, period);
    PWMGenPeriodSet(PWM0_BASE, PWM_GEN_2, period);
    PWMGenPeriodSet(PWM0_BASE, PWM_GEN_3, period);
                                                                                /* Set the duty of the PWM signals     */
    PWMPulseWidthSet(PWM0_BASE, PWM_OUT_0, duty);
    PWMPulseWidthSet(PWM0_BASE, PWM_OUT_1, duty);
    PWMPulseWidthSet(PWM0_BASE, PWM_OUT_2, duty);
    PWMPulseWidthSet(PWM0_BASE, PWM_OUT_3, duty);
    PWMPulseWidthSet(PWM0_BASE, PWM_OUT_4, duty);
    PWMPulseWidthSet(PWM0_BASE, PWM_OUT_5, duty);
    PWMPulseWidthSet(PWM0_BASE, PWM_OUT_6, duty);
    PWMPulseWidthSet(PWM0_BASE, PWM_OUT_7, duty);

                                                                                /* Enable the PWM generators           */
    PWMGenEnable(PWM0_BASE, PWM_GEN_0);
    PWMGenEnable(PWM0_BASE, PWM_GEN_1);
    PWMGenEnable(PWM0_BASE, PWM_GEN_2);
    PWMGenEnable(PWM0_BASE, PWM_GEN_3);

                                                                                /* Turn on the Output pins             */
    PWMOutputState(PWM0_BASE, PWM_OUT_0_BIT
                            | PWM_OUT_1_BIT
                            | PWM_OUT_2_BIT
                            | PWM_OUT_3_BIT
                            | PWM_OUT_4_BIT
                            | PWM_OUT_5_BIT
                            | PWM_OUT_6_BIT
                            | PWM_OUT_7_BIT
                            , true);
}

/* halPWMMotorsSet
 \param motor - with this variable we can choose the motor what we want to set
 \param duty_us - the duty in us (it have to be between 1000 and 2000)
 \return 0 - no error 1 - error
 */
uint8_t halPWMMotorsSet(uint8_t motor, uint32_t duty_us){
    if((duty_us > 2000) || (duty_us < 1000)){
        return 1;
    }
    uint32_t duty =  (unsigned int)(duty_us*(0.000001f/(1/((double)SysCtlClockGet()/64.0f))));

    switch(motor){
        case MOTOR0:
            PWMPulseWidthSet(PWM0_BASE, PWM_OUT_0, duty);
            break;
        case MOTOR1:
            PWMPulseWidthSet(PWM0_BASE, PWM_OUT_1, duty);
            break;
        case MOTOR2:
            PWMPulseWidthSet(PWM0_BASE, PWM_OUT_2, duty);
            break;
        case MOTOR3:
            PWMPulseWidthSet(PWM0_BASE, PWM_OUT_3, duty);
            break;
        case MOTOR4:
            PWMPulseWidthSet(PWM0_BASE, PWM_OUT_4, duty);
            break;
        case MOTOR5:
            PWMPulseWidthSet(PWM0_BASE, PWM_OUT_5, duty);
            break;
        case MOTOR6:
            PWMPulseWidthSet(PWM0_BASE, PWM_OUT_6, duty);
            break;
        case MOTOR7:
            PWMPulseWidthSet(PWM0_BASE, PWM_OUT_7, duty);
            break;
        default:
            return 1;
    }
    return 0;
}

/*
 \param freq - the frequency of the PWM module
 \param defDuty - the default duty of the PWM channel
*/
uint8_t halPWMLEDInit(uint32_t freq, uint32_t defDuty){
	return 1;
}
/*
 \param channel - with this parameter you can choose the channel of PWM
 \param duty - the duty of the PWM channel in %
*/
uint8_t halPWMLEDSet(uint32_t channel, uint16_t duty){
	return 1;
}
